/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.BCELBackend;
import net.sf.cglib.CodeGenerationException;
import net.sf.cglib.CodeGeneratorBackend;
import net.sf.cglib.Constants;
import net.sf.cglib.MethodConstants;

abstract class CodeGenerator {
    private static final String FIND_CLASS = "CGLIB$findClass";
    private static final Map primitiveMethods = new HashMap();
    private static final Map primitiveToWrapper = new HashMap();
    private static String debugLocation;
    private static RuntimePermission DEFINE_CGLIB_CLASS_IN_JAVA_PACKAGE_PERMISSION;
    private final ClassLoader loader;
    private String methodName;
    private Class returnType;
    private Class[] parameterTypes;
    private Class superclass;
    private boolean needsFindClass;
    private Map locals = new HashMap();
    private Map localTypes = new HashMap();
    private int nextLocal;
    private boolean inMethod;
    private LinkedList handlerStack = new LinkedList();
    private LinkedList handlerList = new LinkedList();
    private Set definedClasses = new HashSet();
    private Map fieldInfo = new HashMap();
    private String className;
    private CodeGeneratorBackend backend;
    private boolean debug = false;
    static /* synthetic */ Class class$net$sf$cglib$ReflectUtils;
    static /* synthetic */ Class class$net$sf$cglib$MethodConstants;
    static /* synthetic */ Class class$net$sf$cglib$CodeGenerationException;
    static /* synthetic */ Class class$net$sf$cglib$BCELBackend;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$ClassNotFoundException;
    static /* synthetic */ Class class$java$lang$NoClassDefFoundError;
    static /* synthetic */ Class class$java$lang$String;

    protected CodeGenerator(String className, Class superclass, ClassLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException("ClassLoader is required");
        }
        this.loader = loader;
        this.className = className;
        this.superclass = superclass;
        this.defineResource(superclass);
        this.defineResource(class$net$sf$cglib$ReflectUtils == null ? (class$net$sf$cglib$ReflectUtils = CodeGenerator.class$("net.sf.cglib.ReflectUtils")) : class$net$sf$cglib$ReflectUtils);
        this.defineResource(class$net$sf$cglib$MethodConstants == null ? (class$net$sf$cglib$MethodConstants = CodeGenerator.class$("net.sf.cglib.MethodConstants")) : class$net$sf$cglib$MethodConstants);
        this.defineResource(class$net$sf$cglib$CodeGenerationException == null ? (class$net$sf$cglib$CodeGenerationException = CodeGenerator.class$("net.sf.cglib.CodeGenerationException")) : class$net$sf$cglib$CodeGenerationException);
        this.defineResource(class$net$sf$cglib$BCELBackend == null ? (class$net$sf$cglib$BCELBackend = CodeGenerator.class$("net.sf.cglib.BCELBackend")) : class$net$sf$cglib$BCELBackend);
        this.backend = new BCELBackend(className, superclass);
    }

    protected void setDebug(boolean debug) {
        this.debug = debug;
        this.backend.setDebug(debug);
    }

    protected String getClassName() {
        return this.className;
    }

    protected Class getSuperclass() {
        return this.superclass;
    }

    public static void setDebugLocation(String debugLocation) {
        CodeGenerator.debugLocation = debugLocation;
    }

    protected abstract void generate() throws Exception;

    public Class define() {
        try {
            this.generate();
            if (this.needsFindClass) {
                this.generateFindClass();
            }
            byte[] bytes = this.backend.getBytes();
            if (debugLocation != null) {
                FileOutputStream out = new FileOutputStream(new File(new File(debugLocation), this.className + ".cglib"));
                ((OutputStream)out).write(bytes);
                ((OutputStream)out).close();
            }
            return CodeGenerator.defineClass(this.className, bytes, this.loader);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CodeGenerationException(t);
        }
    }

    public void defineResource(Class resource) {
        if (resource != null && resource.isArray()) {
            this.defineResource(resource.getComponentType());
            return;
        }
        if (resource == null || resource.getClassLoader() == null || resource.getClassLoader() == this.loader || this.definedClasses.contains(resource)) {
            return;
        }
        this.definedClasses.add(resource);
        this.defineResource(resource.getSuperclass());
        Class<?>[] classes = resource.getInterfaces();
        int i = 0;
        while (i < classes.length) {
            this.defineResource(classes[i]);
            ++i;
        }
        classes = resource.getDeclaredClasses();
        int i2 = 0;
        while (i2 < classes.length) {
            this.defineResource(classes[i2]);
            ++i2;
        }
        Method[] methods = resource.getDeclaredMethods();
        int i3 = 0;
        while (i3 < methods.length) {
            this.defineResource(methods[i3].getReturnType());
            classes = methods[i3].getParameterTypes();
            int j = 0;
            while (j < classes.length) {
                this.defineResource(classes[j]);
                ++j;
            }
            classes = methods[i3].getExceptionTypes();
            int j2 = 0;
            while (j2 < classes.length) {
                this.defineResource(classes[j2]);
                ++j2;
            }
            ++i3;
        }
        Constructor<?>[] constructors = resource.getDeclaredConstructors();
        int i4 = 0;
        while (i4 < constructors.length) {
            classes = constructors[i4].getParameterTypes();
            int j = 0;
            while (j < classes.length) {
                this.defineResource(classes[j]);
                ++j;
            }
            classes = constructors[i4].getExceptionTypes();
            int j3 = 0;
            while (j3 < classes.length) {
                this.defineResource(classes[j3]);
                ++j3;
            }
            ++i4;
        }
        Field[] fields = resource.getDeclaredFields();
        int i5 = 0;
        while (i5 < fields.length) {
            this.defineResource(fields[i5].getType());
            ++i5;
        }
        this.defineDependancy(resource);
    }

    private void defineDependancy(Class resource) {
        if (resource != null && resource.getClassLoader() != null && resource.getClassLoader() != this.loader) {
            try {
                this.loader.loadClass(resource.getName());
                return;
            }
            catch (ClassNotFoundException cne) {
                try {
                    int b;
                    InputStream is = resource.getClassLoader().getResourceAsStream(resource.getName().replace('.', '/') + ".class");
                    if (is == null) {
                        throw new CodeGenerationException(new ClassNotFoundException(resource.getName()));
                    }
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    while ((b = is.read()) != -1) {
                        out.write(b);
                    }
                    CodeGenerator.defineClass(resource.getName(), out.toByteArray(), this.loader);
                }
                catch (Exception e) {
                    throw new CodeGenerationException(e);
                }
            }
        }
    }

    private static Class defineClass(String className, byte[] b, ClassLoader loader) throws Exception {
        Method m = MethodConstants.DEFINE_CLASS;
        boolean flag = m.isAccessible();
        ((AccessibleObject)m).setAccessible(true);
        SecurityManager sm = System.getSecurityManager();
        if (className != null && className.startsWith("java.") && sm != null) {
            sm.checkPermission(DEFINE_CGLIB_CLASS_IN_JAVA_PACKAGE_PERMISSION);
        }
        Object[] args = new Object[]{b, new Integer(0), new Integer(b.length)};
        Class result = (Class)m.invoke((Object)loader, args);
        ((AccessibleObject)m).setAccessible(flag);
        return result;
    }

    protected void declare_interfaces(Class[] interfaces) {
        int i = 0;
        while (i < interfaces.length) {
            this.declare_interface(interfaces[i]);
            ++i;
        }
    }

    protected void declare_interface(Class iface) {
        this.defineResource(iface);
        this.backend.declare_interface(iface);
    }

    protected void begin_method(int modifiers, Class returnType, String methodName, Class[] parameterTypes, Class[] exceptionTypes) {
        this.checkInMethod();
        this.methodName = methodName;
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        this.backend.begin_method(modifiers, returnType, methodName, parameterTypes, exceptionTypes);
        this.setNextLocal();
    }

    protected int getDefaultModifiers(Method method) {
        int modifiers = method.getModifiers();
        return 0x10 | modifiers & 0xFFFFFBFF & 0xFFFFFEFF & 0xFFFFFFDF;
    }

    protected void begin_method(Method method) {
        this.begin_method(method, this.getDefaultModifiers(method));
    }

    protected void begin_method(Method method, int modifiers) {
        this.begin_method(modifiers, method.getReturnType(), method.getName(), method.getParameterTypes(), method.getExceptionTypes());
    }

    protected void begin_constructor(Constructor constructor) {
        this.begin_constructor(constructor.getParameterTypes());
    }

    protected void begin_constructor() {
        this.begin_constructor(Constants.TYPES_EMPTY);
    }

    protected void begin_constructor(Class[] parameterTypes) {
        this.checkInMethod();
        this.returnType = Void.TYPE;
        this.parameterTypes = parameterTypes;
        this.backend.begin_constructor(parameterTypes);
        this.setNextLocal();
    }

    protected void begin_static() {
        this.checkInMethod();
        this.returnType = Void.TYPE;
        this.parameterTypes = Constants.TYPES_EMPTY;
        this.backend.begin_static();
        this.setNextLocal();
    }

    private void checkInMethod() {
        if (this.inMethod) {
            throw new IllegalStateException("cannot nest methods");
        }
    }

    private void setNextLocal() {
        this.nextLocal = 1 + CodeGenerator.getStackSize(this.parameterTypes);
    }

    protected void end_method() {
        this.backend.end_method();
        this.parameterTypes = null;
        this.returnType = null;
        this.methodName = null;
        this.locals.clear();
        this.localTypes.clear();
        if (this.handlerStack.size() > 0) {
            throw new IllegalStateException("unclosed exception handler");
        }
        this.handlerList.clear();
        this.inMethod = false;
    }

    protected void create_arg_array() {
        this.push(this.parameterTypes.length);
        this.newarray();
        int i = 0;
        while (i < this.parameterTypes.length) {
            this.dup();
            this.push(i);
            this.load_arg(i);
            this.box(this.parameterTypes[i]);
            this.aastore();
            ++i;
        }
    }

    protected Object begin_handler() {
        int ref = this.handlerList.size();
        Object[] range = new Object[]{this.backend.start_range(), null};
        this.handlerList.add(range);
        this.handlerStack.add(range);
        return new Integer(ref);
    }

    protected void end_handler() {
        if (this.handlerStack.size() == 0) {
            throw new IllegalStateException("mismatched handler boundaries");
        }
        Object[] range = (Object[])this.handlerStack.removeLast();
        range[1] = this.backend.end_range();
    }

    protected void handle_exception(Object handler, Class exceptionType) {
        int ref = (Integer)handler;
        if (this.handlerList.size() <= ref) {
            throw new IllegalArgumentException("unknown handler reference: " + ref);
        }
        Object[] range = (Object[])this.handlerList.get(ref);
        if (range[1] == null) {
            throw new IllegalStateException("end of handler is unset");
        }
        this.backend.handle_exception(range[0], range[1], exceptionType);
    }

    protected void ifeq(Object label) {
        this.backend.ifeq(label);
    }

    protected void ifne(Object label) {
        this.backend.ifne(label);
    }

    protected void iflt(Object label) {
        this.backend.iflt(label);
    }

    protected void ifge(Object label) {
        this.backend.ifge(label);
    }

    protected void ifgt(Object label) {
        this.backend.ifgt(label);
    }

    protected void ifle(Object label) {
        this.backend.ifle(label);
    }

    protected void goTo(Object label) {
        this.backend.goTo(label);
    }

    protected void ifnull(Object label) {
        this.backend.ifnull(label);
    }

    protected void ifnonnull(Object label) {
        this.backend.ifnonnull(label);
    }

    protected void if_icmplt(Object label) {
        this.backend.if_icmplt(label);
    }

    protected void if_icmpne(Object label) {
        this.backend.if_icmpne(label);
    }

    protected void if_icmpeq(Object label) {
        this.backend.if_icmpeq(label);
    }

    protected void nop(Object label) {
        this.backend.nop(label);
    }

    protected void imul() {
        this.backend.imul();
    }

    protected void iadd() {
        this.backend.iadd();
    }

    protected void lushr() {
        this.backend.lushr();
    }

    protected void lxor() {
        this.backend.lxor();
    }

    protected void ixor() {
        this.backend.ixor();
    }

    protected void l2i() {
        this.backend.l2i();
    }

    protected void dcmpg() {
        this.backend.dcmpg();
    }

    protected void fcmpg() {
        this.backend.fcmpg();
    }

    protected void lcmp() {
        this.backend.lcmp();
    }

    protected void pop() {
        this.backend.pop();
    }

    protected void pop2() {
        this.backend.pop2();
    }

    protected void dup() {
        this.backend.dup();
    }

    protected void dup2() {
        this.backend.dup2();
    }

    protected void dup_x1() {
        this.backend.dup_x1();
    }

    protected void dup_x2() {
        this.backend.dup_x2();
    }

    protected void swap() {
        this.backend.swap();
    }

    protected void aconst_null() {
        this.backend.aconst_null();
    }

    protected void push(int i) {
        if (i < 0) {
            this.backend.ldc(i);
        } else if (i <= 5) {
            this.backend.iconst(i);
        } else if (i <= 127) {
            this.backend.bipush((byte)i);
        } else if (i <= Short.MAX_VALUE) {
            this.backend.sipush((short)i);
        } else {
            this.backend.ldc(i);
        }
    }

    protected void push(long value) {
        if (value == 0L || value == 1L) {
            this.backend.lconst(value);
        } else {
            this.backend.ldc(value);
        }
    }

    protected void push(float value) {
        if (value == 0.0f || value == 1.0f || value == 2.0f) {
            this.backend.fconst(value);
        } else {
            this.backend.ldc(value);
        }
    }

    protected void push(double value) {
        if (value == 0.0 || value == 1.0) {
            this.backend.dconst(value);
        } else {
            this.backend.ldc(value);
        }
    }

    protected void push(String value) {
        this.backend.ldc(value);
    }

    protected void push(Object[] array) {
        this.push(array.length);
        this.newarray(array.getClass().getComponentType());
        int i = 0;
        while (i < array.length) {
            this.dup();
            this.push(i);
            this.push_object(array[i]);
            this.aastore();
            ++i;
        }
    }

    protected void push_object(Object obj) {
        if (obj == null) {
            this.aconst_null();
        } else {
            Class<?> type = obj.getClass();
            if (type.isArray()) {
                this.push((Object[])obj);
            } else if (obj instanceof String) {
                this.push((String)obj);
            } else if (obj instanceof Class) {
                this.load_class((Class)obj);
            } else {
                if (obj.getClass().getSuperclass().equals(class$java$lang$Number == null ? (class$java$lang$Number = CodeGenerator.class$("java.lang.Number")) : class$java$lang$Number)) {
                    throw new IllegalArgumentException("not implemented yet");
                }
                throw new IllegalArgumentException("unknown type: " + obj.getClass());
            }
        }
    }

    protected void newarray() {
        this.newarray(class$java$lang$Object == null ? (class$java$lang$Object = CodeGenerator.class$("java.lang.Object")) : class$java$lang$Object);
    }

    protected void newarray(Class clazz) {
        if (clazz.isPrimitive()) {
            this.backend.newarray(clazz);
        } else {
            this.backend.anewarray(clazz);
        }
    }

    protected void arraylength() {
        this.backend.arraylength();
    }

    protected void array_load(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz.equals(Long.TYPE)) {
                this.backend.laload();
            } else if (clazz.equals(Double.TYPE)) {
                this.backend.daload();
            } else if (clazz.equals(Float.TYPE)) {
                this.backend.faload();
            } else if (clazz.equals(Short.TYPE)) {
                this.backend.saload();
            } else if (clazz.equals(Character.TYPE)) {
                this.backend.caload();
            } else if (clazz.equals(Integer.TYPE)) {
                this.backend.iaload();
            } else {
                this.backend.baload();
            }
        } else {
            this.defineResource(clazz);
            this.backend.aaload();
        }
    }

    protected void array_store(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz.equals(Long.TYPE)) {
                this.backend.lastore();
            } else if (clazz.equals(Double.TYPE)) {
                this.backend.dastore();
            } else if (clazz.equals(Float.TYPE)) {
                this.backend.fastore();
            } else if (clazz.equals(Short.TYPE)) {
                this.backend.sastore();
            } else if (clazz.equals(Character.TYPE)) {
                this.backend.castore();
            } else if (clazz.equals(Integer.TYPE)) {
                this.backend.iastore();
            } else {
                this.backend.bastore();
            }
        } else {
            this.defineResource(clazz);
            this.backend.aastore();
        }
    }

    protected void load_this() {
        this.backend.aload(0);
    }

    protected void load_class_this() {
        this.load_class_helper(this.className);
    }

    protected void load_class(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz.equals(Void.TYPE)) {
                throw new IllegalArgumentException("cannot load void type");
            }
            try {
                this.getfield(((Class)primitiveToWrapper.get(clazz)).getDeclaredField("TYPE"));
            }
            catch (NoSuchFieldException e) {
                throw new CodeGenerationException(e);
            }
        } else {
            this.defineResource(clazz);
            this.load_class_helper(clazz.getName());
        }
    }

    private void load_class_helper(String className) {
        this.needsFindClass = true;
        this.push(className);
        this.invoke_static_this(FIND_CLASS, class$java$lang$Class == null ? (class$java$lang$Class = CodeGenerator.class$("java.lang.Class")) : class$java$lang$Class, Constants.TYPES_STRING);
    }

    protected void load_args() {
        this.load_args(0, this.parameterTypes.length);
    }

    protected void load_arg(int index) {
        this.load_local(this.parameterTypes[index], 1 + this.skipArgs(index));
    }

    protected void load_args(int fromArg, int count) {
        int pos = 1 + this.skipArgs(fromArg);
        int i = 0;
        while (i < count) {
            Class t = this.parameterTypes[fromArg + i];
            this.load_local(t, pos);
            pos += CodeGenerator.getStackSize(t);
            ++i;
        }
    }

    private int skipArgs(int numArgs) {
        int amount = 0;
        int i = 0;
        while (i < numArgs) {
            amount += CodeGenerator.getStackSize(this.parameterTypes[i]);
            ++i;
        }
        return amount;
    }

    private void load_local(Class t, int pos) {
        if (t != null && t.isPrimitive()) {
            if (t.equals(Long.TYPE)) {
                this.backend.lload(pos);
            } else if (t.equals(Double.TYPE)) {
                this.backend.dload(pos);
            } else if (t.equals(Float.TYPE)) {
                this.backend.fload(pos);
            } else {
                this.backend.iload(pos);
            }
        } else {
            this.defineResource(t);
            this.backend.aload(pos);
        }
    }

    private void store_local(Class t, int index) {
        if (t != null && t.isPrimitive()) {
            if (t.equals(Long.TYPE)) {
                this.backend.lstore(index);
            } else if (t.equals(Double.TYPE)) {
                this.backend.dstore(index);
            } else if (t.equals(Float.TYPE)) {
                this.backend.fstore(index);
            } else {
                this.backend.istore(index);
            }
        } else {
            this.defineResource(t);
            this.backend.astore(index);
        }
    }

    protected void iinc(Object local, int amount) {
        this.backend.iinc(this.getLocal(local), amount);
    }

    protected void store_local(Object local) {
        this.store_local((Class)this.localTypes.get(local), this.getLocal(local));
    }

    protected void load_local(Object local) {
        this.load_local((Class)this.localTypes.get(local), this.getLocal(local));
    }

    private int getLocal(Object local) {
        return (Integer)this.locals.get(local);
    }

    protected void return_value() {
        if (this.returnType.isPrimitive()) {
            if (this.returnType.equals(Void.TYPE)) {
                this.backend.returnVoid();
            } else if (this.returnType.equals(Long.TYPE)) {
                this.backend.lreturn();
            } else if (this.returnType.equals(Double.TYPE)) {
                this.backend.dreturn();
            } else if (this.returnType.equals(Float.TYPE)) {
                this.backend.freturn();
            } else {
                this.backend.ireturn();
            }
        } else {
            this.backend.areturn();
        }
    }

    protected void declare_field(int modifiers, Class type, String name) {
        if (this.getFieldInfo(name) != null) {
            throw new IllegalArgumentException("Field \"" + name + "\" already exists");
        }
        this.backend.declare_field(modifiers, type, name);
        this.fieldInfo.put(name, new FieldInfo(Modifier.isStatic(modifiers), type));
    }

    private FieldInfo getFieldInfo(String name) {
        return (FieldInfo)this.fieldInfo.get(name);
    }

    protected void getfield(String name) {
        FieldInfo info = this.getFieldInfo(name);
        if (info.isStatic()) {
            this.backend.getstatic(this.className, name, info.getType());
        } else {
            this.backend.getfield(this.className, name, info.getType());
        }
    }

    protected void putfield(String name) {
        FieldInfo info = this.getFieldInfo(name);
        if (info.isStatic()) {
            this.backend.putstatic(this.className, name, info.getType());
        } else {
            this.backend.putfield(this.className, name, info.getType());
        }
    }

    protected void super_getfield(String name) throws NoSuchFieldException {
        this.getfield(this.superclass.getDeclaredField(name));
    }

    protected void super_putfield(String name) throws NoSuchFieldException {
        this.putfield(this.superclass.getDeclaredField(name));
    }

    protected void getfield(Field field) {
        this.defineResource(field.getType());
        this.defineResource(field.getDeclaringClass());
        if (Modifier.isStatic(field.getModifiers())) {
            this.backend.getstatic(field.getDeclaringClass().getName(), field.getName(), field.getType());
        } else {
            this.backend.getfield(field.getDeclaringClass().getName(), field.getName(), field.getType());
        }
    }

    protected void putfield(Field field) {
        this.defineResource(field.getType());
        this.defineResource(field.getDeclaringClass());
        if (Modifier.isStatic(field.getModifiers())) {
            this.backend.putstatic(field.getDeclaringClass().getName(), field.getName(), field.getType());
        } else {
            this.backend.putfield(field.getDeclaringClass().getName(), field.getName(), field.getType());
        }
    }

    protected void invoke(Method method) {
        this.defineResource(method.getDeclaringClass());
        this.defineResource(method.getReturnType());
        Class<?>[] types = method.getParameterTypes();
        int i = 0;
        while (i < types.length) {
            this.defineResource(types[i]);
            ++i;
        }
        if (method.getDeclaringClass().isInterface()) {
            this.backend.invoke_interface(method.getDeclaringClass().getName(), method.getName(), method.getReturnType(), method.getParameterTypes());
        } else if (Modifier.isStatic(method.getModifiers())) {
            this.backend.invoke_static(method.getDeclaringClass().getName(), method.getName(), method.getReturnType(), method.getParameterTypes());
        } else {
            this.backend.invoke_virtual(method.getDeclaringClass().getName(), method.getName(), method.getReturnType(), method.getParameterTypes());
        }
    }

    protected void super_invoke(Method method) {
        this.backend.invoke_special(this.superclass.getName(), method.getName(), method.getReturnType(), method.getParameterTypes());
    }

    protected void invoke_virtual_this(String methodName, Class returnType, Class[] parameterTypes) {
        this.backend.invoke_virtual(this.className, methodName, returnType, parameterTypes);
    }

    protected void invoke_static_this(String methodName, Class returnType, Class[] parameterTypes) {
        this.backend.invoke_static(this.className, methodName, returnType, parameterTypes);
    }

    protected void super_invoke() {
        this.backend.invoke_special(this.superclass.getName(), this.methodName, this.returnType, this.parameterTypes);
    }

    protected void invoke_constructor(String className, Class[] parameterTypes) {
        this.backend.invoke_special(className, "<init>", Void.TYPE, parameterTypes);
    }

    protected void invoke_constructor(Class type) {
        this.defineResource(type);
        this.invoke_constructor(type, Constants.TYPES_EMPTY);
    }

    protected void invoke(Constructor constructor) {
        this.invoke_constructor(constructor.getDeclaringClass(), (Class[])constructor.getParameterTypes());
    }

    protected void invoke_constructor(Class type, Class[] parameterTypes) {
        this.invoke_constructor(type.getName(), parameterTypes);
    }

    private static int getStackSize(Class type) {
        return type.equals(Double.TYPE) || type.equals(Long.TYPE) ? 2 : 1;
    }

    static int getStackSize(Class[] classes) {
        int size = 0;
        int i = 0;
        while (i < classes.length) {
            size += CodeGenerator.getStackSize(classes[i]);
            ++i;
        }
        return size;
    }

    protected void super_invoke(Constructor constructor) {
        this.super_invoke_constructor(constructor.getParameterTypes());
    }

    protected void super_invoke_constructor() {
        this.invoke_constructor(this.superclass.getName(), Constants.TYPES_EMPTY);
    }

    protected void super_invoke_constructor(Class[] parameterTypes) {
        this.invoke_constructor(this.superclass.getName(), parameterTypes);
    }

    protected void invoke_constructor_this() {
        this.invoke_constructor_this(Constants.TYPES_EMPTY);
    }

    protected void invoke_constructor_this(Class[] parameterTypes) {
        this.invoke_constructor(this.className, parameterTypes);
    }

    protected void new_instance_this() {
        this.backend.new_instance(this.className);
    }

    protected void new_instance(String className) {
        this.backend.new_instance(className);
    }

    protected void new_instance(Class clazz) {
        this.defineResource(clazz);
        this.new_instance(clazz.getName());
    }

    protected void aaload(int index) {
        this.push(index);
        this.aaload();
    }

    protected void aaload() {
        this.backend.aaload();
    }

    protected void aastore() {
        this.backend.aastore();
    }

    protected void athrow() {
        this.backend.athrow();
    }

    protected Object make_label() {
        return new Object();
    }

    protected Object make_local() {
        return this.make_local(null);
    }

    protected Object make_local(Class type) {
        Object local = new Object();
        this.locals.put(local, new Integer(this.nextLocal));
        this.localTypes.put(local, type);
        this.nextLocal += type == null ? 1 : CodeGenerator.getStackSize(type);
        return local;
    }

    protected void zero_or_null(Class type) {
        if (type.isPrimitive()) {
            if (type.equals(Double.TYPE)) {
                this.push(0.0);
            } else if (type.equals(Long.TYPE)) {
                this.push(0L);
            } else if (type.equals(Float.TYPE)) {
                this.push(0.0f);
            } else if (!type.equals(Void.TYPE)) {
                this.push(0);
            }
        } else {
            this.aconst_null();
        }
    }

    protected void unbox_or_zero(Class type) {
        if (type.isPrimitive()) {
            if (!type.equals(Void.TYPE)) {
                Object nonNull = this.make_label();
                Object end = this.make_label();
                this.dup();
                this.ifnonnull(nonNull);
                this.pop();
                this.zero_or_null(type);
                this.goTo(end);
                this.nop(nonNull);
                this.unbox(type);
                this.nop(end);
            }
        } else {
            this.checkcast(type);
        }
    }

    protected void box(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz.equals(Void.TYPE)) {
                this.aconst_null();
            } else {
                Class wrapper = (Class)primitiveToWrapper.get(clazz);
                this.new_instance(wrapper);
                if (CodeGenerator.getStackSize(clazz) == 2) {
                    this.dup_x2();
                    this.dup_x2();
                    this.pop();
                } else {
                    this.dup_x1();
                    this.swap();
                }
                this.invoke_constructor(wrapper, new Class[]{clazz});
            }
        }
    }

    protected void unbox(Class clazz) {
        if (clazz.isPrimitive()) {
            if (!clazz.equals(Void.TYPE)) {
                Method convert = (Method)primitiveMethods.get(clazz);
                this.checkcast(convert.getDeclaringClass());
                this.invoke(convert);
            }
        } else {
            this.checkcast(clazz);
        }
    }

    protected void checkcast_this() {
        this.backend.checkcast(this.className);
    }

    protected void checkcast(Class clazz) {
        if (!clazz.equals(class$java$lang$Object == null ? (class$java$lang$Object = CodeGenerator.class$("java.lang.Object")) : class$java$lang$Object)) {
            this.backend.checkcast(clazz.getName());
        }
    }

    protected void instance_of(Class clazz) {
        this.backend.instance_of(clazz.getName());
    }

    protected void instance_of_this() {
        this.backend.instance_of(this.className);
    }

    protected void generateNullConstructor() {
        this.begin_constructor();
        this.load_this();
        this.super_invoke_constructor();
        this.return_value();
        this.end_method();
    }

    private void generateFindClass() {
        this.begin_method(10, class$java$lang$Class == null ? (class$java$lang$Class = CodeGenerator.class$("java.lang.Class")) : class$java$lang$Class, FIND_CLASS, Constants.TYPES_STRING, null);
        Object eh = this.begin_handler();
        this.load_this();
        this.invoke(MethodConstants.FOR_NAME);
        this.return_value();
        this.end_handler();
        this.handle_exception(eh, class$java$lang$ClassNotFoundException == null ? (class$java$lang$ClassNotFoundException = CodeGenerator.class$("java.lang.ClassNotFoundException")) : class$java$lang$ClassNotFoundException);
        this.invoke(MethodConstants.THROWABLE_GET_MESSAGE);
        this.new_instance(class$java$lang$NoClassDefFoundError == null ? (class$java$lang$NoClassDefFoundError = CodeGenerator.class$("java.lang.NoClassDefFoundError")) : class$java$lang$NoClassDefFoundError);
        this.dup_x1();
        this.swap();
        this.invoke_constructor(class$java$lang$NoClassDefFoundError == null ? (class$java$lang$NoClassDefFoundError = CodeGenerator.class$("java.lang.NoClassDefFoundError")) : class$java$lang$NoClassDefFoundError, Constants.TYPES_STRING);
        this.athrow();
        this.end_method();
    }

    protected void process_array(Class type, ProcessArrayCallback callback) {
        Class<?> compType = type.getComponentType();
        Object array = this.make_local();
        Object loopvar = this.make_local(Integer.TYPE);
        Object loopbody = this.make_label();
        Object checkloop = this.make_label();
        this.store_local(array);
        this.push(0);
        this.store_local(loopvar);
        this.goTo(checkloop);
        this.nop(loopbody);
        this.load_local(array);
        this.load_local(loopvar);
        this.array_load(compType);
        callback.processElement(compType);
        this.iinc(loopvar, 1);
        this.nop(checkloop);
        this.load_local(loopvar);
        this.load_local(array);
        this.arraylength();
        this.if_icmplt(loopbody);
    }

    protected void process_arrays(Class clazz, ProcessArrayCallback callback) {
        Class<?> compType = clazz.getComponentType();
        Object array1 = this.make_local();
        Object array2 = this.make_local();
        Object loopvar = this.make_local(Integer.TYPE);
        Object loopbody = this.make_label();
        Object checkloop = this.make_label();
        this.store_local(array1);
        this.store_local(array2);
        this.push(0);
        this.store_local(loopvar);
        this.goTo(checkloop);
        this.nop(loopbody);
        this.load_local(array1);
        this.load_local(loopvar);
        this.array_load(compType);
        this.load_local(array2);
        this.load_local(loopvar);
        this.array_load(compType);
        callback.processElement(compType);
        this.iinc(loopvar, 1);
        this.nop(checkloop);
        this.load_local(loopvar);
        this.load_local(array1);
        this.arraylength();
        this.if_icmplt(loopbody);
    }

    protected void not_equals(Class clazz, final Object notEquals) {
        new ProcessArrayCallback(){

            public void processElement(Class type) {
                CodeGenerator.this.not_equals_helper(type, notEquals, this);
            }
        }.processElement(clazz);
    }

    private void not_equals_helper(Class clazz, Object notEquals, ProcessArrayCallback callback) {
        if (clazz.isPrimitive()) {
            if (this.returnType.equals(Double.TYPE)) {
                this.dcmpg();
                this.ifne(notEquals);
            } else if (this.returnType.equals(Long.TYPE)) {
                this.lcmp();
                this.ifne(notEquals);
            } else if (this.returnType.equals(Float.TYPE)) {
                this.fcmpg();
                this.ifne(notEquals);
            } else {
                this.if_icmpne(notEquals);
            }
        } else {
            Object end = this.make_label();
            this.nullcmp(notEquals, end);
            if (clazz.isArray()) {
                Object checkContents = this.make_label();
                this.dup2();
                this.arraylength();
                this.swap();
                this.arraylength();
                this.if_icmpeq(checkContents);
                this.pop2();
                this.goTo(notEquals);
                this.nop(checkContents);
                this.process_arrays(clazz, callback);
            } else {
                this.invoke(MethodConstants.EQUALS);
                this.ifeq(notEquals);
            }
            this.nop(end);
        }
    }

    protected void throw_exception(Class type, String msg) {
        this.defineResource(type);
        this.new_instance(type);
        this.dup();
        this.push(msg);
        this.invoke_constructor(type, new Class[]{class$java$lang$String == null ? (class$java$lang$String = CodeGenerator.class$("java.lang.String")) : class$java$lang$String});
        this.athrow();
    }

    protected void nullcmp(Object oneNull, Object bothNull) {
        this.dup2();
        Object nonNull = this.make_label();
        Object oneNullHelper = this.make_label();
        Object end = this.make_label();
        this.ifnonnull(nonNull);
        this.ifnonnull(oneNullHelper);
        this.pop2();
        this.goTo(bothNull);
        this.nop(nonNull);
        this.ifnull(oneNullHelper);
        this.goTo(end);
        this.nop(oneNullHelper);
        this.pop2();
        this.goTo(oneNull);
        this.nop(end);
    }

    protected void generateFactoryMethod(Method method) {
        this.begin_method(method);
        this.new_instance_this();
        this.dup();
        this.load_args();
        this.invoke_constructor_this(method.getParameterTypes());
        this.return_value();
        this.end_method();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DEFINE_CGLIB_CLASS_IN_JAVA_PACKAGE_PERMISSION = new RuntimePermission("defineCGLIBClassInJavaPackage");
        primitiveMethods.put(Boolean.TYPE, MethodConstants.BOOLEAN_VALUE);
        primitiveMethods.put(Character.TYPE, MethodConstants.CHAR_VALUE);
        primitiveMethods.put(Long.TYPE, MethodConstants.LONG_VALUE);
        primitiveMethods.put(Double.TYPE, MethodConstants.DOUBLE_VALUE);
        primitiveMethods.put(Float.TYPE, MethodConstants.FLOAT_VALUE);
        primitiveMethods.put(Short.TYPE, MethodConstants.INT_VALUE);
        primitiveMethods.put(Integer.TYPE, MethodConstants.INT_VALUE);
        primitiveMethods.put(Byte.TYPE, MethodConstants.INT_VALUE);
        primitiveToWrapper.put(Boolean.TYPE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = CodeGenerator.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        primitiveToWrapper.put(Character.TYPE, class$java$lang$Character == null ? (class$java$lang$Character = CodeGenerator.class$("java.lang.Character")) : class$java$lang$Character);
        primitiveToWrapper.put(Long.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = CodeGenerator.class$("java.lang.Long")) : class$java$lang$Long);
        primitiveToWrapper.put(Double.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = CodeGenerator.class$("java.lang.Double")) : class$java$lang$Double);
        primitiveToWrapper.put(Float.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = CodeGenerator.class$("java.lang.Float")) : class$java$lang$Float);
        primitiveToWrapper.put(Short.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = CodeGenerator.class$("java.lang.Short")) : class$java$lang$Short);
        primitiveToWrapper.put(Integer.TYPE, class$java$lang$Integer == null ? (class$java$lang$Integer = CodeGenerator.class$("java.lang.Integer")) : class$java$lang$Integer);
        primitiveToWrapper.put(Byte.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = CodeGenerator.class$("java.lang.Byte")) : class$java$lang$Byte);
    }

    protected static interface ProcessArrayCallback {
        public void processElement(Class var1);
    }

    private static class FieldInfo {
        private boolean staticFlag;
        private Class type;

        public FieldInfo(boolean staticFlag, Class type) {
            this.staticFlag = staticFlag;
            this.type = type;
        }

        public boolean isStatic() {
            return this.staticFlag;
        }

        public Class getType() {
            return this.type;
        }
    }
}

