/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import net.sf.cglib.ClassNameFactory;
import net.sf.cglib.CodeGenerationException;
import net.sf.cglib.CodeGenerator;
import net.sf.cglib.Constants;
import net.sf.cglib.KeyFactory;
import net.sf.cglib.ReflectUtils;

public abstract class ConstructorProxy {
    private static final Method NEW_INSTANCE = ReflectUtils.findMethod("ConstructorProxy.newInstance(Object[])");
    private static final ClassNameFactory NAME_FACTORY = new ClassNameFactory("ConstructorProxiedByCGLIB");
    private static final ClassKey CLASS_KEY_FACTORY = (ClassKey)((Object)KeyFactory.create(class$net$sf$cglib$ConstructorProxy$ClassKey == null ? (class$net$sf$cglib$ConstructorProxy$ClassKey = ConstructorProxy.class$("net.sf.cglib.ConstructorProxy$ClassKey")) : class$net$sf$cglib$ConstructorProxy$ClassKey, null));
    private static final ClassLoader DEFAULT_LOADER = (class$net$sf$cglib$ConstructorProxy == null ? (class$net$sf$cglib$ConstructorProxy = ConstructorProxy.class$("net.sf.cglib.ConstructorProxy")) : class$net$sf$cglib$ConstructorProxy).getClassLoader();
    static /* synthetic */ Class class$net$sf$cglib$ConstructorProxy$ClassKey;
    static /* synthetic */ Class class$net$sf$cglib$ConstructorProxy;

    public static Object newClassKey(Class[] args) {
        return CLASS_KEY_FACTORY.newInstance(args);
    }

    protected ConstructorProxy() {
    }

    public static ConstructorProxy create(Constructor constructor) {
        return ConstructorProxy.createHelper(constructor, null);
    }

    public static ConstructorProxy create(Class iface, Class declaring) {
        try {
            Method newInstance = ReflectUtils.findNewInstance(iface);
            if (!newInstance.getReturnType().isAssignableFrom(declaring)) {
                throw new IllegalArgumentException("incompatible return type");
            }
            Constructor constructor = declaring.getDeclaredConstructor(newInstance.getParameterTypes());
            return ConstructorProxy.createHelper(constructor, newInstance);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("interface does not match any known constructor");
        }
    }

    private static ConstructorProxy createHelper(Constructor constructor, Method newInstance) {
        try {
            Class declaring = constructor.getDeclaringClass();
            String className = NAME_FACTORY.getNextName(declaring);
            ClassLoader loader = declaring.getClassLoader();
            if (loader == null) {
                loader = DEFAULT_LOADER;
            }
            Class gen = new Generator(className, constructor, loader, newInstance).define();
            return (ConstructorProxy)gen.getConstructor(Constants.TYPES_EMPTY).newInstance(null);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    public abstract Object newInstance(Object[] var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Generator
    extends CodeGenerator {
        private Constructor constructor;
        private Method newInstance;
        static /* synthetic */ Class class$net$sf$cglib$ConstructorProxy;

        public Generator(String className, Constructor constructor, ClassLoader loader, Method newInstance) {
            super(className, class$net$sf$cglib$ConstructorProxy == null ? (class$net$sf$cglib$ConstructorProxy = Generator.class$("net.sf.cglib.ConstructorProxy")) : class$net$sf$cglib$ConstructorProxy, loader);
            this.constructor = constructor;
            this.newInstance = newInstance;
        }

        protected void generate() {
            this.generateNullConstructor();
            this.generateNewInstance();
            if (this.newInstance != null) {
                this.declare_interface(this.newInstance.getDeclaringClass());
                this.begin_method(this.newInstance);
                this.new_instance(this.constructor.getDeclaringClass());
                this.dup();
                this.load_args();
                this.invoke(this.constructor);
                this.return_value();
                this.end_method();
            }
        }

        private void generateNewInstance() {
            this.begin_method(NEW_INSTANCE);
            this.new_instance(this.constructor.getDeclaringClass());
            this.dup();
            Class<?>[] types = this.constructor.getParameterTypes();
            int i = 0;
            while (i < types.length) {
                this.load_arg(0);
                this.push(i);
                this.aaload();
                this.unbox(types[i]);
                ++i;
            }
            this.invoke(this.constructor);
            this.return_value();
            this.end_method();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static interface ClassKey {
        public Object newInstance(Class[] var1);
    }
}

