/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.sf.cglib.ClassNameFactory;
import net.sf.cglib.Constants;
import net.sf.cglib.Delegator;
import net.sf.cglib.DelegatorGenerator;
import net.sf.cglib.FactoryCache;
import net.sf.cglib.KeyFactory;
import net.sf.cglib.ReflectUtils;

public class Delegator {
    static final Class TYPE = class$net$sf$cglib$Delegator == null ? (class$net$sf$cglib$Delegator = Delegator.class$("net.sf.cglib.Delegator")) : class$net$sf$cglib$Delegator;
    private static final FactoryCache cache = new FactoryCache();
    private static final ClassLoader defaultLoader = TYPE.getClassLoader();
    private static final Map infoCache = new HashMap();
    private static final ClassNameFactory nameFactory = new ClassNameFactory("CreatedByCGLIB");
    private static final DelegatorKey keyFactory = (DelegatorKey)((Object)KeyFactory.create(class$net$sf$cglib$Delegator$DelegatorKey == null ? (class$net$sf$cglib$Delegator$DelegatorKey = Delegator.class$("net.sf.cglib.Delegator$DelegatorKey")) : class$net$sf$cglib$Delegator$DelegatorKey, null));
    static /* synthetic */ Class class$net$sf$cglib$Delegator;
    static /* synthetic */ Class class$net$sf$cglib$Delegator$DelegatorKey;
    static /* synthetic */ Class class$java$lang$Object;

    private Delegator() {
    }

    public static Object create(Class[] interfaces, Object[] delegates, ClassLoader loader) {
        return Delegator.makeDelegatorHelper(keyFactory.newInstance(interfaces), interfaces, delegates, loader, false);
    }

    public static Object create(Object[] delegates, ClassLoader loader) {
        Info info = Delegator.getInfo(delegates);
        Object[] remapped = new Object[info.interfaces.length];
        int i = 0;
        while (i < remapped.length) {
            remapped[i] = delegates[info.indexes[i]];
            ++i;
        }
        return Delegator.makeDelegatorHelper(info.key, info.interfaces, remapped, loader, false);
    }

    public static Map getInterfaceMap(Object[] delegates) {
        Info info = Delegator.getInfo(delegates);
        HashMap<Class, Object> map = new HashMap<Class, Object>();
        int i = 0;
        while (i < info.interfaces.length) {
            map.put(info.interfaces[i], delegates[info.indexes[i]]);
            ++i;
        }
        return map;
    }

    public static Object createBean(Object[] beans, ClassLoader loader) {
        Class[] classes = ReflectUtils.getClasses(beans);
        Object key = keyFactory.newInstance(classes);
        return Delegator.makeDelegatorHelper(key, classes, beans, loader, true);
    }

    private static synchronized Info getInfo(Object[] delegates) {
        Object key = keyFactory.newInstance(ReflectUtils.getClasses(delegates));
        Info info = (Info)infoCache.get(key);
        if (info == null) {
            info = new Info(delegates);
            infoCache.put(key, info);
        }
        return info;
    }

    private static Object makeDelegatorHelper(Object key, Class[] classes, Object[] delegates, ClassLoader loader, boolean bean) {
        Factory factory;
        if (loader == null) {
            loader = defaultLoader;
        }
        FactoryCache factoryCache = cache;
        synchronized (factoryCache) {
            factory = (Factory)cache.get(loader, key);
            if (factory == null) {
                String className = nameFactory.getNextName(TYPE);
                Class result = new DelegatorGenerator(className, classes, loader, bean).define();
                factory = (Factory)ReflectUtils.newInstance(result, Constants.TYPES_OBJECT_ARRAY, new Object[1]);
                cache.put(loader, key, factory);
            }
        }
        return factory.cglib_newInstance(delegates);
    }

    private static Class[] getAllInterfaces(Class clazz) {
        ArrayList interfaces = new ArrayList();
        while (!clazz.equals(class$java$lang$Object == null ? Delegator.class$("java.lang.Object") : class$java$lang$Object)) {
            interfaces.addAll(Arrays.asList(clazz.getInterfaces()));
            clazz = clazz.getSuperclass();
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Info {
        private Class[] interfaces;
        private int[] indexes;
        private Object key;

        public Info(Object[] incoming) {
            HashSet<Class> seenInterfaces = new HashSet<Class>();
            LinkedList<Class> interfaceList = new LinkedList<Class>();
            LinkedList<Integer> indexList = new LinkedList<Integer>();
            int i = 0;
            while (i < incoming.length) {
                Object delegate = incoming[i];
                Class[] delegateInterfaces = Delegator.getAllInterfaces(delegate.getClass());
                int j = 0;
                while (j < delegateInterfaces.length) {
                    Class iface = delegateInterfaces[j];
                    if (iface != null && !seenInterfaces.contains(iface)) {
                        interfaceList.add(iface);
                        indexList.add(new Integer(i));
                        seenInterfaces.add(iface);
                    }
                    ++j;
                }
                ++i;
            }
            this.interfaces = interfaceList.toArray(new Class[interfaceList.size()]);
            this.indexes = new int[this.interfaces.length];
            Iterator it = indexList.iterator();
            int i2 = 0;
            while (it.hasNext()) {
                this.indexes[i2] = (Integer)it.next();
                ++i2;
            }
            this.key = keyFactory.newInstance(this.interfaces);
        }
    }

    static interface Factory {
        public static final Class TYPE = 1.class$net$sf$cglib$Delegator$Factory == null ? (1.class$net$sf$cglib$Delegator$Factory = 1.class$("net.sf.cglib.Delegator$Factory")) : 1.class$net$sf$cglib$Delegator$Factory;

        public Object cglib_newInstance(Object[] var1);
    }

    public static interface DelegatorKey {
        public Object newInstance(Class[] var1);
    }
}

