/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sf.cglib.CodeGenerationException;
import net.sf.cglib.CodeGenerator;
import net.sf.cglib.Constants;
import net.sf.cglib.Delegator;
import net.sf.cglib.MethodWrapper;
import net.sf.cglib.ReflectUtils;

class DelegatorGenerator
extends CodeGenerator {
    private static final String FIELD_NAME = "CGLIB$DELEGATES";
    private static final Method NEW_INSTANCE = ReflectUtils.findMethod("Delegator$Factory.cglib_newInstance(Object[])");
    private Class[] classes;
    private boolean bean;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public DelegatorGenerator(String className, Class[] classes, ClassLoader loader, boolean bean) {
        super(className, class$java$lang$Object == null ? (class$java$lang$Object = DelegatorGenerator.class$("java.lang.Object")) : class$java$lang$Object, loader);
        this.classes = classes;
        this.bean = bean;
    }

    protected void generate() throws NoSuchMethodException {
        this.generateConstructor();
        this.generateFactoryMethod(NEW_INSTANCE);
        this.declare_interface(Delegator.Factory.TYPE);
        HashSet<Object> methodSet = new HashSet<Object>();
        int i = 0;
        while (i < this.classes.length) {
            Method[] methods;
            Class clazz = this.classes[i];
            if (this.bean) {
                methods = DelegatorGenerator.getBeanMethods(clazz);
            } else {
                if (!clazz.isInterface()) {
                    throw new IllegalArgumentException(clazz + " is not an interface");
                }
                this.declare_interface(clazz);
                methods = clazz.getMethods();
            }
            int j = 0;
            while (j < methods.length) {
                Method method = methods[j];
                Object methodKey = MethodWrapper.create(method);
                if (!methodSet.contains(methodKey)) {
                    methodSet.add(methodKey);
                    this.generateProxy(clazz, method, i);
                }
                ++j;
            }
            ++i;
        }
    }

    private static Method[] getBeanMethods(Class clazz) {
        try {
            BeanInfo info = Introspector.getBeanInfo(clazz, 3);
            PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
            ArrayList methods = new ArrayList(descriptors.length * 2);
            int i = 0;
            while (i < descriptors.length) {
                PropertyDescriptor pd = descriptors[i];
                DelegatorGenerator.addBeanMethod(methods, pd.getReadMethod());
                DelegatorGenerator.addBeanMethod(methods, pd.getWriteMethod());
                ++i;
            }
            return methods.toArray(new Method[methods.size()]);
        }
        catch (IntrospectionException e) {
            throw new CodeGenerationException(e);
        }
    }

    private static void addBeanMethod(List methods, Method method) {
        int mod;
        if (method != null && !Modifier.isFinal(mod = method.getModifiers()) && !Modifier.isAbstract(mod)) {
            methods.add(method);
        }
    }

    private void generateConstructor() {
        this.declare_field(2, array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = DelegatorGenerator.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, FIELD_NAME);
        this.begin_constructor(Constants.TYPES_OBJECT_ARRAY);
        this.load_this();
        this.super_invoke_constructor();
        this.load_this();
        this.load_arg(0);
        this.putfield(FIELD_NAME);
        this.return_value();
        this.end_method();
    }

    private void generateProxy(Class clazz, Method method, int arrayref) {
        this.begin_method(method);
        this.load_this();
        this.getfield(FIELD_NAME);
        this.aaload(arrayref);
        this.checkcast(clazz);
        this.load_args();
        this.invoke(method);
        this.return_value();
        this.end_method();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

