/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.sf.cglib.ClassNameFactory;
import net.sf.cglib.CodeGenerationException;
import net.sf.cglib.EnhancerGenerator;
import net.sf.cglib.Factory;
import net.sf.cglib.FactoryCache;
import net.sf.cglib.KeyFactory;
import net.sf.cglib.MethodFilter;
import net.sf.cglib.MethodInterceptor;
import net.sf.cglib.ReflectUtils;

public class Enhancer {
    private static final FactoryCache cache = new FactoryCache();
    private static final FactoryCache classCache = new FactoryCache();
    private static final ClassLoader defaultLoader = (class$net$sf$cglib$Enhancer == null ? (class$net$sf$cglib$Enhancer = Enhancer.class$("net.sf.cglib.Enhancer")) : class$net$sf$cglib$Enhancer).getClassLoader();
    private static final EnhancerKey keyFactory = (EnhancerKey)((Object)KeyFactory.create(class$net$sf$cglib$Enhancer$EnhancerKey == null ? (class$net$sf$cglib$Enhancer$EnhancerKey = Enhancer.class$("net.sf.cglib.Enhancer$EnhancerKey")) : class$net$sf$cglib$Enhancer$EnhancerKey, null));
    private static final ClassNameFactory nameFactory = new ClassNameFactory("EnhancedByCGLIB");
    static /* synthetic */ Class class$net$sf$cglib$Enhancer;
    static /* synthetic */ Class class$net$sf$cglib$Enhancer$EnhancerKey;
    static /* synthetic */ Class class$java$lang$Object;

    private Enhancer() {
    }

    public static MethodInterceptor getMethodInterceptor(Object enhanced) {
        return ((Factory)enhanced).interceptor();
    }

    public static Factory enhance(Class clazz, MethodInterceptor interceptor) {
        Class[] classArray;
        Class clazz2 = clazz.isInterface() ? null : clazz;
        if (clazz.isInterface()) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = clazz;
        } else {
            classArray = null;
        }
        return (Factory)Enhancer.enhanceHelper(clazz2, classArray, interceptor, clazz.getClassLoader(), null, null);
    }

    public static Object enhance(Class cls, Class[] interfaces, MethodInterceptor ih) {
        return Enhancer.enhance(cls, interfaces, ih, null, null);
    }

    public static Object enhance(Class cls, Class[] interfaces, MethodInterceptor ih, ClassLoader loader) {
        return Enhancer.enhance(cls, interfaces, ih, loader, null);
    }

    public static Object enhance(Class cls, Class[] interfaces, MethodInterceptor ih, ClassLoader loader, Method wreplace) {
        return Enhancer.enhanceHelper(cls, interfaces, ih, loader, wreplace, null);
    }

    public static Object enhance(Class cls, Class[] interfaces, MethodInterceptor ih, ClassLoader loader, Method wreplace, MethodFilter filter) {
        return Enhancer.enhanceHelper(cls, interfaces, ih, loader, wreplace, filter);
    }

    public static Class enhanceClass(Class cls, Class[] interfaces, ClassLoader loader, MethodFilter filter) {
        if (cls == null) {
            Class clazz = cls = class$java$lang$Object == null ? (class$java$lang$Object = Enhancer.class$("java.lang.Object")) : class$java$lang$Object;
        }
        if (loader == null) {
            loader = defaultLoader;
        }
        return Enhancer.enhanceClassHelper(cls, interfaces, loader, null, filter);
    }

    private static Object enhanceHelper(Class cls, Class[] interfaces, MethodInterceptor ih, ClassLoader loader, Method wreplace, MethodFilter filter) {
        Factory factory;
        if (ih == null) {
            throw new IllegalArgumentException("MethodInterceptor is null");
        }
        if (cls == null) {
            Class clazz = cls = class$java$lang$Object == null ? (class$java$lang$Object = Enhancer.class$("java.lang.Object")) : class$java$lang$Object;
        }
        if (loader == null) {
            loader = defaultLoader;
        }
        Object key = keyFactory.newInstance(cls, interfaces, wreplace, filter);
        FactoryCache factoryCache = cache;
        synchronized (factoryCache) {
            factory = (Factory)cache.get(loader, key);
            if (factory == null) {
                Class gen = Enhancer.enhanceClassHelper(cls, interfaces, loader, wreplace, filter);
                factory = (Factory)ReflectUtils.newInstance(gen);
                cache.put(loader, key, factory);
            }
        }
        return factory.newInstance(ih);
    }

    private static Class enhanceClassHelper(Class cls, Class[] interfaces, ClassLoader loader, Method wreplace, MethodFilter filter) {
        Class result;
        Object key = keyFactory.newInstance(cls, interfaces, wreplace, filter);
        FactoryCache factoryCache = classCache;
        synchronized (factoryCache) {
            result = (Class)classCache.get(loader, key);
            if (result == null) {
                String className = nameFactory.getNextName(cls);
                result = new EnhancerGenerator(className, cls, interfaces, loader, wreplace, filter).define();
                classCache.put(loader, key, result);
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ReadResolveException
    extends ObjectStreamException {
        private Throwable cause;

        public ReadResolveException(Throwable cause) {
            super(cause.getMessage());
            this.cause = cause;
        }

        public Throwable getCause() {
            return this.cause;
        }
    }

    public static class InternalReplace
    implements Serializable {
        private String parentClassName;
        private String[] interfaceNames;
        private MethodInterceptor mi;
        static /* synthetic */ Class class$net$sf$cglib$Enhancer;

        public InternalReplace() {
        }

        private InternalReplace(String parentClassName, String[] interfaceNames, MethodInterceptor mi) {
            this.parentClassName = parentClassName;
            this.interfaceNames = interfaceNames;
            this.mi = mi;
        }

        public static Object writeReplace(Object enhanced) throws ObjectStreamException {
            MethodInterceptor mi = Enhancer.getMethodInterceptor(enhanced);
            String parentClassName = enhanced.getClass().getSuperclass().getName();
            Class<?>[] interfaces = enhanced.getClass().getInterfaces();
            ArrayList<String> interfaceNames = new ArrayList<String>(interfaces.length);
            int i = 0;
            while (i < interfaces.length) {
                if (!interfaces[i].getPackage().equals((class$net$sf$cglib$Enhancer == null ? InternalReplace.class$("net.sf.cglib.Enhancer") : class$net$sf$cglib$Enhancer).getPackage())) {
                    interfaceNames.add(interfaces[i].getName());
                }
                ++i;
            }
            return new InternalReplace(parentClassName, interfaceNames.toArray(new String[interfaceNames.size()]), mi);
        }

        private Object readResolve() throws ObjectStreamException {
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                Class<?> parent = loader.loadClass(this.parentClassName);
                Class[] interfaces = null;
                if (this.interfaceNames != null) {
                    interfaces = new Class[this.interfaceNames.length];
                    int i = 0;
                    while (i < this.interfaceNames.length) {
                        interfaces[i] = loader.loadClass(this.interfaceNames[i]);
                        ++i;
                    }
                }
                return Enhancer.enhance(parent, interfaces, this.mi, loader);
            }
            catch (ClassNotFoundException e) {
                throw new ReadResolveException(e);
            }
            catch (CodeGenerationException e) {
                throw new ReadResolveException(e.getCause());
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static interface EnhancerKey {
        public Object newInstance(Class var1, Class[] var2, Method var3, Object var4);
    }
}

