/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.cglib.CodeGenerationException;
import net.sf.cglib.CodeGenerator;
import net.sf.cglib.Constants;
import net.sf.cglib.DuplicatesFilter;
import net.sf.cglib.MethodConstants;
import net.sf.cglib.MethodFilter;
import net.sf.cglib.MethodWrapper;
import net.sf.cglib.ModifierFilter;
import net.sf.cglib.ReflectUtils;
import net.sf.cglib.VisibilityFilter;

class EnhancerGenerator
extends CodeGenerator {
    private static final String INTERCEPTOR_FIELD = "CGLIB$INTERCEPTOR";
    private static final String CONSTRUCTOR_PROXY_MAP = "CGLIB$CONSTRUCTOR_PROXY_MAP";
    private static final int PRIVATE_FINAL_STATIC = 26;
    private static final Method NEW_INSTANCE = ReflectUtils.findMethod("Factory.newInstance(MethodInterceptor)");
    private static final Method AROUND_ADVICE = ReflectUtils.findMethod("MethodInterceptor.intercept(Object, Method, Object[], MethodProxy)");
    private static final Method MAKE_PROXY = ReflectUtils.findMethod("MethodProxy.create(Method,Method)");
    private static final Method MAKE_CONSTRUCTOR_PROXY = ReflectUtils.findMethod("ConstructorProxy.create(Constructor)");
    private static final Method INTERNAL_WRITE_REPLACE = ReflectUtils.findMethod("Enhancer$InternalReplace.writeReplace(Object)");
    private static final Method NEW_CLASS_KEY = ReflectUtils.findMethod("ConstructorProxy.newClassKey(Class[])");
    private static final Method PROXY_NEW_INSTANCE = ReflectUtils.findMethod("ConstructorProxy.newInstance(Object[])");
    private static final Method MULTIARG_NEW_INSTANCE = ReflectUtils.findMethod("Factory.newInstance(Class[], Object[], MethodInterceptor)");
    private static final Method GET_INTERCEPTOR = ReflectUtils.findMethod("Factory.interceptor()");
    private static final Method SET_INTERCEPTOR = ReflectUtils.findMethod("Factory.interceptor(MethodInterceptor)");
    private Class[] interfaces;
    private Method wreplace;
    private MethodFilter filter;
    private Constructor cstruct;
    private List constructorList;
    private boolean isProxy;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$cglib$Factory;
    static /* synthetic */ Class class$net$sf$cglib$MethodInterceptor;
    static /* synthetic */ Class class$java$lang$reflect$Method;
    static /* synthetic */ Class class$net$sf$cglib$MethodProxy;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$net$sf$cglib$ConstructorProxy;
    static /* synthetic */ Class class$java$lang$IllegalArgumentException;
    static /* synthetic */ Class class$java$io$ObjectStreamException;
    static /* synthetic */ Class class$java$lang$AbstractMethodError;
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$RuntimeException;
    static /* synthetic */ Class class$java$lang$Error;
    static /* synthetic */ Class class$net$sf$cglib$UndeclaredThrowableException;
    static /* synthetic */ Class class$java$util$HashMap;

    EnhancerGenerator(String className, Class clazz, Class[] interfaces, ClassLoader loader, Method wreplace, MethodFilter filter) {
        super(className, clazz, loader);
        this.interfaces = interfaces;
        this.wreplace = wreplace;
        this.filter = filter;
        this.isProxy = EnhancerGenerator.hasSuperclass(clazz, "net.sf.cglib.Proxy");
        if (!(wreplace == null || Modifier.isStatic(wreplace.getModifiers()) && Modifier.isPublic(wreplace.getModifiers()) && wreplace.getReturnType() == (class$java$lang$Object == null ? (class$java$lang$Object = EnhancerGenerator.class$("java.lang.Object")) : class$java$lang$Object) && wreplace.getParameterTypes().length == 1 && wreplace.getParameterTypes()[0] == (class$java$lang$Object == null ? (class$java$lang$Object = EnhancerGenerator.class$("java.lang.Object")) : class$java$lang$Object))) {
            throw new IllegalArgumentException(wreplace.toString());
        }
        try {
            VisibilityFilter vis = new VisibilityFilter(clazz);
            try {
                this.cstruct = clazz.getDeclaredConstructor(Constants.TYPES_EMPTY);
                if (!vis.accept(this.cstruct)) {
                    this.cstruct = null;
                }
            }
            catch (NoSuchMethodException ignore) {
                // empty catch block
            }
            this.constructorList = new ArrayList(Arrays.asList(clazz.getDeclaredConstructors()));
            this.filterMembers(this.constructorList, vis);
            if (this.constructorList.size() == 0) {
                throw new IllegalArgumentException("No visible constructors in " + clazz);
            }
            if (wreplace != null) {
                loader.loadClass(wreplace.getDeclaringClass().getName());
            }
            loader.loadClass(clazz.getName());
            if (interfaces != null) {
                int i = 0;
                while (i < interfaces.length) {
                    if (!interfaces[i].isInterface()) {
                        throw new IllegalArgumentException(interfaces[i] + " is not an interface");
                    }
                    loader.loadClass(interfaces[i].getName());
                    ++i;
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new CodeGenerationException(e);
        }
    }

    private static boolean hasSuperclass(Class clazz, String superclassName) {
        while (clazz != null) {
            if (clazz.getName().equals(superclassName)) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    protected void generate() throws NoSuchMethodException {
        Set forcePublic;
        int i;
        if (this.wreplace == null) {
            this.wreplace = INTERNAL_WRITE_REPLACE;
        }
        this.declare_interface(class$net$sf$cglib$Factory == null ? (class$net$sf$cglib$Factory = EnhancerGenerator.class$("net.sf.cglib.Factory")) : class$net$sf$cglib$Factory);
        this.declare_field(2, class$net$sf$cglib$MethodInterceptor == null ? (class$net$sf$cglib$MethodInterceptor = EnhancerGenerator.class$("net.sf.cglib.MethodInterceptor")) : class$net$sf$cglib$MethodInterceptor, INTERCEPTOR_FIELD);
        this.generateConstructors();
        this.generateFactory();
        ArrayList methods = new ArrayList();
        EnhancerGenerator.addDeclaredMethods(methods, this.getSuperclass());
        if (this.interfaces != null) {
            this.declare_interfaces(this.interfaces);
            ArrayList interfaceMethods = new ArrayList();
            i = 0;
            while (i < this.interfaces.length) {
                EnhancerGenerator.addDeclaredMethods(interfaceMethods, this.interfaces[i]);
                ++i;
            }
            forcePublic = MethodWrapper.createSet(interfaceMethods);
            methods.addAll(interfaceMethods);
        } else {
            forcePublic = Collections.EMPTY_SET;
        }
        this.filterMembers(methods, new VisibilityFilter(this.getSuperclass()));
        this.filterMembers(methods, new DuplicatesFilter());
        this.filterMembers(methods, new ModifierFilter(16, 0));
        if (this.filter != null) {
            this.filterMembers(methods, this.filter);
        }
        boolean declaresWriteReplace = false;
        i = 0;
        while (i < methods.size()) {
            Method method = (Method)methods.get(i);
            if (method.getName().equals("writeReplace") && method.getParameterTypes().length == 0) {
                declaresWriteReplace = true;
            }
            String fieldName = this.getFieldName(i);
            String accessName = this.getAccessName(method, i);
            this.declare_field(26, class$java$lang$reflect$Method == null ? EnhancerGenerator.class$("java.lang.reflect.Method") : class$java$lang$reflect$Method, fieldName);
            this.declare_field(26, class$net$sf$cglib$MethodProxy == null ? EnhancerGenerator.class$("net.sf.cglib.MethodProxy") : class$net$sf$cglib$MethodProxy, accessName);
            this.generateAccessMethod(method, accessName);
            this.generateAroundMethod(method, fieldName, accessName, forcePublic.contains(MethodWrapper.create(method)));
            ++i;
        }
        this.generateClInit(methods);
        if (!declaresWriteReplace) {
            this.generateWriteReplace();
        }
    }

    private void filterMembers(List members, MethodFilter filter) {
        Iterator it = members.iterator();
        while (it.hasNext()) {
            if (filter.accept((Member)it.next())) continue;
            it.remove();
        }
    }

    private String getFieldName(int index) {
        return "METHOD_" + index;
    }

    private String getAccessName(Method method, int index) {
        return "CGLIB$ACCESS_" + index + "_" + method.getName();
    }

    private void generateConstructors() throws NoSuchMethodException {
        Iterator i = this.constructorList.iterator();
        while (i.hasNext()) {
            Constructor constructor = (Constructor)i.next();
            this.begin_constructor(constructor);
            this.load_this();
            this.load_args();
            this.super_invoke(constructor);
            this.return_value();
            this.end_method();
        }
    }

    private void generateFactory() {
        this.begin_method(GET_INTERCEPTOR);
        this.load_this();
        this.getfield(INTERCEPTOR_FIELD);
        this.return_value();
        this.end_method();
        this.begin_method(SET_INTERCEPTOR);
        this.load_this();
        this.load_arg(0);
        this.putfield(INTERCEPTOR_FIELD);
        this.return_value();
        this.end_method();
        this.generateFactoryHelper(NEW_INSTANCE);
        this.generateMultiArgFactory();
    }

    private void generateFactoryHelper(Method method) {
        this.begin_method(method);
        this.new_instance_this();
        this.dup();
        this.invoke_constructor_this();
        this.dup();
        this.load_arg(0);
        this.putfield(INTERCEPTOR_FIELD);
        this.return_value();
        this.end_method();
    }

    private void generateMultiArgFactory() {
        this.declare_field(26, class$java$util$Map == null ? (class$java$util$Map = EnhancerGenerator.class$("java.util.Map")) : class$java$util$Map, CONSTRUCTOR_PROXY_MAP);
        this.begin_method(MULTIARG_NEW_INSTANCE);
        this.getfield(CONSTRUCTOR_PROXY_MAP);
        this.load_arg(0);
        this.invoke(NEW_CLASS_KEY);
        this.invoke(MethodConstants.MAP_GET);
        this.checkcast(class$net$sf$cglib$ConstructorProxy == null ? (class$net$sf$cglib$ConstructorProxy = EnhancerGenerator.class$("net.sf.cglib.ConstructorProxy")) : class$net$sf$cglib$ConstructorProxy);
        this.dup();
        this.ifnull("fail");
        this.load_arg(1);
        this.invoke(PROXY_NEW_INSTANCE);
        this.checkcast_this();
        this.load_arg(2);
        this.ifnull("skip_set_interceptor");
        this.dup();
        this.load_arg(2);
        this.putfield(INTERCEPTOR_FIELD);
        this.nop("skip_set_interceptor");
        this.return_value();
        this.nop("fail");
        this.throw_exception(class$java$lang$IllegalArgumentException == null ? (class$java$lang$IllegalArgumentException = EnhancerGenerator.class$("java.lang.IllegalArgumentException")) : class$java$lang$IllegalArgumentException, "Constructor not found ");
        this.end_method();
    }

    private void generateWriteReplace() {
        this.begin_method(2, class$java$lang$Object == null ? (class$java$lang$Object = EnhancerGenerator.class$("java.lang.Object")) : class$java$lang$Object, "writeReplace", Constants.TYPES_EMPTY, new Class[]{class$java$io$ObjectStreamException == null ? (class$java$io$ObjectStreamException = EnhancerGenerator.class$("java.io.ObjectStreamException")) : class$java$io$ObjectStreamException});
        this.load_this();
        this.invoke(this.wreplace);
        this.return_value();
        this.end_method();
    }

    private static void addDeclaredMethods(List methodList, Class clazz) {
        methodList.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        if (clazz.isInterface()) {
            Class<?>[] interfaces = clazz.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                EnhancerGenerator.addDeclaredMethods(methodList, interfaces[i]);
                ++i;
            }
        } else {
            Class superclass = clazz.getSuperclass();
            if (superclass != null) {
                EnhancerGenerator.addDeclaredMethods(methodList, superclass);
            }
        }
    }

    private void generateAccessMethod(Method method, String accessName) {
        this.begin_method(16, method.getReturnType(), accessName, method.getParameterTypes(), method.getExceptionTypes());
        if (Modifier.isAbstract(method.getModifiers())) {
            this.throw_exception(class$java$lang$AbstractMethodError == null ? (class$java$lang$AbstractMethodError = EnhancerGenerator.class$("java.lang.AbstractMethodError")) : class$java$lang$AbstractMethodError, method.toString() + " is abstract");
        } else {
            this.load_this();
            this.load_args();
            this.super_invoke(method);
        }
        this.return_value();
        this.end_method();
    }

    private void generateAroundMethod(Method method, String fieldName, String accessName, boolean forcePublic) {
        int modifiers = this.getDefaultModifiers(method);
        if (forcePublic) {
            modifiers = modifiers & 0xFFFFFFFB | 1;
        }
        this.begin_method(method, modifiers);
        Object handler = this.begin_handler();
        this.load_this();
        this.getfield(INTERCEPTOR_FIELD);
        this.dup();
        this.ifnull("null_interceptor");
        this.load_this();
        this.getfield(fieldName);
        this.create_arg_array();
        this.getfield(accessName);
        this.invoke(AROUND_ADVICE);
        if (this.isProxy) {
            this.unbox(method.getReturnType());
        } else {
            this.unbox_or_zero(method.getReturnType());
        }
        this.return_value();
        this.nop("null_interceptor");
        this.load_this();
        this.load_args();
        this.super_invoke(method);
        this.return_value();
        this.end_handler();
        this.generateHandleUndeclared(method, handler);
        this.end_method();
    }

    private void generateHandleUndeclared(Method method, Object handler) {
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        HashSet exceptionSet = new HashSet(Arrays.asList(exceptionTypes));
        if (!exceptionSet.contains(class$java$lang$Exception == null ? (class$java$lang$Exception = EnhancerGenerator.class$("java.lang.Exception")) : class$java$lang$Exception) && !exceptionSet.contains(class$java$lang$Throwable == null ? (class$java$lang$Throwable = EnhancerGenerator.class$("java.lang.Throwable")) : class$java$lang$Throwable)) {
            if (!exceptionSet.contains(class$java$lang$RuntimeException == null ? (class$java$lang$RuntimeException = EnhancerGenerator.class$("java.lang.RuntimeException")) : class$java$lang$RuntimeException)) {
                this.handle_exception(handler, class$java$lang$RuntimeException == null ? (class$java$lang$RuntimeException = EnhancerGenerator.class$("java.lang.RuntimeException")) : class$java$lang$RuntimeException);
                this.athrow();
            }
            if (!exceptionSet.contains(class$java$lang$Error == null ? (class$java$lang$Error = EnhancerGenerator.class$("java.lang.Error")) : class$java$lang$Error)) {
                this.handle_exception(handler, class$java$lang$Error == null ? (class$java$lang$Error = EnhancerGenerator.class$("java.lang.Error")) : class$java$lang$Error);
                this.athrow();
            }
            int i = 0;
            while (i < exceptionTypes.length) {
                this.handle_exception(handler, exceptionTypes[i]);
                this.athrow();
                ++i;
            }
            this.handle_exception(handler, class$java$lang$Throwable == null ? (class$java$lang$Throwable = EnhancerGenerator.class$("java.lang.Throwable")) : class$java$lang$Throwable);
            this.new_instance(class$net$sf$cglib$UndeclaredThrowableException == null ? (class$net$sf$cglib$UndeclaredThrowableException = EnhancerGenerator.class$("net.sf.cglib.UndeclaredThrowableException")) : class$net$sf$cglib$UndeclaredThrowableException);
            this.dup_x1();
            this.swap();
            this.invoke_constructor(class$net$sf$cglib$UndeclaredThrowableException == null ? (class$net$sf$cglib$UndeclaredThrowableException = EnhancerGenerator.class$("net.sf.cglib.UndeclaredThrowableException")) : class$net$sf$cglib$UndeclaredThrowableException, Constants.TYPES_THROWABLE);
            this.athrow();
        }
    }

    private void generateClInit(List methodList) throws NoSuchMethodException {
        this.begin_static();
        Object args = this.make_local();
        int i = 0;
        int size = methodList.size();
        while (i < size) {
            Method method = (Method)methodList.get(i);
            String fieldName = this.getFieldName(i);
            this.load_class(method.getDeclaringClass());
            this.push(method.getName());
            this.push_object(method.getParameterTypes());
            this.dup();
            this.store_local(args);
            this.invoke(MethodConstants.GET_DECLARED_METHOD);
            this.dup();
            this.putfield(fieldName);
            String accessName = this.getAccessName(method, i);
            this.load_class_this();
            this.push(accessName);
            this.load_local(args);
            this.invoke(MethodConstants.GET_DECLARED_METHOD);
            this.invoke(MAKE_PROXY);
            this.putfield(accessName);
            ++i;
        }
        this.new_instance(class$java$util$HashMap == null ? (class$java$util$HashMap = EnhancerGenerator.class$("java.util.HashMap")) : class$java$util$HashMap);
        this.dup();
        this.dup();
        this.invoke_constructor(class$java$util$HashMap == null ? (class$java$util$HashMap = EnhancerGenerator.class$("java.util.HashMap")) : class$java$util$HashMap);
        this.putfield(CONSTRUCTOR_PROXY_MAP);
        Object map = this.make_local();
        this.store_local(map);
        int i2 = 0;
        int size2 = this.constructorList.size();
        while (i2 < size2) {
            Constructor constructor = (Constructor)this.constructorList.get(i2);
            Object[] types = constructor.getParameterTypes();
            this.load_local(map);
            this.push(types);
            this.invoke(NEW_CLASS_KEY);
            this.load_class_this();
            this.push(types);
            this.invoke(MethodConstants.GET_DECLARED_CONSTRUCTOR);
            this.invoke(MAKE_CONSTRUCTOR_PROXY);
            this.invoke(MethodConstants.MAP_PUT);
            ++i2;
        }
        this.return_value();
        this.end_method();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

