/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib;

import java.lang.reflect.Method;
import net.sf.cglib.ClassNameFactory;
import net.sf.cglib.CodeGenerationException;
import net.sf.cglib.CodeGenerator;
import net.sf.cglib.FactoryCache;
import net.sf.cglib.KeyFactory;
import net.sf.cglib.ReflectUtils;

public abstract class MethodDelegate {
    static final Class TYPE = class$net$sf$cglib$MethodDelegate == null ? (class$net$sf$cglib$MethodDelegate = MethodDelegate.class$("net.sf.cglib.MethodDelegate")) : class$net$sf$cglib$MethodDelegate;
    private static final FactoryCache cache = new FactoryCache();
    private static final ClassLoader defaultLoader = TYPE.getClassLoader();
    private static final ClassNameFactory nameFactory = new ClassNameFactory("DelegatedByCGLIB");
    private static final MethodDelegateKey keyFactory = (MethodDelegateKey)((Object)KeyFactory.create(class$net$sf$cglib$MethodDelegate$MethodDelegateKey == null ? (class$net$sf$cglib$MethodDelegate$MethodDelegateKey = MethodDelegate.class$("net.sf.cglib.MethodDelegate$MethodDelegateKey")) : class$net$sf$cglib$MethodDelegate$MethodDelegateKey, null));
    private static final Method NEW_INSTANCE = ReflectUtils.findMethod("MethodDelegate.cglib_newInstance(Object)");
    protected Object delegate;
    protected String eqMethod;
    static /* synthetic */ Class class$net$sf$cglib$MethodDelegate;
    static /* synthetic */ Class class$net$sf$cglib$MethodDelegate$MethodDelegateKey;

    public boolean equals(Object obj) {
        MethodDelegate other = (MethodDelegate)obj;
        return this.delegate == other.delegate && this.eqMethod.equals(other.eqMethod);
    }

    public int hashCode() {
        return this.delegate.hashCode() ^ this.eqMethod.hashCode();
    }

    public Object getInvocationTarget() {
        return this.delegate;
    }

    protected MethodDelegate() {
    }

    protected abstract MethodDelegate cglib_newInstance(Object var1);

    public static MethodDelegate createStatic(Class clazz, String methodName, Class iface) {
        return MethodDelegate.createHelper(null, clazz, methodName, iface, null);
    }

    public static MethodDelegate createStatic(Class clazz, String methodName, Class iface, ClassLoader loader) {
        return MethodDelegate.createHelper(null, clazz, methodName, iface, loader);
    }

    public static MethodDelegate create(Object delegate, String methodName, Class iface) {
        return MethodDelegate.createHelper(delegate, delegate.getClass(), methodName, iface, null);
    }

    public static MethodDelegate create(Object delegate, String methodName, Class iface, ClassLoader loader) {
        return MethodDelegate.createHelper(delegate, delegate.getClass(), methodName, iface, loader);
    }

    private static MethodDelegate createHelper(Object delegate, Class clazz, String methodName, Class iface, ClassLoader loader) {
        MethodDelegate factory;
        if (loader == null) {
            loader = defaultLoader;
        }
        Object key = keyFactory.newInstance(clazz, methodName, iface);
        FactoryCache factoryCache = cache;
        synchronized (factoryCache) {
            factory = (MethodDelegate)cache.get(loader, key);
            if (factory == null) {
                Method method = MethodDelegate.findProxiedMethod(clazz, methodName, iface);
                String className = nameFactory.getNextName(clazz);
                Class result = new Generator(className, method, iface, loader).define();
                factory = (MethodDelegate)ReflectUtils.newInstance(result);
                cache.put(loader, key, factory);
            }
        }
        return factory.cglib_newInstance(delegate);
    }

    static Method findInterfaceMethod(Class iface) {
        if (!iface.isInterface()) {
            throw new IllegalArgumentException(iface + " is not an interface");
        }
        Method[] methods = iface.getDeclaredMethods();
        if (methods.length != 1) {
            throw new IllegalArgumentException("expecting exactly 1 method in " + iface);
        }
        return methods[0];
    }

    private static Method findProxiedMethod(Class clazz, String methodName, Class iface) {
        Method proxy = MethodDelegate.findInterfaceMethod(iface);
        try {
            Method method = clazz.getMethod(methodName, proxy.getParameterTypes());
            if (method == null) {
                throw new IllegalArgumentException("no matching method found");
            }
            if (!proxy.getReturnType().isAssignableFrom(method.getReturnType())) {
                throw new IllegalArgumentException("incompatible return types");
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new CodeGenerationException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Generator
    extends CodeGenerator {
        private Method method;
        private Class iface;
        static /* synthetic */ Class class$net$sf$cglib$MethodDelegate;
        static /* synthetic */ Class class$java$lang$String;

        public Generator(String className, Method method, Class iface, ClassLoader loader) {
            super(className, class$net$sf$cglib$MethodDelegate == null ? (class$net$sf$cglib$MethodDelegate = Generator.class$("net.sf.cglib.MethodDelegate")) : class$net$sf$cglib$MethodDelegate, loader);
            this.method = method;
            this.iface = iface;
        }

        protected void generate() throws NoSuchMethodException, NoSuchFieldException {
            this.declare_field(26, class$java$lang$String == null ? (class$java$lang$String = Generator.class$("java.lang.String")) : class$java$lang$String, "eqMethod");
            this.declare_interface(this.iface);
            this.generateNullConstructor();
            this.begin_method(this.iface.getDeclaredMethods()[0]);
            this.load_this();
            this.super_getfield("delegate");
            this.checkcast(this.method.getDeclaringClass());
            this.load_args();
            this.invoke(this.method);
            this.return_value();
            this.end_method();
            this.begin_method(NEW_INSTANCE);
            this.new_instance_this();
            this.dup();
            this.dup2();
            this.invoke_constructor_this();
            this.getfield("eqMethod");
            this.super_putfield("eqMethod");
            this.load_arg(0);
            this.super_putfield("delegate");
            this.return_value();
            this.end_method();
            this.begin_static();
            this.push(this.getSignature(this.method));
            this.putfield("eqMethod");
            this.return_value();
            this.end_method();
        }

        private String getSignature(Method method) {
            StringBuffer sb = new StringBuffer();
            sb.append(method.getDeclaringClass().getName()).append('.');
            sb.append(method.getName()).append('(');
            Class<?>[] types = method.getParameterTypes();
            int i = 0;
            while (i < types.length) {
                sb.append(types[i].getName());
                ++i;
            }
            return sb.toString();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static interface MethodDelegateKey {
        public Object newInstance(Class var1, String var2, Class var3);
    }
}

