/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.cglib.ClassNameFactory;
import net.sf.cglib.CodeGenerationException;
import net.sf.cglib.CodeGenerator;
import net.sf.cglib.Constants;
import net.sf.cglib.ReflectUtils;

public abstract class MethodProxy {
    private static final Method INVOKE_SUPER = ReflectUtils.findMethod("MethodProxy.invokeSuper(Object, Object[])");
    private static final Method INVOKE = ReflectUtils.findMethod("MethodProxy.invoke(Object, Object[])");
    private static final ClassNameFactory NAME_FACTORY = new ClassNameFactory("ProxiedByCGLIB");
    private static final ClassLoader DEFAULT_LOADER = (class$net$sf$cglib$MethodProxy == null ? (class$net$sf$cglib$MethodProxy = MethodProxy.class$("net.sf.cglib.MethodProxy")) : class$net$sf$cglib$MethodProxy).getClassLoader();
    static /* synthetic */ Class class$net$sf$cglib$MethodProxy;

    public abstract Object invokeSuper(Object var1, Object[] var2) throws Throwable;

    public abstract Object invoke(Object var1, Object[] var2) throws Throwable;

    protected MethodProxy() {
    }

    public static MethodProxy create(Method method, Method superMethod) {
        return MethodProxy.create(method, superMethod, null);
    }

    public static MethodProxy create(Method method, Method superMethod, ClassLoader loader) {
        try {
            Class<?> declaring = superMethod.getDeclaringClass();
            String className = NAME_FACTORY.getNextName(declaring);
            if (loader == null && (loader = declaring.getClassLoader()) == null) {
                loader = DEFAULT_LOADER;
            }
            Class gen = new Generator(className, superMethod, method, loader).define();
            return (MethodProxy)gen.getConstructor(Constants.TYPES_EMPTY).newInstance(null);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Generator
    extends CodeGenerator {
        private Method method;
        private Method superMethod;
        static /* synthetic */ Class class$net$sf$cglib$MethodProxy;
        static /* synthetic */ Class class$java$lang$IllegalAccessException;

        public Generator(String className, Method superMethod, Method method, ClassLoader loader) {
            super(className, class$net$sf$cglib$MethodProxy == null ? (class$net$sf$cglib$MethodProxy = Generator.class$("net.sf.cglib.MethodProxy")) : class$net$sf$cglib$MethodProxy, loader);
            this.method = method;
            this.superMethod = superMethod;
        }

        public void generate() {
            this.generateNullConstructor();
            this.generate(INVOKE, this.method);
            this.generate(INVOKE_SUPER, this.superMethod);
        }

        private void generate(Method proxyMethod, Method method) {
            this.begin_method(proxyMethod);
            if (Modifier.isProtected(method.getModifiers())) {
                this.throw_exception(class$java$lang$IllegalAccessException == null ? (class$java$lang$IllegalAccessException = Generator.class$("java.lang.IllegalAccessException")) : class$java$lang$IllegalAccessException, "not public method: " + method);
            } else {
                this.load_arg(0);
                this.checkcast(method.getDeclaringClass());
                Class<?>[] types = method.getParameterTypes();
                int i = 0;
                while (i < types.length) {
                    this.load_arg(1);
                    this.push(i);
                    this.aaload();
                    this.unbox(types[i]);
                    ++i;
                }
                this.invoke(method);
                this.box(method.getReturnType());
            }
            this.return_value();
            this.end_method();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

