/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.CodeGenerationException;
import net.sf.cglib.Constants;

abstract class ReflectUtils {
    private static final Map primitives = new HashMap(8);
    private static final Map transforms = new HashMap(8);
    private static final ClassLoader defaultLoader = (class$net$sf$cglib$ReflectUtils == null ? (class$net$sf$cglib$ReflectUtils = ReflectUtils.class$("net.sf.cglib.ReflectUtils")) : class$net$sf$cglib$ReflectUtils).getClassLoader();
    private static final String[] packages = new String[]{"java.lang", "java.lang.reflect", "net.sf.cglib"};
    static /* synthetic */ Class class$net$sf$cglib$ReflectUtils;

    ReflectUtils() {
    }

    public static Method findMethod(String desc) {
        return ReflectUtils.findMethod(desc, defaultLoader);
    }

    public static Method findMethod(String desc, ClassLoader loader) {
        try {
            int comma;
            int lparen = desc.indexOf(40);
            int rparen = desc.indexOf(41, lparen);
            int dot = desc.lastIndexOf(46, lparen);
            String className = desc.substring(0, dot).trim();
            String methodName = desc.substring(dot + 1, lparen).trim();
            ArrayList<String> params = new ArrayList<String>();
            int start = lparen + 1;
            while ((comma = desc.indexOf(44, start)) >= 0) {
                params.add(desc.substring(start, comma).trim());
                start = comma + 1;
            }
            if (start < rparen) {
                params.add(desc.substring(start, rparen).trim());
            }
            Class cls = ReflectUtils.getClass(className, loader);
            Class[] types = new Class[params.size()];
            int i = 0;
            while (i < types.length) {
                types[i] = ReflectUtils.getClass((String)params.get(i), loader);
                ++i;
            }
            return cls.getDeclaredMethod(methodName, types);
        }
        catch (ClassNotFoundException e) {
            throw new CodeGenerationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new CodeGenerationException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static Class getClass(String className, ClassLoader loader) throws ClassNotFoundException {
        save = className;
        dimensions = 0;
        index = 0;
        while ((index = className.indexOf("[]", index) + 1) > 0) {
            ++dimensions;
        }
        brackets = new StringBuffer(className.length() - dimensions);
        i = 0;
        while (i < dimensions) {
            brackets.append('[');
            ++i;
        }
        className = className.substring(0, className.length() - 2 * dimensions);
        prefix = dimensions > 0 ? brackets + "L" : "";
        suffix = dimensions > 0 ? ";" : "";
        try {
            return Class.forName(prefix + className + suffix, false, loader);
        }
        catch (ClassNotFoundException ignore) {
            i = 0;
            ** while (i < ReflectUtils.packages.length)
        }
lbl-1000:
        // 1 sources

        {
            try {
                return Class.forName(prefix + ReflectUtils.packages[i] + '.' + className + suffix, false, loader);
            }
            catch (ClassNotFoundException ignore) {
                ++i;
            }
            continue;
        }
lbl27:
        // 1 sources

        if (dimensions == 0) {
            c = (Class)ReflectUtils.primitives.get(className);
            if (c != null) {
                return c;
            }
        } else {
            transform = (String)ReflectUtils.transforms.get(className);
            if (transform != null) {
                try {
                    return Class.forName(brackets + transform, false, loader);
                }
                catch (ClassNotFoundException ignore) {
                    // empty catch block
                }
            }
        }
        throw new ClassNotFoundException(save);
    }

    public static Class forName(String name, ClassLoader loader) {
        try {
            return Class.forName(name, false, loader);
        }
        catch (ClassNotFoundException e) {
            throw new CodeGenerationException(e);
        }
    }

    public static Object newInstance(Class clazz) {
        return ReflectUtils.newInstance(clazz, Constants.TYPES_EMPTY, null);
    }

    public static Object newInstance(Class clazz, Class[] parameterTypes, Object[] args) {
        try {
            return clazz.getConstructor(parameterTypes).newInstance(args);
        }
        catch (NoSuchMethodException e) {
            throw new CodeGenerationException(e);
        }
        catch (InstantiationException e) {
            throw new CodeGenerationException(e);
        }
        catch (IllegalAccessException e) {
            throw new CodeGenerationException(e);
        }
        catch (InvocationTargetException e) {
            throw new CodeGenerationException(e.getTargetException());
        }
    }

    public static Class[] getClasses(Object[] objects) {
        Class[] classes = new Class[objects.length];
        int i = 0;
        while (i < objects.length) {
            classes[i] = objects[i].getClass();
            ++i;
        }
        return classes;
    }

    public static Method findNewInstance(Class iface) {
        if (!iface.isInterface()) {
            throw new IllegalArgumentException(iface + " is not an interface");
        }
        Method newInstance = null;
        Method[] methods = iface.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals("newInstance")) {
                if (newInstance != null) {
                    throw new IllegalArgumentException("Multiple newInstance methods");
                }
                newInstance = methods[i];
            }
            ++i;
        }
        if (newInstance == null) {
            throw new IllegalArgumentException("Missing newInstance method");
        }
        return newInstance;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        primitives.put("char", Character.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("boolean", Boolean.TYPE);
        transforms.put("byte", "B");
        transforms.put("char", "C");
        transforms.put("double", "D");
        transforms.put("float", "F");
        transforms.put("int", "I");
        transforms.put("long", "J");
        transforms.put("short", "S");
        transforms.put("boolean", "Z");
    }
}

