/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.sf.cglib.CodeGeneratorBackend;

public class StandaloneBackend
extends CodeGeneratorBackend {
    private ByteArrayOutputStream methodBytes;
    private DataOutputStream out;
    private static final short NOP = 0;
    private static final short ACONST_NULL = 1;
    private static final short ICONST_0 = 3;
    private static final short LCONST_0 = 9;
    private static final short FCONST_0 = 11;
    private static final short DCONST_0 = 14;
    private static final short BIPUSH = 16;
    private static final short SIPUSH = 17;
    private static final short ILOAD = 21;
    private static final short LLOAD = 22;
    private static final short FLOAD = 23;
    private static final short DLOAD = 24;
    private static final short ALOAD = 25;
    private static final short IALOAD = 46;
    private static final short LALOAD = 47;
    private static final short FALOAD = 48;
    private static final short DALOAD = 49;
    private static final short AALOAD = 50;
    private static final short BALOAD = 51;
    private static final short CALOAD = 52;
    private static final short SALOAD = 53;
    private static final short ISTORE = 54;
    private static final short LSTORE = 55;
    private static final short FSTORE = 56;
    private static final short DSTORE = 57;
    private static final short ASTORE = 58;
    private static final short IASTORE = 79;
    private static final short LASTORE = 80;
    private static final short FASTORE = 81;
    private static final short DASTORE = 82;
    private static final short AASTORE = 83;
    private static final short BASTORE = 84;
    private static final short CASTORE = 85;
    private static final short SASTORE = 86;
    private static final short POP = 87;
    private static final short POP2 = 88;
    private static final short DUP = 89;
    private static final short DUP_X1 = 90;
    private static final short DUP_X2 = 91;
    private static final short DUP2 = 92;
    private static final short SWAP = 95;
    private static final short IADD = 96;
    private static final short IMUL = 104;
    private static final short LUSHR = 125;
    private static final short IXOR = 130;
    private static final short LXOR = 131;
    private static final short L2I = 136;
    private static final short LCMP = 148;
    private static final short FCMPG = 150;
    private static final short DCMPG = 152;
    private static final short IFEQ = 153;
    private static final short IFNE = 154;
    private static final short IFLT = 155;
    private static final short IFGE = 156;
    private static final short IFGT = 157;
    private static final short IFLE = 158;
    private static final short IF_ICMPEQ = 159;
    private static final short IF_ICMPNE = 160;
    private static final short IF_ICMPLT = 161;
    private static final short IRETURN = 172;
    private static final short LRETURN = 173;
    private static final short FRETURN = 174;
    private static final short DRETURN = 175;
    private static final short ARETURN = 176;
    private static final short ARRAYLENGTH = 190;
    private static final short ATHROW = 191;
    private static final short IFNULL = 198;
    private static final short IFNONNULL = 199;

    public StandaloneBackend(String className, Class superclass) {
        super(className, superclass);
    }

    public byte[] getBytes() {
        return null;
    }

    public void ifeq(Object label) {
        this.ifbranch(153, label);
    }

    public void ifne(Object label) {
        this.ifbranch(154, label);
    }

    public void iflt(Object label) {
        this.ifbranch(155, label);
    }

    public void ifge(Object label) {
        this.ifbranch(156, label);
    }

    public void ifgt(Object label) {
        this.ifbranch(157, label);
    }

    public void ifle(Object label) {
        this.ifbranch(158, label);
    }

    public void ifnull(Object label) {
        this.ifbranch(198, label);
    }

    public void ifnonnull(Object label) {
        this.ifbranch(199, label);
    }

    public void if_icmplt(Object label) {
        this.ifbranch(161, label);
    }

    public void if_icmpne(Object label) {
        this.ifbranch(160, label);
    }

    public void if_icmpeq(Object label) {
        this.ifbranch(159, label);
    }

    public void imul() {
        this.simple(104);
    }

    public void iadd() {
        this.simple(96);
    }

    public void lushr() {
        this.simple(125);
    }

    public void lxor() {
        this.simple(131);
    }

    public void ixor() {
        this.simple(130);
    }

    public void l2i() {
        this.simple(136);
    }

    public void dcmpg() {
        this.simple(152);
    }

    public void fcmpg() {
        this.simple(150);
    }

    public void lcmp() {
        this.simple(148);
    }

    public void aconst_null() {
        this.simple(1);
    }

    public void arraylength() {
        this.simple(190);
    }

    public void athrow() {
        this.simple(191);
    }

    public void pop() {
        this.simple(87);
    }

    public void pop2() {
        this.simple(88);
    }

    public void dup() {
        this.simple(89);
    }

    public void dup2() {
        this.simple(92);
    }

    public void dup_x1() {
        this.simple(90);
    }

    public void dup_x2() {
        this.simple(91);
    }

    public void swap() {
        this.simple(95);
    }

    public void laload() {
        this.simple(47);
    }

    public void daload() {
        this.simple(49);
    }

    public void faload() {
        this.simple(48);
    }

    public void saload() {
        this.simple(53);
    }

    public void caload() {
        this.simple(52);
    }

    public void iaload() {
        this.simple(46);
    }

    public void baload() {
        this.simple(51);
    }

    public void aaload() {
        this.simple(50);
    }

    public void lastore() {
        this.simple(80);
    }

    public void dastore() {
        this.simple(82);
    }

    public void fastore() {
        this.simple(81);
    }

    public void sastore() {
        this.simple(86);
    }

    public void castore() {
        this.simple(85);
    }

    public void iastore() {
        this.simple(79);
    }

    public void bastore() {
        this.simple(84);
    }

    public void aastore() {
        this.simple(83);
    }

    public void iconst(int value) {
        this.simple(3 + value);
    }

    public void bipush(byte value) {
        this.pushBS(16, value);
    }

    public void sipush(short value) {
        this.pushBS(17, value);
    }

    public void lconst(long value) {
        this.simple(9 + (int)value);
    }

    public void fconst(float value) {
        this.simple(11 + (int)value);
    }

    public void dconst(double value) {
        this.simple(14 + (int)value);
    }

    public void lload(int index) {
        this.load(22, index);
    }

    public void dload(int index) {
        this.load(24, index);
    }

    public void fload(int index) {
        this.load(23, index);
    }

    public void iload(int index) {
        this.load(21, index);
    }

    public void aload(int index) {
        this.load(25, index);
    }

    public void lstore(int index) {
        this.store(55, index);
    }

    public void dstore(int index) {
        this.store(57, index);
    }

    public void fstore(int index) {
        this.store(56, index);
    }

    public void istore(int index) {
        this.store(54, index);
    }

    public void astore(int index) {
        this.store(58, index);
    }

    public void lreturn() {
        this.simple(173);
    }

    public void dreturn() {
        this.simple(175);
    }

    public void freturn() {
        this.simple(174);
    }

    public void ireturn() {
        this.simple(172);
    }

    public void areturn() {
        this.simple(176);
    }

    public void nop(Object label) {
        this.simple(label, 0);
    }

    public void goTo(Object label) {
    }

    public void newarray(Class clazz) {
    }

    public void anewarray(Class clazz) {
    }

    public void new_instance(String className) {
    }

    public void checkcast(String className) {
    }

    public void instance_of(String className) {
    }

    public void invoke_interface(String className, String methodName, Class returnType, Class[] parameterTypes) {
    }

    public void invoke_virtual(String className, String methodName, Class returnType, Class[] parameterTypes) {
    }

    public void invoke_static(String className, String methodName, Class returnType, Class[] parameterTypes) {
    }

    public void invoke_special(String className, String methodName, Class returnType, Class[] parameterTypes) {
    }

    public void declare_field(int modifiers, Class type, String name) {
    }

    public void getfield(String className, String fieldName, Class type) {
    }

    public void putfield(String className, String fieldName, Class type) {
    }

    public void getstatic(String className, String fieldName, Class type) {
    }

    public void putstatic(String className, String fieldName, Class type) {
    }

    public void begin_static() {
    }

    public void begin_constructor(Class[] parameterTypes) {
    }

    public void declare_interface(Class iface) {
    }

    public void begin_method(int modifiers, Class returnType, String name, Class[] parameterTypes, Class[] exceptionTypes) {
        this.methodBytes = new ByteArrayOutputStream();
        this.out = new DataOutputStream(this.methodBytes);
    }

    public Object start_range() {
        return null;
    }

    public Object end_range() {
        return null;
    }

    public void handle_exception(Object start, Object end, Class exceptionType) {
    }

    public void end_method() {
    }

    public void ldc(String value) {
    }

    public void ldc(double value) {
    }

    public void ldc(long value) {
    }

    public void ldc(int value) {
    }

    public void ldc(float value) {
    }

    public void returnVoid() {
    }

    public void iinc(int index, int amount) {
    }

    private void simple(int opcode) {
        try {
            this.out.writeByte(opcode);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void simple(Object label, int opcode) {
    }

    private void pushBS(int opcode, int value) {
    }

    private void load(int opcode, int index) {
    }

    private void store(int opcode, int index) {
    }

    private void ifbranch(int opcode, Object label) {
    }
}

