/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib;

import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import net.sf.cglib.MethodFilter;

class VisibilityFilter
implements MethodFilter {
    private Package pkg;

    public VisibilityFilter(Class source) {
        this.pkg = source.getPackage();
    }

    public boolean accept(Member method) {
        return VisibilityFilter.accept(method, this.pkg);
    }

    private static boolean accept(Member member, Package pkg) {
        int mod = member.getModifiers();
        if (Modifier.isStatic(mod) || Modifier.isPrivate(mod)) {
            return false;
        }
        if (Modifier.isProtected(mod) || Modifier.isPublic(mod)) {
            return true;
        }
        Package other = member.getDeclaringClass().getPackage();
        return null == pkg ? other == null : pkg.equals(other);
    }

    public int hashCode() {
        return null == this.pkg ? 0 : this.pkg.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof VisibilityFilter) {
            return ((VisibilityFilter)obj).pkg == this.pkg;
        }
        return false;
    }
}

