/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config;

import java.io.File;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.ehcache.config.BeanHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.helpers.DefaultHandler;

public class Configurator {
    private static final Log LOG = LogFactory.getLog((class$net$sf$ehcache$config$Configurator == null ? (class$net$sf$ehcache$config$Configurator = Configurator.class$("net.sf.ehcache.config.Configurator")) : class$net$sf$ehcache$config$Configurator).getName());
    private static final String DEFAULT_CLASSPATH_CONFIGURATION_FILE = "/ehcache.xml";
    private static final String FAILSAFE_CLASSPATH_CONFIGURATION_FILE = "/ehcache-failsafe.xml";
    static /* synthetic */ Class class$net$sf$ehcache$config$Configurator;

    public void configure(Object bean, File file) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configuring ehcache from file: " + file.toString());
        }
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        BeanHandler handler = new BeanHandler(bean);
        parser.parse(file, (DefaultHandler)handler);
    }

    public void configure(Object bean, URL url) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configuring ehcache from URL: " + url);
        }
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        BeanHandler handler = new BeanHandler(bean);
        parser.parse(url.toExternalForm(), (DefaultHandler)handler);
    }

    public void configure(Object bean) throws Exception {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        BeanHandler handler = new BeanHandler(bean);
        URL url = this.getClass().getResource(DEFAULT_CLASSPATH_CONFIGURATION_FILE);
        if (url != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Configuring ehcache from ehcache.xml found in the classpath: " + url);
            }
        } else {
            url = this.getClass().getResource(FAILSAFE_CLASSPATH_CONFIGURATION_FILE);
            if (LOG.isWarnEnabled()) {
                LOG.warn("No configuration found. Configuring ehcache from ehcache-failsafe.xml found in the classpath: " + url);
            }
        }
        parser.parse(url.toExternalForm(), (DefaultHandler)handler);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

