/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.Store;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiskStore
implements Store {
    private static final Log LOG = LogFactory.getLog((class$net$sf$ehcache$store$DiskStore == null ? (class$net$sf$ehcache$store$DiskStore = DiskStore.class$("net.sf.ehcache.store.DiskStore")) : class$net$sf$ehcache$store$DiskStore).getName());
    private static Map caches = Collections.synchronizedMap(new HashMap());
    private final String name;
    private boolean active;
    private RandomAccessFile file;
    private final Map elements = new HashMap();
    private final Map spool = new HashMap();
    private Thread spoolThread;
    private Thread expiryThread;
    private final ArrayList freeSpace = new ArrayList();
    private long totalSize;
    private int expiryThreadInterval;
    private Cache cache;
    private File dataFile;
    private int status = 1;
    static /* synthetic */ Class class$net$sf$ehcache$store$DiskStore;

    public DiskStore(Cache cache, String diskPath) {
        this(cache, diskPath, 1500);
    }

    public DiskStore(Cache cache, String diskPath, int expiryThreadInterval) {
        this.cache = cache;
        this.name = cache.getName();
        caches.put(this.name, this);
        try {
            File diskDir = new File(diskPath);
            if (diskDir.exists() && !diskDir.isDirectory()) {
                throw new Exception("Store directory \"" + diskDir.getCanonicalPath() + "\" exists and is not a directory.");
            }
            if (!diskDir.exists() && !diskDir.mkdirs()) {
                throw new Exception("Could not create cache directory \"" + diskDir.getCanonicalPath() + "\".");
            }
            this.dataFile = new File(diskDir, this.name + ".data");
            this.dataFile.delete();
            this.file = new RandomAccessFile(this.dataFile, "rw");
            this.active = true;
            this.spoolThread = new SpoolThread();
            this.spoolThread.start();
            if (!cache.isEternal()) {
                this.expiryThread = new ExpiryThread(expiryThreadInterval);
                this.expiryThread.start();
            }
            this.status = 2;
        }
        catch (Exception e) {
            this.dispose();
            LOG.error(this.name + "Cache: Could not create disk store", e);
        }
    }

    public static Store getCache(String name) {
        return (Store)caches.get(name);
    }

    private void checkActive() throws Exception {
        if (!this.active) {
            throw new Exception(this.name + "Cache: The Disk store is not active.");
        }
    }

    public int getCacheType() {
        return 2;
    }

    public String getName() {
        return this.name;
    }

    public synchronized int getStatus() {
        return 2;
    }

    public synchronized Element get(Serializable key) throws IOException {
        try {
            this.checkActive();
            Element element = (Element)this.spool.remove(key);
            if (element != null) {
                element.updateAccessStatistics();
                return element;
            }
            DiskElement diskElement = (DiskElement)this.elements.get(key);
            if (diskElement == null) {
                return null;
            }
            this.file.seek(diskElement.position);
            byte[] buffer = new byte[diskElement.payloadSize];
            this.file.readFully(buffer);
            ByteArrayInputStream instr = new ByteArrayInputStream(buffer);
            ObjectInputStream objstr = new ObjectInputStream(instr);
            element = (Element)objstr.readObject();
            element.updateAccessStatistics();
            return element;
        }
        catch (Exception e) {
            LOG.error(this.name + "Cache: Could not read disk store element for key " + key, e);
            return null;
        }
    }

    public synchronized Object[] getKeyArray() {
        return this.elements.keySet().toArray();
    }

    public synchronized int getSize() {
        try {
            this.checkActive();
            return this.elements.size() + this.spool.size();
        }
        catch (Exception e) {
            LOG.error(this.name + "Cache: Could not determine size of disk store.", e);
            return 0;
        }
    }

    public synchronized void put(Element entry) throws IOException {
        try {
            this.checkActive();
            this.spool.put(entry.getKey(), entry);
            this.notifyAll();
        }
        catch (Exception e) {
            LOG.error(this.name + "Cache: Could not write disk store element for " + entry.getKey(), e);
        }
    }

    public synchronized boolean remove(Serializable key) throws IOException {
        try {
            this.checkActive();
            Object spoolValue = this.spool.remove(key);
            if (spoolValue != null) {
                return true;
            }
            DiskElement element = (DiskElement)this.elements.remove(key);
            if (element != null) {
                this.freeBlock(element);
                return true;
            }
        }
        catch (Exception e) {
            LOG.error(this.name + "Cache: Could not remove disk store entry for " + key, e);
        }
        return false;
    }

    private void freeBlock(DiskElement element) {
        this.totalSize -= (long)element.payloadSize;
        element.payloadSize = 0;
        this.freeSpace.add(element);
    }

    public synchronized void removeAll() throws IOException {
        try {
            this.checkActive();
            this.spool.clear();
            this.elements.clear();
            this.freeSpace.clear();
            this.totalSize = 0L;
            this.file.setLength(0L);
        }
        catch (Exception e) {
            LOG.error(this.name + "Cache: Could not rebuild disk store", e);
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        try {
            try {
                this.elements.clear();
                this.spool.clear();
                this.freeSpace.clear();
                if (this.file != null) {
                    this.file.close();
                }
                this.dataFile.delete();
            }
            catch (Exception e) {
                LOG.error(this.name + "Cache: Could not shut down disk cache", e);
                Object var3_2 = null;
                this.active = false;
                this.file = null;
                this.notifyAll();
            }
            Object var3_1 = null;
            this.active = false;
            this.file = null;
            this.notifyAll();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.active = false;
            this.file = null;
            this.notifyAll();
            throw throwable;
        }
    }

    public synchronized boolean isSpoolEmpty() {
        return !this.active || this.spool.size() == 0;
    }

    private synchronized void spoolThreadMain() {
        while (true) {
            if (this.active && this.spool.size() == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            if (!this.active) {
                return;
            }
            try {
                this.flushSpool();
                continue;
            }
            catch (IOException e) {
                LOG.error(this.name + "Cache: Could not write elements to disk cache", e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void flushSpool() throws IOException {
        try {
            Iterator iterator = this.spool.values().iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                Serializable key = element.getKey();
                DiskElement oldBlock = (DiskElement)this.elements.remove(key);
                if (oldBlock != null) {
                    this.freeBlock(oldBlock);
                }
                ByteArrayOutputStream outstr = new ByteArrayOutputStream();
                ObjectOutputStream objstr = new ObjectOutputStream(outstr);
                objstr.writeObject(element);
                objstr.close();
                byte[] buffer = outstr.toByteArray();
                DiskElement diskElement = this.findFreeBlock(buffer.length);
                if (diskElement == null) {
                    diskElement = new DiskElement();
                    diskElement.position = this.file.length();
                    diskElement.blockSize = buffer.length;
                }
                this.file.seek(diskElement.position);
                this.file.write(buffer);
                if (this.cache.isEternal()) {
                    diskElement.expiryTime = Long.MAX_VALUE;
                } else {
                    long timeToLive = element.getCreationTime() + this.cache.getTimeToLiveSeconds() * 1000L;
                    long timeToIdle = element.getLastAccessTime() + this.cache.getTimeToIdleSeconds() * 1000L;
                    diskElement.expiryTime = Math.max(timeToLive, timeToIdle);
                }
                diskElement.payloadSize = buffer.length;
                this.totalSize += (long)buffer.length;
                this.elements.put(key, diskElement);
            }
        }
        finally {
            this.spool.clear();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.name + "Disk Store: " + " elements = " + this.elements.size() + ", free blocks = " + this.freeSpace.size() + ", used = " + this.totalSize + " bytes, total = " + this.file.length() + " bytes.");
        }
    }

    private void expiryThreadMain(int expiryInterval) {
        block3: {
            try {
                while (this.active) {
                    Thread.sleep(expiryInterval * 1000);
                    this.expireElements();
                }
            }
            catch (InterruptedException e) {
                if (!LOG.isWarnEnabled()) break block3;
                LOG.warn(this.name + "Cache: Expiry thread interrupted on Disk Store.");
            }
        }
    }

    private synchronized void expireElements() {
        long now = System.currentTimeMillis();
        Iterator<Object> iterator = this.spool.values().iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (!this.cache.isExpired(element)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.name + "Cache: Removing expired spool element " + element.getKey() + " from Disk Store");
            }
            iterator.remove();
        }
        iterator = this.elements.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            DiskElement element = (DiskElement)entry.getValue();
            if (now < element.expiryTime) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.name + "Cache: Removing expired spool element " + entry.getKey() + " from Disk Store");
            }
            iterator.remove();
            this.freeBlock(element);
        }
    }

    private DiskElement findFreeBlock(int length) {
        for (int i = 0; i < this.freeSpace.size(); ++i) {
            DiskElement element = (DiskElement)this.freeSpace.get(i);
            if (element.blockSize < length) continue;
            this.freeSpace.remove(i);
            return element;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ dataFile = ").append(this.dataFile.getAbsolutePath()).append(", active=").append(this.active).append(", totalSize=").append(this.totalSize).append(", status=").append(this.status).append(", expiryThreadInterval = ").append(this.expiryThreadInterval).append(" ]");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ExpiryThread
    extends Thread {
        private final int expiryInterval;

        public ExpiryThread(int expiryInterval) {
            super("Store " + DiskStore.this.name + " Expiry Thread");
            this.expiryInterval = expiryInterval;
            this.setDaemon(true);
        }

        public void run() {
            DiskStore.this.expiryThreadMain(this.expiryInterval);
        }
    }

    private class SpoolThread
    extends Thread {
        public SpoolThread() {
            super("Store " + DiskStore.this.name + " Spool Thread");
            this.setDaemon(true);
        }

        public void run() {
            DiskStore.this.spoolThreadMain();
        }
    }

    private static class DiskElement {
        private long position;
        private int payloadSize;
        private int blockSize;
        private long expiryTime;

        private DiskElement() {
        }
    }
}

