/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cache;

import net.sf.hibernate.MappingException;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.cache.NonstrictReadWriteCache;
import net.sf.hibernate.cache.ReadOnlyCache;
import net.sf.hibernate.cache.ReadWriteCache;
import net.sf.hibernate.cache.TransactionalCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;

public final class CacheFactory {
    private static final Log log = LogFactory.getLog(class$net$sf$hibernate$cache$CacheFactory == null ? (class$net$sf$hibernate$cache$CacheFactory = CacheFactory.class$("net.sf.hibernate.cache.CacheFactory")) : class$net$sf$hibernate$cache$CacheFactory);
    public static final String READ_ONLY = "read-only";
    public static final String READ_WRITE = "read-write";
    public static final String NONSTRICT_READ_WRITE = "nonstrict-read-write";
    public static final String TRANSACTIONAL = "transactional";
    static /* synthetic */ Class class$net$sf$hibernate$cache$CacheFactory;

    private CacheFactory() {
    }

    public static CacheConcurrencyStrategy createCache(Element node, String name, boolean mutable) throws MappingException {
        return CacheFactory.createCache(node.attributeValue("usage"), name, mutable);
    }

    /*
     * WARNING - void declaration
     */
    private static CacheConcurrencyStrategy createCache(String usage, String name, boolean mutable) throws MappingException {
        void var3_3;
        CacheConcurrencyStrategy ccs;
        if (log.isDebugEnabled()) {
            log.debug("cache for: " + name + " usage strategy: " + usage);
        }
        if (usage.equals(READ_ONLY)) {
            if (mutable) {
                log.warn("read-only cache configured for mutable: " + name);
            }
            ccs = new ReadOnlyCache();
        } else if (usage.equals(READ_WRITE)) {
            ccs = new ReadWriteCache();
        } else if (usage.equals(NONSTRICT_READ_WRITE)) {
            ccs = new NonstrictReadWriteCache();
        } else if (usage.equals(TRANSACTIONAL)) {
            ccs = new TransactionalCache();
        } else {
            throw new MappingException("cache usage attribute should be read-write, read-only, nonstrict-read-write or transactional");
        }
        return var3_3;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

