/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cache;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.cache.CacheException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NonstrictReadWriteCache
implements CacheConcurrencyStrategy {
    private Cache cache;
    private static final Log log = LogFactory.getLog(class$net$sf$hibernate$cache$ReadWriteCache == null ? (class$net$sf$hibernate$cache$ReadWriteCache = NonstrictReadWriteCache.class$("net.sf.hibernate.cache.ReadWriteCache")) : class$net$sf$hibernate$cache$ReadWriteCache);
    private boolean minimalPuts;
    static /* synthetic */ Class class$net$sf$hibernate$cache$ReadWriteCache;

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Object get(Object key, long txTimestamp) throws CacheException {
        Object result;
        if (log.isDebugEnabled()) {
            log.debug("Cache lookup: " + key);
        }
        if ((result = this.cache.get(key)) != null) {
            log.debug("Cache hit");
        } else {
            log.debug("Cache miss");
        }
        return result;
    }

    public boolean put(Object key, Object value, long txTimestamp) throws CacheException {
        if (this.minimalPuts && this.cache.get(key) != null) {
            if (log.isDebugEnabled()) {
                log.debug("item already cached: " + key);
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Caching: " + key);
        }
        this.cache.put(key, value);
        return true;
    }

    public CacheConcurrencyStrategy.SoftLock lock(Object key) throws CacheException {
        return null;
    }

    public void remove(Object key) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("Removing: " + key);
        }
        this.cache.remove(key);
    }

    public void clear() throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("Clearing");
        }
        this.cache.clear();
    }

    public void destroy() {
        try {
            this.cache.destroy();
        }
        catch (Exception e) {
            log.warn("could not destroy cache", e);
        }
    }

    public void evict(Object key) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("Invalidating: " + key);
        }
        this.cache.remove(key);
    }

    public void update(Object key, Object value) throws CacheException {
        this.evict(key);
    }

    public void insert(Object key, Object value) throws CacheException {
    }

    public void release(Object key, CacheConcurrencyStrategy.SoftLock lock) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("Invalidating (again): " + key);
        }
        this.cache.remove(key);
    }

    public void afterUpdate(Object key, Object value, CacheConcurrencyStrategy.SoftLock lock) throws CacheException {
        this.release(key, lock);
    }

    public void afterInsert(Object key, Object value) throws CacheException {
    }

    public void setMinimalPuts(boolean minimalPuts) throws HibernateException {
        this.minimalPuts = minimalPuts;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

