/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cfg;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.sf.hibernate.util.PropertiesHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Environment {
    public static final String VERSION = "2.1.4";
    public static final String CONNECTION_PROVIDER = "hibernate.connection.provider_class";
    public static final String DRIVER = "hibernate.connection.driver_class";
    public static final String ISOLATION = "hibernate.connection.isolation";
    public static final String URL = "hibernate.connection.url";
    public static final String USER = "hibernate.connection.username";
    public static final String PASS = "hibernate.connection.password";
    public static final String POOL_SIZE = "hibernate.connection.pool_size";
    public static final String DATASOURCE = "hibernate.connection.datasource";
    public static final String CONNECTION_PREFIX = "hibernate.connection";
    public static final String STATEMENT_CACHE_SIZE = "hibernate.statement_cache.size";
    public static final String JNDI_CLASS = "hibernate.jndi.class";
    public static final String JNDI_URL = "hibernate.jndi.url";
    public static final String JNDI_PREFIX = "hibernate.jndi";
    public static final String SESSION_FACTORY_NAME = "hibernate.session_factory_name";
    public static final String DIALECT = "hibernate.dialect";
    public static final String DEFAULT_SCHEMA = "hibernate.default_schema";
    public static final String SHOW_SQL = "hibernate.show_sql";
    public static final String USE_OUTER_JOIN = "hibernate.use_outer_join";
    public static final String MAX_FETCH_DEPTH = "hibernate.max_fetch_depth";
    public static final String USE_STREAMS_FOR_BINARY = "hibernate.jdbc.use_streams_for_binary";
    public static final String USE_SCROLLABLE_RESULTSET = "hibernate.jdbc.use_scrollable_resultset";
    public static final String USE_GET_GENERATED_KEYS = "hibernate.jdbc.use_get_generated_keys";
    public static final String STATEMENT_FETCH_SIZE = "hibernate.jdbc.fetch_size";
    public static final String STATEMENT_BATCH_SIZE = "hibernate.jdbc.batch_size";
    public static final String OUTPUT_STYLESHEET = "hibernate.xml.output_stylesheet";
    public static final String C3P0_MAX_SIZE = "hibernate.c3p0.max_size";
    public static final String C3P0_MIN_SIZE = "hibernate.c3p0.min_size";
    public static final String C3P0_TIMEOUT = "hibernate.c3p0.timeout";
    public static final String C3P0_MAX_STATEMENTS = "hibernate.c3p0.max_statements";
    public static final String C3P0_ACQUIRE_INCREMENT = "hibernate.c3p0.acquire_increment";
    public static final String C3P0_IDLE_TEST_PERIOD = "hibernate.c3p0.idle_test_period";
    public static final String C3P0_VALIDATE_CONNECTION = "hibernate.c3p0.validate";
    public static final String DBCP_MAXACTIVE = "hibernate.dbcp.maxActive";
    public static final String DBCP_MAXIDLE = "hibernate.dbcp.maxIdle";
    public static final String DBCP_MAXWAIT = "hibernate.dbcp.maxWait";
    public static final String DBCP_WHENEXHAUSTED = "hibernate.dbcp.whenExhaustedAction";
    public static final String DBCP_VALIDATION_ONBORROW = "hibernate.dbcp.testOnBorrow";
    public static final String DBCP_VALIDATION_ONRETURN = "hibernate.dbcp.testOnReturn";
    public static final String DBCP_VALIDATION_QUERY = "hibernate.dbcp.validationQuery";
    public static final String DBCP_PS_MAXACTIVE = "hibernate.dbcp.ps.maxActive";
    public static final String DBCP_PS_MAXIDLE = "hibernate.dbcp.ps.maxIdle";
    public static final String DBCP_PS_MAXWAIT = "hibernate.dbcp.ps.maxWait";
    public static final String DBCP_PS_WHENEXHAUSTED = "hibernate.dbcp.ps.whenExhaustedAction";
    public static final String PROXOOL_PREFIX = "hibernate.proxool";
    public static final String PROXOOL_XML = "hibernate.proxool.xml";
    public static final String PROXOOL_PROPERTIES = "hibernate.proxool.properties";
    public static final String PROXOOL_EXISTING_POOL = "hibernate.proxool.existing_pool";
    public static final String PROXOOL_POOL_ALIAS = "hibernate.proxool.pool_alias";
    public static final String TRANSACTION_STRATEGY = "hibernate.transaction.factory_class";
    public static final String TRANSACTION_MANAGER_STRATEGY = "hibernate.transaction.manager_lookup_class";
    public static final String USER_TRANSACTION = "jta.UserTransaction";
    public static final String CACHE_PROVIDER = "hibernate.cache.provider_class";
    public static final String USE_QUERY_CACHE = "hibernate.cache.use_query_cache";
    public static final String CACHE_REGION_PREFIX = "hibernate.cache.region_prefix";
    public static final String USE_MINIMAL_PUTS = "hibernate.cache.use_minimal_puts";
    public static final String USE_REFLECTION_OPTIMIZER = "hibernate.cglib.use_reflection_optimizer";
    public static final String QUERY_SUBSTITUTIONS = "hibernate.query.substitutions";
    public static final String QUERY_IMPORTS = "hibernate.query.imports";
    public static final String HBM2DDL_AUTO = "hibernate.hbm2ddl.auto";
    private static final String OUTPUT_STYLESHEET_OLD = "hibernate.output_stylesheet";
    private static final String CONNECTION_PROVIDER_OLD = "hibernate.connection_provider";
    private static final String DRIVER_OLD = "hibernate.driver";
    private static final String ISOLATION_OLD = "hibernate.isolation";
    private static final String USER_OLD = "hibernate.username";
    private static final String PASS_OLD = "hibernate.password";
    private static final String POOL_SIZE_OLD = "hibernate.pool_size";
    private static final String STATEMENT_CACHE_SIZE_OLD = "hibernate.statement_cache_size";
    private static final String DATASOURCE_OLD = "hibernate.datasource";
    private static final String TRANSACTION_STRATEGY_OLD = "hibernate.transaction_factory";
    private static final String URL_OLD = "hibernate.url";
    private static final String USE_STREAMS_FOR_BINARY_OLD = "hibernate.use_streams_for_binary";
    private static final String STATEMENT_FETCH_SIZE_OLD = "hibernate.statement.fetch_size";
    private static final String USE_SCROLLABLE_RESULTSET_OLD = "hibernate.use_scrollable_resultset";
    public static final String USE_JDBC_BATCH = "hibernate.use_jdbc_batch";
    private static final boolean ENABLE_BINARY_STREAMS;
    private static final boolean ENABLE_REFLECTION_OPTIMIZER;
    private static final boolean JVM_SUPPORTS_LINKED_HASH_COLLECTIONS;
    private static final boolean JVM_HAS_TIMESTAMP_BUG;
    private static final boolean JVM_SUPPORTS_GET_GENERATED_KEYS;
    private static final Properties GLOBAL_PROPERTIES;
    private static final HashMap ISOLATION_LEVELS;
    private static final Map OBSOLETE_PROPERTIES;
    private static final Log log;
    static /* synthetic */ Class class$net$sf$hibernate$cfg$Environment;
    static /* synthetic */ Class class$java$sql$Statement;

    public static void verifyProperties(Properties props) {
        Iterator<Object> iter = props.keySet().iterator();
        while (iter.hasNext()) {
            Object oldProp = iter.next();
            Object newProp = OBSOLETE_PROPERTIES.get(oldProp);
            if (newProp == null) continue;
            log.warn("Usage of obsolete property: " + oldProp + " no longer supported, use: " + newProp);
        }
    }

    public static boolean jvmSupportsProxies() {
        return true;
    }

    public static boolean jvmHasTimestampBug() {
        return JVM_HAS_TIMESTAMP_BUG;
    }

    public static boolean jvmSupportsLinkedHashCollections() {
        return JVM_SUPPORTS_LINKED_HASH_COLLECTIONS;
    }

    public static boolean jvmSupportsGetGeneratedKeys() {
        return JVM_SUPPORTS_GET_GENERATED_KEYS;
    }

    public static boolean useStreamsForBinary() {
        return ENABLE_BINARY_STREAMS;
    }

    public static boolean useReflectionOptimizer() {
        return ENABLE_REFLECTION_OPTIMIZER;
    }

    private Environment() {
        throw new UnsupportedOperationException();
    }

    public static Properties getProperties() {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)GLOBAL_PROPERTIES);
        return copy;
    }

    public static String isolationLevelToString(int isolation) {
        return (String)ISOLATION_LEVELS.get(new Integer(isolation));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static {
        boolean linkedHashSupport;
        boolean getGeneratedKeysSupport;
        block21: {
            ISOLATION_LEVELS = new HashMap();
            OBSOLETE_PROPERTIES = new HashMap();
            log = LogFactory.getLog(class$net$sf$hibernate$cfg$Environment == null ? (class$net$sf$hibernate$cfg$Environment = Environment.class$("net.sf.hibernate.cfg.Environment")) : class$net$sf$hibernate$cfg$Environment);
            log.info("Hibernate 2.1.4");
            ISOLATION_LEVELS.put(new Integer(0), "NONE");
            ISOLATION_LEVELS.put(new Integer(1), "READ_UNCOMMITTED");
            ISOLATION_LEVELS.put(new Integer(2), "READ_COMMITTED");
            ISOLATION_LEVELS.put(new Integer(4), "REPEATABLE_READ");
            ISOLATION_LEVELS.put(new Integer(8), "SERIALIZABLE");
            OBSOLETE_PROPERTIES.put(CONNECTION_PROVIDER_OLD, CONNECTION_PROVIDER);
            OBSOLETE_PROPERTIES.put(DRIVER_OLD, DRIVER);
            OBSOLETE_PROPERTIES.put(ISOLATION_OLD, ISOLATION);
            OBSOLETE_PROPERTIES.put(URL_OLD, URL);
            OBSOLETE_PROPERTIES.put(PASS_OLD, PASS);
            OBSOLETE_PROPERTIES.put(USER_OLD, USER);
            OBSOLETE_PROPERTIES.put(POOL_SIZE_OLD, POOL_SIZE);
            OBSOLETE_PROPERTIES.put(STATEMENT_CACHE_SIZE_OLD, STATEMENT_CACHE_SIZE);
            OBSOLETE_PROPERTIES.put(DATASOURCE_OLD, DATASOURCE);
            OBSOLETE_PROPERTIES.put(TRANSACTION_STRATEGY_OLD, TRANSACTION_STRATEGY);
            OBSOLETE_PROPERTIES.put(OUTPUT_STYLESHEET_OLD, OUTPUT_STYLESHEET);
            OBSOLETE_PROPERTIES.put(USE_JDBC_BATCH, STATEMENT_BATCH_SIZE);
            OBSOLETE_PROPERTIES.put(USE_SCROLLABLE_RESULTSET_OLD, USE_SCROLLABLE_RESULTSET);
            OBSOLETE_PROPERTIES.put(USE_STREAMS_FOR_BINARY_OLD, USE_STREAMS_FOR_BINARY);
            OBSOLETE_PROPERTIES.put(STATEMENT_FETCH_SIZE_OLD, STATEMENT_FETCH_SIZE);
            GLOBAL_PROPERTIES = new Properties();
            GLOBAL_PROPERTIES.setProperty(USE_REFLECTION_OPTIMIZER, Boolean.TRUE.toString());
            InputStream stream = (class$net$sf$hibernate$cfg$Environment == null ? (class$net$sf$hibernate$cfg$Environment = Environment.class$("net.sf.hibernate.cfg.Environment")) : class$net$sf$hibernate$cfg$Environment).getResourceAsStream("/hibernate.properties");
            if (stream == null) {
                log.info("hibernate.properties not found");
            } else {
                GLOBAL_PROPERTIES.load(stream);
                log.info("loaded properties from resource hibernate.properties: " + GLOBAL_PROPERTIES);
                Object var3_1 = null;
                try {
                    stream.close();
                }
                catch (IOException ioe) {
                    log.error("could not close stream on hibernate.properties", ioe);
                }
            }
            break block21;
            {
                catch (Exception e) {
                    log.error("problem loading properties from hibernate.properties");
                    Object var3_2 = null;
                    try {
                        stream.close();
                    }
                    catch (IOException ioe) {
                        log.error("could not close stream on hibernate.properties", ioe);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    stream.close();
                }
                catch (IOException ioe) {
                    log.error("could not close stream on hibernate.properties", ioe);
                }
                throw throwable;
            }
        }
        try {
            GLOBAL_PROPERTIES.putAll((Map<?, ?>)System.getProperties());
        }
        catch (SecurityException se) {
            log.warn("could not copy system properties. System properties will be ignored.");
        }
        Environment.verifyProperties(GLOBAL_PROPERTIES);
        ENABLE_BINARY_STREAMS = PropertiesHelper.getBoolean(USE_STREAMS_FOR_BINARY, GLOBAL_PROPERTIES);
        ENABLE_REFLECTION_OPTIMIZER = PropertiesHelper.getBoolean(USE_REFLECTION_OPTIMIZER, GLOBAL_PROPERTIES);
        if (ENABLE_BINARY_STREAMS) {
            log.info("using java.io streams to persist binary types");
        }
        if (ENABLE_REFLECTION_OPTIMIZER) {
            log.info("using CGLIB reflection optimizer");
        }
        try {
            (class$java$sql$Statement == null ? (class$java$sql$Statement = Environment.class$("java.sql.Statement")) : class$java$sql$Statement).getMethod("getGeneratedKeys", null);
            getGeneratedKeysSupport = true;
        }
        catch (NoSuchMethodException nsme) {
            getGeneratedKeysSupport = false;
        }
        JVM_SUPPORTS_GET_GENERATED_KEYS = getGeneratedKeysSupport;
        if (!JVM_SUPPORTS_GET_GENERATED_KEYS) {
            log.info("JVM does not support Statement.getGeneratedKeys()");
        }
        try {
            Class.forName("java.util.LinkedHashSet");
            linkedHashSupport = true;
        }
        catch (ClassNotFoundException cnfe) {
            linkedHashSupport = false;
        }
        JVM_SUPPORTS_LINKED_HASH_COLLECTIONS = linkedHashSupport;
        if (!JVM_SUPPORTS_LINKED_HASH_COLLECTIONS) {
            log.info("JVM does not support LinkedHasMap, LinkedHashSet - ordered maps and sets disabled");
        }
        boolean bl = JVM_HAS_TIMESTAMP_BUG = new Timestamp(123456789L).getTime() != 123456789L;
        if (JVM_HAS_TIMESTAMP_BUG) {
            log.info("using workaround for JVM bug in java.sql.Timestamp");
        }
    }
}

