/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.collection;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArrayHolder
extends PersistentCollection {
    private Object array;
    private static final Log log = LogFactory.getLog(class$net$sf$hibernate$collection$PersistentCollection == null ? (class$net$sf$hibernate$collection$PersistentCollection = ArrayHolder.class$("net.sf.hibernate.collection.PersistentCollection")) : class$net$sf$hibernate$collection$PersistentCollection);
    private transient Class elementClass;
    private transient List tempList;
    static /* synthetic */ Class class$net$sf$hibernate$collection$PersistentCollection;

    public ArrayHolder(SessionImplementor session, Object array) {
        super(session);
        this.array = array;
        this.setInitialized();
    }

    protected Serializable snapshot(CollectionPersister persister) throws HibernateException {
        int length = Array.getLength(this.array);
        Serializable result = (Serializable)Array.newInstance(persister.getElementClass(), length);
        for (int i = 0; i < length; ++i) {
            Object elt = Array.get(this.array, i);
            try {
                Array.set(result, i, persister.getElementType().deepCopy(elt));
                continue;
            }
            catch (IllegalArgumentException iae) {
                log.error("Array element type error", iae);
                throw new HibernateException("Array element type error", iae);
            }
        }
        return result;
    }

    public Collection getOrphans(Serializable snapshot) throws HibernateException {
        int i;
        Object[] sn = (Object[])snapshot;
        Object[] arr = (Object[])this.array;
        ArrayList<Object> result = new ArrayList<Object>();
        for (i = 0; i < sn.length; ++i) {
            result.add(sn[i]);
        }
        for (i = 0; i < sn.length; ++i) {
            PersistentCollection.identityRemove(result, arr[i], this.getSession());
        }
        return result;
    }

    public ArrayHolder(SessionImplementor session, CollectionPersister persister) throws HibernateException {
        super(session);
        this.elementClass = persister.getElementClass();
    }

    public Object getArray() {
        return this.array;
    }

    public boolean isWrapper(Object collection) {
        return this.array == collection;
    }

    public boolean equalsSnapshot(Type elementType) throws HibernateException {
        Serializable snapshot = this.getSnapshot();
        int xlen = Array.getLength(snapshot);
        if (xlen != Array.getLength(this.array)) {
            return false;
        }
        for (int i = 0; i < xlen; ++i) {
            if (!elementType.isDirty(Array.get(snapshot, i), Array.get(this.array, i), this.getSession())) continue;
            return false;
        }
        return true;
    }

    public Iterator elements() {
        int length = Array.getLength(this.array);
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            list.add(Array.get(this.array, i));
        }
        return list.iterator();
    }

    public boolean empty() {
        return false;
    }

    public void writeTo(PreparedStatement st, CollectionPersister persister, Object entry, int i, boolean writeOrder) throws HibernateException, SQLException {
        persister.writeElement(st, entry, writeOrder, this.getSession());
        persister.writeIndex(st, new Integer(i), writeOrder, this.getSession());
    }

    public Object readFrom(ResultSet rs, CollectionPersister persister, Object owner) throws HibernateException, SQLException {
        Object element = persister.readElement(rs, owner, this.getSession());
        int index = (Integer)persister.readIndex(rs, this.getSession());
        for (int i = this.tempList.size(); i <= index; ++i) {
            this.tempList.add(i, null);
        }
        this.tempList.set(index, element);
        return element;
    }

    public Iterator entries() {
        return this.elements();
    }

    public void beginRead() {
        super.beginRead();
        this.tempList = new ArrayList();
    }

    public boolean endRead() {
        this.setInitialized();
        this.array = Array.newInstance(this.elementClass, this.tempList.size());
        for (int i = 0; i < this.tempList.size(); ++i) {
            Array.set(this.array, i, this.tempList.get(i));
        }
        this.tempList = null;
        return true;
    }

    public void beforeInitialize(CollectionPersister persister) {
    }

    public boolean isDirectlyAccessible() {
        return true;
    }

    public void initializeFromCache(CollectionPersister persister, Serializable disassembled, Object owner) throws HibernateException {
        Serializable[] cached = (Serializable[])disassembled;
        this.array = Array.newInstance(persister.getElementClass(), cached.length);
        for (int i = 0; i < cached.length; ++i) {
            Array.set(this.array, i, persister.getElementType().assemble(cached[i], this.getSession(), owner));
        }
        this.setInitialized();
    }

    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        int length = Array.getLength(this.array);
        Serializable[] result = new Serializable[length];
        for (int i = 0; i < length; ++i) {
            result[i] = persister.getElementType().disassemble(Array.get(this.array, i), this.getSession());
        }
        return result;
    }

    public Object getValue() {
        return this.array;
    }

    public Iterator getDeletes(Type elemType) throws HibernateException {
        int end;
        int i;
        int arraySize;
        ArrayList<Integer> deletes = new ArrayList<Integer>();
        Serializable sn = this.getSnapshot();
        int snSize = Array.getLength(sn);
        if (snSize > (arraySize = Array.getLength(this.array))) {
            for (i = arraySize; i < snSize; ++i) {
                deletes.add(new Integer(i));
            }
            end = arraySize;
        } else {
            end = snSize;
        }
        for (i = 0; i < end; ++i) {
            if (Array.get(this.array, i) != null || Array.get(sn, i) == null) continue;
            deletes.add(new Integer(i));
        }
        return deletes.iterator();
    }

    public boolean needsInserting(Object entry, int i, Type elemType) throws HibernateException {
        Serializable sn = this.getSnapshot();
        return Array.get(this.array, i) != null && (i >= Array.getLength(sn) || Array.get(sn, i) == null);
    }

    public boolean needsUpdating(Object entry, int i, Type elemType) throws HibernateException {
        Serializable sn = this.getSnapshot();
        return i < Array.getLength(sn) && Array.get(sn, i) != null && Array.get(this.array, i) != null && elemType.isDirty(Array.get(this.array, i), Array.get(sn, i), this.getSession());
    }

    public Object getIndex(Object entry, int i) {
        return new Integer(i);
    }

    public boolean entryExists(Object entry, int i) {
        return entry != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

