/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.collection;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LazyInitializationException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.engine.CollectionSnapshot;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.EmptyIterator;
import org.apache.commons.logging.LogFactory;

public abstract class PersistentCollection
implements Serializable {
    private transient SessionImplementor session;
    private boolean initialized;
    private transient List additions;
    private CollectionSnapshot collectionSnapshot;
    private transient boolean directlyAccessible;
    private transient boolean initializing;
    static /* synthetic */ Class class$net$sf$hibernate$collection$PersistentCollection;

    public abstract boolean empty();

    public final void read() {
        this.initialize(false);
    }

    private final boolean isConnectedToSession() {
        return this.session != null && this.session.isOpen();
    }

    protected final void write() {
        this.initialize(true);
        this.collectionSnapshot.setDirty();
    }

    private boolean isQueueAdditionEnabled() {
        return !this.initialized && this.isConnectedToSession() && this.session.isInverseCollection(this);
    }

    protected final boolean queueAdd(Object element) {
        if (this.isQueueAdditionEnabled()) {
            if (this.additions == null) {
                this.additions = new ArrayList(10);
            }
            this.additions.add(element);
            this.collectionSnapshot.setDirty();
            return true;
        }
        return false;
    }

    protected final boolean queueAddAll(Collection coll) {
        if (this.isQueueAdditionEnabled()) {
            if (this.additions == null) {
                this.additions = new ArrayList(20);
            }
            this.additions.addAll(coll);
            return true;
        }
        return false;
    }

    public void delayedAddAll(Collection coll) {
        throw new AssertionFailure("Collection does not support delayed initialization");
    }

    public void postFlush() {
        if (this.additions != null) {
            this.additions = null;
        }
    }

    public PersistentCollection() {
    }

    protected PersistentCollection(SessionImplementor session) {
        this.session = session;
    }

    public Object getValue() {
        return this;
    }

    public void beginRead() {
        this.initializing = true;
    }

    public boolean endRead() {
        this.setInitialized();
        if (this.additions != null) {
            this.delayedAddAll(this.additions);
            this.additions = null;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void initialize(boolean writing) {
        if (this.initialized) return;
        if (this.initializing) {
            throw new LazyInitializationException("cannot access loading collection");
        }
        if (!this.isConnectedToSession()) throw new LazyInitializationException("Failed to lazily initialize a collection - no session or session was closed");
        if (!this.session.isConnected()) throw new LazyInitializationException("Failed to lazily initialize a collection - session is disconnected");
        try {
            this.session.initializeCollection(this, writing);
            return;
        }
        catch (Exception e) {
            LogFactory.getLog(class$net$sf$hibernate$collection$PersistentCollection == null ? (class$net$sf$hibernate$collection$PersistentCollection = PersistentCollection.class$("net.sf.hibernate.collection.PersistentCollection")) : class$net$sf$hibernate$collection$PersistentCollection).error("Failed to lazily initialize a collection", e);
            throw new LazyInitializationException("Failed to lazily initialize a collection", e);
        }
    }

    protected final void setInitialized() {
        this.initializing = false;
        this.initialized = true;
    }

    protected final void setDirectlyAccessible(boolean directlyAccessible) {
        this.directlyAccessible = directlyAccessible;
    }

    public boolean isDirectlyAccessible() {
        return this.directlyAccessible;
    }

    public final boolean unsetSession(SessionImplementor currentSession) {
        if (currentSession == this.session) {
            this.session = null;
            return true;
        }
        return false;
    }

    public final boolean setCurrentSession(SessionImplementor session) throws HibernateException {
        if (session == this.session) {
            return false;
        }
        if (this.isConnectedToSession()) {
            throw new HibernateException("Illegal attempt to associate a collection with two open sessions");
        }
        this.session = session;
        return true;
    }

    public abstract void initializeFromCache(CollectionPersister var1, Serializable var2, Object var3) throws HibernateException;

    public abstract Iterator entries();

    public abstract Object readFrom(ResultSet var1, CollectionPersister var2, Object var3) throws HibernateException, SQLException;

    public abstract void writeTo(PreparedStatement var1, CollectionPersister var2, Object var3, int var4, boolean var5) throws HibernateException, SQLException;

    public abstract Object getIndex(Object var1, int var2);

    public abstract void beforeInitialize(CollectionPersister var1);

    public abstract boolean equalsSnapshot(Type var1) throws HibernateException;

    protected abstract Serializable snapshot(CollectionPersister var1) throws HibernateException;

    public abstract Serializable disassemble(CollectionPersister var1) throws HibernateException;

    public boolean needsRecreate(CollectionPersister persister) {
        return false;
    }

    public final Serializable getSnapshot(CollectionPersister persister) throws HibernateException {
        return persister == null ? null : this.snapshot(persister);
    }

    public final void forceInitialization() throws HibernateException {
        if (this.initializing) {
            throw new AssertionFailure("force initialize loading collection");
        }
        if (this.session == null) {
            throw new HibernateException("collection is not associated with any session");
        }
        if (!this.session.isConnected()) {
            throw new HibernateException("disconnected session");
        }
        if (!this.initialized) {
            this.session.initializeCollection(this, false);
        }
    }

    public abstract boolean entryExists(Object var1, int var2);

    public abstract boolean needsInserting(Object var1, int var2, Type var3) throws HibernateException;

    public abstract boolean needsUpdating(Object var1, int var2, Type var3) throws HibernateException;

    public abstract Iterator getDeletes(Type var1) throws HibernateException;

    public abstract boolean isWrapper(Object var1);

    protected final Serializable getSnapshot() {
        return this.session.getSnapshot(this);
    }

    public final boolean wasInitialized() {
        return this.initialized;
    }

    public final boolean hasQueuedAdditions() {
        return this.additions != null;
    }

    public final Iterator queuedAdditionIterator() {
        return this.hasQueuedAdditions() ? this.additions.iterator() : EmptyIterator.INSTANCE;
    }

    public CollectionSnapshot getCollectionSnapshot() {
        return this.collectionSnapshot;
    }

    public void setCollectionSnapshot(CollectionSnapshot collectionSnapshot) {
        this.collectionSnapshot = collectionSnapshot;
    }

    public void preInsert(CollectionPersister persister) throws HibernateException {
    }

    public void afterRowInsert(CollectionPersister persister, Object entry, int i) throws HibernateException {
    }

    public abstract Collection getOrphans(Serializable var1) throws HibernateException;

    protected final SessionImplementor getSession() {
        return this.session;
    }

    protected static Collection getOrphans(Collection oldElements, Collection currentElements, SessionImplementor session) throws HibernateException {
        if (currentElements.size() == 0) {
            return oldElements;
        }
        if (oldElements.size() == 0) {
            return oldElements;
        }
        ArrayList res = new ArrayList();
        HashSet<Serializable> currentIds = new HashSet<Serializable>();
        Iterator it = currentElements.iterator();
        while (it.hasNext()) {
            Object current = it.next();
            if (current == null || !session.isSaved(current)) continue;
            currentIds.add(session.getEntityIdentifierIfNotUnsaved(current));
        }
        it = oldElements.iterator();
        while (it.hasNext()) {
            Object old = it.next();
            Serializable id = session.getEntityIdentifierIfNotUnsaved(old);
            if (currentIds.contains(id)) continue;
            res.add(old);
        }
        return res;
    }

    static void identityRemove(Collection list, Object object, SessionImplementor session) throws HibernateException {
        if (object != null && session.isSaved(object)) {
            Serializable idOfCurrent = session.getEntityIdentifierIfNotUnsaved(object);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Serializable idOfOld = session.getEntityIdentifierIfNotUnsaved(iter.next());
                if (!idOfCurrent.equals(idOfOld)) continue;
                iter.remove();
                break;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    final class ListProxy
    implements List {
        private final List list;

        ListProxy(List list) {
            this.list = list;
        }

        public void add(int index, Object value) {
            PersistentCollection.this.write();
            this.list.add(index, value);
        }

        public boolean add(Object o) {
            PersistentCollection.this.write();
            return this.list.add(o);
        }

        public boolean addAll(Collection c) {
            PersistentCollection.this.write();
            return this.list.addAll(c);
        }

        public boolean addAll(int i, Collection c) {
            PersistentCollection.this.write();
            return this.list.addAll(i, c);
        }

        public void clear() {
            PersistentCollection.this.write();
            this.list.clear();
        }

        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        public boolean containsAll(Collection c) {
            return this.list.containsAll(c);
        }

        public Object get(int i) {
            return this.list.get(i);
        }

        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public Iterator iterator() {
            return new IteratorProxy(this.list.iterator());
        }

        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        public ListIterator listIterator() {
            return new ListIteratorProxy(this.list.listIterator());
        }

        public ListIterator listIterator(int i) {
            return new ListIteratorProxy(this.list.listIterator(i));
        }

        public Object remove(int i) {
            PersistentCollection.this.write();
            return this.list.remove(i);
        }

        public boolean remove(Object o) {
            PersistentCollection.this.write();
            return this.list.remove(o);
        }

        public boolean removeAll(Collection c) {
            PersistentCollection.this.write();
            return this.list.removeAll(c);
        }

        public boolean retainAll(Collection c) {
            PersistentCollection.this.write();
            return this.list.retainAll(c);
        }

        public Object set(int i, Object o) {
            PersistentCollection.this.write();
            return this.list.set(i, o);
        }

        public int size() {
            return this.list.size();
        }

        public List subList(int i, int j) {
            return this.list.subList(i, j);
        }

        public Object[] toArray() {
            return this.list.toArray();
        }

        public Object[] toArray(Object[] array) {
            return this.list.toArray(array);
        }
    }

    class SetProxy
    implements Set {
        final Collection set;

        SetProxy(Collection set) {
            this.set = set;
        }

        public boolean add(Object o) {
            PersistentCollection.this.write();
            return this.set.add(o);
        }

        public boolean addAll(Collection c) {
            PersistentCollection.this.write();
            return this.set.addAll(c);
        }

        public void clear() {
            PersistentCollection.this.write();
            this.set.clear();
        }

        public boolean contains(Object o) {
            return this.set.contains(o);
        }

        public boolean containsAll(Collection c) {
            return this.set.containsAll(c);
        }

        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        public Iterator iterator() {
            return new IteratorProxy(this.set.iterator());
        }

        public boolean remove(Object o) {
            PersistentCollection.this.write();
            return this.set.remove(o);
        }

        public boolean removeAll(Collection c) {
            PersistentCollection.this.write();
            return this.set.removeAll(c);
        }

        public boolean retainAll(Collection c) {
            PersistentCollection.this.write();
            return this.set.retainAll(c);
        }

        public int size() {
            return this.set.size();
        }

        public Object[] toArray() {
            return this.set.toArray();
        }

        public Object[] toArray(Object[] array) {
            return this.set.toArray(array);
        }
    }

    final class ListIteratorProxy
    implements ListIterator {
        private final ListIterator iter;

        ListIteratorProxy(ListIterator iter) {
            this.iter = iter;
        }

        public void add(Object o) {
            PersistentCollection.this.write();
            this.iter.add(o);
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        public Object next() {
            return this.iter.next();
        }

        public int nextIndex() {
            return this.iter.nextIndex();
        }

        public Object previous() {
            return this.iter.previous();
        }

        public int previousIndex() {
            return this.iter.previousIndex();
        }

        public void remove() {
            PersistentCollection.this.write();
            this.iter.remove();
        }

        public void set(Object o) {
            PersistentCollection.this.write();
            this.iter.set(o);
        }
    }

    final class IteratorProxy
    implements Iterator {
        private final Iterator iter;

        IteratorProxy(Iterator iter) {
            this.iter = iter;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            return this.iter.next();
        }

        public void remove() {
            PersistentCollection.this.write();
            this.iter.remove();
        }
    }
}

