/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.collection;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.ODMGCollection;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.LinkedHashCollectionHelper;
import org.odmg.DSet;

public class Set
extends ODMGCollection
implements java.util.Set,
DSet {
    java.util.Set set;
    private transient List tempList;

    protected Serializable snapshot(CollectionPersister persister) throws HibernateException {
        HashMap<Object, Object> clonedSet = new HashMap<Object, Object>(this.set.size());
        Iterator iter = this.set.iterator();
        while (iter.hasNext()) {
            Object copied = persister.getElementType().deepCopy(iter.next());
            clonedSet.put(copied, copied);
        }
        return clonedSet;
    }

    public Collection getOrphans(Serializable snapshot) throws HibernateException {
        Map sn = (Map)((Object)snapshot);
        return PersistentCollection.getOrphans(sn.keySet(), this.set, this.getSession());
    }

    public boolean equalsSnapshot(Type elementType) throws HibernateException {
        Map sn = (Map)((Object)this.getSnapshot());
        if (sn.size() != this.set.size()) {
            return false;
        }
        Iterator iter = this.set.iterator();
        while (iter.hasNext()) {
            Object test = iter.next();
            Object oldValue = sn.get(test);
            if (oldValue != null && !elementType.isDirty(oldValue, test, this.getSession())) continue;
            return false;
        }
        return true;
    }

    public Set(SessionImplementor session) {
        super(session);
    }

    public Set() {
    }

    public void beforeInitialize(CollectionPersister persister) {
        this.set = persister.hasOrdering() ? LinkedHashCollectionHelper.createLinkedHashSet() : new HashSet();
    }

    public Set(SessionImplementor session, java.util.Set set) {
        super(session);
        this.set = set;
        this.setInitialized();
        this.setDirectlyAccessible(true);
    }

    public void initializeFromCache(CollectionPersister persister, Serializable disassembled, Object owner) throws HibernateException {
        this.beforeInitialize(persister);
        Serializable[] array = (Serializable[])disassembled;
        for (int i = 0; i < array.length; ++i) {
            this.set.add(persister.getElementType().assemble(array[i], this.getSession(), owner));
        }
        this.setInitialized();
    }

    public boolean empty() {
        return this.set.isEmpty();
    }

    public int size() {
        this.read();
        return this.set.size();
    }

    public boolean isEmpty() {
        this.read();
        return this.set.isEmpty();
    }

    public boolean contains(Object o) {
        this.read();
        return this.set.contains(o);
    }

    public Iterator iterator() {
        this.read();
        return new PersistentCollection.IteratorProxy(this.set.iterator());
    }

    public Object[] toArray() {
        this.read();
        return this.set.toArray();
    }

    public Object[] toArray(Object[] array) {
        this.read();
        return this.set.toArray(array);
    }

    public boolean add(Object value) {
        this.write();
        return this.set.add(value);
    }

    public boolean remove(Object value) {
        this.write();
        return this.set.remove(value);
    }

    public boolean containsAll(Collection coll) {
        this.read();
        return this.set.containsAll(coll);
    }

    public boolean addAll(Collection coll) {
        if (coll.size() > 0) {
            this.write();
            return this.set.addAll(coll);
        }
        return false;
    }

    public boolean retainAll(Collection coll) {
        this.write();
        return this.set.retainAll(coll);
    }

    public boolean removeAll(Collection coll) {
        if (coll.size() > 0) {
            this.write();
            return this.set.removeAll(coll);
        }
        return false;
    }

    public void clear() {
        this.write();
        this.set.clear();
    }

    public String toString() {
        this.read();
        return this.set.toString();
    }

    public void writeTo(PreparedStatement st, CollectionPersister persister, Object entry, int i, boolean writeOrder) throws HibernateException, SQLException {
        persister.writeElement(st, entry, writeOrder, this.getSession());
    }

    public Object readFrom(ResultSet rs, CollectionPersister persister, Object owner) throws HibernateException, SQLException {
        Object element = persister.readElement(rs, owner, this.getSession());
        this.tempList.add(element);
        return element;
    }

    public void beginRead() {
        super.beginRead();
        this.tempList = new ArrayList();
    }

    public boolean endRead() {
        this.set.addAll(this.tempList);
        this.tempList = null;
        this.setInitialized();
        return true;
    }

    public Iterator entries() {
        return this.set.iterator();
    }

    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        Serializable[] result = new Serializable[this.set.size()];
        Iterator iter = this.set.iterator();
        int i = 0;
        while (iter.hasNext()) {
            result[i++] = persister.getElementType().disassemble(iter.next(), this.getSession());
        }
        return result;
    }

    public Iterator getDeletes(Type elemType) throws HibernateException {
        Object test;
        Map sn = (Map)((Object)this.getSnapshot());
        ArrayList<Object> deletes = new ArrayList<Object>(sn.size());
        Iterator<Object> iter = sn.keySet().iterator();
        while (iter.hasNext()) {
            test = iter.next();
            if (this.set.contains(test)) continue;
            deletes.add(test);
        }
        iter = this.set.iterator();
        while (iter.hasNext()) {
            test = iter.next();
            Object oldValue = sn.get(test);
            if (oldValue == null || !elemType.isDirty(test, oldValue, this.getSession())) continue;
            deletes.add(oldValue);
        }
        return deletes.iterator();
    }

    public boolean needsInserting(Object entry, int i, Type elemType) throws HibernateException {
        Map sn = (Map)((Object)this.getSnapshot());
        Object oldValue = sn.get(entry);
        return oldValue == null || elemType.isDirty(oldValue, entry, this.getSession());
    }

    public boolean needsUpdating(Object entry, int i, Type elemType) {
        return false;
    }

    public Object getIndex(Object entry, int i) {
        throw new UnsupportedOperationException("Sets don't have indexes");
    }

    public DSet union(DSet otherSet) {
        this.read();
        HashSet newset = new HashSet(this.set.size());
        newset.addAll(this.set);
        newset.addAll(otherSet);
        return new Set(this.getSession(), newset);
    }

    public DSet difference(DSet otherSet) {
        this.read();
        HashSet newset = new HashSet(this.set.size());
        newset.addAll(this.set);
        newset.removeAll(otherSet);
        return new Set(this.getSession(), newset);
    }

    public DSet intersection(DSet otherSet) {
        this.read();
        HashSet newset = new HashSet(this.set.size());
        newset.addAll(this.set);
        newset.retainAll(otherSet);
        return new Set(this.getSession(), newset);
    }

    public boolean properSubsetOf(DSet otherSet) {
        this.read();
        return otherSet.size() > this.set.size() && otherSet.containsAll(this.set);
    }

    public boolean properSupersetOf(DSet otherSet) {
        this.read();
        return this.set.size() > otherSet.size() && this.set.containsAll(otherSet);
    }

    public boolean subsetOf(DSet otherSet) {
        this.read();
        return otherSet.size() >= this.set.size() && otherSet.containsAll(this.set);
    }

    public boolean supersetOf(DSet otherSet) {
        this.read();
        return this.set.size() >= otherSet.size() && this.set.containsAll(otherSet);
    }

    public boolean equals(Object other) {
        this.read();
        return ((Object)this.set).equals(other);
    }

    public int hashCode() {
        this.read();
        return ((Object)this.set).hashCode();
    }

    public boolean entryExists(Object key, int i) {
        return true;
    }

    public boolean isWrapper(Object collection) {
        return this.set == collection;
    }
}

