/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.connection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cfg.Environment;
import net.sf.hibernate.connection.ConnectionProvider;
import net.sf.hibernate.util.PropertiesHelper;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.logicalcobwebs.proxool.configuration.JAXPConfigurator;
import org.logicalcobwebs.proxool.configuration.PropertyConfigurator;

public class ProxoolConnectionProvider
implements ConnectionProvider {
    private static final String PROXOOL_JDBC_STEM = "proxool.";
    private static final String HIBERNATE_ALIAS_STEM = "proxool.hibernate-";
    private static final Log log = LogFactory.getLog(class$net$sf$hibernate$connection$ProxoolConnectionProvider == null ? (class$net$sf$hibernate$connection$ProxoolConnectionProvider = ProxoolConnectionProvider.class$("net.sf.hibernate.connection.ProxoolConnectionProvider")) : class$net$sf$hibernate$connection$ProxoolConnectionProvider);
    private static int aliasCount;
    private String proxoolAlias;
    private boolean existingPool;
    private Integer isolation;
    static /* synthetic */ Class class$net$sf$hibernate$connection$ProxoolConnectionProvider;

    public Connection getConnection() throws SQLException {
        Connection c = DriverManager.getConnection(this.proxoolAlias);
        if (this.isolation != null) {
            c.setTransactionIsolation(this.isolation);
        }
        if (c.getAutoCommit()) {
            c.setAutoCommit(false);
        }
        return c;
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public void configure(Properties props) throws HibernateException {
        String jaxpFile = props.getProperty("hibernate.proxool.xml");
        String propFile = props.getProperty("hibernate.proxool.properties");
        String externalConfig = props.getProperty("hibernate.proxool.existing_pool");
        this.proxoolAlias = props.getProperty("hibernate.proxool.pool_alias");
        if ("true".equals(externalConfig)) {
            if (!StringHelper.isNotEmpty(this.proxoolAlias)) {
                String msg = "Cannot configure Proxool Provider to use an existing in memory pool without the hibernate.proxool.pool_alias property set.";
                log.fatal(msg);
                throw new HibernateException(msg);
            }
            this.proxoolAlias = PROXOOL_JDBC_STEM + this.proxoolAlias;
            this.existingPool = true;
            log.info("Configuring Proxool Provider using existing pool in memory: " + this.proxoolAlias);
        } else if (StringHelper.isNotEmpty(jaxpFile)) {
            log.info("Configuring Proxool Provider using JAXPConfigurator: " + jaxpFile);
            if (!StringHelper.isNotEmpty(this.proxoolAlias)) {
                String msg = "Cannot configure Proxool Provider to use JAXP without the hibernate.proxool.pool_alias property set.";
                log.fatal(msg);
                throw new HibernateException(msg);
            }
            try {
                JAXPConfigurator.configure((String)jaxpFile, (boolean)false);
            }
            catch (ProxoolException e) {
                String msg = "Proxool Provider unable to load JAXP configurator file: " + jaxpFile;
                log.fatal(msg, e);
                throw new HibernateException(msg, e);
            }
            this.proxoolAlias = PROXOOL_JDBC_STEM + this.proxoolAlias;
            log.info("Configuring Proxool Provider to use pool alias: " + this.proxoolAlias);
        } else if (StringHelper.isNotEmpty(propFile)) {
            log.info("Configuring Proxool Provider using Properties File: " + propFile);
            if (!StringHelper.isNotEmpty(this.proxoolAlias)) {
                String msg = "Cannot configure Proxool Provider to use Properties File without the hibernate.proxool.pool_alias property set.";
                log.fatal(msg);
                throw new HibernateException(msg);
            }
            try {
                PropertyConfigurator.configure((String)propFile);
            }
            catch (ProxoolException e) {
                String msg = "Proxool Provider unable to load load Property configurator file: " + propFile;
                log.fatal(msg, e);
                throw new HibernateException(msg, e);
            }
            this.proxoolAlias = PROXOOL_JDBC_STEM + this.proxoolAlias;
            log.info("Configuring Proxool Provider to use pool alias: " + this.proxoolAlias);
        }
        this.isolation = PropertiesHelper.getInteger("hibernate.connection.isolation", props);
        if (this.isolation != null) {
            log.info("JDBC isolation level: " + Environment.isolationLevelToString(this.isolation));
        }
    }

    public void close() throws HibernateException {
        if (this.existingPool) {
            return;
        }
        try {
            ProxoolFacade.shutdown((int)0);
        }
        catch (Exception e) {
            log.warn("Exception occured when closing the Proxool pool", e);
            throw new HibernateException("Exception occured when closing the Proxool pool", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String newAlias() {
        Class clazz = class$net$sf$hibernate$connection$ProxoolConnectionProvider == null ? (class$net$sf$hibernate$connection$ProxoolConnectionProvider = ProxoolConnectionProvider.class$("net.sf.hibernate.connection.ProxoolConnectionProvider")) : class$net$sf$hibernate$connection$ProxoolConnectionProvider;
        synchronized (clazz) {
            StringBuffer buff = new StringBuffer(HIBERNATE_ALIAS_STEM);
            buff.append(++aliasCount);
            return buff.toString();
        }
    }

    private static Properties extractProxoolProperties(Properties properties) {
        Iterator<Object> iter = properties.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            String prop = (String)iter.next();
            if (prop.indexOf("hibernate.proxool") <= -1) continue;
            result.setProperty(prop.substring("hibernate".length() + 1), properties.getProperty(prop));
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

