/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.engine;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.ReplicationMode;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.AssociationType;
import net.sf.hibernate.type.PersistentCollectionType;
import net.sf.hibernate.type.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Cascades {
    private static final Log log = LogFactory.getLog(class$net$sf$hibernate$engine$Cascades == null ? (class$net$sf$hibernate$engine$Cascades = Cascades.class$("net.sf.hibernate.engine.Cascades")) : class$net$sf$hibernate$engine$Cascades);
    public static final CascadingAction ACTION_DELETE = new CascadingAction(){

        void cascade(SessionImplementor session, Object child, Object anything) throws HibernateException {
            log.trace("cascading to delete()");
            if (session.isSaved(child)) {
                session.delete(child);
            }
        }

        Iterator getCascadableChildrenIterator(PersistentCollectionType collectionType, Object collection) {
            return Cascades.getAllElementsIterator(collectionType, collection);
        }

        boolean deleteOrphans() {
            return true;
        }
    };
    public static final CascadingAction ACTION_LOCK = new CascadingAction(){

        void cascade(SessionImplementor session, Object child, Object anything) throws HibernateException {
            log.trace("cascading to lock()");
            session.lock(child, (LockMode)anything);
        }

        Iterator getCascadableChildrenIterator(PersistentCollectionType collectionType, Object collection) {
            return Cascades.getLoadedElementsIterator(collectionType, collection);
        }

        boolean deleteOrphans() {
            return false;
        }
    };
    public static final CascadingAction ACTION_EVICT = new CascadingAction(){

        void cascade(SessionImplementor session, Object child, Object anything) throws HibernateException {
            log.trace("cascading to evict()");
            session.evict(child);
        }

        Iterator getCascadableChildrenIterator(PersistentCollectionType collectionType, Object collection) {
            return Cascades.getLoadedElementsIterator(collectionType, collection);
        }

        boolean deleteOrphans() {
            return false;
        }
    };
    public static final CascadingAction ACTION_SAVE_UPDATE = new CascadingAction(){

        void cascade(SessionImplementor session, Object child, Object anything) throws HibernateException {
            log.trace("cascading to saveOrUpdate()");
            session.saveOrUpdate(child);
        }

        Iterator getCascadableChildrenIterator(PersistentCollectionType collectionType, Object collection) {
            return Cascades.getLoadedElementsIterator(collectionType, collection);
        }

        boolean deleteOrphans() {
            return true;
        }
    };
    public static final CascadingAction ACTION_COPY = new CascadingAction(){

        void cascade(SessionImplementor session, Object child, Object anything) throws HibernateException {
            log.trace("cascading to copy()");
            session.copy(child, (Map)anything);
        }

        Iterator getCascadableChildrenIterator(PersistentCollectionType collectionType, Object collection) {
            return Cascades.getLoadedElementsIterator(collectionType, collection);
        }

        boolean deleteOrphans() {
            return false;
        }
    };
    public static final CascadingAction ACTION_REPLICATE = new CascadingAction(){

        void cascade(SessionImplementor session, Object child, Object anything) throws HibernateException {
            log.trace("cascading to replicate()");
            session.replicate(child, (ReplicationMode)anything);
        }

        Iterator getCascadableChildrenIterator(PersistentCollectionType collectionType, Object collection) {
            return Cascades.getLoadedElementsIterator(collectionType, collection);
        }

        boolean deleteOrphans() {
            return false;
        }
    };
    public static final int CASCADE_AFTER_INSERT_BEFORE_DELETE = 1;
    public static final int CASCADE_BEFORE_INSERT_AFTER_DELETE = 2;
    public static final int CASCADE_AFTER_INSERT_BEFORE_DELETE_VIA_COLLECTION = 3;
    public static final int CASCADE_ON_UPDATE = 0;
    public static final int CASCADE_ON_EVICT = 0;
    public static final int CASCADE_ON_LOCK = 0;
    public static final int CASCADE_ON_COPY = 0;
    public static final CascadeStyle STYLE_ALL_DELETE_ORPHAN = new CascadeStyle(){

        boolean doCascade(CascadingAction action) {
            return true;
        }

        boolean hasOrphanDelete() {
            return true;
        }
    };
    public static final CascadeStyle STYLE_ALL = new CascadeStyle(){

        boolean doCascade(CascadingAction action) {
            return true;
        }
    };
    public static final CascadeStyle STYLE_SAVE_UPDATE = new CascadeStyle(){

        boolean doCascade(CascadingAction action) {
            return action == ACTION_SAVE_UPDATE || action == ACTION_LOCK || action == ACTION_REPLICATE || action == ACTION_COPY;
        }
    };
    public static final CascadeStyle STYLE_ONLY_DELETE = new CascadeStyle(){

        boolean doCascade(CascadingAction action) {
            return action == ACTION_DELETE;
        }
    };
    public static final CascadeStyle STYLE_DELETE_ORPHAN = new CascadeStyle(){

        boolean doCascade(CascadingAction action) {
            return action == ACTION_DELETE;
        }

        boolean hasOrphanDelete() {
            return true;
        }
    };
    public static final CascadeStyle STYLE_NONE = new CascadeStyle(){

        boolean doCascade(CascadingAction action) {
            return action == ACTION_REPLICATE;
        }
    };
    public static final IdentifierValue SAVE_ANY = new IdentifierValue(){

        public final boolean isUnsaved(Serializable id) {
            log.trace("id unsaved-value strategy ANY");
            return true;
        }
    };
    public static final IdentifierValue SAVE_NONE = new IdentifierValue(){

        public final boolean isUnsaved(Serializable id) {
            log.trace("id unsaved-value strategy NONE");
            return false;
        }
    };
    public static final IdentifierValue SAVE_NULL = new IdentifierValue(){

        public final boolean isUnsaved(Serializable id) {
            log.trace("id unsaved-value strategy NULL");
            return id == null;
        }
    };
    public static final VersionValue VERSION_SAVE_NULL = new VersionValue(){

        public final Boolean isUnsaved(Object version) {
            log.trace("version unsaved-value strategy NULL");
            return version == null ? Boolean.TRUE : Boolean.FALSE;
        }
    };
    public static final VersionValue VERSION_UNDEFINED = new VersionValue(){

        public final Boolean isUnsaved(Object version) {
            log.trace("version unsaved-value strategy UNDEFINED");
            return version == null ? Boolean.TRUE : null;
        }
    };
    public static final VersionValue VERSION_NEGATIVE = new VersionValue(){

        public final Boolean isUnsaved(Object version) throws MappingException {
            log.trace("version unsaved-value strategy NEGATIVE");
            if (version instanceof Number) {
                return ((Number)version).longValue() < 0L ? Boolean.TRUE : Boolean.FALSE;
            }
            throw new MappingException("unsaved-value NEGATIVE may only be used with short, int and long types");
        }
    };
    static /* synthetic */ Class class$net$sf$hibernate$engine$Cascades;

    private Cascades() {
    }

    private static boolean collectionIsInitialized(Object collection) {
        return !(collection instanceof PersistentCollection) || ((PersistentCollection)collection).wasInitialized();
    }

    private static void cascade(SessionImplementor session, Object child, Type type, CascadingAction action, CascadeStyle style, int cascadeTo, Object anything) throws HibernateException {
        block2: {
            block3: {
                block4: {
                    if (child == null) break block2;
                    if (!type.isAssociationType()) break block3;
                    if (!((AssociationType)type).getForeignKeyDirection().cascadeNow(cascadeTo)) break block2;
                    if (!type.isEntityType() && !type.isObjectType()) break block4;
                    action.cascade(session, child, anything);
                    break block2;
                }
                if (!type.isPersistentCollectionType()) break block2;
                int cascadeVia = cascadeTo == 1 ? 3 : cascadeTo;
                PersistentCollectionType pctype = (PersistentCollectionType)type;
                CollectionPersister persister = session.getFactory().getCollectionPersister(pctype.getRole());
                Type elemType = persister.getElementType();
                if (!elemType.isEntityType() && !elemType.isObjectType() && !elemType.isComponentType()) break block2;
                Cascades.cascadeCollection(action, style, pctype, elemType, child, cascadeVia, session, anything);
                break block2;
            }
            if (type.isComponentType()) {
                AbstractComponentType componentType = (AbstractComponentType)type;
                Object[] children = componentType.getPropertyValues(child, session);
                Type[] types = componentType.getSubtypes();
                for (int i = 0; i < types.length; ++i) {
                    CascadeStyle componentPropertyStyle = componentType.cascade(i);
                    if (!componentPropertyStyle.doCascade(action)) continue;
                    Cascades.cascade(session, children[i], types[i], action, componentPropertyStyle, cascadeTo, anything);
                }
            }
        }
    }

    public static void cascade(SessionImplementor session, ClassPersister persister, Object parent, CascadingAction action, int cascadeTo) throws HibernateException {
        Cascades.cascade(session, persister, parent, action, cascadeTo, null);
    }

    public static void cascade(SessionImplementor session, ClassPersister persister, Object parent, CascadingAction action, int cascadeTo, Object anything) throws HibernateException {
        if (persister.hasCascades()) {
            if (log.isTraceEnabled()) {
                log.trace("processing cascades for: " + persister.getClassName());
            }
            Type[] types = persister.getPropertyTypes();
            CascadeStyle[] cascadeStyles = persister.getPropertyCascadeStyles();
            for (int i = 0; i < types.length; ++i) {
                CascadeStyle style = cascadeStyles[i];
                if (!style.doCascade(action)) continue;
                Cascades.cascade(session, persister.getPropertyValue(parent, i), types[i], action, style, cascadeTo, anything);
            }
            if (log.isTraceEnabled()) {
                log.trace("done processing cascades for: " + persister.getClassName());
            }
        }
    }

    private static void cascadeCollection(CascadingAction action, CascadeStyle style, PersistentCollectionType collectionType, Type elemType, Object child, int cascadeVia, SessionImplementor session, Object anything) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace("cascading to collection: " + collectionType.getRole());
        }
        Iterator iter = action.getCascadableChildrenIterator(collectionType, child);
        while (iter.hasNext()) {
            Cascades.cascade(session, iter.next(), elemType, action, style, cascadeVia, anything);
        }
        if (style.hasOrphanDelete() && action.deleteOrphans() && child instanceof PersistentCollection) {
            Cascades.deleteOrphans((PersistentCollection)child, session);
        }
    }

    private static void deleteOrphans(PersistentCollection pc, SessionImplementor session) throws HibernateException {
        if (pc.wasInitialized()) {
            Iterator orphanIter = session.getOrphans(pc).iterator();
            while (orphanIter.hasNext()) {
                Object orphan = orphanIter.next();
                if (orphan == null) continue;
                session.delete(orphan);
            }
        }
    }

    private static Iterator getLoadedElementsIterator(PersistentCollectionType collectionType, Object collection) {
        if (Cascades.collectionIsInitialized(collection)) {
            return collectionType.getElementsIterator(collection);
        }
        return ((PersistentCollection)collection).queuedAdditionIterator();
    }

    private static Iterator getAllElementsIterator(PersistentCollectionType collectionType, Object collection) {
        return collectionType.getElementsIterator(collection);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class VersionValue {
        private final Object value;

        protected VersionValue() {
            this.value = null;
        }

        public VersionValue(Object value) {
            this.value = value;
        }

        public Boolean isUnsaved(Object version) throws MappingException {
            if (log.isTraceEnabled()) {
                log.trace("version unsaved-value: " + this.value);
            }
            return version == null || this.value.equals(version) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public static class IdentifierValue {
        private final Object value;

        protected IdentifierValue() {
            this.value = null;
        }

        public IdentifierValue(Object value) {
            this.value = value;
        }

        public boolean isUnsaved(Serializable id) {
            if (log.isTraceEnabled()) {
                log.trace("id unsaved-value: " + this.value);
            }
            return id == null || this.value.equals(id);
        }
    }

    public static abstract class CascadeStyle
    implements Serializable {
        protected CascadeStyle() {
        }

        abstract boolean doCascade(CascadingAction var1);

        boolean hasOrphanDelete() {
            return false;
        }
    }

    public static abstract class CascadingAction {
        protected CascadingAction() {
        }

        abstract void cascade(SessionImplementor var1, Object var2, Object var3) throws HibernateException;

        abstract Iterator getCascadableChildrenIterator(PersistentCollectionType var1, Object var2);

        abstract boolean deleteOrphans();
    }
}

