/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.id;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.id.IdentifierGeneratorFactory;
import net.sf.hibernate.id.TableGenerator;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.PropertiesHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TableHiLoGenerator
extends TableGenerator {
    public static final String MAX_LO = "max_lo";
    private long hi;
    private int lo;
    private int maxLo;
    private Class returnClass;
    private static final Log log = LogFactory.getLog(class$net$sf$hibernate$id$TableHiLoGenerator == null ? (class$net$sf$hibernate$id$TableHiLoGenerator = TableHiLoGenerator.class$("net.sf.hibernate.id.TableHiLoGenerator")) : class$net$sf$hibernate$id$TableHiLoGenerator);
    static /* synthetic */ Class class$net$sf$hibernate$id$TableHiLoGenerator;

    public void configure(Type type, Properties params, Dialect d) {
        super.configure(type, params, d);
        this.maxLo = PropertiesHelper.getInt(MAX_LO, params, Short.MAX_VALUE);
        this.lo = this.maxLo + 1;
        this.returnClass = type.getReturnedClass();
    }

    public synchronized Serializable generate(SessionImplementor session, Object obj) throws SQLException, HibernateException {
        if (this.lo > this.maxLo) {
            int hival = (Integer)super.generate(session, obj);
            this.lo = 1;
            this.hi = hival * (this.maxLo + 1);
            log.debug("new hi value: " + hival);
        }
        return IdentifierGeneratorFactory.createNumber(this.hi + (long)this.lo++, this.returnClass);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

