/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.impl.BatcherImpl;
import net.sf.hibernate.util.JDBCExceptionReporter;

public class BatchingBatcher
extends BatcherImpl {
    private int batchSize;
    private int[] expectedRowCounts = new int[this.getFactory().getJdbcBatchSize()];

    public BatchingBatcher(SessionImplementor session) {
        super(session);
    }

    public void addToBatch(int expectedRowCount) throws SQLException, HibernateException {
        log.trace("Adding to batch");
        PreparedStatement batchUpdate = this.getStatement();
        batchUpdate.addBatch();
        this.expectedRowCounts[this.batchSize++] = expectedRowCount;
        if (this.batchSize == this.getFactory().getJdbcBatchSize()) {
            this.doExecuteBatch(batchUpdate);
        }
    }

    protected void doExecuteBatch(PreparedStatement ps) throws SQLException, HibernateException {
        if (log.isDebugEnabled()) {
            log.debug("Executing batch size: " + this.batchSize);
        }
        try {
            if (this.batchSize != 0) {
                int[] results = ps.executeBatch();
                for (int i = 0; i < this.batchSize; ++i) {
                    if (results[i] == -2) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("success of batch update unknown: " + i);
                        continue;
                    }
                    if (results[i] == -3) {
                        throw new HibernateException("Batch update failed: " + i);
                    }
                    if (this.expectedRowCounts[i] < 0 || results[i] == this.expectedRowCounts[i]) continue;
                    throw new HibernateException("Batch update row count wrong: " + i);
                }
            }
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
        catch (RuntimeException re) {
            log.error("Exception executing batch: ", re);
            throw re;
        }
        finally {
            this.batchSize = 0;
        }
    }
}

