/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.lang.reflect.Constructor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LazyInitializationException;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.engine.HibernateIterator;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ReflectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class IteratorImpl
implements HibernateIterator {
    private static final Log log = LogFactory.getLog(class$net$sf$hibernate$impl$IteratorImpl == null ? (class$net$sf$hibernate$impl$IteratorImpl = IteratorImpl.class$("net.sf.hibernate.impl.IteratorImpl")) : class$net$sf$hibernate$impl$IteratorImpl);
    private ResultSet rs;
    private final SessionImplementor sess;
    private final Type[] types;
    private final boolean single;
    private Object currentResult;
    private boolean hasNext;
    private final String[][] names;
    private PreparedStatement ps;
    private Object nextResult;
    private Constructor holderConstructor;
    static /* synthetic */ Class class$net$sf$hibernate$impl$IteratorImpl;

    public IteratorImpl(ResultSet rs, PreparedStatement ps, SessionImplementor sess, Type[] types, String[][] columnNames, Class holderClass) throws HibernateException, SQLException {
        this.rs = rs;
        this.ps = ps;
        this.sess = sess;
        this.types = types;
        this.names = columnNames;
        if (holderClass != null) {
            this.holderConstructor = ReflectHelper.getConstructor(holderClass, types);
        }
        this.single = types.length == 1;
        this.postNext();
    }

    public void close() throws SQLException {
        if (this.ps != null) {
            log.debug("closing iterator");
            this.nextResult = null;
            this.sess.getBatcher().closeQueryStatement(this.ps, this.rs);
            this.ps = null;
            this.rs = null;
            this.hasNext = false;
        }
    }

    private void postNext() throws HibernateException, SQLException {
        this.hasNext = this.rs.next();
        if (!this.hasNext) {
            log.debug("exhausted results");
            this.close();
        } else {
            log.debug("retrieving next results");
            if (this.single) {
                this.nextResult = this.types[0].nullSafeGet(this.rs, this.names[0], this.sess, null);
            } else {
                Object[] nextResults = new Object[this.types.length];
                for (int i = 0; i < this.types.length; ++i) {
                    nextResults[i] = this.types[i].nullSafeGet(this.rs, this.names[i], this.sess, null);
                }
                this.nextResult = nextResults;
            }
            if (this.holderConstructor != null) {
                try {
                    this.nextResult = this.nextResult == null || !this.nextResult.getClass().isArray() ? this.holderConstructor.newInstance(this.nextResult) : this.holderConstructor.newInstance((Object[])this.nextResult);
                }
                catch (Exception e) {
                    throw new QueryException("Could not instantiate: " + this.holderConstructor.getDeclaringClass(), e);
                }
            }
        }
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public Object next() {
        if (!this.hasNext) {
            throw new NoSuchElementException("No more results");
        }
        try {
            this.currentResult = this.nextResult;
            this.postNext();
            log.debug("returning current results");
            return this.currentResult;
        }
        catch (Exception sqle) {
            log.error("could not get next result", sqle);
            throw new LazyInitializationException(sqle);
        }
    }

    public void remove() {
        if (!this.single) {
            throw new UnsupportedOperationException("Not a single column hibernate query result set");
        }
        if (this.currentResult == null) {
            throw new IllegalStateException("Called Iterator.remove() before next()");
        }
        try {
            this.sess.delete(this.currentResult);
        }
        catch (Exception sqle) {
            log.error("could not remove", sqle);
            throw new LazyInitializationException(sqle);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

