/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.loader;

import java.io.Serializable;
import java.sql.SQLException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.loader.CollectionInitializer;
import net.sf.hibernate.loader.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BatchingCollectionInitializer
implements CollectionInitializer {
    private static final Log log = LogFactory.getLog(class$net$sf$hibernate$loader$BatchingCollectionInitializer == null ? (class$net$sf$hibernate$loader$BatchingCollectionInitializer = BatchingCollectionInitializer.class$("net.sf.hibernate.loader.BatchingCollectionInitializer")) : class$net$sf$hibernate$loader$BatchingCollectionInitializer);
    private final Loader nonBatchLoader;
    private final Loader batchLoader;
    private final Loader smallBatchLoader;
    private final int batchSize;
    private final int smallBatchSize;
    private final CollectionPersister collectionPersister;
    static /* synthetic */ Class class$net$sf$hibernate$loader$BatchingCollectionInitializer;

    public BatchingCollectionInitializer(CollectionPersister collPersister, int batchSize, Loader batchLoader, int smallBatchSize, Loader smallBatchLoader, Loader nonBatchLoader) {
        this.batchLoader = batchLoader;
        this.nonBatchLoader = nonBatchLoader;
        this.batchSize = batchSize;
        this.collectionPersister = collPersister;
        this.smallBatchLoader = smallBatchLoader;
        this.smallBatchSize = smallBatchSize;
    }

    public void initialize(Serializable id, SessionImplementor session) throws SQLException, HibernateException {
        Serializable[] batch = session.getCollectionBatch(this.collectionPersister, id, this.batchSize);
        if (this.smallBatchSize == 1 || batch[this.smallBatchSize - 1] == null) {
            this.nonBatchLoader.loadCollection(session, id, this.collectionPersister.getKeyType());
        } else if (batch[this.batchSize - 1] == null) {
            if (log.isDebugEnabled()) {
                log.debug("batch loading collection role (small batch): " + this.collectionPersister.getRole());
            }
            Serializable[] smallBatch = new Serializable[this.smallBatchSize];
            System.arraycopy(batch, 0, smallBatch, 0, this.smallBatchSize);
            this.smallBatchLoader.loadCollectionBatch(session, smallBatch, this.collectionPersister.getKeyType());
            log.debug("done batch load");
        } else {
            if (log.isDebugEnabled()) {
                log.debug("batch loading collection role: " + this.collectionPersister.getRole());
            }
            this.batchLoader.loadCollectionBatch(session, batch, this.collectionPersister.getKeyType());
            log.debug("done batch load");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

