/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.loader;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.StaleObjectStateException;
import net.sf.hibernate.WrongClassException;
import net.sf.hibernate.cache.QueryCache;
import net.sf.hibernate.cache.QueryKey;
import net.sf.hibernate.cfg.Environment;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.Key;
import net.sf.hibernate.engine.QueryParameters;
import net.sf.hibernate.engine.RowSelection;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.impl.MessageHelper;
import net.sf.hibernate.persister.Loadable;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.type.VersionType;
import net.sf.hibernate.util.JDBCExceptionReporter;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Loader {
    private static final Log log = LogFactory.getLog(class$net$sf$hibernate$loader$Loader == null ? (class$net$sf$hibernate$loader$Loader = Loader.class$("net.sf.hibernate.loader.Loader")) : class$net$sf$hibernate$loader$Loader);
    private String[][] suffixedKeyColumns;
    private String[][] suffixedVersionColumNames;
    private String[][][] suffixedPropertyColumns;
    private String[] suffixedDiscriminatorColumn;
    protected static final String[] NO_SUFFIX = new String[]{""};
    static /* synthetic */ Class class$net$sf$hibernate$loader$Loader;

    protected abstract String getSQLString();

    protected abstract Loadable[] getPersisters();

    protected abstract String[] getSuffixes();

    protected abstract int[] getOwners();

    protected abstract CollectionPersister getCollectionPersister();

    protected int getCollectionOwner() {
        return -1;
    }

    protected abstract LockMode[] getLockModes(Map var1);

    protected String applyLocks(String sql, Map lockModes, Dialect dialect) throws HibernateException {
        return sql;
    }

    protected boolean upgradeLocks() {
        return false;
    }

    protected boolean isSingleRowLoader() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List doQueryAndInitializeNonLazyCollections(SessionImplementor session, QueryParameters queryParameters, Object optionalObject, Serializable optionalId, Serializable[] optionalCollectionKeys, boolean returnProxies) throws SQLException, HibernateException {
        List result;
        session.beforeLoad();
        try {
            result = this.doQuery(session, queryParameters, optionalObject, optionalId, optionalCollectionKeys, returnProxies);
        }
        finally {
            session.afterLoad();
        }
        session.initializeNonLazyCollections();
        return result;
    }

    private List doQuery(SessionImplementor session, QueryParameters queryParameters, Object optionalObject, Serializable optionalId, Serializable[] optionalCollectionKeys, boolean returnProxies) throws SQLException, HibernateException {
        returnProxies = returnProxies && Environment.jvmSupportsProxies();
        RowSelection selection = queryParameters.getRowSelection();
        int maxRows = Loader.hasMaxRows(selection) ? selection.getMaxRows() : Integer.MAX_VALUE;
        Loadable[] persisters = this.getPersisters();
        int cols = persisters.length;
        CollectionPersister collectionPersister = this.getCollectionPersister();
        int collectionOwner = this.getCollectionOwner();
        boolean returnsEntities = cols > 0;
        String[] suffixes = this.getSuffixes();
        LockMode[] lockModeArray = this.getLockModes(queryParameters.getLockModes());
        int[] owners = this.getOwners();
        boolean hasCollections = collectionPersister != null;
        boolean hasCollectionOwners = hasCollections && collectionOwner >= 0;
        ArrayList hydratedObjects = returnsEntities ? new ArrayList() : null;
        Key optionalObjectKey = optionalObject != null ? new Key(optionalId, session.getPersister(optionalObject)) : null;
        ArrayList<Object> results = new ArrayList<Object>();
        PreparedStatement st = this.prepareQueryStatement(this.applyLocks(this.getSQLString(), queryParameters.getLockModes(), session.getFactory().getDialect()), queryParameters, false, session);
        ResultSet rs = this.getResultSet(st, selection, session);
        try {
            int count;
            if (optionalCollectionKeys != null) {
                this.handleEmptyCollections(optionalCollectionKeys, rs, session);
            }
            Key[] keys = new Key[cols];
            if (log.isTraceEnabled()) {
                log.trace("processing result set");
            }
            for (count = 0; count < maxRows && rs.next(); ++count) {
                for (int i = 0; i < cols; ++i) {
                    keys[i] = this.getKeyFromResultSet(i, persisters[i], i == cols - 1 ? optionalId : null, rs, session);
                }
                if (owners != null) {
                    this.registerNonExists(keys, owners, persisters, session);
                }
                Object[] row = this.getRow(rs, persisters, suffixes, keys, optionalObject, optionalObjectKey, lockModeArray, hydratedObjects, session);
                if (returnProxies) {
                    for (int i = 0; i < cols; ++i) {
                        row[i] = session.proxyFor(persisters[i], keys[i], row[i]);
                    }
                }
                if (hasCollections) {
                    Object owner = hasCollectionOwners ? row[collectionOwner] : null;
                    Serializable key = owner != null ? keys[collectionOwner].getIdentifier() : null;
                    this.readCollectionElement(owner, key, rs, session);
                }
                results.add(this.getResultColumnOrRow(row, rs, session));
            }
            if (log.isTraceEnabled()) {
                log.trace("done processing result set (" + count + " rows)");
            }
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
        finally {
            session.getBatcher().closeQueryStatement(st, rs);
        }
        if (returnsEntities) {
            int hydratedObjectsSize = hydratedObjects.size();
            if (log.isTraceEnabled()) {
                log.trace("total objects hydrated: " + hydratedObjectsSize);
            }
            for (int i = 0; i < hydratedObjectsSize; ++i) {
                session.initializeEntity(hydratedObjects.get(i));
            }
        }
        if (hasCollections) {
            session.endLoadingCollections(collectionPersister, rs);
        }
        return results;
    }

    protected List getResultList(List results) throws QueryException {
        return results;
    }

    protected Object getResultColumnOrRow(Object[] row, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        return row;
    }

    private void registerNonExists(Key[] keys, int[] owners, Loadable[] persisters, SessionImplementor session) {
        for (int i = 0; i < keys.length; ++i) {
            int owner = owners[i];
            if (owner <= -1) continue;
            Key ownerKey = keys[owner];
            if (keys[i] != null || ownerKey == null) continue;
            session.addNonExist(new Key(ownerKey.getIdentifier(), persisters[i]));
        }
    }

    private void readCollectionElement(Object optionalOwner, Serializable optionalKey, ResultSet rs, SessionImplementor session) throws HibernateException, SQLException {
        CollectionPersister collectionPersister = this.getCollectionPersister();
        Serializable collectionRowKey = (Serializable)collectionPersister.readKey(rs, session);
        if (collectionRowKey != null) {
            PersistentCollection rowCollection;
            Object owner;
            if (log.isDebugEnabled()) {
                log.debug("found row of collection: " + MessageHelper.infoString(collectionPersister, collectionRowKey));
            }
            if ((owner = optionalOwner) != null || (owner = session.getCollectionOwner(collectionRowKey, collectionPersister)) == null) {
                // empty if block
            }
            if ((rowCollection = session.getLoadingCollection(collectionPersister, collectionRowKey, rs)) != null) {
                rowCollection.readFrom(rs, collectionPersister, owner);
            }
        } else if (optionalKey != null) {
            if (log.isDebugEnabled()) {
                log.debug("result set contains (possibly empty) collection: " + MessageHelper.infoString(collectionPersister, optionalKey));
            }
            session.getLoadingCollection(collectionPersister, optionalKey, rs);
        }
    }

    private void handleEmptyCollections(Serializable[] keys, Object resultSetId, SessionImplementor session) throws HibernateException {
        CollectionPersister collectionPersister = this.getCollectionPersister();
        for (int i = 0; i < keys.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug("result set contains (possibly empty) collection: " + MessageHelper.infoString(collectionPersister, keys[i]));
            }
            session.getLoadingCollection(collectionPersister, keys[i], resultSetId);
        }
    }

    private Key getKeyFromResultSet(int i, Loadable persister, Serializable id, ResultSet rs, SessionImplementor session) throws HibernateException, SQLException {
        Serializable resultId;
        if (this.isSingleRowLoader() && id != null) {
            resultId = id;
        } else {
            Type idType = persister.getIdentifierType();
            resultId = (Serializable)idType.nullSafeGet(rs, this.suffixedKeyColumns[i], session, null);
            if (id != null && resultId != null && id.equals(resultId)) {
                resultId = id;
            }
        }
        return resultId == null ? null : new Key(resultId, persister);
    }

    private void checkVersion(int i, Loadable persister, Serializable id, Object version, ResultSet rs, SessionImplementor session) throws HibernateException, SQLException {
        Object currentVersion;
        VersionType versionType;
        if (version != null && !(versionType = persister.getVersionType()).equals(version, currentVersion = versionType.nullSafeGet(rs, this.suffixedVersionColumNames[i], session, null))) {
            throw new StaleObjectStateException(persister.getMappedClass(), id);
        }
    }

    private Object[] getRow(ResultSet rs, Loadable[] persisters, String[] suffixes, Key[] keys, Object optionalObject, Key optionalObjectKey, LockMode[] lockModes, List hydratedObjects, SessionImplementor session) throws HibernateException, SQLException {
        int cols = persisters.length;
        if (log.isDebugEnabled()) {
            log.debug("result row: " + StringHelper.toString(keys));
        }
        Object[] rowResults = new Object[cols];
        for (int i = 0; i < cols; ++i) {
            Object object = null;
            Key key = keys[i];
            if (keys[i] != null) {
                object = session.getEntity(key);
                if (object != null) {
                    this.instanceAlreadyLoaded(rs, i, persisters[i], suffixes[i], key, object, lockModes[i], session);
                } else {
                    object = this.instanceNotYetLoaded(rs, i, persisters[i], suffixes[i], key, lockModes[i], optionalObjectKey, optionalObject, hydratedObjects, session);
                }
            }
            rowResults[i] = object;
        }
        return rowResults;
    }

    private void instanceAlreadyLoaded(ResultSet rs, int i, Loadable persister, String suffix, Key key, Object object, LockMode lockMode, SessionImplementor session) throws HibernateException, SQLException {
        if (!persister.getMappedClass().isAssignableFrom(object.getClass())) {
            throw new WrongClassException("loaded object was of wrong class", key.getIdentifier(), persister.getMappedClass());
        }
        if (LockMode.NONE != lockMode && this.upgradeLocks() && persister.isVersioned() && session.getLockMode(object).lessThan(lockMode)) {
            this.checkVersion(i, persister, key.getIdentifier(), session.getVersion(object), rs, session);
            session.setLockMode(object, lockMode);
        }
    }

    private Object instanceNotYetLoaded(ResultSet rs, int i, Loadable persister, String suffix, Key key, LockMode lockMode, Key optionalObjectKey, Object optionalObject, List hydratedObjects, SessionImplementor session) throws HibernateException, SQLException {
        Class instanceClass = this.getInstanceClass(rs, i, persister, key.getIdentifier(), session);
        Object object = optionalObjectKey != null && key.equals(optionalObjectKey) ? optionalObject : session.instantiate(instanceClass, key.getIdentifier());
        LockMode acquiredLockMode = lockMode == LockMode.NONE ? LockMode.READ : lockMode;
        this.loadFromResultSet(rs, i, object, key, suffix, acquiredLockMode, persister, session);
        hydratedObjects.add(object);
        return object;
    }

    private void loadFromResultSet(ResultSet rs, int i, Object object, Key key, String suffix, LockMode lockMode, Loadable rootPersister, SessionImplementor session) throws SQLException, HibernateException {
        if (log.isTraceEnabled()) {
            log.trace("Initializing object from ResultSet: " + key);
        }
        session.addUninitializedEntity(key, object, lockMode);
        Loadable persister = (Loadable)session.getPersister(object);
        String[][] cols = persister == rootPersister ? this.suffixedPropertyColumns[i] : Loader.getSuffixedPropertyAliases(persister, suffix);
        Serializable id = key.getIdentifier();
        Object[] values = this.hydrate(rs, id, object, persister, session, cols);
        session.postHydrate(persister, id, values, object, lockMode);
    }

    private Class getInstanceClass(ResultSet rs, int i, Loadable persister, Serializable id, SessionImplementor session) throws HibernateException, SQLException {
        Class topClass = persister.getMappedClass();
        if (persister.hasSubclasses()) {
            Object discriminatorValue = persister.getDiscriminatorType().nullSafeGet(rs, this.suffixedDiscriminatorColumn[i], session, null);
            Class result = persister.getSubclassForDiscriminatorValue(discriminatorValue);
            if (result == null) {
                throw new WrongClassException("Discriminator: " + discriminatorValue, id, topClass);
            }
            return result;
        }
        return topClass;
    }

    private Object[] hydrate(ResultSet rs, Serializable id, Object object, Loadable persister, SessionImplementor session, String[][] suffixedPropertyColumns) throws SQLException, HibernateException {
        if (log.isTraceEnabled()) {
            log.trace("Hydrating entity: " + persister.getClassName() + '#' + id);
        }
        Type[] types = persister.getPropertyTypes();
        Object[] values = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            values[i] = types[i].hydrate(rs, suffixedPropertyColumns[i], session, object);
        }
        return values;
    }

    private void advance(ResultSet rs, RowSelection selection, SessionImplementor session) throws SQLException {
        int firstRow = Loader.getFirstRow(selection);
        if (firstRow != 0) {
            if (session.getFactory().isScrollableResultSetsEnabled()) {
                rs.absolute(firstRow);
            } else {
                for (int m = 0; m < firstRow; ++m) {
                    rs.next();
                }
            }
        }
    }

    private static boolean hasMaxRows(RowSelection selection) {
        return selection != null && selection.getMaxRows() != null;
    }

    private static int getFirstRow(RowSelection selection) {
        if (selection == null || selection.getFirstRow() == null) {
            return 0;
        }
        return selection.getFirstRow();
    }

    private static boolean useLimit(RowSelection selection, Dialect dialect) {
        return dialect.supportsLimit() && Loader.hasMaxRows(selection);
    }

    protected int bindPositionalParameters(PreparedStatement st, QueryParameters queryParameters, int start, SessionImplementor session) throws SQLException, HibernateException {
        Object[] values = queryParameters.getPositionalParameterValues();
        Type[] types = queryParameters.getPositionalParameterTypes();
        int span = 0;
        for (int i = 0; i < values.length; ++i) {
            types[i].nullSafeSet(st, values[i], start + span, session);
            span += types[i].getColumnSpan(session.getFactory());
        }
        return span;
    }

    protected final PreparedStatement prepareQueryStatement(String sql, QueryParameters queryParameters, boolean scroll, SessionImplementor session) throws SQLException, HibernateException {
        boolean scrollable;
        Dialect dialect = session.getFactory().getDialect();
        RowSelection selection = queryParameters.getRowSelection();
        boolean useLimit = Loader.useLimit(selection, dialect);
        boolean hasFirstRow = Loader.getFirstRow(selection) > 0;
        boolean useOffset = hasFirstRow && useLimit && dialect.supportsLimitOffset();
        boolean bl = scrollable = session.getFactory().isScrollableResultSetsEnabled() && (scroll || hasFirstRow && !useOffset);
        if (useLimit) {
            sql = dialect.getLimitString(sql.trim(), useOffset, Loader.getMaxOrLimit(selection, dialect));
        }
        PreparedStatement st = session.getBatcher().prepareQueryStatement(sql, scrollable);
        try {
            int col = 1;
            if (useLimit && dialect.bindLimitParametersFirst()) {
                col += this.bindLimitParameters(st, col, selection, session);
            }
            col += this.bindPositionalParameters(st, queryParameters, col, session);
            col += this.bindNamedParameters(st, queryParameters.getNamedParameters(), col, session);
            if (useLimit && !dialect.bindLimitParametersFirst()) {
                col += this.bindLimitParameters(st, col, selection, session);
            }
            if (!useLimit) {
                this.setMaxRows(st, selection);
            }
            if (selection != null) {
                if (selection.getTimeout() != null) {
                    st.setQueryTimeout(selection.getTimeout());
                }
                if (selection.getFetchSize() != null) {
                    st.setFetchSize(selection.getFetchSize());
                }
            }
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            session.getBatcher().closeQueryStatement(st, null);
            throw sqle;
        }
        catch (HibernateException he) {
            session.getBatcher().closeQueryStatement(st, null);
            throw he;
        }
        return st;
    }

    private static int getMaxOrLimit(RowSelection selection, Dialect dialect) {
        int firstRow = Loader.getFirstRow(selection);
        int lastRow = selection.getMaxRows();
        if (dialect.useMaxForLimit()) {
            return lastRow + firstRow;
        }
        return lastRow;
    }

    private int bindLimitParameters(PreparedStatement st, int index, RowSelection selection, SessionImplementor session) throws SQLException {
        Dialect dialect = session.getFactory().getDialect();
        if (!dialect.supportsVariableLimit()) {
            return 0;
        }
        if (!Loader.hasMaxRows(selection)) {
            throw new AssertionFailure("Bug binding LIMIT parameters");
        }
        int firstRow = Loader.getFirstRow(selection);
        int lastRow = Loader.getMaxOrLimit(selection, dialect);
        boolean hasFirstRow = firstRow > 0 && dialect.supportsLimitOffset();
        boolean reverse = dialect.bindLimitParametersInReverseOrder();
        if (hasFirstRow) {
            st.setInt(index + (reverse ? 1 : 0), firstRow);
        }
        st.setInt(index + (reverse || !hasFirstRow ? 0 : 1), lastRow);
        return hasFirstRow ? 2 : 1;
    }

    private void setMaxRows(PreparedStatement st, RowSelection selection) throws SQLException {
        if (Loader.hasMaxRows(selection)) {
            st.setMaxRows(selection.getMaxRows() + Loader.getFirstRow(selection));
        }
    }

    protected final ResultSet getResultSet(PreparedStatement st, RowSelection selection, SessionImplementor session) throws SQLException, HibernateException {
        ResultSet rs = null;
        try {
            rs = session.getBatcher().getResultSet(st);
            Dialect dialect = session.getFactory().getDialect();
            if (!dialect.supportsLimitOffset() || !Loader.useLimit(selection, dialect)) {
                this.advance(rs, selection, session);
            }
            return rs;
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            session.getBatcher().closeQueryStatement(st, rs);
            throw sqle;
        }
    }

    protected int bindNamedParameters(PreparedStatement st, Map namedParams, int start, SessionImplementor session) throws SQLException, HibernateException {
        return 0;
    }

    private List loadEntity(SessionImplementor session, Object[] values, Type[] types, Object optionalObject, Serializable optionalId) throws SQLException, HibernateException {
        return this.doQueryAndInitializeNonLazyCollections(session, new QueryParameters(types, values), optionalObject, optionalId, null, false);
    }

    protected final List loadEntity(SessionImplementor session, Serializable id, Type identifierType, Object optionalObject, Serializable optionalIdentifier) throws SQLException, HibernateException {
        return this.loadEntity(session, new Object[]{id}, new Type[]{identifierType}, optionalObject, optionalIdentifier);
    }

    protected final List loadEntityBatch(SessionImplementor session, Serializable[] ids, Type idType, Object optionalObject, Serializable optionalID) throws SQLException, HibernateException {
        Object[] types = new Type[ids.length];
        Arrays.fill(types, idType);
        return this.loadEntity(session, ids, (Type[])types, optionalObject, optionalID);
    }

    protected final void loadCollection(SessionImplementor session, Serializable id, Type type) throws SQLException, HibernateException {
        this.loadCollection(session, new Serializable[]{id}, new Type[]{type});
    }

    protected final void loadCollectionBatch(SessionImplementor session, Serializable[] ids, Type type) throws SQLException, HibernateException {
        Object[] idTypes = new Type[ids.length];
        Arrays.fill(idTypes, type);
        this.loadCollection(session, ids, (Type[])idTypes);
    }

    private void loadCollection(SessionImplementor session, Serializable[] ids, Type[] types) throws SQLException, HibernateException {
        this.doQueryAndInitializeNonLazyCollections(session, new QueryParameters(types, ids), null, null, ids, true);
    }

    protected List list(SessionImplementor session, QueryParameters queryParameters, Set querySpaces, Type[] resultTypes) throws SQLException, HibernateException {
        boolean cacheable;
        SessionFactoryImplementor factory = session.getFactory();
        boolean bl = cacheable = factory.isQueryCacheEnabled() && queryParameters.isCacheable();
        if (cacheable) {
            QueryKey key;
            QueryCache queryCache = factory.getQueryCache(queryParameters.getCacheRegion());
            List result = queryCache.get(key = new QueryKey(this.getSQLString(), queryParameters), resultTypes, querySpaces, session);
            if (result == null) {
                result = this.doList(session, queryParameters);
                if (cacheable) {
                    queryCache.put(key, resultTypes, result, session);
                }
            }
            return this.getResultList(result);
        }
        return this.getResultList(this.doList(session, queryParameters));
    }

    protected final List doList(SessionImplementor session, QueryParameters queryParameters) throws SQLException, HibernateException {
        return this.doQueryAndInitializeNonLazyCollections(session, queryParameters, null, null, null, true);
    }

    protected void postInstantiate() {
        Loadable[] persisters = this.getPersisters();
        String[] suffixes = this.getSuffixes();
        this.suffixedKeyColumns = new String[persisters.length][];
        this.suffixedPropertyColumns = new String[persisters.length][][];
        this.suffixedVersionColumNames = new String[persisters.length][];
        this.suffixedDiscriminatorColumn = new String[persisters.length];
        for (int i = 0; i < persisters.length; ++i) {
            this.suffixedKeyColumns[i] = persisters[i].getIdentifierAliases(suffixes[i]);
            this.suffixedPropertyColumns[i] = Loader.getSuffixedPropertyAliases(persisters[i], suffixes[i]);
            this.suffixedDiscriminatorColumn[i] = persisters[i].getDiscriminatorAlias(suffixes[i]);
            if (!persisters[i].isVersioned()) continue;
            this.suffixedVersionColumNames[i] = this.suffixedPropertyColumns[i][persisters[i].getVersionProperty()];
        }
    }

    private static String[][] getSuffixedPropertyAliases(Loadable persister, String suffix) {
        int size = persister.getPropertyNames().length;
        String[][] suffixedPropertyAliases = new String[size][];
        for (int j = 0; j < size; ++j) {
            suffixedPropertyAliases[j] = persister.getPropertyAliases(suffix, j);
        }
        return suffixedPropertyAliases;
    }

    protected static String[] generateSuffixes(int length) {
        if (length == 0) {
            return NO_SUFFIX;
        }
        String[] suffixes = new String[length];
        for (int i = 0; i < length; ++i) {
            suffixes[i] = Integer.toString(i) + '_';
        }
        return suffixes;
    }

    protected static String generateAlias(String description, int unique) {
        return StringHelper.truncate(StringHelper.unqualify(description), 10).toLowerCase().replace('$', '_') + Integer.toString(unique) + '_';
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

