/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.persister;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.beans.BulkBean;
import net.sf.cglib.reflect.FastClass;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.InstantiationException;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.PropertyAccessException;
import net.sf.hibernate.PropertyNotFoundException;
import net.sf.hibernate.StaleObjectStateException;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.cfg.Environment;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.Cascades;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.id.IdentifierGenerationException;
import net.sf.hibernate.id.IdentifierGenerator;
import net.sf.hibernate.id.IdentifierGeneratorFactory;
import net.sf.hibernate.id.IdentityGenerator;
import net.sf.hibernate.impl.MessageHelper;
import net.sf.hibernate.loader.BatchingEntityLoader;
import net.sf.hibernate.loader.EntityLoader;
import net.sf.hibernate.loader.UniqueEntityLoader;
import net.sf.hibernate.mapping.Column;
import net.sf.hibernate.mapping.PersistentClass;
import net.sf.hibernate.mapping.Property;
import net.sf.hibernate.mapping.SimpleValue;
import net.sf.hibernate.mapping.Subclass;
import net.sf.hibernate.metadata.ClassMetadata;
import net.sf.hibernate.persister.AbstractPropertyMapping;
import net.sf.hibernate.persister.OuterJoinLoadable;
import net.sf.hibernate.persister.Queryable;
import net.sf.hibernate.persister.SQLLoadable;
import net.sf.hibernate.persister.UniqueKeyLoadable;
import net.sf.hibernate.property.Getter;
import net.sf.hibernate.property.Setter;
import net.sf.hibernate.proxy.CGLIBProxyFactory;
import net.sf.hibernate.proxy.ProxyFactory;
import net.sf.hibernate.sql.Alias;
import net.sf.hibernate.sql.SelectFragment;
import net.sf.hibernate.sql.SimpleSelect;
import net.sf.hibernate.sql.Template;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.ComponentType;
import net.sf.hibernate.type.EntityType;
import net.sf.hibernate.type.IdentifierType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.type.TypeFactory;
import net.sf.hibernate.type.VersionType;
import net.sf.hibernate.util.JDBCExceptionReporter;
import net.sf.hibernate.util.ReflectHelper;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractEntityPersister
extends AbstractPropertyMapping
implements OuterJoinLoadable,
Queryable,
ClassMetadata,
UniqueKeyLoadable,
SQLLoadable {
    private static final Log log = LogFactory.getLog(class$net$sf$hibernate$persister$AbstractEntityPersister == null ? (class$net$sf$hibernate$persister$AbstractEntityPersister = AbstractEntityPersister.class$("net.sf.hibernate.persister.AbstractEntityPersister")) : class$net$sf$hibernate$persister$AbstractEntityPersister);
    public static final String ENTITY_CLASS = "class";
    private final Dialect dialect;
    private final Class mappedClass;
    private final boolean polymorphic;
    private final boolean explicitPolymorphism;
    private final boolean inherited;
    private final boolean hasSubclasses;
    private final boolean versioned;
    private final boolean abstractClass;
    private final boolean implementsLifecycle;
    private final boolean implementsValidatable;
    private final boolean hasCollections;
    private final boolean hasCascades;
    private final boolean mutable;
    private final boolean selectBeforeUpdate;
    private final Class superclass;
    private final boolean dynamicUpdate;
    private final boolean dynamicInsert;
    private final int optimisticLockMode;
    private final String className;
    private final int batchSize;
    private final Type entityType;
    private final Constructor constructor;
    private final BulkBean optimizer;
    private final FastClass fastClass;
    private final String sqlWhereString;
    private final String sqlWhereStringTemplate;
    private final Class concreteProxyClass;
    private final boolean hasProxy;
    private final ProxyFactory proxyFactory;
    private final boolean useIdentityColumn;
    private final String identitySelectString;
    private final boolean hasEmbeddedIdentifier;
    private final String identifierPropertyName;
    private final String[] identifierColumnNames;
    private final String[] identifierAliases;
    private final Cascades.IdentifierValue unsavedIdentifierValue;
    private final Type identifierType;
    private final Setter identifierSetter;
    private final Getter identifierGetter;
    private final IdentifierGenerator identifierGenerator;
    private final String versionColumnName;
    private final VersionType versionType;
    private final Getter versionGetter;
    private final int versionProperty;
    private final Cascades.VersionValue unsavedVersionValue;
    private final int hydrateSpan;
    private final String[] propertyNames;
    private final Type[] propertyTypes;
    private final boolean[] propertyUpdateability;
    private final boolean[] propertyInsertability;
    private final boolean[] propertyNullability;
    private final Getter[] getters;
    private final Setter[] setters;
    private final Cascades.CascadeStyle[] cascadeStyles;
    private final Map gettersByPropertyName = new HashMap();
    private final Map settersByPropertyName = new HashMap();
    private final Map typesByPropertyName = new HashMap();
    private final CacheConcurrencyStrategy cache;
    private final Map uniqueKeyLoaders = new HashMap();
    private final Map uniqueKeyColumns = new HashMap();
    private final Map subclassPropertyAliases = new HashMap();
    private final Map lockers = new HashMap();
    static /* synthetic */ Class class$net$sf$hibernate$persister$AbstractEntityPersister;
    static /* synthetic */ Class class$net$sf$hibernate$Lifecycle;
    static /* synthetic */ Class class$net$sf$hibernate$Validatable;
    static /* synthetic */ Class class$net$sf$hibernate$proxy$HibernateProxy;

    private String getLockString(LockMode lockMode) {
        return (String)this.lockers.get(lockMode);
    }

    public final Class getMappedClass() {
        return this.mappedClass;
    }

    public final String getClassName() {
        return this.className;
    }

    public String identifierSelectFragment(String name, String suffix) {
        return new SelectFragment().setSuffix(suffix).addColumns(name, this.getIdentifierColumnNames(), this.getIdentifierAliases()).toFragmentString().substring(2);
    }

    public Cascades.CascadeStyle[] getPropertyCascadeStyles() {
        return this.cascadeStyles;
    }

    public void setPropertyValues(Object object, Object[] values) throws HibernateException {
        try {
            if (this.optimizer != null) {
                this.optimizer.setPropertyValues(object, values);
                return;
            }
        }
        catch (Throwable t) {
            throw new PropertyAccessException(t, "exception setting property value with CGLIB (set hibernate.cglib.use_reflection_optimizer=false for more info)", true, this.mappedClass, ReflectHelper.getPropertyName(t, this.optimizer));
        }
        for (int j = 0; j < this.getHydrateSpan(); ++j) {
            this.getSetters()[j].set(object, values[j]);
        }
    }

    public Object[] getPropertyValues(Object object) throws HibernateException {
        try {
            if (this.optimizer != null) {
                return this.optimizer.getPropertyValues(object);
            }
        }
        catch (Throwable t) {
            throw new PropertyAccessException(t, "exception setting property value with CGLIB (set hibernate.cglib.use_reflection_optimizer=false for more info)", false, this.mappedClass, ReflectHelper.getPropertyName(t, this.optimizer));
        }
        int span = this.getHydrateSpan();
        Object[] result = new Object[span];
        for (int j = 0; j < span; ++j) {
            result[j] = this.getGetters()[j].get(object);
        }
        return result;
    }

    public Object getPropertyValue(Object object, int i) throws HibernateException {
        return this.getGetters()[i].get(object);
    }

    public void setPropertyValue(Object object, int i, Object value) throws HibernateException {
        this.getSetters()[i].set(object, value);
    }

    public int[] findDirty(Object[] x, Object[] y, Object object, SessionImplementor session) throws HibernateException {
        int[] props = TypeFactory.findDirty(this.propertyTypes, x, y, this.propertyUpdateability, session);
        if (props == null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            for (int i = 0; i < props.length; ++i) {
                log.trace(StringHelper.qualify(this.className, this.propertyNames[props[i]]) + " is dirty");
            }
        }
        return props;
    }

    public int[] findModified(Object[] old, Object[] current, Object object, SessionImplementor session) throws HibernateException {
        int[] props = TypeFactory.findModified(this.propertyTypes, old, current, this.propertyUpdateability, session);
        if (props == null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            for (int i = 0; i < props.length; ++i) {
                log.trace(StringHelper.qualify(this.className, this.propertyNames[props[i]]) + " is dirty");
            }
        }
        return props;
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        Object id;
        if (this.hasEmbeddedIdentifier) {
            id = object;
        } else {
            if (this.identifierGetter == null) {
                throw new HibernateException("The class has no identifier property: " + this.className);
            }
            id = this.identifierGetter.get(object);
        }
        try {
            return (Serializable)id;
        }
        catch (ClassCastException cce) {
            throw new ClassCastException("Identifier classes must be serializable: " + cce.getMessage());
        }
    }

    public Object getVersion(Object object) throws HibernateException {
        if (!this.versioned) {
            return null;
        }
        return this.versionGetter.get(object);
    }

    public void setIdentifier(Object object, Serializable id) throws HibernateException {
        if (this.hasEmbeddedIdentifier) {
            if (object != id) {
                ComponentType copier = (ComponentType)this.identifierType;
                copier.setPropertyValues(object, copier.getPropertyValues(id));
            }
        } else if (this.identifierSetter != null) {
            this.identifierSetter.set(object, id);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object instantiate(Serializable id) throws HibernateException {
        void var2_2;
        Object result;
        if (this.hasEmbeddedIdentifier && id.getClass() == this.mappedClass) {
            return id;
        }
        if (this.abstractClass) {
            throw new HibernateException("Cannot instantiate abstract class or interface: " + this.className);
        }
        if (this.optimizer != null) {
            try {
                result = this.fastClass.newInstance();
            }
            catch (Throwable t) {
                throw new InstantiationException("Could not instantiate entity with CGLIB: ", this.mappedClass, t);
            }
        }
        try {
            result = this.constructor.newInstance(null);
        }
        catch (Exception e) {
            throw new InstantiationException("Could not instantiate entity: ", this.mappedClass, e);
        }
        this.setIdentifier(var2_2, id);
        return var2_2;
    }

    protected Setter[] getSetters() {
        return this.setters;
    }

    protected Getter[] getGetters() {
        return this.getters;
    }

    public Type[] getPropertyTypes() {
        return this.propertyTypes;
    }

    public Type getIdentifierType() {
        return this.identifierType;
    }

    public String[] getIdentifierColumnNames() {
        return this.identifierColumnNames;
    }

    protected String[] getIdentifierAliases() {
        return this.identifierAliases;
    }

    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public boolean hasCascades() {
        return this.hasCascades;
    }

    public CacheConcurrencyStrategy getCache() {
        return this.cache;
    }

    public boolean hasIdentifierProperty() {
        return this.identifierGetter != null;
    }

    public VersionType getVersionType() {
        return this.versionType;
    }

    public int getVersionProperty() {
        return this.versionProperty;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public boolean isIdentifierAssignedByInsert() {
        return this.useIdentityColumn;
    }

    public boolean isUnsaved(Object object) throws HibernateException {
        Boolean result;
        Serializable id = this.hasIdentifierPropertyOrEmbeddedCompositeIdentifier() ? this.getIdentifier(object) : null;
        if (id == null) {
            return true;
        }
        if (this.isVersioned() && (result = this.unsavedVersionValue.isUnsaved(this.getVersion(object))) != null) {
            return result;
        }
        return this.unsavedIdentifierValue.isUnsaved(id);
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public String getIdentifierPropertyName() {
        return this.identifierPropertyName;
    }

    public String getVersionColumnName() {
        return this.versionColumnName;
    }

    public boolean implementsLifecycle() {
        return this.implementsLifecycle;
    }

    public boolean implementsValidatable() {
        return this.implementsValidatable;
    }

    public boolean hasCollections() {
        return this.hasCollections;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean hasCache() {
        return this.cache != null;
    }

    public boolean hasSubclasses() {
        return this.hasSubclasses;
    }

    public boolean hasProxy() {
        return this.hasProxy;
    }

    protected final String sqlIdentitySelect() {
        return this.identitySelectString;
    }

    public IdentifierGenerator getIdentifierGenerator() throws HibernateException {
        return this.identifierGenerator;
    }

    protected void check(int rows, Serializable id) throws HibernateException {
        if (rows < 1) {
            throw new StaleObjectStateException(this.getMappedClass(), id);
        }
        if (rows > 1) {
            throw new HibernateException("Duplicate identifier in table for " + this.getClassName() + ": " + id);
        }
    }

    protected abstract String[] getActualPropertyColumnNames(int var1);

    protected abstract String getFormulaTemplate(int var1);

    protected void initPropertyPaths(SessionFactoryImplementor factory) throws MappingException {
        for (int i = 0; i < this.propertyNames.length; ++i) {
            this.initPropertyPaths(this.propertyNames[i], this.propertyTypes[i], this.getActualPropertyColumnNames(i), this.getFormulaTemplate(i), factory);
        }
        String idProp = this.getIdentifierPropertyName();
        if (idProp != null) {
            this.initPropertyPaths(idProp, this.getIdentifierType(), this.getIdentifierColumnNames(), factory);
        }
        if (this.hasEmbeddedIdentifier()) {
            this.initPropertyPaths(null, this.getIdentifierType(), this.getIdentifierColumnNames(), factory);
        }
        this.initPropertyPaths("id", this.getIdentifierType(), this.getIdentifierColumnNames(), factory);
        if (this.isPolymorphic()) {
            this.addPropertyPath(ENTITY_CLASS, this.getDiscriminatorType(), new String[]{this.getDiscriminatorColumnName()});
        }
    }

    protected AbstractEntityPersister(PersistentClass model, SessionFactoryImplementor factory) throws HibernateException {
        this.dialect = factory.getDialect();
        this.className = model.getMappedClass().getName();
        this.mappedClass = model.getMappedClass();
        this.mutable = model.isMutable();
        this.selectBeforeUpdate = model.hasSelectBeforeUpdate();
        this.dynamicUpdate = model.useDynamicUpdate();
        this.dynamicInsert = model.useDynamicInsert();
        this.sqlWhereString = model.getWhere();
        this.sqlWhereStringTemplate = this.sqlWhereString == null ? null : Template.renderWhereStringTemplate(this.sqlWhereString, this.dialect);
        this.polymorphic = model.isPolymorphic();
        this.explicitPolymorphism = model.isExplicitPolymorphism();
        this.inherited = model.isInherited();
        this.superclass = this.inherited ? model.getSuperclass().getMappedClass() : null;
        this.hasSubclasses = model.hasSubclasses();
        this.batchSize = model.getBatchSize();
        this.constructor = ReflectHelper.getDefaultConstructor(this.mappedClass);
        this.abstractClass = ReflectHelper.isAbstractClass(this.mappedClass);
        this.entityType = Hibernate.entity(this.mappedClass);
        this.optimisticLockMode = model.getOptimisticLockMode();
        if (this.optimisticLockMode > 0 && !this.dynamicUpdate) {
            throw new MappingException("optimistic-lock setting requires dynamic-update=\"true\": " + this.className);
        }
        this.hasEmbeddedIdentifier = model.hasEmbeddedIdentifier();
        SimpleValue idValue = model.getIdentifier();
        this.identifierType = idValue.getType();
        if (model.hasIdentifierProperty()) {
            Property idProperty = model.getIdentifierProperty();
            this.identifierPropertyName = idProperty.getName();
            this.identifierSetter = idProperty.getSetter(this.mappedClass);
            this.identifierGetter = idProperty.getGetter(this.mappedClass);
        } else {
            this.identifierPropertyName = null;
            this.identifierGetter = null;
            this.identifierSetter = null;
        }
        Class prox = model.getProxyInterface();
        Method proxyGetIdentifierMethod = null;
        Method proxySetIdentifierMethod = null;
        if (model.hasIdentifierProperty() && prox != null) {
            Property idProperty = model.getIdentifierProperty();
            try {
                proxyGetIdentifierMethod = idProperty.getGetter(prox).getMethod();
            }
            catch (PropertyNotFoundException pnfe) {
                // empty catch block
            }
            try {
                proxySetIdentifierMethod = idProperty.getSetter(prox).getMethod();
            }
            catch (PropertyNotFoundException pnfe) {
                // empty catch block
            }
        }
        int m = 0;
        Iterator iter = model.getPropertyClosureIterator();
        while (iter.hasNext()) {
            ++m;
            iter.next();
        }
        this.hydrateSpan = m;
        int idColumnSpan = model.getIdentifier().getColumnSpan();
        this.identifierColumnNames = new String[idColumnSpan];
        this.identifierAliases = new String[idColumnSpan];
        iter = idValue.getColumnIterator();
        int i = 0;
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            this.identifierColumnNames[i] = col.getQuotedName(this.dialect);
            this.identifierAliases[i] = col.getAlias();
            ++i;
        }
        this.identifierGenerator = model.getIdentifier().createIdentifierGenerator(this.dialect);
        this.useIdentityColumn = this.identifierGenerator instanceof IdentityGenerator;
        this.identitySelectString = this.useIdentityColumn ? this.dialect.getIdentitySelectString() : null;
        String unsavedValue = model.getIdentifier().getNullValue();
        if (unsavedValue == null || "null".equals(unsavedValue)) {
            this.unsavedIdentifierValue = Cascades.SAVE_NULL;
        } else if ("none".equals(unsavedValue)) {
            this.unsavedIdentifierValue = Cascades.SAVE_NONE;
        } else if ("any".equals(unsavedValue)) {
            this.unsavedIdentifierValue = Cascades.SAVE_ANY;
        } else {
            Type idType = model.getIdentifier().getType();
            try {
                this.unsavedIdentifierValue = new Cascades.IdentifierValue(((IdentifierType)idType).stringToObject(unsavedValue));
            }
            catch (ClassCastException cce) {
                throw new MappingException("Bad identifier type: " + idType.getClass().getName());
            }
            catch (Exception e) {
                throw new MappingException("Could not parse identifier unsaved-value: " + unsavedValue);
            }
        }
        this.versionColumnName = model.isVersioned() ? ((Column)model.getVersion().getColumnIterator().next()).getQuotedName(this.dialect) : null;
        if (model.isVersioned()) {
            this.versioned = true;
            this.versionGetter = model.getVersion().getGetter(this.mappedClass);
            this.versionType = (VersionType)model.getVersion().getType();
        } else {
            this.versioned = false;
            this.versionType = null;
            this.versionGetter = null;
        }
        String versionUnsavedValue = null;
        if (model.isVersioned()) {
            versionUnsavedValue = model.getVersion().getNullValue();
        }
        if (versionUnsavedValue == null || "undefined".equals(versionUnsavedValue)) {
            this.unsavedVersionValue = Cascades.VERSION_UNDEFINED;
        } else if ("null".equals(versionUnsavedValue)) {
            this.unsavedVersionValue = Cascades.VERSION_SAVE_NULL;
        } else if ("negative".equals(versionUnsavedValue)) {
            this.unsavedVersionValue = Cascades.VERSION_NEGATIVE;
        } else {
            throw new MappingException("Could not parse version unsaved-value: " + versionUnsavedValue);
        }
        this.propertyTypes = new Type[this.hydrateSpan];
        this.propertyNames = new String[this.hydrateSpan];
        this.propertyUpdateability = new boolean[this.hydrateSpan];
        this.propertyInsertability = new boolean[this.hydrateSpan];
        this.propertyNullability = new boolean[this.hydrateSpan];
        this.getters = new Getter[this.hydrateSpan];
        this.setters = new Setter[this.hydrateSpan];
        this.cascadeStyles = new Cascades.CascadeStyle[this.hydrateSpan];
        String[] setterNames = new String[this.hydrateSpan];
        String[] getterNames = new String[this.hydrateSpan];
        Class[] types = new Class[this.hydrateSpan];
        iter = model.getPropertyClosureIterator();
        i = 0;
        int tempVersionProperty = -66;
        boolean foundCascade = false;
        boolean foundCustomAccessor = false;
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            if (prop == model.getVersion()) {
                tempVersionProperty = i;
            }
            this.propertyNames[i] = prop.getName();
            if (!prop.isBasicPropertyAccessor()) {
                foundCustomAccessor = true;
            }
            this.getters[i] = prop.getGetter(this.mappedClass);
            this.setters[i] = prop.getSetter(this.mappedClass);
            getterNames[i] = this.getters[i].getMethodName();
            setterNames[i] = this.setters[i].getMethodName();
            types[i] = this.getters[i].getReturnType();
            this.propertyTypes[i] = prop.getType();
            this.propertyUpdateability[i] = prop.isUpdateable();
            this.propertyInsertability[i] = prop.isInsertable();
            this.propertyNullability[i] = prop.isNullable();
            this.gettersByPropertyName.put(this.propertyNames[i], this.getters[i]);
            this.settersByPropertyName.put(this.propertyNames[i], this.setters[i]);
            this.typesByPropertyName.put(this.propertyNames[i], this.propertyTypes[i]);
            this.cascadeStyles[i] = prop.getCascadeStyle();
            if (this.cascadeStyles[i] != Cascades.STYLE_NONE) {
                foundCascade = true;
            }
            ++i;
        }
        this.optimizer = !foundCustomAccessor && Environment.useReflectionOptimizer() ? ReflectHelper.getBulkBean(this.mappedClass, getterNames, setterNames, types) : null;
        this.fastClass = FastClass.create(this.mappedClass);
        this.hasCascades = foundCascade;
        this.versionProperty = tempVersionProperty;
        this.implementsLifecycle = (class$net$sf$hibernate$Lifecycle == null ? (class$net$sf$hibernate$Lifecycle = AbstractEntityPersister.class$("net.sf.hibernate.Lifecycle")) : class$net$sf$hibernate$Lifecycle).isAssignableFrom(this.mappedClass);
        this.implementsValidatable = (class$net$sf$hibernate$Validatable == null ? (class$net$sf$hibernate$Validatable = AbstractEntityPersister.class$("net.sf.hibernate.Validatable")) : class$net$sf$hibernate$Validatable).isAssignableFrom(this.mappedClass);
        this.cache = model.getCache();
        this.hasCollections = this.initHasCollections();
        this.concreteProxyClass = model.getProxyInterface();
        boolean bl = this.hasProxy = this.concreteProxyClass != null;
        if (this.hasProxy) {
            HashSet<Class> proxyInterfaces = new HashSet<Class>();
            proxyInterfaces.add(class$net$sf$hibernate$proxy$HibernateProxy == null ? (class$net$sf$hibernate$proxy$HibernateProxy = AbstractEntityPersister.class$("net.sf.hibernate.proxy.HibernateProxy")) : class$net$sf$hibernate$proxy$HibernateProxy);
            if (!this.mappedClass.equals(this.concreteProxyClass)) {
                if (!this.concreteProxyClass.isInterface()) {
                    throw new MappingException("proxy must be either an interface, or the class itself: " + this.mappedClass.getName());
                }
                proxyInterfaces.add(this.concreteProxyClass);
            }
            if (this.mappedClass.isInterface()) {
                proxyInterfaces.add(this.mappedClass);
            }
            if (this.hasProxy) {
                iter = model.getSubclassIterator();
                while (iter.hasNext()) {
                    Subclass subclass = (Subclass)iter.next();
                    Class subclassProxy = subclass.getProxyInterface();
                    if (subclassProxy == null) {
                        throw new MappingException("All subclasses must also have proxies: " + this.mappedClass.getName());
                    }
                    if (subclass.getMappedClass().equals(subclassProxy)) continue;
                    proxyInterfaces.add(subclassProxy);
                }
            }
            if (this.hasProxy) {
                this.proxyFactory = this.createProxyFactory();
                this.proxyFactory.postInstantiate(this.mappedClass, proxyInterfaces, proxyGetIdentifierMethod, proxySetIdentifierMethod);
            } else {
                this.proxyFactory = null;
            }
        } else {
            this.proxyFactory = null;
        }
    }

    protected ProxyFactory createProxyFactory() {
        return new CGLIBProxyFactory();
    }

    protected void initSubclassPropertyAliasesMap(PersistentClass model) throws MappingException {
        Iterator iter = model.getSubclassPropertyClosureIterator();
        while (iter.hasNext()) {
            String[] aliases;
            Property prop = (Property)iter.next();
            String propname = prop.getName();
            if (prop.isFormula()) {
                aliases = new String[]{prop.getFormula().getAlias()};
            } else {
                aliases = new String[prop.getColumnSpan()];
                String[] cols = new String[prop.getColumnSpan()];
                Iterator colIter = prop.getColumnIterator();
                int l = 0;
                while (colIter.hasNext()) {
                    Column col = (Column)colIter.next();
                    aliases[l] = col.getAlias();
                    cols[l] = col.getQuotedName(this.dialect);
                    ++l;
                }
                if (prop.getValue().isUnique()) {
                    this.uniqueKeyColumns.put(propname, cols);
                }
            }
            this.subclassPropertyAliases.put(propname, aliases);
        }
        if (this.hasIdentifierProperty()) {
            this.subclassPropertyAliases.put(this.getIdentifierPropertyName(), this.getIdentifierAliases());
            this.subclassPropertyAliases.put("id", this.getIdentifierAliases());
        } else if (this.hasEmbeddedIdentifier()) {
            ComponentType componentId = (ComponentType)this.getIdentifierType();
            String[] idPropertyNames = componentId.getPropertyNames();
            String[] idAliases = this.getIdentifierAliases();
            for (int i = 0; i < idPropertyNames.length; ++i) {
                this.subclassPropertyAliases.put(idPropertyNames[i], new String[]{idAliases[i]});
            }
        }
        if (this.isPolymorphic()) {
            this.subclassPropertyAliases.put(ENTITY_CLASS, new String[]{this.getDiscriminatorAlias()});
        }
    }

    protected void initLockers() {
        String lockString = this.generateLockString();
        this.lockers.put(LockMode.READ, lockString);
        String lockExclusiveString = this.getDialect().supportsForUpdate() ? lockString + " for update" : lockString;
        this.lockers.put(LockMode.UPGRADE, lockExclusiveString);
        String lockExclusiveNowaitString = this.getDialect().supportsForUpdateNowait() ? lockString + " for update nowait" : lockExclusiveString;
        this.lockers.put(LockMode.UPGRADE_NOWAIT, lockExclusiveNowaitString);
    }

    protected abstract String generateLockString();

    private boolean initHasCollections() {
        return this.initHasCollections(this.propertyTypes);
    }

    private boolean initHasCollections(Type[] types) {
        for (int i = 0; i < types.length; ++i) {
            if (types[i].isPersistentCollectionType()) {
                return true;
            }
            if (!types[i].isComponentType() || !this.initHasCollections(((AbstractComponentType)types[i]).getSubtypes())) continue;
            return true;
        }
        return false;
    }

    public ClassMetadata getClassMetadata() {
        return this;
    }

    public Class getConcreteProxyClass() {
        return this.concreteProxyClass;
    }

    public Class getMappedSuperclass() {
        return this.superclass;
    }

    public boolean isExplicitPolymorphism() {
        return this.explicitPolymorphism;
    }

    public boolean[] getPropertyUpdateability() {
        return this.propertyUpdateability;
    }

    public boolean[] getPropertyNullability() {
        return this.propertyNullability;
    }

    protected boolean useDynamicUpdate() {
        return this.dynamicUpdate;
    }

    protected boolean useDynamicInsert() {
        return this.dynamicInsert;
    }

    public boolean[] getPropertyInsertability() {
        return this.propertyInsertability;
    }

    public Object getPropertyValue(Object object, String propertyName) throws HibernateException {
        Getter getter = (Getter)this.gettersByPropertyName.get(propertyName);
        if (getter == null) {
            throw new HibernateException("unmapped property: " + propertyName);
        }
        return getter.get(object);
    }

    public void setPropertyValue(Object object, String propertyName, Object value) throws HibernateException {
        Setter setter = (Setter)this.settersByPropertyName.get(propertyName);
        if (setter == null) {
            throw new HibernateException("unmapped property: " + propertyName);
        }
        setter.set(object, value);
    }

    protected boolean hasEmbeddedIdentifier() {
        return this.hasEmbeddedIdentifier;
    }

    public boolean[] getNotNullInsertableColumns(Object[] fields) {
        boolean[] notNull = new boolean[fields.length];
        boolean[] insertable = this.getPropertyInsertability();
        for (int i = 0; i < fields.length; ++i) {
            notNull[i] = insertable[i] && fields[i] != null;
        }
        return notNull;
    }

    protected Dialect getDialect() {
        return this.dialect;
    }

    protected String getSQLWhereString(String alias) {
        return StringHelper.replace(this.sqlWhereStringTemplate, "$PlaceHolder$", alias);
    }

    protected boolean hasWhere() {
        return this.sqlWhereString != null;
    }

    public boolean hasIdentifierPropertyOrEmbeddedCompositeIdentifier() {
        return this.hasIdentifierProperty() || this.hasEmbeddedIdentifier;
    }

    protected void checkColumnDuplication(Set distinctColumns, Iterator columns) throws MappingException {
        while (columns.hasNext()) {
            Column col = (Column)columns.next();
            if (distinctColumns.add(col.getName())) continue;
            throw new MappingException("Repeated column in mapping for class " + this.className + " should be mapped with insert=\"false\" update=\"false\": " + col.getName());
        }
    }

    protected UniqueEntityLoader createEntityLoader(SessionFactoryImplementor factory) throws MappingException {
        EntityLoader nonBatchLoader = new EntityLoader(this, 1, factory);
        if (this.batchSize > 1) {
            EntityLoader batchLoader = new EntityLoader(this, this.batchSize, factory);
            int smallBatchSize = (int)Math.round(Math.sqrt(this.batchSize));
            EntityLoader smallBatchLoader = new EntityLoader(this, smallBatchSize, factory);
            return new BatchingEntityLoader(this, this.batchSize, batchLoader, smallBatchSize, smallBatchLoader, nonBatchLoader);
        }
        return nonBatchLoader;
    }

    protected void createUniqueKeyLoaders(SessionFactoryImplementor factory) throws MappingException {
        for (int i = 0; i < this.propertyNames.length; ++i) {
            String[] columns = (String[])this.uniqueKeyColumns.get(this.propertyNames[i]);
            if (columns == null) continue;
            Type uniqueKeyType = this.propertyTypes[i];
            if (uniqueKeyType.isEntityType()) {
                Class clazz = ((EntityType)uniqueKeyType).getAssociatedClass();
                uniqueKeyType = factory.getPersister(clazz).getIdentifierType();
            }
            this.uniqueKeyLoaders.put(this.propertyNames[i], new EntityLoader(this, columns, uniqueKeyType, 1, factory));
        }
    }

    public Type getType() {
        return this.entityType;
    }

    protected int getHydrateSpan() {
        return this.hydrateSpan;
    }

    public boolean isBatchLoadable() {
        return this.batchSize > 1;
    }

    public String[] getSubclassPropertyColumnAliases(String propertyName, String suffix) {
        String[] rawAliases = (String[])this.subclassPropertyAliases.get(propertyName);
        if (rawAliases == null) {
            return null;
        }
        String[] result = new String[rawAliases.length];
        for (int i = 0; i < rawAliases.length; ++i) {
            result[i] = new Alias(suffix).toUnquotedAliasString(rawAliases[i]);
        }
        return result;
    }

    public String[] getJoinKeyColumnNames() {
        return this.getIdentifierColumnNames();
    }

    public String getName() {
        return this.getClassName();
    }

    public String selectFragment(String alias, String suffix) {
        return this.identifierSelectFragment(alias, suffix) + this.propertySelectFragment(alias, suffix);
    }

    public String[] getIdentifierAliases(String suffix) {
        return new Alias(suffix).toAliasStrings(this.getIdentifierAliases());
    }

    public String[] getPropertyAliases(String suffix, int i) {
        return new Alias(suffix).toUnquotedAliasStrings(this.getPropertyColumnNames(i));
    }

    public String getDiscriminatorAlias(String suffix) {
        return this.hasSubclasses() ? new Alias(suffix).toAliasString(this.getDiscriminatorAlias()) : null;
    }

    protected abstract String getDiscriminatorAlias();

    public Object loadByUniqueKey(String propertyName, Serializable uniqueKey, SessionImplementor session) throws HibernateException, SQLException {
        return ((EntityLoader)this.uniqueKeyLoaders.get(propertyName)).loadByUniqueKey(session, uniqueKey);
    }

    public String[] getUniqueKeyColumnNames(String propertyName) {
        return (String[])this.uniqueKeyColumns.get(propertyName);
    }

    public boolean isCollection() {
        return false;
    }

    public boolean consumesAlias() {
        return true;
    }

    public Type getPropertyType(String propertyName) throws MappingException {
        Type propertyType = (Type)this.typesByPropertyName.get(propertyName);
        if (propertyType == null) {
            throw new MappingException("property does not exist: " + propertyName);
        }
        return propertyType;
    }

    protected boolean hasSelectBeforeUpdate() {
        return this.selectBeforeUpdate;
    }

    protected abstract String getVersionSelectString();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Object getCurrentVersion(Serializable id, SessionImplementor session) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace("Getting version: " + MessageHelper.infoString(this, id));
        }
        try {
            PreparedStatement st = session.getBatcher().prepareStatement(this.getVersionSelectString());
            try {
                ResultSet rs;
                block16: {
                    block15: {
                        Object var5_7;
                        this.getIdentifierType().nullSafeSet(st, id, 1, session);
                        rs = st.executeQuery();
                        try {
                            if (rs.next()) break block15;
                            var5_7 = null;
                        }
                        catch (Throwable throwable) {
                            try {
                                rs.close();
                                throw throwable;
                            }
                            catch (SQLException sqle) {
                                JDBCExceptionReporter.logExceptions(sqle);
                                throw sqle;
                            }
                        }
                        rs.close();
                        return var5_7;
                    }
                    if (this.isVersioned()) break block16;
                    AbstractEntityPersister abstractEntityPersister = this;
                    rs.close();
                    return abstractEntityPersister;
                }
                Object object = this.getVersionType().nullSafeGet(rs, this.getVersionColumnName(), session, null);
                rs.close();
                return object;
            }
            finally {
                session.getBatcher().closeStatement(st);
            }
        }
        catch (SQLException sqle) {
            throw new JDBCException("could not retrieve version: " + MessageHelper.infoString(this, id), sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Serializable id, Object version, Object object, LockMode lockMode, SessionImplementor session) throws HibernateException {
        if (lockMode != LockMode.NONE) {
            if (log.isTraceEnabled()) {
                log.trace("Locking entity: " + MessageHelper.infoString(this, id));
                if (this.isVersioned()) {
                    log.trace("Version: " + version);
                }
            }
            try {
                PreparedStatement st = session.getBatcher().prepareStatement(this.getLockString(lockMode));
                try {
                    this.getIdentifierType().nullSafeSet(st, id, 1, session);
                    if (this.isVersioned()) {
                        this.getVersionType().nullSafeSet(st, version, this.getIdentifierColumnNames().length + 1, session);
                    }
                    ResultSet rs = st.executeQuery();
                    try {
                        if (!rs.next()) {
                            throw new StaleObjectStateException(this.getMappedClass(), id);
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
                catch (SQLException sqle) {
                    JDBCExceptionReporter.logExceptions(sqle);
                    throw sqle;
                }
                finally {
                    session.getBatcher().closeStatement(st);
                }
            }
            catch (SQLException sqle) {
                throw new JDBCException("could not lock: " + MessageHelper.infoString(this, id), sqle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Serializable getGeneratedIdentity(Object object, SessionImplementor session, ResultSet rs) throws SQLException, HibernateException, IdentifierGenerationException {
        Serializable id;
        try {
            if (!rs.next()) {
                throw new HibernateException("The database returned no natively generated identity value");
            }
            id = IdentifierGeneratorFactory.get(rs, this.getIdentifierType(), session, object);
        }
        finally {
            rs.close();
        }
        if (log.isDebugEnabled()) {
            log.debug("Natively generated identity: " + id);
        }
        return id;
    }

    public Object[] getCurrentPersistentState(Serializable id, Object version, SessionImplementor session) throws HibernateException {
        if (!this.hasSelectBeforeUpdate()) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("Getting current persistent state for: " + MessageHelper.infoString(this, id));
        }
        Type[] types = this.getPropertyTypes();
        Object[] values = new Object[types.length];
        boolean[] includeProperty = this.getPropertyUpdateability();
        try {
            PreparedStatement ps = session.getBatcher().prepareQueryStatement(this.getConcreteSelectString(), false);
            ResultSet rs = null;
            try {
                this.getIdentifierType().nullSafeSet(ps, id, 1, session);
                if (this.isVersioned()) {
                    this.getVersionType().nullSafeSet(ps, version, this.getIdentifierColumnNames().length + 1, session);
                }
                if (!(rs = session.getBatcher().getResultSet(ps)).next()) {
                    throw new StaleObjectStateException(this.getMappedClass(), id);
                }
                for (int i = 0; i < types.length; ++i) {
                    if (!includeProperty[i]) continue;
                    values[i] = types[i].hydrate(rs, this.getPropertyAliases("", i), session, null);
                }
            }
            catch (SQLException sqle) {
                try {
                    JDBCExceptionReporter.logExceptions(sqle);
                    throw sqle;
                }
                catch (Throwable throwable) {
                    session.getBatcher().closeQueryStatement(ps, rs);
                    throw throwable;
                }
            }
            session.getBatcher().closeQueryStatement(ps, rs);
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
        return values;
    }

    protected abstract String getVersionedTableName();

    protected String generateSelectVersionString() {
        SimpleSelect select = new SimpleSelect().setTableName(this.getVersionedTableName());
        if (this.isVersioned()) {
            select.addColumn(this.versionColumnName);
        } else {
            select.addColumns(this.identifierColumnNames);
        }
        return select.addCondition(this.identifierColumnNames, "=?").toStatementString();
    }

    protected abstract String getConcreteSelectString();

    protected final int optimisticLockMode() {
        return this.optimisticLockMode;
    }

    public boolean isManyToMany() {
        return false;
    }

    public Object createProxy(Serializable id, SessionImplementor session) throws HibernateException {
        return this.proxyFactory.getProxy(id, session);
    }

    protected final boolean[] getPropertiesToUpdate(int[] dirtyProperties) {
        boolean[] propsToUpdate = new boolean[this.getHydrateSpan()];
        for (int j = 0; j < dirtyProperties.length; ++j) {
            propsToUpdate[dirtyProperties[j]] = true;
        }
        if (this.isVersioned()) {
            propsToUpdate[this.getVersionProperty()] = true;
        }
        return propsToUpdate;
    }

    public String toString() {
        return this.getClass().getName() + " for class: " + this.className;
    }

    protected abstract String[] getPropertyColumnNames(int var1);

    public final String selectFragment(String alias, String suffix, boolean includeCollectionColumns) {
        return this.selectFragment(alias, suffix);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

