/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.class2hbm;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Vector;
import net.sf.hibernate.tool.class2hbm.ReflectedArrayProperty;
import net.sf.hibernate.tool.class2hbm.ReflectedClass;
import net.sf.hibernate.tool.class2hbm.ReflectedCollectionProperty;
import net.sf.hibernate.tool.class2hbm.ReflectedComponent;
import net.sf.hibernate.tool.class2hbm.ReflectedListProperty;
import net.sf.hibernate.tool.class2hbm.ReflectedMapProperty;
import net.sf.hibernate.tool.class2hbm.ReflectedProperty;
import net.sf.hibernate.tool.class2hbm.ReflectedSetProperty;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.type.TypeFactory;
import net.sf.hibernate.util.StringHelper;

public class MapGenerator {
    private static String[] defaultKeys = new String[]{"uid", "UID", "id", "ID", "key", "KEY", "pk", "PK"};
    private ClassLoader classLoader;
    private boolean verbose = true;
    protected int maxDepth = 0;
    protected String[] niceKeys = defaultKeys;
    protected StringBuffer buf;
    protected Hashtable rClasses;
    protected Hashtable abstractClasses = new Hashtable(5);
    protected Hashtable cycleBuster;
    private Hashtable usedTableNames;
    private Hashtable usedColumnNames;
    private Vector entities;
    private Vector roots;
    private char[] prefix = StringHelper.repeat("\t", 100).toCharArray();
    private String interact_usage = "usage: class.name | uid=<newUID> | done";
    static /* synthetic */ Class class$net$sf$hibernate$PersistentEnum;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$Collection;

    public static void main(String[] args) {
        FileWriter outputWriter = null;
        int len = args.length;
        if (len == 0) {
            System.out.println("<!-- No args provided, no classes reflected! -->");
        } else if (len == 1 && "--interact".equals(args[0])) {
            MapGenerator map = new MapGenerator(null, ClassLoader.getSystemClassLoader());
            map.interact();
        } else {
            MapGenerator map = new MapGenerator(null, ClassLoader.getSystemClassLoader());
            for (int i = 0; i < len; ++i) {
                if (args[i].startsWith("--")) {
                    if (args[i].startsWith("--setUID=")) {
                        map.setUID(args[i].substring(9));
                        continue;
                    }
                    if (args[i].startsWith("--addUID=")) {
                        map.addUID(args[i].substring(9));
                        continue;
                    }
                    if (args[i].startsWith("--depth=")) {
                        try {
                            map.maxDepth = Integer.parseInt(args[i].substring(8));
                        }
                        catch (NumberFormatException e) {
                            System.err.println("<!-- Can't set maxDepth " + e.getMessage() + "-->");
                        }
                        continue;
                    }
                    if (args[i].equals("--quiet")) {
                        map.verbose = false;
                        continue;
                    }
                    if (args[i].startsWith("--output=")) {
                        outputWriter = MapGenerator.makeWriter(args[i].substring(9));
                        continue;
                    }
                    if (!args[i].startsWith("--abstract=")) continue;
                    map.abstractClasses.put(args[i].substring(11), "");
                    continue;
                }
                map.addClass(args[i], true);
            }
            map.writeXML(outputWriter);
        }
    }

    public void writeXML(Writer outputWriter) {
        String xml = this.getXML();
        if (outputWriter != null) {
            try {
                outputWriter.write(xml);
                outputWriter.flush();
            }
            catch (Exception e) {
                outputWriter = null;
            }
        }
        if (this.verbose || outputWriter == null) {
            System.out.println(xml);
        }
    }

    private static FileWriter makeWriter(String fileName) {
        try {
            FileWriter fw = new FileWriter(fileName);
            return fw;
        }
        catch (Exception e) {
            System.err.println("<!-- Error making FileWriter " + e.getMessage() + "-->");
            return null;
        }
    }

    public MapGenerator(String[] className, ClassLoader loader) {
        this.setClassLoader(loader);
        this.reset();
        if (className != null) {
            int len = className.length;
            for (int i = 0; i < len; ++i) {
                this.addClass(className[i], true);
            }
        }
    }

    private void interact() {
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        StreamTokenizer st = new StreamTokenizer(r);
        st.wordChars(33, 126);
        System.out.println(this.interact_usage);
        System.out.print("? ");
        boolean allIsWell = true;
        while (allIsWell) {
            int tt;
            try {
                tt = st.nextToken();
            }
            catch (Exception e) {
                System.out.println("IOException; done");
                tt = -1;
            }
            switch (tt) {
                case -1: {
                    allIsWell = false;
                    break;
                }
                case 10: {
                    st.eolIsSignificant(false);
                    break;
                }
                case -2: {
                    System.out.println("number!? ");
                    System.out.println(this.interact_usage);
                    System.out.print("? ");
                    break;
                }
                case -3: {
                    String name = st.sval;
                    if ("done".equals(name)) {
                        allIsWell = false;
                        break;
                    }
                    if (name.startsWith("uid=")) {
                        String uid = name.substring(4);
                        System.out.print("niceKey(" + uid + ")=>");
                        this.addUID(uid);
                        for (int i = 0; i < this.niceKeys.length; ++i) {
                            System.out.print(" ");
                            System.out.print(this.niceKeys[i]);
                        }
                        System.out.print("\n? ");
                        break;
                    }
                    System.out.println("addClass(" + name + ")");
                    this.addClass(name, true);
                    System.out.print("? ");
                    break;
                }
            }
        }
        System.out.println(this.getXML());
    }

    public void reset() {
        this.buf = new StringBuffer();
        this.roots = new Vector();
        this.entities = new Vector();
        this.rClasses = new Hashtable();
        this.usedTableNames = new Hashtable();
        this.buf.append("<?xml version=\"1.0\"?>\n").append("<!DOCTYPE hibernate-mapping PUBLIC\n").append("\t\"-//Hibernate/Hibernate Mapping DTD 2.0//EN\"\n").append("\t\"http://hibernate.sourceforge.net/hibernate-mapping-2.0.dtd\">\n");
    }

    public void addClass(String className, boolean verbose) {
        ReflectedClass rc;
        Class clazz = this.checkClassNamed(className, verbose);
        if (clazz != null && (rc = this.reallyAdd(clazz, verbose)) == null && verbose) {
            this.buf.append("<!-- ").append(clazz.getName()).append(" cannot be added, no UID found! -->\n");
        }
    }

    public void setUID(String uid) {
        String[] uida = new String[]{uid};
        this.niceKeys = uida;
    }

    public void addUID(String uid) {
        int i;
        String[] uida = new String[this.niceKeys.length + 1];
        for (i = 0; i < this.niceKeys.length; ++i) {
            uida[i + 1] = this.niceKeys[i];
        }
        uida[0] = uid;
        this.niceKeys = uida;
        for (i = 0; i < this.niceKeys.length; ++i) {
            System.out.print(" ");
            System.out.print(this.niceKeys[i]);
        }
    }

    public ReflectedClass[] getRoots() {
        Object[] v = new ReflectedClass[this.roots.size()];
        this.roots.copyInto(v);
        return v;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ReflectedClass reallyAdd(Class clazz, boolean verbose) {
        ReflectedClass rc = (ReflectedClass)this.rClasses.get(clazz);
        Class superclass = clazz.getSuperclass();
        if (rc == null) {
            rc = new ReflectedClass(this, clazz);
        } else if (rc.isPersistent()) {
            if (!verbose) return rc;
            this.buf.append("<!-- ").append(clazz.getName()).append(" already added -->\n");
            return rc;
        }
        rc.setPersistent(true);
        if (rc.getUidProp(this.niceKeys) != null) {
            rc.addSuperclassProps();
            this.roots.add(rc);
            return rc;
        }
        if (superclass != null && this.abstractClasses.containsKey(superclass.getName())) {
            rc.addSuperclassProps();
            if (rc.getUidProp(this.niceKeys) != null) {
                this.roots.add(rc);
                return rc;
            }
            rc.setPersistent(false);
            return null;
        }
        if (superclass == null) {
            rc.setPersistent(false);
            return null;
        }
        ReflectedClass sup = this.reallyAdd(superclass, false);
        if (sup == null) {
            rc.setPersistent(false);
            return null;
        }
        sup.addReflectedClass(rc);
        return rc;
    }

    protected String nextName(String best, Hashtable h) {
        Integer seen = (Integer)h.get(best);
        if (seen == null) {
            h.put(best, new Integer(1));
            return best;
        }
        h.put(best, new Integer(seen + 1));
        return best + "_" + seen;
    }

    protected String tableNameFor(String name) {
        String best = StringHelper.unqualify(name);
        return this.nextName(best, this.usedTableNames);
    }

    protected String columnNameFor(String best) {
        return this.nextName(best, this.usedColumnNames);
    }

    protected void emitPrefix(int n) {
        int e = n * 1;
        if (e > this.prefix.length) {
            e = this.prefix.length;
        }
        this.buf.append(this.prefix, 0, e);
    }

    public String getXML() {
        this.buf.append("<hibernate-mapping>\n");
        int eln = this.entities.size();
        for (int i = 0; i < eln; ++i) {
            PEntity pet = (PEntity)this.roots.get(i);
            this.usedColumnNames = new Hashtable();
            pet.getXML(1, true);
        }
        int len = this.roots.size();
        for (int i = 0; i < len; ++i) {
            ReflectedClass rc = (ReflectedClass)this.roots.get(i);
            this.usedColumnNames = new Hashtable();
            rc.getXML(1);
        }
        this.buf.append("</hibernate-mapping>\n");
        return this.buf.toString();
    }

    private Class checkClassNamed(String className, boolean v) {
        try {
            Class<?> clazz = this.classLoader.loadClass(className);
            return this.checkClass(clazz, className, v);
        }
        catch (Exception e) {
            if (v) {
                this.buf.append("<!-- Class ").append(className).append(" gave exception ").append(e).append(" -->\n");
            }
            return null;
        }
    }

    protected ReflectedProperty makeProperty(String name, Class cls) {
        String tynm = cls.getName();
        Type htyp = TypeFactory.basic(tynm);
        if (htyp != null) {
            return new ReflectedProperty(name, cls, this, "basic");
        }
        if (cls.isArray()) {
            return new ReflectedArrayProperty(name, cls, this);
        }
        if ((class$net$sf$hibernate$PersistentEnum == null ? (class$net$sf$hibernate$PersistentEnum = MapGenerator.class$("net.sf.hibernate.PersistentEnum")) : class$net$sf$hibernate$PersistentEnum).isAssignableFrom(cls)) {
            return new ReflectedProperty(name, cls, this, "enum");
        }
        if ((class$java$util$List == null ? (class$java$util$List = MapGenerator.class$("java.util.List")) : class$java$util$List).isAssignableFrom(cls)) {
            return new ReflectedListProperty(name, cls, this);
        }
        if ((class$java$util$Map == null ? (class$java$util$Map = MapGenerator.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(cls)) {
            return new ReflectedMapProperty(name, cls, this);
        }
        if ((class$java$util$Set == null ? (class$java$util$Set = MapGenerator.class$("java.util.Set")) : class$java$util$Set).isAssignableFrom(cls)) {
            return new ReflectedSetProperty(name, cls, this);
        }
        if ((class$java$util$Collection == null ? (class$java$util$Collection = MapGenerator.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(cls)) {
            return new ReflectedCollectionProperty(name, cls, this);
        }
        Class comp = this.checkComponent(cls, tynm, true);
        if (comp == null) {
            return new ReflectedProperty(name, cls, this, "custom");
        }
        ReflectedClass rc = (ReflectedClass)this.rClasses.get(comp);
        if (rc == null) {
            rc = new ReflectedClass(this, comp);
        }
        return new ReflectedComponent(name, cls, this, rc);
    }

    protected Class checkClass(Class clazz, String className, boolean v) {
        return this.checkClCoGuts(clazz, className, v, "<!-- Class ");
    }

    protected Class checkComponent(Class clazz, String className, boolean v) {
        return this.checkClCoGuts(clazz, className, v, "<!-- Component ");
    }

    /*
     * WARNING - void declaration
     */
    private Class checkClCoGuts(Class clazz, String className, boolean v, String c) {
        void var5_5;
        Constructor<Object> z;
        if (clazz.isPrimitive()) {
            if (v) {
                this.buf.append(c).append(className).append(" is a primitive! -->\n");
            }
            return null;
        }
        if (clazz.isArray()) {
            if (v) {
                this.buf.append(c).append(className).append(" is an array! -->\n");
            }
            return null;
        }
        if (clazz.isInterface()) {
            if (v) {
                this.buf.append(c).append(className).append(" is an interface! -->\n");
            }
            return null;
        }
        if (clazz.getDeclaringClass() != null) {
            if (v) {
                this.buf.append(c).append(className).append(" is a nested class! -->\n");
            }
            return null;
        }
        try {
            z = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            z = null;
        }
        catch (SecurityException e) {
            if (v) {
                this.buf.append(c).append(className).append(" cannot be reflected due to a SecurityException! -->\n");
            }
            return null;
        }
        if (z == null) {
            try {
                Constructor<?>[] cs = clazz.getDeclaredConstructors();
                for (int i = 0; i < cs.length; ++i) {
                    if (cs[i].getParameterTypes().length != 0) continue;
                    z = cs[i];
                    break;
                }
            }
            catch (SecurityException e) {
                if (v) {
                    this.buf.append(c).append(className).append(" cannot be reflected due to a SecurityException! -->\n");
                }
                return null;
            }
        }
        if (var5_5 == null) {
            if (v) {
                this.buf.append(c).append(className).append(" has no 0-arg constructor! -->\n");
            }
            return null;
        }
        return clazz;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class PEntity {
        PEntity() {
        }

        void getXML(int level, boolean isRoot) {
        }
    }
}

