/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.hbm2ddl;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.cfg.NamingStrategy;
import net.sf.hibernate.connection.ConnectionProvider;
import net.sf.hibernate.connection.ConnectionProviderFactory;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.util.JDBCExceptionReporter;
import net.sf.hibernate.util.ReflectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SchemaExport {
    private static final Log log = LogFactory.getLog(class$net$sf$hibernate$tool$hbm2ddl$SchemaExport == null ? (class$net$sf$hibernate$tool$hbm2ddl$SchemaExport = SchemaExport.class$("net.sf.hibernate.tool.hbm2ddl.SchemaExport")) : class$net$sf$hibernate$tool$hbm2ddl$SchemaExport);
    private String[] dropSQL;
    private String[] createSQL;
    private Properties connectionProperties;
    private String outputFile = null;
    private Dialect dialect;
    private String delimiter;
    static /* synthetic */ Class class$net$sf$hibernate$tool$hbm2ddl$SchemaExport;

    public SchemaExport(Configuration cfg) throws HibernateException {
        this(cfg, cfg.getProperties());
    }

    public SchemaExport(Configuration cfg, Properties connectionProperties) throws HibernateException {
        this.connectionProperties = connectionProperties;
        this.dialect = Dialect.getDialect(connectionProperties);
        this.dropSQL = cfg.generateDropSchemaScript(this.dialect);
        this.createSQL = cfg.generateSchemaCreationScript(this.dialect);
    }

    public SchemaExport setOutputFile(String filename) {
        this.outputFile = filename;
        return this;
    }

    public SchemaExport setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public void create(boolean script, boolean export) {
        this.execute(script, export, false, true);
    }

    public void drop(boolean script, boolean export) {
        this.execute(script, export, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void execute(boolean script, boolean export, boolean justDrop, boolean format) {
        block38: {
            String formatted;
            log.info("Running hbm2ddl schema export");
            Connection connection = null;
            OutputStreamWriter fileOutput = null;
            ConnectionProvider connectionProvider = null;
            Statement statement = null;
            Properties props = new Properties();
            props.putAll((Map<?, ?>)this.dialect.getDefaultProperties());
            props.putAll((Map<?, ?>)this.connectionProperties);
            if (this.outputFile != null) {
                log.info("writing generated schema to file: " + this.outputFile);
                fileOutput = new FileWriter(this.outputFile);
            }
            if (export) {
                log.info("exporting generated schema to database");
                connectionProvider = ConnectionProviderFactory.newConnectionProvider(props);
                connection = connectionProvider.getConnection();
                if (!connection.getAutoCommit()) {
                    connection.commit();
                    connection.setAutoCommit(true);
                }
                statement = connection.createStatement();
            }
            for (int i = 0; i < this.dropSQL.length; ++i) {
                try {
                    formatted = this.dropSQL[i];
                    if (this.delimiter != null) {
                        formatted = formatted + this.delimiter;
                    }
                    if (script) {
                        System.out.println(formatted);
                    }
                    log.debug(formatted);
                    if (this.outputFile != null) {
                        fileOutput.write(formatted + "\n");
                    }
                    if (!export) continue;
                    statement.executeUpdate(this.dropSQL[i]);
                    continue;
                }
                catch (SQLException e) {
                    log.debug("Unsuccessful: " + this.dropSQL[i]);
                    log.debug(e.getMessage());
                }
            }
            if (!justDrop) {
                for (int j = 0; j < this.createSQL.length; ++j) {
                    try {
                        String string = formatted = format ? SchemaExport.format(this.createSQL[j]) : this.createSQL[j];
                        if (this.delimiter != null) {
                            formatted = formatted + this.delimiter;
                        }
                        if (script) {
                            System.out.println(formatted);
                        }
                        log.debug(formatted);
                        if (this.outputFile != null) {
                            fileOutput.write(formatted + "\n");
                        }
                        if (!export) continue;
                        statement.executeUpdate(this.createSQL[j]);
                        continue;
                    }
                    catch (SQLException e) {
                        log.error("Unsuccessful: " + this.createSQL[j]);
                        log.error(e.getMessage());
                    }
                }
            }
            log.info("schema export complete");
            Object var13_15 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    JDBCExceptionReporter.logWarnings(connection.getWarnings());
                    connection.clearWarnings();
                    connectionProvider.closeConnection(connection);
                    connectionProvider.close();
                }
            }
            catch (Exception e2) {
                log.error("Could not close connection", e2);
            }
            try {
                if (fileOutput != null) {
                    fileOutput.close();
                }
                break block38;
            }
            catch (IOException ioe) {
                log.error("Error closing output file: " + this.outputFile, ioe);
            }
            break block38;
            {
                catch (Exception e) {
                    log.error("schema export unsuccessful", e);
                    Object var13_16 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        if (connection != null) {
                            JDBCExceptionReporter.logWarnings(connection.getWarnings());
                            connection.clearWarnings();
                            connectionProvider.closeConnection(connection);
                            connectionProvider.close();
                        }
                    }
                    catch (Exception e2) {
                        log.error("Could not close connection", e2);
                    }
                    try {
                        if (fileOutput != null) {
                            fileOutput.close();
                        }
                        break block38;
                    }
                    catch (IOException ioe) {
                        log.error("Error closing output file: " + this.outputFile, ioe);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        JDBCExceptionReporter.logWarnings(connection.getWarnings());
                        connection.clearWarnings();
                        connectionProvider.closeConnection(connection);
                        connectionProvider.close();
                    }
                }
                catch (Exception e2) {
                    log.error("Could not close connection", e2);
                }
                try {
                    if (fileOutput != null) {
                        fileOutput.close();
                    }
                }
                catch (IOException ioe) {
                    log.error("Error closing output file: " + this.outputFile, ioe);
                }
                throw throwable;
            }
        }
    }

    private static String format(String sql) {
        String formatted;
        if (sql.indexOf("\"") > 0 || sql.indexOf("'") > 0) {
            return sql;
        }
        if (sql.toLowerCase().startsWith("create table")) {
            StringBuffer result = new StringBuffer(60);
            StringTokenizer tokens = new StringTokenizer(sql, "(,)", true);
            int depth = 0;
            while (tokens.hasMoreTokens()) {
                String tok = tokens.nextToken();
                if (")".equals(tok) && --depth == 0) {
                    result.append("\n");
                }
                result.append(tok);
                if (",".equals(tok) && depth == 1) {
                    result.append("\n  ");
                }
                if (!"(".equals(tok) || ++depth != 1) continue;
                result.append("\n   ");
            }
            formatted = result.toString();
        } else {
            formatted = sql;
        }
        return formatted;
    }

    public static void main(String[] args) {
        try {
            Configuration cfg = new Configuration();
            boolean script = true;
            boolean drop = false;
            boolean export = true;
            String outFile = null;
            String propFile = null;
            boolean formatSQL = false;
            String delim = null;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("--")) {
                    if (args[i].equals("--quiet")) {
                        script = false;
                        continue;
                    }
                    if (args[i].equals("--drop")) {
                        drop = true;
                        continue;
                    }
                    if (args[i].equals("--text")) {
                        export = false;
                        continue;
                    }
                    if (args[i].startsWith("--output=")) {
                        outFile = args[i].substring(9);
                        continue;
                    }
                    if (args[i].startsWith("--properties=")) {
                        propFile = args[i].substring(13);
                        continue;
                    }
                    if (args[i].equals("--format")) {
                        formatSQL = true;
                        continue;
                    }
                    if (args[i].startsWith("--delimiter=")) {
                        delim = args[i].substring(12);
                        continue;
                    }
                    if (args[i].startsWith("--config=")) {
                        cfg.configure(args[i].substring(9));
                        continue;
                    }
                    if (!args[i].startsWith("--naming=")) continue;
                    cfg.setNamingStrategy((NamingStrategy)ReflectHelper.classForName(args[i].substring(9)).newInstance());
                    continue;
                }
                String filename = args[i];
                if (filename.endsWith(".jar")) {
                    cfg.addJar(filename);
                    continue;
                }
                cfg.addFile(filename);
            }
            if (propFile != null) {
                Properties props = new Properties();
                props.load(new FileInputStream(propFile));
                new SchemaExport(cfg, props).setOutputFile(outFile).setDelimiter(delim).execute(script, export, drop, formatSQL);
            } else {
                new SchemaExport(cfg).setOutputFile(outFile).setDelimiter(delim).execute(script, export, drop, formatSQL);
            }
        }
        catch (Exception e) {
            log.error("Error creating schema ", e);
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

