/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.hbm2java;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hibernate.tool.hbm2java.AbstractRenderer;
import net.sf.hibernate.tool.hbm2java.ClassMapping;
import net.sf.hibernate.tool.hbm2java.ClassName;
import net.sf.hibernate.tool.hbm2java.FieldProperty;
import net.sf.hibernate.tool.hbm2java.JavaTool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicRenderer
extends AbstractRenderer {
    protected static final int ORDINARY = 0;
    protected static final int BOUND = 1;
    protected static final int CONSTRAINT = 3;
    private static Log log = LogFactory.getLog(class$net$sf$hibernate$tool$hbm2java$BasicRenderer == null ? (class$net$sf$hibernate$tool$hbm2java$BasicRenderer = BasicRenderer.class$("net.sf.hibernate.tool.hbm2java.BasicRenderer")) : class$net$sf$hibernate$tool$hbm2java$BasicRenderer);
    JavaTool javaTool = new JavaTool();
    static Map primitiveToObject = new HashMap();
    static /* synthetic */ Class class$net$sf$hibernate$tool$hbm2java$BasicRenderer;
    static /* synthetic */ Class class$java$io$Serializable;

    public BasicRenderer() {
        primitiveToObject.put("char", "Character");
        primitiveToObject.put("byte", "Byte");
        primitiveToObject.put("short", "Short");
        primitiveToObject.put("int", "Integer");
        primitiveToObject.put("long", "Long");
        primitiveToObject.put("boolean", "Boolean");
        primitiveToObject.put("float", "Float");
        primitiveToObject.put("double", "Double");
    }

    public void render(String savedToPackage, String savedToClass, ClassMapping classMapping, Map class2classmap, PrintWriter mainwriter) throws Exception {
        this.genPackageDelaration(savedToPackage, classMapping, mainwriter);
        mainwriter.println();
        StringWriter strWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(strWriter);
        if (classMapping.getMeta("class-description") == null) {
            writer.println("/** @author Hibernate CodeGenerator */");
        } else {
            writer.println("/** \n" + this.javaTool.toJavaDoc(classMapping.getMetaAsString("class-description"), 0) + "*/");
        }
        String classScope = classMapping.getScope();
        String declarationType = classMapping.getDeclarationType();
        classMapping.addImport(class$java$io$Serializable == null ? (class$java$io$Serializable = BasicRenderer.class$("java.io.Serializable")) : class$java$io$Serializable);
        if (classMapping.shouldBeAbstract() && classScope.indexOf("abstract") == -1) {
            writer.print("abstract " + classScope + " " + declarationType + " " + savedToClass);
        } else {
            writer.print(classScope + " " + declarationType + " " + savedToClass);
        }
        if (this.generateConcreteEmptyClasses()) {
            writer.print(" extends " + this.getProperty("baseclass-prefix", "Base") + classMapping.getName());
        } else if (this.javaTool.hasExtends(classMapping)) {
            writer.print(" extends " + this.javaTool.getExtends(classMapping));
        }
        if (this.javaTool.hasImplements(classMapping)) {
            writer.print(" implements " + this.javaTool.getImplements(classMapping));
        }
        writer.println(" {");
        writer.println();
        StringWriter strPropWriter = new StringWriter();
        PrintWriter propWriter = new PrintWriter(strPropWriter);
        String vetoSupport = null;
        String changeSupport = null;
        int fieldTypes = 0;
        if (!this.generateConcreteEmptyClasses()) {
            if (!classMapping.isInterface()) {
                this.doFields(classMapping, class2classmap, propWriter);
                this.doConstructors(savedToClass, classMapping, class2classmap, propWriter);
            }
            vetoSupport = this.makeSupportField("vetos", classMapping.getAllFields());
            changeSupport = this.makeSupportField("changes", classMapping.getAllFields());
            fieldTypes = this.doFieldAccessors(classMapping, class2classmap, propWriter, vetoSupport, changeSupport);
            if (!classMapping.isInterface()) {
                this.doSupportMethods(fieldTypes, vetoSupport, changeSupport, propWriter);
                this.doToString(classMapping, propWriter);
                this.doEqualsAndHashCode(savedToClass, classMapping, propWriter);
            }
            if (classMapping.getMeta("class-code") != null) {
                propWriter.println("// The following is extra code specified in the hbm.xml files");
                List extras = classMapping.getMeta("class-code");
                Iterator iter = extras.iterator();
                while (iter.hasNext()) {
                    String code = iter.next().toString();
                    propWriter.println(code);
                }
                propWriter.println("// end of extra code specified in the hbm.xml files");
            }
        } else {
            this.doConstructors(savedToClass, classMapping, class2classmap, propWriter);
        }
        propWriter.println("}");
        if (!classMapping.isInterface() && this.generateConcreteEmptyClasses()) {
            this.doSupports(fieldTypes, classMapping, vetoSupport, changeSupport, writer);
        }
        writer.print(strPropWriter.toString());
        this.doImports(classMapping, mainwriter);
        mainwriter.print(strWriter.toString());
    }

    private String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    private void doSupportMethods(int fieldTypes, String vetoSupport, String changeSupport, PrintWriter writer) {
        if ((fieldTypes & 3) == 3) {
            writer.println("    public void addVetoableChangeListener( VetoableChangeListener l ) {");
            writer.println("        " + vetoSupport + ".addVetoableChangeListener(l);");
            writer.println("    }");
            writer.println("    public void removeVetoableChangeListener( VetoableChangeListener l ) {");
            writer.println("        " + vetoSupport + ".removeVetoableChangeListener(l);");
            writer.println("    }");
            writer.println();
        }
        if ((fieldTypes & 1) == 1) {
            writer.println("    public void addPropertyChangeListener( PropertyChangeListener l ) {");
            writer.println("        " + changeSupport + ".addPropertyChangeListener(l);");
            writer.println("    }");
            writer.println("    public void removePropertyChangeListener( PropertyChangeListener l ) {");
            writer.println("        " + changeSupport + ".removePropertyChangeListener(l);");
            writer.println("    }");
            writer.println();
        }
    }

    private void doSupports(int fieldTypes, ClassMapping classMapping, String vetoSupport, String changeSupport, PrintWriter writer) {
        if ((fieldTypes & 3) == 3) {
            writer.println("    private VetoableChangeSupport " + vetoSupport + " = new VetoableChangeSupport(this);");
            classMapping.getImports().add("java.beans.VetoableChangeSupport");
            classMapping.getImports().add("java.beans.PropertyVetoException");
            classMapping.getImports().add("java.beans.VetoableChangeListener");
        }
        if ((fieldTypes & 1) == 1) {
            writer.println("    private PropertyChangeSupport " + changeSupport + " = new PropertyChangeSupport(this);");
            writer.println();
            classMapping.getImports().add("java.beans.PropertyChangeSupport");
            classMapping.getImports().add("java.beans.PropertyChangeListener");
        }
    }

    public void doConstructors(String savedToClass, ClassMapping classMapping, Map class2classmap, PrintWriter writer) {
        FieldProperty field;
        Iterator fields;
        List supersConstructorFields;
        List allFieldsForFullConstructor = classMapping.getAllFieldsForFullConstructor();
        writer.println("    /** full constructor */");
        String fullCons = "    public " + savedToClass + "(";
        fullCons = fullCons + this.javaTool.fieldsAsParameters(allFieldsForFullConstructor, classMapping, class2classmap);
        writer.println(fullCons + ") {");
        if (!this.generateConcreteEmptyClasses()) {
            supersConstructorFields = classMapping.getFieldsForSupersFullConstructor();
            if (!supersConstructorFields.isEmpty()) {
                writer.print("        super(");
                fields = supersConstructorFields.iterator();
                while (fields.hasNext()) {
                    field = (FieldProperty)fields.next();
                    writer.print(field.getFieldName());
                    if (!fields.hasNext()) continue;
                    writer.print(", ");
                }
                writer.println(");");
            }
            fields = classMapping.getLocalFieldsForFullConstructor().iterator();
            while (fields.hasNext()) {
                field = (FieldProperty)fields.next();
                if (!field.isGeneratedAsProperty()) continue;
                writer.println("        this." + field.getFieldName() + " = " + field.getFieldName() + ";");
            }
        } else {
            supersConstructorFields = classMapping.getAllFieldsForFullConstructor();
            if (!supersConstructorFields.isEmpty()) {
                writer.print("        super(");
                fields = supersConstructorFields.iterator();
                while (fields.hasNext()) {
                    field = (FieldProperty)fields.next();
                    writer.print(field.getFieldName());
                    if (!fields.hasNext()) continue;
                    writer.print(", ");
                }
                writer.println(");");
            }
        }
        writer.println("    }");
        writer.println();
        if (allFieldsForFullConstructor.size() > 0) {
            writer.println("    /** default constructor */");
            writer.println("    public " + savedToClass + "() {");
            writer.println("    }");
            writer.println();
        }
        if (allFieldsForFullConstructor.size() > 0 && classMapping.needsMinimalConstructor()) {
            Iterator fields2;
            List supersMinConstructorFields;
            List allFieldsForMinimalConstructor = classMapping.getAllFieldsForMinimalConstructor();
            writer.println("    /** minimal constructor */");
            String minCons = "    public " + savedToClass + "(";
            Iterator fields3 = allFieldsForMinimalConstructor.iterator();
            while (fields3.hasNext()) {
                FieldProperty field2 = (FieldProperty)fields3.next();
                minCons = minCons + JavaTool.shortenType(JavaTool.getTrueTypeName(field2, class2classmap), classMapping.getImports()) + " " + field2.getFieldName();
                if (!fields3.hasNext()) continue;
                minCons = minCons + ", ";
            }
            writer.println(minCons + ") {");
            if (!this.generateConcreteEmptyClasses()) {
                FieldProperty field3;
                supersMinConstructorFields = classMapping.getFieldsForSupersMinimalConstructor();
                if (!supersMinConstructorFields.isEmpty()) {
                    writer.print("      super(");
                    fields2 = supersMinConstructorFields.iterator();
                    while (fields2.hasNext()) {
                        field3 = (FieldProperty)fields2.next();
                        writer.print(field3.getFieldName());
                        if (!fields2.hasNext()) continue;
                        writer.print(", ");
                    }
                    writer.println(");");
                }
                fields2 = classMapping.getLocalFieldsForMinimalConstructor().iterator();
                while (fields2.hasNext()) {
                    field3 = (FieldProperty)fields2.next();
                    if (!field3.isGeneratedAsProperty()) continue;
                    writer.println("        this." + field3.getFieldName() + " = " + field3.getFieldName() + ";");
                }
            } else {
                supersMinConstructorFields = classMapping.getAllFieldsForMinimalConstructor();
                if (!supersMinConstructorFields.isEmpty()) {
                    writer.print("      super(");
                    fields2 = supersMinConstructorFields.iterator();
                    while (fields2.hasNext()) {
                        FieldProperty field4 = (FieldProperty)fields2.next();
                        writer.print(field4.getFieldName());
                        if (!fields2.hasNext()) continue;
                        writer.print(", ");
                    }
                    writer.println(");");
                }
            }
            writer.println("    }");
            writer.println();
        }
    }

    private boolean generateConcreteEmptyClasses() {
        return this.isPropertySet("generate-concrete-empty-classes");
    }

    public void doFields(ClassMapping classMapping, Map class2classmap, PrintWriter writer) {
        if (!classMapping.isInterface() && classMapping.isSuperInterface()) {
            this.doFields(classMapping.getAllFields(), classMapping.getImports(), class2classmap, writer);
        }
        List fieldList = classMapping.getFields();
        Set imports = classMapping.getImports();
        this.doFields(fieldList, imports, class2classmap, writer);
    }

    private void doFields(List fieldList, Set imports, Map class2classmap, PrintWriter writer) {
        Iterator fields = fieldList.iterator();
        while (fields.hasNext()) {
            FieldProperty field = (FieldProperty)fields.next();
            if (field.isGeneratedAsProperty()) {
                String fieldScope = this.getFieldScope(field, "scope-field", "private");
                writer.println("    /** " + (field.isNullable() && !field.isIdentifier() ? "nullable " : "") + (field.isIdentifier() ? "identifier" : "persistent") + " field */");
                writer.print("    " + fieldScope + " " + JavaTool.shortenType(JavaTool.getTrueTypeName(field, class2classmap), imports) + ' ' + field.getFieldName());
                if (field.getMeta("default-value") != null) {
                    writer.print(" = " + field.getMetaAsString("default-value"));
                }
                writer.println(';');
            }
            writer.println();
        }
    }

    public void doEqualsAndHashCode(String savedToClass, ClassMapping classMapping, PrintWriter writer) {
        if (classMapping.getSuperClassMapping() != null) {
            Iterator fields = classMapping.getFields().iterator();
            while (fields.hasNext()) {
                FieldProperty field = (FieldProperty)fields.next();
                if (!field.getMetaAsBool("use-in-equals")) continue;
                log.warn("use-in-equals for property " + field.getFieldName() + " in " + classMapping.getName() + " will be ignored since it is in a subclass.  \"There is simply no way to extend an instantiable class and add an aspect while preserving the equals() contract\" -- Bloch.");
            }
        } else if (classMapping.mustImplementEquals()) {
            FieldProperty field;
            classMapping.getImports().add("org.apache.commons.lang.builder.EqualsBuilder");
            classMapping.getImports().add("org.apache.commons.lang.builder.HashCodeBuilder");
            writer.println("    public boolean equals(Object other) {");
            writer.println("        if ( (this == other ) ) return true;");
            writer.println("        if ( !(other instanceof " + savedToClass + ") ) return false;");
            writer.println("        " + savedToClass + " castOther = (" + savedToClass + ") other;");
            writer.println("        return new EqualsBuilder()");
            int usedFields = 0;
            ArrayList<FieldProperty> idFields = new ArrayList<FieldProperty>();
            Iterator fields = classMapping.getAllFields().iterator();
            while (fields.hasNext()) {
                field = (FieldProperty)fields.next();
                if (field.getMetaAsBool("use-in-equals")) {
                    writer.println("            .append(this." + field.getGetterSignature() + ", castOther." + field.getGetterSignature() + ")");
                    ++usedFields;
                }
                if (!field.isIdentifier()) continue;
                idFields.add(field);
            }
            if (usedFields == 0) {
                log.warn("No properties has been marked as being used in equals/hashcode for " + classMapping.getName() + ". Using object identifier which is RARELY safe to use! See http://hibernate.org/109.html");
                fields = idFields.iterator();
                while (fields.hasNext()) {
                    field = (FieldProperty)fields.next();
                    writer.println("            .append(this." + field.getGetterSignature() + ", castOther." + field.getGetterSignature() + ")");
                }
            }
            writer.println("            .isEquals();");
            writer.println("    }");
            writer.println();
            writer.println("    public int hashCode() {");
            writer.println("        return new HashCodeBuilder()");
            fields = classMapping.getAllFields().iterator();
            while (fields.hasNext()) {
                field = (FieldProperty)fields.next();
                if (!field.getMetaAsBool("use-in-equals")) continue;
                writer.println("            .append(" + field.getGetterSignature() + ")");
            }
            if (usedFields == 0) {
                fields = idFields.iterator();
                while (fields.hasNext()) {
                    field = (FieldProperty)fields.next();
                    writer.println("            .append(" + field.getGetterSignature() + ")");
                }
            }
            writer.println("            .toHashCode();");
            writer.println("    }");
            writer.println();
        }
    }

    public void doToString(ClassMapping classMapping, PrintWriter writer) {
        classMapping.addImport("org.apache.commons.lang.builder.ToStringBuilder");
        writer.println("    public String toString() {");
        writer.println("        return new ToStringBuilder(this)");
        Iterator fields = classMapping.getAllFields().iterator();
        while (fields.hasNext()) {
            FieldProperty field = (FieldProperty)fields.next();
            if (field.isIdentifier() && field.getMeta("use-in-tostring") == null) {
                writer.println("            .append(\"" + field.getFieldName() + "\", " + field.getGetterSignature() + ")");
                continue;
            }
            if (!field.getMetaAsBool("use-in-tostring")) continue;
            writer.println("            .append(\"" + field.getFieldName() + "\", " + field.getGetterSignature() + ")");
        }
        writer.println("            .toString();");
        writer.println("    }");
        writer.println();
    }

    public int doFieldAccessors(ClassMapping classMapping, Map class2classmap, PrintWriter writer, String vetoSupport, String changeSupport) {
        int fieldTypes = 0;
        if (classMapping.isSuperInterface()) {
            fieldTypes = this.doFields(classMapping, class2classmap, writer, vetoSupport, changeSupport, fieldTypes, classMapping.getAllFields());
        }
        List fieldz = classMapping.getFields();
        fieldTypes = this.doFields(classMapping, class2classmap, writer, vetoSupport, changeSupport, fieldTypes, fieldz);
        return fieldTypes;
    }

    private int doFields(ClassMapping classMapping, Map class2classmap, PrintWriter writer, String vetoSupport, String changeSupport, int fieldTypes, List fieldz) {
        Iterator fields = fieldz.iterator();
        while (fields.hasNext()) {
            FieldProperty field = (FieldProperty)fields.next();
            if (!field.isGeneratedAsProperty()) continue;
            String getAccessScope = this.getFieldScope(field, "scope-get", "public");
            if (field.getMeta("field-description") != null) {
                writer.println("    /** \n" + this.javaTool.toJavaDoc(field.getMetaAsString("field-description"), 4) + "     */");
            }
            writer.print("    " + getAccessScope + " " + JavaTool.shortenType(JavaTool.getTrueTypeName(field, class2classmap), classMapping.getImports()) + " " + field.getGetterSignature());
            if (classMapping.isInterface()) {
                writer.println(";");
            } else {
                writer.println(" {");
                writer.println("        return this." + field.getFieldName() + ";");
                writer.println("    }");
            }
            writer.println();
            int fieldType = 0;
            if (field.getMeta("beans-property-type") != null) {
                String beansPropertyType = field.getMetaAsString("beans-property-type").trim().toLowerCase();
                if (beansPropertyType.equals("constraint")) {
                    fieldTypes |= 3;
                    fieldType = 3;
                } else if (beansPropertyType.equals("bound")) {
                    fieldTypes |= 1;
                    fieldType = 1;
                }
            }
            String setAccessScope = this.getFieldScope(field, "scope-set", "public");
            writer.print("    " + setAccessScope + " void set" + field.getAccessorName() + "(" + JavaTool.shortenType(JavaTool.getTrueTypeName(field, class2classmap), classMapping.getImports()) + " " + field.getFieldName() + ")");
            writer.print((fieldType & 3) == 3 ? " throws PropertyVetoException " : "");
            if (classMapping.isInterface()) {
                writer.println(";");
            } else {
                writer.println(" {");
                if ((fieldType & 3) == 3 || (fieldType & 1) == 1) {
                    writer.println("        Object oldValue = " + this.getFieldAsObject(true, field) + ";");
                }
                if ((fieldType & 3) == 3) {
                    writer.println("        " + vetoSupport + ".fireVetoableChange(\"" + field.getFieldName() + "\",");
                    writer.println("                oldValue,");
                    writer.println("                " + this.getFieldAsObject(false, field) + ");");
                }
                writer.println("        this." + field.getFieldName() + " = " + field.getFieldName() + ";");
                if ((fieldType & 1) == 1) {
                    writer.println("        " + changeSupport + ".firePropertyChange(\"" + field.getFieldName() + "\",");
                    writer.println("                oldValue,");
                    writer.println("                " + this.getFieldAsObject(false, field) + ");");
                }
                writer.println("    }");
            }
            writer.println();
        }
        return fieldTypes;
    }

    public void doImports(ClassMapping classMapping, PrintWriter writer) {
        writer.println(this.javaTool.genImports(classMapping));
        writer.println();
    }

    protected String makeSupportField(String fieldName, List fieldList) {
        String suffix = "";
        boolean needSuffix = false;
        Iterator fields = fieldList.iterator();
        while (fields.hasNext()) {
            String name = ((FieldProperty)fields.next()).getFieldName();
            if (name.equals(fieldName)) {
                needSuffix = true;
            }
            suffix = suffix + name;
        }
        return needSuffix ? fieldName + "_" + suffix : fieldName;
    }

    private String getFieldAsObject(boolean prependThis, FieldProperty field) {
        ClassName type = field.getClassType();
        if (type != null && type.isPrimitive() && !type.isArray()) {
            String typeName = (String)primitiveToObject.get(type.getName());
            typeName = "new " + typeName + "( ";
            typeName = typeName + (prependThis ? "this." : "");
            return typeName + field.getFieldName() + " )";
        }
        return (prependThis ? "this." : "") + field.getFieldName();
    }

    boolean isPropertySet(String key) {
        String val = this.properties.getProperty(key);
        return Boolean.valueOf(val);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

