/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.hbm2java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.hibernate.CompositeUserType;
import net.sf.hibernate.UserType;
import net.sf.hibernate.tool.hbm2java.ClassName;
import net.sf.hibernate.tool.hbm2java.FieldProperty;
import net.sf.hibernate.tool.hbm2java.MappingElement;
import net.sf.hibernate.tool.hbm2java.MetaAttributeHelper;
import net.sf.hibernate.type.PrimitiveType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.type.TypeFactory;
import net.sf.hibernate.util.ReflectHelper;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Attribute;
import org.jdom.Element;

public class ClassMapping
extends MappingElement {
    private static Log log = LogFactory.getLog(class$net$sf$hibernate$tool$hbm2java$ClassMapping == null ? (class$net$sf$hibernate$tool$hbm2java$ClassMapping = ClassMapping.class$("net.sf.hibernate.tool.hbm2java.ClassMapping")) : class$net$sf$hibernate$tool$hbm2java$ClassMapping);
    private ClassName name = null;
    private ClassName generatedName = null;
    private String superClass = null;
    private ClassMapping superClassMapping = null;
    private String proxyClass = null;
    private List fields = new ArrayList();
    private TreeSet imports = new TreeSet();
    private List subclasses = new ArrayList();
    private static final Map components = new HashMap();
    private boolean mustImplementEquals = false;
    private boolean shouldBeAbstract = false;
    static /* synthetic */ Class class$net$sf$hibernate$tool$hbm2java$ClassMapping;
    static /* synthetic */ Class class$java$util$SortedMap;
    static /* synthetic */ Class class$java$util$TreeMap;
    static /* synthetic */ Class class$java$util$SortedSet;
    static /* synthetic */ Class class$java$util$TreeSet;
    static /* synthetic */ Class class$net$sf$hibernate$UserType;
    static /* synthetic */ Class class$net$sf$hibernate$CompositeUserType;

    public ClassMapping(String classPackage, MappingElement parentElement, ClassName superClass, ClassMapping superClassMapping, Element classElement, MultiMap inheritedMeta) {
        this(classPackage, parentElement, superClass, classElement, inheritedMeta);
        this.superClassMapping = superClassMapping;
        if (this.superClassMapping != null) {
            List l = this.superClassMapping.getAllFieldsForFullConstructor();
            Iterator iter = l.iterator();
            while (iter.hasNext()) {
                FieldProperty element = (FieldProperty)iter.next();
                ClassName ct = element.getClassType();
                if (ct != null) {
                    this.addImport(ct);
                    continue;
                }
                this.addImport(element.getFullyQualifiedTypeName());
            }
        }
    }

    public ClassMapping(String classPackage, MappingElement parentElement, ClassName superClass, Element classElement, MultiMap inheritedMeta) {
        super(classElement, parentElement);
        this.initWith(classPackage, superClass, classElement, false, inheritedMeta);
    }

    public ClassMapping(String classPackage, Element classElement, MappingElement parentElement, MultiMap inheritedMeta) {
        super(classElement, parentElement);
        this.initWith(classPackage, null, classElement, false, inheritedMeta);
    }

    public ClassMapping(String classPackage, Element classElement, MappingElement parentElement, boolean component, MultiMap inheritedMeta) {
        super(classElement, parentElement);
        this.initWith(classPackage, null, classElement, component, inheritedMeta);
    }

    protected void initWith(String classPackage, ClassName mySuperClass, Element classElement, boolean component, MultiMap inheritedMeta) {
        ClassMapping subclassMapping;
        Element subclass;
        String propertyName;
        Element cmpid;
        Element id;
        String fullyQualifiedName = classElement.getAttributeValue(component ? "class" : "name");
        if (fullyQualifiedName.indexOf(46) < 0 && classPackage != null && classPackage.trim().length() > 0) {
            fullyQualifiedName = classPackage + "." + fullyQualifiedName;
        }
        log.debug("Processing mapping for class: " + fullyQualifiedName);
        this.setMetaAttribs(MetaAttributeHelper.loadAndMergeMetaMap(classElement, inheritedMeta));
        this.name = new ClassName(fullyQualifiedName);
        if (this.getMeta("generated-class") != null) {
            this.generatedName = new ClassName(this.getMetaAsString("generated-class").trim());
            this.shouldBeAbstract = true;
            log.warn("Generating " + this.generatedName + " instead of " + this.name);
        } else {
            this.generatedName = this.name;
        }
        if (mySuperClass != null) {
            this.superClass = mySuperClass.getName();
            this.addImport(mySuperClass);
        }
        ArrayList<Element> propertyList = new ArrayList<Element>();
        propertyList.addAll(classElement.getChildren("property"));
        propertyList.addAll(classElement.getChildren("version"));
        propertyList.addAll(classElement.getChildren("timestamp"));
        propertyList.addAll(classElement.getChildren("key-property"));
        propertyList.addAll(classElement.getChildren("any"));
        propertyList.addAll(classElement.getChildren("parent"));
        ArrayList manyToOneList = new ArrayList();
        manyToOneList.addAll(classElement.getChildren("many-to-one"));
        manyToOneList.addAll(classElement.getChildren("key-many-to-one"));
        Attribute att = classElement.getAttribute("proxy");
        if (att != null) {
            this.proxyClass = att.getValue();
        }
        if ((id = classElement.getChild("id")) != null) {
            propertyList.add(0, id);
        }
        if ((cmpid = classElement.getChild("composite-id")) != null) {
            this.implementEquals();
            String cmpname = cmpid.getAttributeValue("name");
            String cmpclass = cmpid.getAttributeValue("class");
            if (cmpclass == null || cmpclass.equals("")) {
                propertyList.addAll(0, cmpid.getChildren("key-property"));
                manyToOneList.addAll(0, cmpid.getChildren("key-many-to-one"));
            } else {
                ClassMapping mapping = new ClassMapping(classPackage, cmpid, this, true, this.getMetaAttribs());
                MultiMap metaForCompositeid = MetaAttributeHelper.loadAndMergeMetaMap(cmpid, this.getMetaAttribs());
                mapping.implementEquals();
                ClassName classType = new ClassName(cmpclass);
                this.addImport(classType);
                FieldProperty cmpidfield = new FieldProperty(cmpid, this, cmpname, classType, false, true, false, metaForCompositeid);
                this.addFieldProperty(cmpidfield);
                components.put(mapping.getFullyQualifiedName(), mapping);
            }
        }
        if (this.getMetaAsBool("implement-equals")) {
            this.implementEquals();
        }
        Iterator properties = propertyList.iterator();
        while (properties.hasNext()) {
            Element column;
            Element propertyElement = (Element)properties.next();
            MultiMap metaForProperty = MetaAttributeHelper.loadAndMergeMetaMap(propertyElement, this.getMetaAttribs());
            String propertyName2 = propertyElement.getAttributeValue("name");
            if (propertyName2 == null || propertyName2.trim().equals("")) continue;
            String type = propertyElement.getAttributeValue("type");
            if (type == null && cmpid != null) {
                type = propertyElement.getAttributeValue("class");
            }
            if ("timestamp".equals(propertyElement.getName())) {
                type = "java.util.Date";
            }
            if ("any".equals(propertyElement.getName())) {
                type = "java.lang.Object";
            }
            if ("parent".equals(propertyElement.getName())) {
                type = ((ClassMapping)this.getParentElement()).getFullyQualifiedName();
            }
            if (type == null || type.trim().equals("")) {
                log.warn("property \"" + propertyName2 + "\" in class " + this.getName() + " is missing a type attribute");
                continue;
            }
            if (propertyElement == id) {
                Element generator = propertyElement.getChild("generator");
                String unsavedValue = propertyElement.getAttributeValue("unsaved-value");
                boolean mustBeNullable = unsavedValue != null && unsavedValue.equals("null");
                boolean generated = !generator.getAttributeValue("class").equals("assigned");
                ClassName rtype = this.getFieldType(type, mustBeNullable, false);
                this.addImport(rtype);
                FieldProperty idField = new FieldProperty(propertyElement, this, propertyName2, rtype, false, true, generated, metaForProperty);
                this.addFieldProperty(idField);
                continue;
            }
            String notnull = propertyElement.getAttributeValue("not-null");
            if (notnull == null && (column = propertyElement.getChild("column")) != null) {
                notnull = column.getAttributeValue("not-null");
            }
            boolean nullable = notnull == null || notnull.equals("false");
            boolean key = propertyElement.getName().startsWith("key-");
            ClassName t = this.getFieldType(type);
            this.addImport(t);
            FieldProperty stdField = new FieldProperty(propertyElement, this, propertyName2, t, nullable && !key, key, false, metaForProperty);
            this.addFieldProperty(stdField);
        }
        List onetooneList = classElement.getChildren("one-to-one");
        Iterator onetoones = onetooneList.iterator();
        while (onetoones.hasNext()) {
            Element onetoone = (Element)onetoones.next();
            MultiMap metaForOneToOne = MetaAttributeHelper.loadAndMergeMetaMap(onetoone, this.getMetaAttribs());
            propertyName = onetoone.getAttributeValue("name");
            String clazz = onetoone.getAttributeValue("class");
            if (StringUtils.isEmpty(clazz)) {
                log.warn("one-to-one \"" + this.name + "\" in class " + this.getName() + " is missing a class attribute");
                continue;
            }
            ClassName cn = this.getFieldType(clazz);
            this.addImport(cn);
            FieldProperty fm = new FieldProperty(onetoone, this, propertyName, cn, true, metaForOneToOne);
            this.addFieldProperty(fm);
        }
        Iterator manytoOnes = manyToOneList.iterator();
        while (manytoOnes.hasNext()) {
            Element manyToOne = (Element)manytoOnes.next();
            MultiMap metaForManyToOne = MetaAttributeHelper.loadAndMergeMetaMap(manyToOne, this.getMetaAttribs());
            propertyName = manyToOne.getAttributeValue("name");
            String type = manyToOne.getAttributeValue("class");
            if (StringUtils.isEmpty(type)) {
                log.warn("many-to-one \"" + propertyName + "\" in class " + this.getName() + " is missing a class attribute");
                continue;
            }
            ClassName classType = new ClassName(type);
            String notnull = manyToOne.getAttributeValue("not-null");
            boolean nullable = notnull == null || notnull.equals("false");
            boolean key = manyToOne.getName().startsWith("key-");
            this.addImport(classType);
            FieldProperty f = new FieldProperty(manyToOne, this, propertyName, classType, nullable && !key, key, false, metaForManyToOne);
            this.addFieldProperty(f);
        }
        this.doCollections(classPackage, classElement, "list", "java.util.List", "java.util.ArrayList", this.getMetaAttribs());
        this.doCollections(classPackage, classElement, "map", "java.util.Map", "java.util.HashMap", this.getMetaAttribs());
        this.doCollections(classPackage, classElement, "set", "java.util.Set", "java.util.HashSet", this.getMetaAttribs());
        this.doCollections(classPackage, classElement, "bag", System.getProperty("hbm2java.bag.interface", "java.util.List"), "java.util.ArrayList", this.getMetaAttribs());
        this.doCollections(classPackage, classElement, "idbag", System.getProperty("hbm2java.idbag.interface", "java.util.List"), "java.util.ArrayList", this.getMetaAttribs());
        this.doArrays(classElement, "array", this.getMetaAttribs());
        this.doArrays(classElement, "primitive-array", this.getMetaAttribs());
        Iterator iter = classElement.getChildren("component").iterator();
        while (iter.hasNext()) {
            Element cmpe = (Element)iter.next();
            MultiMap metaForComponent = MetaAttributeHelper.loadAndMergeMetaMap(cmpe, this.getMetaAttribs());
            String cmpname = cmpe.getAttributeValue("name");
            String cmpclass = cmpe.getAttributeValue("class");
            if (cmpclass == null || cmpclass.equals("")) {
                log.warn("component \"" + cmpname + "\" in class " + this.getName() + " does not specify a class");
                continue;
            }
            ClassMapping mapping = new ClassMapping(classPackage, cmpe, this, true, this.getMetaAttribs());
            ClassName classType = new ClassName(cmpclass);
            this.addImport(classType);
            FieldProperty ff = new FieldProperty(cmpe, this, cmpname, classType, false, metaForComponent);
            this.addFieldProperty(ff);
            components.put(mapping.getFullyQualifiedName(), mapping);
        }
        iter = classElement.getChildren("subclass").iterator();
        while (iter.hasNext()) {
            subclass = (Element)iter.next();
            subclassMapping = new ClassMapping(classPackage, this, this.name, this, subclass, this.getMetaAttribs());
            this.addSubClass(subclassMapping);
        }
        iter = classElement.getChildren("joined-subclass").iterator();
        while (iter.hasNext()) {
            subclass = (Element)iter.next();
            subclassMapping = new ClassMapping(classPackage, this, this.name, this, subclass, this.getMetaAttribs());
            this.addSubClass(subclassMapping);
        }
        this.validateMetaAttribs();
    }

    private void addFieldProperty(FieldProperty fieldProperty) {
        if (fieldProperty.getParentClass() != null) {
            throw new IllegalStateException("Field " + fieldProperty + " is already associated with a class: " + fieldProperty.getParentClass());
        }
        this.fields.add(fieldProperty);
    }

    public void implementEquals() {
        this.mustImplementEquals = true;
    }

    public boolean mustImplementEquals() {
        return !this.isInterface() && this.mustImplementEquals;
    }

    public List getFields() {
        return this.fields;
    }

    public Set getImports() {
        return this.imports;
    }

    public String getFullyQualifiedName() {
        return this.getClassName().getFullyQualifiedName();
    }

    public String getName() {
        return this.getClassName().getName();
    }

    public String getPackageName() {
        return this.getClassName().getPackageName();
    }

    public ClassName getClassName() {
        return this.name;
    }

    public String getGeneratedName() {
        return this.generatedName.getName();
    }

    public String getGeneratedPackageName() {
        return this.generatedName.getPackageName();
    }

    public String getProxy() {
        return this.proxyClass;
    }

    public List getSubclasses() {
        return this.subclasses;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public boolean needsMinimalConstructor() {
        return this.getAllFieldsForFullConstructor().size() != this.getAllFieldsForMinimalConstructor().size() && this.getAllFieldsForMinimalConstructor().size() > 0;
    }

    public List getLocalFieldsForFullConstructor() {
        ArrayList<FieldProperty> result = new ArrayList<FieldProperty>();
        Iterator myFields = this.getFields().iterator();
        while (myFields.hasNext()) {
            FieldProperty field = (FieldProperty)myFields.next();
            if (field.isIdentifier() && (!field.isIdentifier() || field.isGenerated())) continue;
            result.add(field);
        }
        return result;
    }

    public List getFieldsForSupersFullConstructor() {
        ArrayList result = new ArrayList();
        if (this.getSuperClassMapping() != null) {
            result.addAll(this.getSuperClassMapping().getFieldsForSupersFullConstructor());
            result.addAll(this.getSuperClassMapping().getLocalFieldsForFullConstructor());
        }
        return result;
    }

    public List getLocalFieldsForMinimalConstructor() {
        ArrayList<FieldProperty> result = new ArrayList<FieldProperty>();
        Iterator myFields = this.getFields().iterator();
        while (myFields.hasNext()) {
            FieldProperty field = (FieldProperty)myFields.next();
            if ((field.isIdentifier() || field.isNullable()) && (!field.isIdentifier() || field.isGenerated())) continue;
            result.add(field);
        }
        return result;
    }

    public List getAllFields() {
        ArrayList result = new ArrayList();
        if (this.getSuperClassMapping() != null) {
            result.addAll(this.getSuperClassMapping().getAllFields());
        }
        result.addAll(this.getFields());
        return result;
    }

    public List getAllFieldsForFullConstructor() {
        List result = this.getFieldsForSupersFullConstructor();
        result.addAll(this.getLocalFieldsForFullConstructor());
        return result;
    }

    public List getFieldsForSupersMinimalConstructor() {
        ArrayList result = new ArrayList();
        if (this.getSuperClassMapping() != null) {
            result.addAll(this.getSuperClassMapping().getFieldsForSupersMinimalConstructor());
            result.addAll(this.getSuperClassMapping().getLocalFieldsForMinimalConstructor());
        }
        return result;
    }

    public List getAllFieldsForMinimalConstructor() {
        List result = this.getFieldsForSupersMinimalConstructor();
        result.addAll(this.getLocalFieldsForMinimalConstructor());
        return result;
    }

    public void addImport(ClassName className) {
        if (!(className.inJavaLang() || className.inSamePackage(this.generatedName) || className.isPrimitive())) {
            if (className.isArray()) {
                this.imports.add(className.getFullyQualifiedName().substring(0, className.getFullyQualifiedName().length() - 2));
            } else {
                this.imports.add(className.getFullyQualifiedName());
            }
        }
    }

    public void addImport(String className) {
        ClassName cn = new ClassName(className);
        this.addImport(cn);
    }

    public static Iterator getComponents() {
        return components.values().iterator();
    }

    private void doCollections(String classPackage, Element classElement, String xmlName, String interfaceClass, String implementingClass, MultiMap inheritedMeta) {
        String originalInterface = interfaceClass;
        String originalImplementation = implementingClass;
        Iterator collections = classElement.getChildren(xmlName).iterator();
        while (collections.hasNext()) {
            Element collection = (Element)collections.next();
            MultiMap metaForCollection = MetaAttributeHelper.loadAndMergeMetaMap(collection, inheritedMeta);
            String propertyName = collection.getAttributeValue("name");
            String sortValue = collection.getAttributeValue("sort");
            if (sortValue != null && !"unsorted".equals(sortValue) && !"".equals(sortValue.trim())) {
                if ("map".equals(xmlName)) {
                    interfaceClass = (class$java$util$SortedMap == null ? ClassMapping.class$("java.util.SortedMap") : class$java$util$SortedMap).getName();
                    implementingClass = (class$java$util$TreeMap == null ? ClassMapping.class$("java.util.TreeMap") : class$java$util$TreeMap).getName();
                } else if ("set".equals(xmlName)) {
                    interfaceClass = (class$java$util$SortedSet == null ? ClassMapping.class$("java.util.SortedSet") : class$java$util$SortedSet).getName();
                    implementingClass = (class$java$util$TreeSet == null ? ClassMapping.class$("java.util.TreeSet") : class$java$util$TreeSet).getName();
                }
            } else {
                interfaceClass = originalInterface;
                implementingClass = originalImplementation;
            }
            ClassName interfaceClassName = new ClassName(interfaceClass);
            ClassName implementationClassName = new ClassName(implementingClass);
            this.addImport(interfaceClassName);
            ClassName foreignClass = null;
            HashSet<String> foreignKeys = null;
            if (collection.getChildren("one-to-many").size() != 0) {
                foreignClass = new ClassName(collection.getChild("one-to-many").getAttributeValue("class"));
            } else if (collection.getChildren("many-to-many").size() != 0) {
                foreignClass = new ClassName(collection.getChild("many-to-many").getAttributeValue("class"));
            }
            if (foreignClass != null) {
                foreignKeys = new HashSet<String>();
                foreignKeys.add(collection.getChild("key").getAttributeValue("column"));
                Iterator iter = collection.getChild("key").getChildren("column").iterator();
                while (iter.hasNext()) {
                    foreignKeys.add(((Element)iter.next()).getAttributeValue("name"));
                }
            }
            FieldProperty cf = new FieldProperty(collection, this, propertyName, interfaceClassName, implementationClassName, false, foreignClass, foreignKeys, metaForCollection);
            this.addFieldProperty(cf);
            if (collection.getChildren("composite-element") == null) continue;
            Iterator compositeElements = collection.getChildren("composite-element").iterator();
            while (compositeElements.hasNext()) {
                Element compositeElement = (Element)compositeElements.next();
                String compClass = compositeElement.getAttributeValue("class");
                try {
                    ClassMapping mapping = new ClassMapping(classPackage, compositeElement, this, true, this.getMetaAttribs());
                    ClassName classType = new ClassName(compClass);
                    this.addImport(classType);
                    components.put(mapping.getFullyQualifiedName(), mapping);
                }
                catch (Exception e) {
                    log.error("Error building composite-element " + compClass, e);
                }
            }
        }
    }

    private void doArrays(Element classElement, String type, MultiMap inheritedMeta) {
        Iterator arrays = classElement.getChildren(type).iterator();
        while (arrays.hasNext()) {
            Element array = (Element)arrays.next();
            MultiMap metaForArray = MetaAttributeHelper.loadAndMergeMetaMap(array, inheritedMeta);
            String role = array.getAttributeValue("name");
            String elementClass = array.getAttributeValue("element-class");
            if (elementClass == null) {
                Element elt = array.getChild("element");
                if (elt == null) {
                    elt = array.getChild("one-to-many");
                }
                if (elt == null) {
                    elt = array.getChild("many-to-many");
                }
                if (elt == null) {
                    elt = array.getChild("composite-element");
                }
                if (elt == null) {
                    log.warn("skipping collection with subcollections");
                    continue;
                }
                elementClass = elt.getAttributeValue("type");
                if (elementClass == null) {
                    elementClass = elt.getAttributeValue("class");
                }
            }
            ClassName cn = this.getFieldType(elementClass, false, true);
            this.addImport(cn);
            FieldProperty af = new FieldProperty(array, this, role, cn, false, metaForArray);
            this.addFieldProperty(af);
        }
    }

    private ClassName getFieldType(String hibernateType) {
        return this.getFieldType(hibernateType, false, false);
    }

    private ClassName getFieldType(String hibernateType, boolean mustBeNullable, boolean isArray) {
        String postfix = isArray ? "[]" : "";
        ClassName cn = null;
        if (hibernateType.equals("binary")) {
            cn = new ClassName("byte[]" + postfix);
            return cn;
        }
        Type basicType = TypeFactory.basic(hibernateType);
        if (basicType != null) {
            if (basicType instanceof PrimitiveType && !hibernateType.trim().equals(basicType.getReturnedClass().getName()) && !mustBeNullable) {
                cn = new ClassName(((PrimitiveType)basicType).getPrimitiveClass().getName() + postfix);
                return cn;
            }
            cn = new ClassName(basicType.getReturnedClass().getName() + postfix);
            return cn;
        }
        hibernateType = this.getTypeForUserType(hibernateType);
        cn = new ClassName(hibernateType + postfix);
        this.addImport(cn);
        return cn;
    }

    private String getTypeForUserType(String type) {
        Class clazz = null;
        try {
            clazz = ReflectHelper.classForName(type);
            if ((class$net$sf$hibernate$UserType == null ? (class$net$sf$hibernate$UserType = ClassMapping.class$("net.sf.hibernate.UserType")) : class$net$sf$hibernate$UserType).isAssignableFrom(clazz)) {
                UserType ut = (UserType)clazz.newInstance();
                log.debug("Resolved usertype: " + type + " to " + ut.returnedClass().getName());
                String t = this.clazzToName(ut.returnedClass());
                return t;
            }
            if ((class$net$sf$hibernate$CompositeUserType == null ? (class$net$sf$hibernate$CompositeUserType = ClassMapping.class$("net.sf.hibernate.CompositeUserType")) : class$net$sf$hibernate$CompositeUserType).isAssignableFrom(clazz)) {
                CompositeUserType ut = (CompositeUserType)clazz.newInstance();
                log.debug("Resolved composite usertype: " + type + " to " + ut.returnedClass().getName());
                String t = this.clazzToName(ut.returnedClass());
                return t;
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("Could not find UserType: " + type + ". Using the type '" + type + "' directly instead. (" + e.toString() + ")");
        }
        catch (IllegalAccessException iae) {
            log.warn("Error while trying to resolve UserType. Using the type '" + type + "' directly instead. (" + iae.toString() + ")");
        }
        catch (InstantiationException e) {
            log.warn("Error while trying to resolve UserType. Using the type '" + type + "' directly instead. (" + e.toString() + ")");
        }
        return type;
    }

    private String clazzToName(Class cl) {
        String s = null;
        s = cl.isArray() ? this.clazzToName(cl.getComponentType()) + "[]" : cl.getName();
        return s;
    }

    public ClassMapping getSuperClassMapping() {
        return this.superClassMapping;
    }

    public boolean shouldBeAbstract() {
        return this.shouldBeAbstract;
    }

    void validateMetaAttribs() {
        if (this.getSuperClass() != null && this.getMeta("extends") != null) {
            log.warn("Warning: meta attribute extends='" + this.getMetaAsString("extends") + "' will be ignored for subclass " + this.name);
        }
    }

    public String toString() {
        return "ClassMapping: " + this.name.getFullyQualifiedName();
    }

    public boolean isInterface() {
        return this.getMetaAsBool("interface");
    }

    public void addSubClass(ClassMapping subclassMapping) {
        this.subclasses.add(subclassMapping);
    }

    public String getScope() {
        String classScope = "public";
        if (this.getMeta("scope-class") != null) {
            classScope = this.getMetaAsString("scope-class").trim();
        }
        return classScope;
    }

    public String getDeclarationType() {
        if (this.isInterface()) {
            return "interface";
        }
        return "class";
    }

    public String getModifiers() {
        if (this.shouldBeAbstract() && this.getScope().indexOf("abstract") == -1) {
            return "abstract";
        }
        return "";
    }

    public void addImport(Class clazz) {
        this.addImport(clazz.getName());
    }

    public boolean isSuperInterface() {
        return this.getSuperClassMapping() == null ? false : this.getSuperClassMapping().isInterface();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

