/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.hbm2java;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.sf.hibernate.tool.hbm2java.ClassMapping;
import net.sf.hibernate.tool.hbm2java.Renderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;

public class Generator {
    private Log log = LogFactory.getLog(class$net$sf$hibernate$tool$hbm2java$Generator == null ? (class$net$sf$hibernate$tool$hbm2java$Generator = Generator.class$("net.sf.hibernate.tool.hbm2java.Generator")) : class$net$sf$hibernate$tool$hbm2java$Generator);
    private String rendererClass = "net.sf.hibernate.tool.hbm2java.BasicRenderer";
    private String baseDirName = "generated";
    private String packageName = null;
    private String suffix = "";
    private String prefix = "";
    private String extension = "java";
    private boolean lowerFirstLetter = false;
    private Properties params = new Properties();
    static /* synthetic */ Class class$net$sf$hibernate$tool$hbm2java$Generator;

    public Generator() {
    }

    public Generator(Element generateElement) throws Exception {
        String value = null;
        this.rendererClass = generateElement.getAttributeValue("renderer");
        if (this.rendererClass == null) {
            throw new Exception("attribute renderer is required.");
        }
        value = generateElement.getAttributeValue("dir");
        if (value != null) {
            this.baseDirName = value;
        }
        this.packageName = generateElement.getAttributeValue("package");
        value = generateElement.getAttributeValue("prefix");
        if (value != null) {
            this.prefix = value;
        }
        if ((value = generateElement.getAttributeValue("suffix")) != null) {
            this.suffix = value;
        }
        if ((value = generateElement.getAttributeValue("extension")) != null) {
            this.extension = value;
        }
        value = generateElement.getAttributeValue("lowerFirstLetter");
        this.lowerFirstLetter = Boolean.valueOf(value);
        this.params = new Properties();
        Iterator iter = generateElement.getChildren("param").iterator();
        while (iter.hasNext()) {
            Element childNode = (Element)iter.next();
            this.params.setProperty(childNode.getAttributeValue("name"), childNode.getText());
        }
    }

    public void generate(Map classMappingsCol) throws Exception {
        this.log.info("Generating " + classMappingsCol.size() + " in " + this.getBaseDirName());
        Renderer renderer = (Renderer)Class.forName(this.rendererClass).newInstance();
        renderer.configure(this.params);
        Iterator classMappings = classMappingsCol.values().iterator();
        while (classMappings.hasNext()) {
            ClassMapping classMapping = (ClassMapping)classMappings.next();
            this.writeRecur(classMapping, classMappingsCol, renderer);
        }
        Iterator cmpMappings = ClassMapping.getComponents();
        while (cmpMappings.hasNext()) {
            ClassMapping mapping = (ClassMapping)cmpMappings.next();
            this.write(mapping, classMappingsCol, renderer);
        }
    }

    private void writeRecur(ClassMapping classMapping, Map class2classmap, Renderer renderer) throws Exception {
        this.write(classMapping, class2classmap, renderer);
        if (!classMapping.getSubclasses().isEmpty()) {
            Iterator it = classMapping.getSubclasses().iterator();
            while (it.hasNext()) {
                this.writeRecur((ClassMapping)it.next(), class2classmap, renderer);
            }
        }
    }

    private void write(ClassMapping classMapping, Map class2classmap, Renderer renderer) throws Exception {
        String saveToPackage = renderer.getSaveToPackage(classMapping);
        String saveToClassName = renderer.getSaveToClassName(classMapping);
        File dir = this.getDir(saveToPackage);
        File file = new File(dir, this.getFileName(saveToClassName));
        this.log.debug("Writing " + file);
        PrintWriter writer = new PrintWriter(new FileOutputStream(file));
        renderer.render(this.getPackageName(saveToPackage), this.getName(saveToClassName), classMapping, class2classmap, writer);
        writer.close();
    }

    private String getFileName(String className) {
        return this.getName(className) + "." + this.extension;
    }

    private String getName(String className) {
        String name = null;
        name = this.lowerFirstLetter ? className.substring(0, 1).toLowerCase() + className.substring(1, className.length()) : className;
        return this.prefix + name + this.suffix;
    }

    private String getPackageName(String packageName) {
        if (this.packageName == null) {
            return packageName == null ? "" : packageName;
        }
        return this.packageName;
    }

    private File getDir(String packageName) throws Exception {
        File baseDir = new File(this.baseDirName);
        File dir = null;
        String p = this.getPackageName(packageName);
        dir = new File(baseDir, p.replace('.', File.separatorChar));
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new Exception("The path: " + dir.getCanonicalPath() + " exists, but is not a directory");
            }
        } else if (!dir.mkdirs()) {
            throw new Exception("unable to create directory: " + dir.getCanonicalPath());
        }
        return dir;
    }

    public String getBaseDirName() {
        return this.baseDirName;
    }

    public void setBaseDirName(String baseDirName) {
        if (baseDirName != null) {
            this.baseDirName = baseDirName;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

