/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.transaction;

import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.transaction.JDBCTransactionFactory;
import net.sf.hibernate.transaction.TransactionFactory;
import net.sf.hibernate.util.ReflectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TransactionFactoryFactory {
    private static final Log log = LogFactory.getLog(class$net$sf$hibernate$transaction$TransactionFactoryFactory == null ? (class$net$sf$hibernate$transaction$TransactionFactoryFactory = TransactionFactoryFactory.class$("net.sf.hibernate.transaction.TransactionFactoryFactory")) : class$net$sf$hibernate$transaction$TransactionFactoryFactory);
    static /* synthetic */ Class class$net$sf$hibernate$transaction$TransactionFactoryFactory;

    public static TransactionFactory buildTransactionFactory(Properties transactionProps) throws HibernateException {
        TransactionFactory factory;
        String strategyClassName = transactionProps.getProperty("hibernate.transaction.factory_class");
        if (strategyClassName == null) {
            return new JDBCTransactionFactory();
        }
        log.info("Transaction strategy: " + strategyClassName);
        try {
            factory = (TransactionFactory)ReflectHelper.classForName(strategyClassName).newInstance();
        }
        catch (ClassNotFoundException e) {
            log.error("TransactionFactory class not found", e);
            throw new HibernateException("TransactionFactory class not found: " + strategyClassName);
        }
        catch (IllegalAccessException e) {
            log.error("Failed to instantiate TransactionFactory", e);
            throw new HibernateException("Failed to instantiate TransactionFactory: " + e);
        }
        catch (InstantiationException e) {
            log.error("Failed to instantiate TransactionFactory", e);
            throw new HibernateException("Failed to instantiate TransactionFactory: " + e);
        }
        factory.configure(transactionProps);
        return factory;
    }

    private TransactionFactoryFactory() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

