/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.transaction;

import java.util.Properties;
import javax.transaction.TransactionManager;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.transaction.TransactionManagerLookup;
import net.sf.hibernate.util.ReflectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TransactionManagerLookupFactory {
    private static final Log log = LogFactory.getLog(class$net$sf$hibernate$transaction$TransactionManagerLookupFactory == null ? (class$net$sf$hibernate$transaction$TransactionManagerLookupFactory = TransactionManagerLookupFactory.class$("net.sf.hibernate.transaction.TransactionManagerLookupFactory")) : class$net$sf$hibernate$transaction$TransactionManagerLookupFactory);
    static /* synthetic */ Class class$net$sf$hibernate$transaction$TransactionManagerLookupFactory;

    private TransactionManagerLookupFactory() {
    }

    public static final TransactionManager getTransactionManager(Properties props) throws HibernateException {
        log.info("obtaining TransactionManager");
        return TransactionManagerLookupFactory.getTransactionManagerLookup(props).getTransactionManager(props);
    }

    public static final TransactionManagerLookup getTransactionManagerLookup(Properties props) throws HibernateException {
        String tmLookupClass = props.getProperty("hibernate.transaction.manager_lookup_class");
        if (tmLookupClass == null) {
            log.info("No TransactionManagerLookup configured (in JTA environment, use of process level read-write cache is not recommended)");
            return null;
        }
        log.info("instantiating TransactionManagerLookup: " + tmLookupClass);
        try {
            TransactionManagerLookup lookup = (TransactionManagerLookup)ReflectHelper.classForName(tmLookupClass).newInstance();
            log.info("instantiated TransactionManagerLookup");
            return lookup;
        }
        catch (Exception e) {
            log.error("Could not instantiate TransactionManagerLookup", e);
            throw new HibernateException("Could not instantiate TransactionManagerLookup");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

