/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.hibernate.CompositeUserType;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.engine.Cascades;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.AbstractType;
import net.sf.hibernate.type.Type;
import org.apache.commons.logging.LogFactory;

public class CompositeCustomType
extends AbstractType
implements AbstractComponentType {
    private final CompositeUserType userType;
    private final String name;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$net$sf$hibernate$type$CustomType;

    public CompositeCustomType(Class userTypeClass) throws MappingException {
        this.name = userTypeClass.getName();
        try {
            this.userType = (CompositeUserType)userTypeClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new MappingException("Cannot instantiate custom type: " + userTypeClass.getName());
        }
        catch (IllegalAccessException iae) {
            throw new MappingException("IllegalAccessException trying to instantiate custom type: " + userTypeClass.getName());
        }
        catch (ClassCastException cce) {
            throw new MappingException(userTypeClass.getName() + " must implement net.sf.hibernate.UserType");
        }
        if (!(class$java$io$Serializable == null ? (class$java$io$Serializable = CompositeCustomType.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(this.userType.returnedClass())) {
            LogFactory.getLog(class$net$sf$hibernate$type$CustomType == null ? (class$net$sf$hibernate$type$CustomType = CompositeCustomType.class$("net.sf.hibernate.type.CustomType")) : class$net$sf$hibernate$type$CustomType).warn("custom type does not implement Serializable: " + userTypeClass);
        }
    }

    public Type[] getSubtypes() {
        return this.userType.getPropertyTypes();
    }

    public String[] getPropertyNames() {
        return this.userType.getPropertyNames();
    }

    public Object[] getPropertyValues(Object component, SessionImplementor session) throws HibernateException {
        return this.getPropertyValues(component);
    }

    public Object[] getPropertyValues(Object component) throws HibernateException {
        int len = this.getSubtypes().length;
        Object[] result = new Object[len];
        for (int i = 0; i < len; ++i) {
            result[i] = this.getPropertyValue(component, i);
        }
        return result;
    }

    public void setPropertyValues(Object component, Object[] values) throws HibernateException {
        for (int i = 0; i < values.length; ++i) {
            this.userType.setPropertyValue(component, i, values[i]);
        }
    }

    public Object getPropertyValue(Object component, int i, SessionImplementor session) throws HibernateException {
        return this.getPropertyValue(component, i);
    }

    public Object getPropertyValue(Object component, int i) throws HibernateException {
        return this.userType.getPropertyValue(component, i);
    }

    public Cascades.CascadeStyle cascade(int i) {
        return Cascades.STYLE_NONE;
    }

    public int enableJoinedFetch(int i) {
        return 0;
    }

    public boolean isComponentType() {
        return true;
    }

    public Object assemble(Serializable cached, SessionImplementor session, Object owner) throws HibernateException {
        return this.userType.assemble(cached, session, owner);
    }

    public Object deepCopy(Object value) throws HibernateException {
        return this.userType.deepCopy(value);
    }

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        return this.userType.disassemble(value, session);
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return this.userType.equals(x, y);
    }

    public int getColumnSpan(Mapping mapping) throws MappingException {
        Type[] types = this.userType.getPropertyTypes();
        int n = 0;
        for (int i = 0; i < types.length; ++i) {
            n += types[i].getColumnSpan(mapping);
        }
        return n;
    }

    public String getName() {
        return this.name;
    }

    public Class getReturnedClass() {
        return this.userType.returnedClass();
    }

    public boolean hasNiceEquals() {
        return false;
    }

    public boolean isMutable() {
        return this.userType.isMutable();
    }

    public Object nullSafeGet(ResultSet rs, String columnName, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.userType.nullSafeGet(rs, new String[]{columnName}, session, owner);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.userType.nullSafeGet(rs, names, session, owner);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        this.userType.nullSafeSet(st, value, index, session);
    }

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        Type[] types = this.userType.getPropertyTypes();
        int[] result = new int[this.getColumnSpan(mapping)];
        int n = 0;
        for (int i = 0; i < types.length; ++i) {
            int[] sqlTypes = types[i].sqlTypes(mapping);
            for (int k = 0; k < sqlTypes.length; ++k) {
                result[n++] = sqlTypes[k];
            }
        }
        return result;
    }

    public String toString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return value == null ? "null" : value.toString();
    }

    public Object fromString(String xml) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        return ((CompositeCustomType)object).userType.getClass() == this.userType.getClass();
    }

    public int hashCode() {
        return this.userType.hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

