/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.xml;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.hibernate.Databinder;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.proxy.HibernateProxy;
import net.sf.hibernate.proxy.HibernateProxyHelper;
import net.sf.hibernate.proxy.LazyInitializer;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.BagType;
import net.sf.hibernate.type.ListType;
import net.sf.hibernate.type.MapType;
import net.sf.hibernate.type.PersistentCollectionType;
import net.sf.hibernate.type.SetType;
import net.sf.hibernate.type.StringType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.DOMWriter;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XMLDatabinder
implements Databinder {
    private SessionFactoryImplementor factory;
    private List objects = new ArrayList();
    private Set associatedObjects;
    private Set processedObjects;
    private Transformer transform;
    private boolean initializeLazy = false;
    private static final Log log = LogFactory.getLog(class$net$sf$hibernate$xml$XMLDatabinder == null ? (class$net$sf$hibernate$xml$XMLDatabinder = XMLDatabinder.class$("net.sf.hibernate.xml.XMLDatabinder")) : class$net$sf$hibernate$xml$XMLDatabinder);
    static /* synthetic */ Class class$net$sf$hibernate$xml$XMLDatabinder;
    static /* synthetic */ Class class$net$sf$hibernate$cfg$Environment;

    public XMLDatabinder(SessionFactoryImplementor factory, Transformer transform) {
        this.factory = factory;
        this.transform = transform;
    }

    private ClassPersister getPersister(Class clazz) throws MappingException {
        return this.factory.getPersister(clazz);
    }

    public void setInitializeLazy(boolean initializeLazy) {
        this.initializeLazy = initializeLazy;
    }

    private Document toDocument() throws HibernateException {
        this.associatedObjects = new HashSet();
        this.processedObjects = new HashSet();
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("hibernate-generic");
        root.setAttributeValue("datetime", Hibernate.TIMESTAMP.toString(new Date(), this.factory));
        while (this.objects.size() > 0) {
            Iterator iter = this.objects.iterator();
            while (iter.hasNext()) {
                Object object = iter.next();
                Element objectElem = root.addElement("object");
                if ((object = this.maybeInitializeIfProxy(object, objectElem)) == null) continue;
                this.addClass(objectElem, object.getClass());
                ClassPersister persister = this.getPersister(object.getClass());
                if (persister.hasIdentifierPropertyOrEmbeddedCompositeIdentifier()) {
                    Serializable id = persister.getIdentifier(object);
                    Element elemElement = this.renderProperty(persister.getIdentifierPropertyName(), persister.getIdentifierType(), id, "composite-id", "id", null, true);
                    objectElem.add(elemElement);
                }
                Type[] types = persister.getPropertyTypes();
                Object[] values = persister.getPropertyValues(object);
                String[] names = persister.getPropertyNames();
                for (int i = 0; i < types.length; ++i) {
                    objectElem.add(this.renderProperty(names[i], types[i], values[i], "component", "property", "collection", true));
                }
            }
            this.processedObjects.addAll(this.objects);
            this.objects = new ArrayList(this.associatedObjects);
            this.associatedObjects = new HashSet();
        }
        return doc;
    }

    private void addClass(Element element, Class clazz) {
        String className = clazz.getName();
        element.setAttributeValue("class", StringHelper.unqualify(className));
        element.setAttributeValue("package", StringHelper.qualifier(className));
    }

    private Object maybeInitializeIfProxy(Object object, Element element) throws HibernateException {
        if (!(object instanceof HibernateProxy)) {
            return object;
        }
        LazyInitializer li = HibernateProxyHelper.getLazyInitializer((HibernateProxy)object);
        if (li.isUninitialized() && !this.initializeLazy) {
            Class clazz = li.getPersistentClass();
            ClassPersister persister = this.getPersister(clazz);
            if (persister.hasIdentifierPropertyOrEmbeddedCompositeIdentifier()) {
                Serializable id = li.getIdentifier();
                Element elemElement = this.renderProperty(persister.getIdentifierPropertyName(), persister.getIdentifierType(), id, "composite-id", "id", null, true);
                element.add(elemElement);
            }
            this.addClass(element, clazz);
            element.setAttributeValue("proxy", "uninitialized");
            return null;
        }
        if (li.isUninitialized()) {
            element.setAttributeValue("proxy", "now-initialized");
        } else {
            element.setAttributeValue("proxy", "initialized");
        }
        return li.getImplementation();
    }

    public String toGenericXML() throws HibernateException {
        StringWriter writer = new StringWriter();
        XMLWriter outputter = new XMLWriter(writer, OutputFormat.createPrettyPrint());
        try {
            outputter.write(this.toDocument());
        }
        catch (IOException ioe) {
            throw new HibernateException("could not XML to String", ioe);
        }
        return writer.toString();
    }

    public String toXML() throws HibernateException, TransformerException {
        DocumentSource source = new DocumentSource(this.toDocument());
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        this.transform.setErrorListener(new ErrorListener(){

            public void warning(TransformerException te) throws TransformerException {
                log.warn("problem transforming to Custom XML: " + te.getMessageAndLocation(), te);
            }

            public void error(TransformerException te) throws TransformerException {
                log.error("problem transforming to Custom XML: " + te.getMessageAndLocation(), te);
            }

            public void fatalError(TransformerException te) throws TransformerException {
                this.error(te);
            }
        });
        this.transform.transform(source, result);
        return writer.toString();
    }

    public org.w3c.dom.Document toDOM() throws HibernateException, TransformerException {
        DocumentSource source = new DocumentSource(this.toDocument());
        DOMResult result = new DOMResult();
        this.transform.transform(source, result);
        return (org.w3c.dom.Document)result.getNode();
    }

    public Databinder bind(Object object) {
        this.objects.add(object);
        return this;
    }

    public Databinder bindAll(Collection collection) {
        this.objects.addAll(collection);
        return this;
    }

    public org.w3c.dom.Document toGenericDOM() throws HibernateException {
        DOMWriter outputter = new DOMWriter();
        try {
            return outputter.write(this.toDocument());
        }
        catch (DocumentException jde) {
            throw new HibernateException("Could not transform XML to a DOM", jde);
        }
    }

    public static Templates getOutputStyleSheetTemplates(Properties properties) {
        String xsltInputFile = properties.getProperty("hibernate.xml.output_stylesheet");
        Templates templates = null;
        try {
            InputStream stream;
            if (xsltInputFile != null) {
                stream = (class$net$sf$hibernate$cfg$Environment == null ? (class$net$sf$hibernate$cfg$Environment = XMLDatabinder.class$("net.sf.hibernate.cfg.Environment")) : class$net$sf$hibernate$cfg$Environment).getResourceAsStream(xsltInputFile);
                if (stream == null) {
                    stream = new FileInputStream(xsltInputFile);
                }
            } else {
                stream = (class$net$sf$hibernate$cfg$Environment == null ? (class$net$sf$hibernate$cfg$Environment = XMLDatabinder.class$("net.sf.hibernate.cfg.Environment")) : class$net$sf$hibernate$cfg$Environment).getClassLoader().getResourceAsStream("net/sf/hibernate/hibernate-default.xslt");
            }
            templates = TransformerFactory.newInstance().newTemplates(new StreamSource(stream));
        }
        catch (Exception e) {
            log.warn("Problem opening output stylesheet - databinding disabled", e);
        }
        catch (TransformerFactoryConfigurationError tfce) {
            log.warn("no XSLT implementation found - databinding disabled");
        }
        return templates;
    }

    private Element renderProperty(String name, Type type, Object value, String componentName, String propertyName, String collectionName, boolean doType) throws HibernateException {
        if (type.isComponentType()) {
            return this.renderComponentType(name, type, value, componentName, doType);
        }
        if (type.isPersistentCollectionType()) {
            return this.renderCollectionType(name, type, value, collectionName, doType);
        }
        if (type.isEntityType()) {
            return this.renderEntityType(name, type, value, propertyName, doType);
        }
        return this.renderOtherType(name, type, value, propertyName, doType);
    }

    private Element renderOtherType(String name, Type type, Object value, String propertyName, boolean doType) throws HibernateException {
        Element propertyElem = DocumentHelper.createElement(propertyName);
        if (name != null) {
            propertyElem.setAttributeValue("name", name);
        }
        if (value != null) {
            String xmlValue = type.toString(value, this.factory);
            if (type instanceof StringType) {
                propertyElem.addCDATA(xmlValue);
            } else {
                propertyElem.setText(xmlValue);
            }
        }
        if (doType) {
            propertyElem.setAttributeValue("type", type.getName());
        }
        return propertyElem;
    }

    private Element renderEntityType(String name, Type type, Object value, String propertyName, boolean doType) throws HibernateException {
        Element referenceElem = DocumentHelper.createElement(propertyName);
        if (name != null) {
            referenceElem.setAttributeValue("name", name);
        }
        if ((value = this.maybeInitializeIfProxy(value, referenceElem)) != null) {
            ClassPersister persister = this.getPersister(value.getClass());
            if (persister.hasIdentifierPropertyOrEmbeddedCompositeIdentifier()) {
                Type idType = persister.getIdentifierType();
                Serializable id = persister.getIdentifier(value);
                referenceElem.add(this.renderProperty(persister.getIdentifierPropertyName(), idType, id, "composite-id", "id", null, true));
            }
            this.addClass(referenceElem, value.getClass());
            if (!this.processedObjects.contains(value) && !this.objects.contains(value)) {
                this.associatedObjects.add(value);
            }
        }
        if (doType) {
            referenceElem.setAttributeValue("type", type.getName());
        }
        return referenceElem;
    }

    private Element renderCollectionType(String name, Type type, Object value, String collectionName, boolean doType) throws HibernateException {
        Element collectionElem;
        block10: {
            Type elemType;
            CollectionPersister persister;
            block14: {
                block13: {
                    PersistentCollection persistentCollection;
                    block12: {
                        block11: {
                            PersistentCollectionType collectiontype = (PersistentCollectionType)type;
                            String role = collectiontype.getRole();
                            persister = this.factory.getCollectionPersister(role);
                            collectionElem = DocumentHelper.createElement(collectionName);
                            if (name != null) {
                                collectionElem.setAttributeValue("name", name);
                            }
                            if (persister.isArray()) {
                                collectionElem.setName("array");
                            } else if (doType) {
                                collectionElem.setAttributeValue("class", type.getName());
                            }
                            elemType = persister.getElementType();
                            collectionElem.setAttributeValue("element-type", elemType.getName());
                            if (value == null) break block10;
                            if (!persister.isArray()) break block11;
                            collectionElem.setAttributeValue("index-type", "integer");
                            int length = Array.getLength(value);
                            for (int i = 0; i < length; ++i) {
                                Element elemElement = this.renderProperty(null, elemType, Array.get(value, i), "composite-element", "element", "subcollection", false);
                                elemElement.setAttributeValue("index", Integer.toString(i));
                                collectionElem.add(elemElement);
                            }
                            break block10;
                        }
                        persistentCollection = (PersistentCollection)value;
                        if (!persister.isLazy() || this.initializeLazy || persistentCollection.wasInitialized()) break block12;
                        collectionElem.setAttributeValue("lazy", "uninitialized");
                        break block10;
                    }
                    if (persistentCollection.wasInitialized()) {
                        collectionElem.setAttributeValue("lazy", "initialized");
                    } else {
                        collectionElem.setAttributeValue("lazy", "now-initialized");
                    }
                    if (!(type instanceof ListType)) break block13;
                    collectionElem.setAttributeValue("index-type", "integer");
                    Iterator iter = ((List)value).iterator();
                    int i = 0;
                    while (iter.hasNext()) {
                        Element elemElement = this.renderProperty(null, elemType, iter.next(), "composite-element", "element", "subcollection", false);
                        elemElement.setAttributeValue("index", Integer.toString(i++));
                        collectionElem.add(elemElement);
                    }
                    break block10;
                }
                if (!(type instanceof SetType) && !(type instanceof BagType)) break block14;
                Iterator iter = ((Collection)value).iterator();
                while (iter.hasNext()) {
                    Element elemElement = this.renderProperty(null, elemType, iter.next(), "composite-element", "element", "subcollection", false);
                    collectionElem.add(elemElement);
                }
                break block10;
            }
            if (!(type instanceof MapType)) break block10;
            Type indexType = persister.getIndexType();
            collectionElem.setAttributeValue("index-type", indexType.getName());
            Iterator iter = ((Map)value).entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry e = iter.next();
                Object idx = e.getKey();
                Element elemElement = this.renderProperty(null, elemType, e.getValue(), "composite-element", "element", "subcollection", false);
                elemElement.setAttributeValue("index", indexType.toString(idx, this.factory));
                collectionElem.add(elemElement);
            }
        }
        return collectionElem;
    }

    private Element renderComponentType(String name, Type type, Object value, String componentName, boolean doType) throws HibernateException {
        AbstractComponentType componenttype = (AbstractComponentType)type;
        Element componentElem = DocumentHelper.createElement(componentName);
        if (name != null) {
            componentElem.setAttributeValue("name", name);
        }
        if (doType) {
            componentElem.setAttributeValue("class", type.getName());
        }
        if (value != null) {
            String[] properties = componenttype.getPropertyNames();
            Object[] subvalues = componenttype.getPropertyValues(value, null);
            Type[] subtypes = componenttype.getSubtypes();
            for (int j = 0; j < properties.length; ++j) {
                componentElem.add(this.renderProperty(properties[j], subtypes[j], subvalues[j], "component", "property", "collection", true));
            }
        }
        return componentElem;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

