/*
 * BranzaWyborOkno.java
 *
 * Created on 5 maj 2004, 01:04
 */

package admin;

import shared.branze.*;
import shared.Branza;

/**
 * Okno umoliwiajce uytkownikowi wybr Brany
 * z Katalogu Najpopularniejszych Bran
 * @author  witus
 * @version %I% %G%
 */
public class BranzaWyborOknoAdmin extends javax.swing.JFrame {
    private EltKatBranz wybranaBranza = null;
    private BranzaWyborAdmin branzaWybor;
    private BranzaWaiterAdmin myWaiter;
    
    
    /** Tworzy nowy obiekt klasy BranzaWyborOkno 
     * @param model Drzewo Bran, ktre zostanie wywietlone w oknie
     * @param myWaiter komponent oczekujcy na wybr brany
     */
    public BranzaWyborOknoAdmin(javax.swing.tree.DefaultTreeModel model, BranzaWaiterAdmin myWaiter) {
        
        initComponents();
        this.branzaWybor = new BranzaWyborAdmin(model);
        this.myWaiter = myWaiter;
        getContentPane().add(branzaWybor, java.awt.BorderLayout.CENTER);
        this.setSize(300, 600);
    }
    
    /** Zwraca wybran przez uzytkownika bran
     * @return Bran, ktr wybra uytkownik lub null jeli takiego
     * wyboru w ogle nie dokona
     */
    public EltKatBranz wybor() {
        return this.wybranaBranza;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jButton1 = new javax.swing.JButton();

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        jButton1.setText("Wybierz Bran\u017c\u0119");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        getContentPane().add(jButton1, java.awt.BorderLayout.SOUTH);

        pack();
    }//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        // TODO add your handling code here:
        this.wybranaBranza = this.branzaWybor.wybor();
        if (this.wybranaBranza.odwiedzony) {
            KonsolaAdministratora.pokazBlad("Nie wolno tworzy cyklu!");
            return;
        }
        this.myWaiter.setBranza(this.wybranaBranza);
        this.hide();
    }//GEN-LAST:event_jButton1ActionPerformed
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        this.myWaiter.bezWyboru();
        this.hide();
    }//GEN-LAST:event_exitForm
  
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    // End of variables declaration//GEN-END:variables
    
}
