/*
 * KomSieciowa.java
 *
 * Created on 6 kwiecie 2004, 00:31
 */

package admin;

import shared.*;
import java.util.List;
import java.awt.Point;
import shared.branze.KatalogBranzDrzewo;
import java.util.ArrayList;

/** Klasa odpowiedzialna za komunikacj sieciow Interfejsu Administratora z Serwerem.
 *
 * @author  me201258
 * @version %I% %G%
 */
public class KomSieciowa
                extends komponenty.UniKomSieciowa 
                implements komponenty.MapaKomSieciowa {
    
    /** Tworzy nowy obiekt klasy KomSieciowa 
     * @param serwer adres serwera
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji
     */
    public KomSieciowa(String serwer) throws  Wyjatek {
        init(serwer);
    }
    
    /** wzr: odpala wtek (tre metody run()) i powraca) */
    public void aWykonaj() {
         odpalWatek(new Runnable() {
            public void run() {
                try {
                    //zrb co sieciowego
                    mapy.warstwy();
                    //powiadom interfejs
                } catch (Exception e) {
                } finally {
                    zamknijWatek();
                }
            }
        });
    }
    
    /**
     * Zleca zatwierdzenie nowego ogoszenia w bazie danych
     * @param ogloszenie Ogloszenie, ktre ma by zatwierdzone
     */
    public void zatwierdzNoweOgloszenie(Ogloszenie ogloszenie) {
        try {
            ogloszenia.zatwierdzNoweOgloszenie(ogloszenie);
            getNoweOgloszenia();
            KonsolaAdministratora.ponownieWyszukaj();
        } catch (Exception e) {
            e.printStackTrace();
            KonsolaAdministratora.pokazBlad("Nie udao si zatwierdzi ogoszenia!");
        }  
    }
    
    /**
     * Usunicie nowego Ogoszenia
     * @param ogloszenie Usuwane Ogoszenie
     */
    public void usunNoweOgloszenie(Ogloszenie ogloszenie) {
        try {
            this.ogloszenia.usunOgloszenie(ogloszenie);
            getNoweOgloszenia();
            KonsolaAdministratora.ponownieWyszukaj();
        } catch (Exception e) {
            e.printStackTrace();
            KonsolaAdministratora.pokazBlad("Nie udalo si usun ogoszenia!");
        }
    }
    
    /**
     * Usunicie niekatualnego Ogoszenia
     * @param ogloszenie Usuwane Ogoszenie
     */
    public void usunNieaktualneOgloszenie(Ogloszenie ogloszenie) {
        try {
            this.ogloszenia.usunOgloszenie(ogloszenie);
            getNieaktualneOgloszenia();
            KonsolaAdministratora.ponownieWyszukaj();
        } catch (Exception e) {
            e.printStackTrace();
            KonsolaAdministratora.pokazBlad("Nie udalo si usun ogoszenia!");
        }
    }
    
    /**
     * Potwierdzenie aktualnoci Ogoszenia
     * @param ogloszenie Ogoszenie, ktrego aktualno ma zosta potwierdzona
     */
    public void potwierdzAktualnoscOgloszenia(Ogloszenie ogloszenie) {
        try {
            this.ogloszenia.potwierdzAktualnosc(ogloszenie);
            getNieaktualneOgloszenia();
            KonsolaAdministratora.ponownieWyszukaj();
        } catch (Exception e) {
            e.printStackTrace();
            KonsolaAdministratora.pokazBlad("Nie udao si podwierdzi aktualnoci ogoszenia!");
        }
    }
       
    /**
     * Zlecenie pobrania listy nowych ogosze
     */
    public void getNoweOgloszenia() {
        odpalWatek(new Runnable() {
           public void run() {
               try {
                   KonsolaAdministratora.odbierzNoweOgloszenia(ogloszenia.noweOgloszenia());
               } catch (Exception e) {
                   e.printStackTrace();
                   KonsolaAdministratora.pokazBlad("Nie udao si pobra nowych ogosze!");
               }
           }
        });
    }
    
    /**
     * Zlecenie pobrania listy nieaktualnych
     */
    public void getNieaktualneOgloszenia() {
        odpalWatek(new Runnable() {
           public void run() {
               try {
                   KonsolaAdministratora.odbierzNieaktualneOgloszenia(ogloszenia.nieaktualneOgloszenia());
               } catch (Exception e) {
                   e.printStackTrace();
                   KonsolaAdministratora.pokazBlad("Nie udao si pobra nieaktualnych ogosze!");
               }
           }
        });
    }
    
    /**
     * Zlecenie pobrania listy nieopaconych ogosze
     */
    public void getNieoplaconeOgloszenia() {
        odpalWatek(new Runnable() {
           public void run() {
               try {
                   KonsolaAdministratora.odbierzNieoplaconeOgloszenia(ogloszenia.nieoplaconeOgloszenia());
               } catch (Exception e) {
                   e.printStackTrace();
                   KonsolaAdministratora.pokazBlad("Nie udao si pobra nieaktualnych ogosze!");
               }
           }
        });
    }
    
    /**
     * Zlecenie pobrania Katalogu Najpopularniejszych Bran
     */
    public void getKatalogNajpop() {
        odpalWatek(new Runnable() {
           public void run() {
               try {
                   KonsolaAdministratora.odbierzKatalogNajpop(katalogNajpop.katalog());
               } catch (Exception e) {
                   e.printStackTrace();
                   KonsolaAdministratora.pokazBlad("Nie udao si pobra katalogu " +
                                                   "najpopularniejszych branz!");
               }
           }
        });
    }
    
    /**
     * Zlecenie pobrania listy popularnoci Bran
     */
    public void getListaPop() {
        odpalWatek(new Runnable() {
           public void run() {
               try {
                   KonsolaAdministratora.odbierzListePop(katalogNajpop.getListaPopularnosci());
               } catch (Exception e) {
                   e.printStackTrace();
                   KonsolaAdministratora.pokazBlad("Nie udao si pobra listy " +
                                                   "popularnosci!");
               }
           }
        });
    }
    
    /** 
     * Sprawdza czy podane haso administratora jest poprawne.
     * Maa rzecz wic zrobiem to synchronicznie
     * @param haslo napis, ktry uytkownik poda jako 
     * haso i ma zosta sprawdzone czy jest poprawne.
     * @return Czy haso jest prawidowe
     */
    public boolean sprawdzHalso(String haslo) {
        try {
            return kontoAdministratora.autoryzacja(haslo);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
    
    /** 
     * Pobranie z serwera statycznie wygenerowanego Katalogu Bran 
     * @return pobrany Katalog Bran
     */
    public KatalogBranzDrzewo getDrzewoBranz() {
        try {
            return this.pobierzKatalogBranz(System.getProperty("NIIKT_HTTP", "http://localhost/NIIKT"));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return (KatalogBranzDrzewo) null;
    }
    
    /**
     * Pobranie listy telefonow zwizanych z zadanym Ogoszeniem
     * @param ogloszenie Ogloszenie, ktrego Telefony chcemy pobra
     * @return Lista telefonw zwizanych z zadanym Ogoszeniem
     */
    public ArrayList pobierzTelefony(Ogloszenie ogloszenie) {
        try {
            return this.kontaFirm.pobierzTelefony(ogloszenie.getId());
        } catch (Exception e) {
            e.printStackTrace();
            KonsolaAdministratora.pokazBlad("Nie udao si pobra telefonw!");
        }
        return null;
    }
    
    /**
     * Dodanie do Katalogu Bran nowej Brany
     * @param nowa dodawana Brana
     * @param matka grupa Bran, do ktrej bdzie podczepiona nowa Brana
     * @return dodana Brana
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji
     */
    public Branza dodajNowaBranze(Branza nowa, Branza matka) throws Wyjatek {
        try {
            return this.katalogBranz.dodajDoKatalogu(nowa, matka);
        } catch (Exception e) {
            e.printStackTrace();
            throw new Wyjatek();
        }
    }
    
    /**
     * Zlecenie umieszczenia w bazie nowego Katalogu Najpopularniejszych Bran
     * @param nowyKatalog nowy Katalog Najpopularniejszych Bran
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji
     */
    public void zamienKatalogNajpop(List nowyKatalog) {
        try {
            this.katalogNajpop.zamienKatalog(nowyKatalog);           
        } catch (Exception e) {
            e.printStackTrace();
            KonsolaAdministratora.pokazBlad("Nie udao si zachowa katalogu " +
                                            "najpopularniejszych bran!");
        }
    }
    
     /**
     * Zmiania Bran w Katalogu Branz
     * @param nowa Brana, ktra znajdzie si w Katalogu Bran
     * @param stara Brana, ktra zostanie zamieniona na now
     * @return Brana, ktra znalaza si w Katalogu
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji
     */
    public Branza zmienBranze(Branza nowa, Branza stara) throws Wyjatek {
        try {
            return this.katalogBranz.zmienBranze(nowa, stara);
        } catch (Exception e) {
            e.printStackTrace();
            throw new Wyjatek();
        }
    }
    
     /**
     * Usuwanie zadanej brany z bazy danych
     * @param branza brana, ktra zostanie usunita z bazy danych
     * @throws Wyjatek wyjtek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     */    
    public void usunBranze(Branza branza) throws Wyjatek {
        try {
            this.katalogBranz.usunBranze(branza);
        } catch (Exception e) {
            e.printStackTrace();
            KonsolaAdministratora.pokazBlad("Nie udao sie usun Brany!");
            throw new Wyjatek();
        }
        return;
    }
    
    /**
     * Wysya do serwera polecenie zmiany hasa,
     * podobnie maa rzecz i jest synchroniczna
     * @param stare aktualne haso Administatora
     * @param nowe Nowe haso Administratora
     * @return Czy operacja zakoczya si sukcesem
     */    
    public boolean zmienHaslo(String stare, String nowe) {
        try {
            kontoAdministratora.zmienHaslo(stare, nowe);
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
    
    public void pobierzWarstwy() {
         odpalWatek(new Runnable() {
            public void run() {
                try {
                    KonsolaAdministratora.widokMapy.odbierzWarstwy(mapy.warstwy());
                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    zamknijWatek();
                }
            }
        });
    }
    
    public void pobierzFragmenty(final WarstwaMapy w, final int ile, final Point pkt) {
         odpalWatek(new Runnable() {
            public void run() {
                try {
                    KonsolaAdministratora.widokMapy.odbierzFragmenty(mapy.pobierzFragmenty(w, ile, pkt));
                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    zamknijWatek();
                }
            }
        });
    }
    
    public void znajdzUlice(final String nazwa) {
         odpalWatek(new Runnable() {
            public void run() {
                try {
                    KonsolaAdministratora.widokMapy.odbierzUlice(ulice.znajdzUlice(nazwa));
                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    zamknijWatek();
                }
            }
        });
    }
    
    public void znajdzFragmentyUlicy(final Ulica ul) {
         odpalWatek(new Runnable() {
            public void run() {
                try {
                    KonsolaAdministratora.widokMapy.odbierzFragmentyUlicy(ulice.znajdzFragmentyUlicy(ul));
                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    zamknijWatek();
                }
            }
        });
    }
    
    /**
     * Zlecenie wygenerowania pliku ze statycznym Katalogiem Bran
     */
    public void generujStatycznyKatalogBranz() {
        odpalWatek(new Runnable() {
            public void run() {
                try {
                    katalogBranz.generujStatycznyKatalogBranz();
                    KonsolaAdministratora.odbierzKatalogBranz(getDrzewoBranz());
                    KonsolaAdministratora.potwierdzWygenerowanieKataloguBranz();
                    getListaPop();
                } catch (Exception e) {
                    e.printStackTrace();
                    KonsolaAdministratora.porazkaWygenerowanieKataloguBranz();
                }
            
            }
        });
    }
    
    /**
     * Zlecenie zamiany ogoszenia na bezpatne w wypadku, gdy nie zostao ono
     * opacona na nadchodzcy okres
     * @param ogloszenie Ogoszenie, ktre zostanie zamienione na bezpatne
     */
    public void zmienNaBezplatneOgloszenie(OgloszeniePlatne ogloszenie) {
        try {
            ogloszenia.zmienNaBezplatne(ogloszenie);
            getNieoplaconeOgloszenia();
            KonsolaAdministratora.ponownieWyszukaj();
        } catch (Exception e) {
            e.printStackTrace();
            KonsolaAdministratora.pokazBlad("Nie udao si zmieni ogoszenia "
                + "na bezpatne!");
        }
    }
    
    /**
     * Zlecenie wygenerowania statycznego katalogu Najpopularniejszych Bran
     */
    public void generujStatycznyKatalogNajpopularniejszych() {
        try {
            katalogNajpop.wygenerujStatycznyKatalogNajpop();
            KonsolaAdministratora.pokazInfo("Statyczny katalog najpopularniejszych bran zosta wygenerowany");
        } catch (Exception e) {
            e.printStackTrace();
            KonsolaAdministratora.pokazBlad("Nie udao si wygenerowa statycznego "
                + "katalogu najpopularniejszych bran!");
        }
    }
    
    /** Zlecenie dodania nowej zalenoci do Katalogu Branz
     * @param nowa podbrana w nowej zalenoci
     * @param matka nadbrana w nowej zalenoci
     */
    public void dodajZaleznosc(Branza nowa, Branza matka) {
        try {
            katalogBranz.dodajDoKataloguZaleznosc(nowa, matka);
        } catch (Exception e) {
            e.printStackTrace();
            KonsolaAdministratora.pokazBlad("Nie udao si doda zalenoci");
        }
    }
    
    /** Usunicie podczepienia Brany (i samej brany jeli ju nigdzie nie jest podczepiona)
     * @param branza Brana, ktra zostanie usunita z bazy danych
     * @param matka Nadbrana usuwanej Brany
     * @return True gdy operacja powioda si, false wpp.
     */
    public boolean usunPodczepionaBranza(Branza branza, Branza matka) {
        try {
            katalogBranz.usunPodczepionaBranze(branza, matka);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            KonsolaAdministratora.pokazBlad("Nie udao si usun brany!");  
        }
        return false;
    }
    
    /** Przedua termin opacenia ogoszenia patnego.
     * @param platne    patne ogoszenie, ktrego termin przeduamy
     * @param doKiedy   data, do kiedy dane ogoszenie jest opacone
     */
    public void przedluzTermin(OgloszeniePlatne platne, java.util.Date doKiedy) {
        try {
            ogloszenia.przedluzTermin(platne, doKiedy);
            KonsolaAdministratora.ponownieWyszukaj();
        } catch (Exception e) {
            e.printStackTrace();
            KonsolaAdministratora.pokazBlad("Nie udao si przeduy terminu!");
        }
    }
    
    /** Zaktualizowanie ogoszenia w bazie danych 
     * @param ogloszenie Aktualizowane ogoszenie
     * @return True jeli udao si zaktualizowa ogoszenie, false wpp
     */
    public boolean edytujOgloszenie(Ogloszenie ogloszenie) {
        try {
            ogloszenia.aktualizujTrescOgloszenia(ogloszenie);
            KonsolaAdministratora.ponownieWyszukaj();
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            KonsolaAdministratora.pokazBlad("Nie udao si zmieni ogoszenia");
        }
        return false;
    }
    
    /** Zaktualizowanie ogoszenia w bazie danych 
     * @param ogloszenie Aktualizowane ogoszenie
     * @param telefony Lista telefonw aktualizowanego ogoszenia
     * @return True jeli udao si zaktualizowa ogoszenie, false wpp
     */
     public boolean modyfikujOgloszenie(Ogloszenie ogloszenie, ArrayList telefony) {
        try {
            String ret = (kontaFirm.modyfikujOgloszenieAdmin(ogloszenie, telefony));
            if (ret.compareTo("OK") != 0) {
                KonsolaAdministratora.pokazBlad(ret);
                return false;
            }
            KonsolaAdministratora.ponownieWyszukaj();
            return true;
        } catch (Exception e) {
            KonsolaAdministratora.pokazBlad("Nie udao si zmieni ogoszenia!");
            e.printStackTrace();
        }
        return false;
    }
     
    /** 
     * Wyszukanie ogosze speniajcych zadane kryteria
     * @param kryteria Zadane kryteria
     */
    public void zapytanie(final Kryteria kryteria) {
         odpalWatek(new Runnable() {
            public void run() {
                try {
                    //zrb co sieciowego
                    List wyniki;
                    //System.out.println("KOM SIECIOWA zaczynam");
                    wyniki = ogloszenia.wyborOgloszen(kryteria);
                    //System.out.println("KOM sieciowa: wyniki odebrane");
                    KonsolaAdministratora.odbierzWyniki(wyniki);
                    //System.out.println("KOM sieciowa: wyniki odebrane KONCZE");
                    //powiadom interfejs
                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    zamknijWatek();
                }
            }
        });
    }
}
