/*
 * KonsolaAdministratora.java
 *
 * Created on 6 kwiecie 2004, 17:18
 */

package admin;

import javax.swing.*;
import shared.Wyjatek;
import shared.branze.KatTreeNode;
import admin.mapa.WidokMapy;
import sun.net.ftp.*;
import shared.branze.KatalogBranzDrzewo;
import javax.swing.tree.DefaultMutableTreeNode;
import java.awt.Container;
import java.awt.CardLayout;
import java.awt.BorderLayout;
import java.util.List;
import java.util.ArrayList;
import shared.Ogloszenie;
import shared.OgloszeniePlatne;
import shared.Kryteria;

/**
 * MODU ADMINISTRATORA
 * @author  me201258
 * @version %I% %G%
 */
public class KonsolaAdministratora {
    final static String BIEZACEZADANIA = "WidokZadanBiezacych";
    final static String WIDOKKATALOGUFIRM = "WidokKataloguFirm";
    final static String PODSTAWOWY = "WidokPodstawowy";
    final static String WIDOKMAPY = "WidokMapy";
    final static String WIDOKBRANZ = "WidokKataloguBranz";
    final static String WIDOKHASLA = "WidokZmianyHasla";
    final static String WIDOKPOP = "WidokNajpopularniejszych";
    final static String WIDOKOGLOSZENIA = "WidokOgloszenia";
    final static String WIDOKPRZEDLUZANIA = "WidokPrzedluzania";
    
    /** Obiekt odpowiedzialny za komunikacj z serwerem NIIKT */
    public static KomSieciowa komSieciowa;
    
    /** Okno moduu Administratora */
    private static JFrame frame;
    
    /** Widok pozwalajcy zarzdza map */
    public static WidokMapy widokMapy;
    
    private static WidokKataloguBranz widokBranz;
    
    private static WidokZmianyHasla widokHasla;
    
    private static WidokNajpopularniejszychBranz widokPop;
    
    private static WidokZadanBiezacych biezace;
    
    private static boolean brakKatalogu;
    
    private static JPanel cards;
    
    private static WidokKataloguFirm widokFirm;
    
    private static KatalogBranzDrzewo katalog;
    
    /** Creates a new instance of KonsolaAdministratora */
    public KonsolaAdministratora() {
    }
    
    /** Inicjalizacja widoku Interfejsu po zalogowaniu
     * si Administratora
     */
    public static void zalogowany() {
             
        Container cp = frame.getContentPane();
        //usuwamy to co jest - widok logowania
        
        cards = new JPanel(new CardLayout());
        JPanel card1 = new PanelPodstawowy();
        widokFirm = new WidokKataloguFirm();
        
        katalog = komSieciowa.getDrzewoBranz();
        
        if (katalog != null) {
            widokBranz = new WidokKataloguBranz(katalog.dajModel());
            cards.add(widokBranz, WIDOKBRANZ);
            brakKatalogu = false;
        } else
            brakKatalogu = true;
            
        widokHasla = new WidokZmianyHasla();
        
        widokMapy = new WidokMapy();
        widokMapy.initWidok();
        
        widokPop = new WidokNajpopularniejszychBranz();
        komSieciowa.getKatalogNajpop();
        komSieciowa.getListaPop();
        
        cards.add(widokFirm, WIDOKKATALOGUFIRM);
        biezace = new WidokZadanBiezacych();
        cards.add(biezace, BIEZACEZADANIA);
        komSieciowa.getNoweOgloszenia();
        komSieciowa.getNieaktualneOgloszenia();
        komSieciowa.getNieoplaconeOgloszenia();
        
        cards.add(widokMapy, WIDOKMAPY);
        cards.add(widokHasla, WIDOKHASLA);
        cards.add(widokPop, WIDOKPOP);
        
        cp.removeAll();
        cp.setLayout(new BorderLayout());
        cp.add(card1, BorderLayout.WEST);
        cp.add(cards, BorderLayout.CENTER);
        
        // CardLayout cl = (CardLayout) cards.getLayout();
        // cl.show(cards, BIEZACEZADANIA);
        //wstawiamy klawisze z menu opcji
        pokazWidokZadanBiezacych();
        
        frame.show();
        
        
    }
    private static String ostatni;
    
    /** Wcza ostatni widoczny widok
     */
    public static void pokazOstatni() {
        podmienWidok(ostatni);
    }
    
    
        
   
    
        
    /** Usuwa biecy widok, zastpujc go podanym nowym.
     *  @param nowyWidok panel do wywietlenia w oknie.
     */
    private static void podmienWidok(String ident) {
        Container cp = frame.getContentPane();
        JPanel comp = (JPanel) cp.getComponent(1);
        CardLayout cl = (CardLayout) comp.getLayout();
        cl.show(comp, ident);
    }
    
    /** Wcza widok edycji ogoszenia 
     * @param ogloszenie Ogoszenie, ktre bdzie edytowane */
    public static void pokazWidokOgloszenia(Ogloszenie ogloszenie) {
        cards.add(WIDOKOGLOSZENIA, new WidokOgloszenia(ogloszenie));
        podmienWidok(WIDOKOGLOSZENIA);
    }
    
    /** Wcza widok przeduania terminu wanoci ogoszenia patnego
     * @param ogloszenie Ogoszenie, ktre bdzie przeduane
     */
    public static void pokazWidokPrzedluzania(Ogloszenie ogloszenie) {
        cards.add(WIDOKPRZEDLUZANIA, new WidokPrzedluzania(ogloszenie));
        podmienWidok(WIDOKPRZEDLUZANIA);
    }
    
    /** Wcza widok zada biecych */
    public static void pokazWidokZadanBiezacych() {
        ostatni = BIEZACEZADANIA;
        podmienWidok(BIEZACEZADANIA);
    }
    
    /** Wcza widok zmiany hasa */
    public static void pokazWidokZmianyHasla() {
        podmienWidok(WIDOKHASLA);
    }
    
    /** Wcza widok Katalogu Firm */
    public static void pokazWidokKataloguFirm() {
        ostatni = WIDOKKATALOGUFIRM;
        podmienWidok(WIDOKKATALOGUFIRM);
    }
    
    /** Wcza widok Mapy */
    public static void pokazWidokMapy() {
        podmienWidok(WIDOKMAPY);
    }
    
    /** Wcza widok Katalogu Bran */
    public static void pokazWidokKataloguBranz() {
        podmienWidok(WIDOKBRANZ);
    }
    
    /** Wacza widok Katalogu Najpopularniejszych Branz() */
    public static void pokazWidokNajpop() {
        komSieciowa.getListaPop();
        podmienWidok(WIDOKPOP);
    }
    
    /**
     * Uruchomienie moduu Administratora
     * @param args Argumenty z listy polece
     */
    public static void main(String[] args) {
        try {
            
            komSieciowa = new KomSieciowa(System.getProperty("SERWER", "localhost"));
            frame = new JFrame("NIIKT - Modu Administratora");
            frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
            frame.getContentPane().add(new WidokLogowania());
            frame.setSize(886,500);
            frame.setVisible(true);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    /** Metoda wywoywana aby poinformowa modu, e jest nowy Katalog Bran
     * na serwerze
     */
    public static void potwierdzWygenerowanieKataloguBranz() {
        JOptionPane.showMessageDialog(frame, "Katalog Bran zosta wygenerowany");
        if (brakKatalogu) {
            KatalogBranzDrzewo katalog = komSieciowa.getDrzewoBranz();
            if (katalog != null) {
                widokBranz = new WidokKataloguBranz(katalog.dajModel());
                cards.add(widokBranz, WIDOKBRANZ);
                brakKatalogu = false;
            } else
                brakKatalogu = true;
        }
    }
    
    /**
     * Pobranie listy telefonow zwizanych z zadanym Ogoszeniem
     * @param ogloszenie Ogloszenie, ktrego Telefony chcemy pobra
     * @return Lista telefonw zwizanych z zadanym Ogoszeniem
     */
    public static ArrayList getTelefony(Ogloszenie ogloszenie) {
        return komSieciowa.pobierzTelefony(ogloszenie);
    }
    
    /**
     * Usunicie nowego Ogoszenia
     * @param ogloszenie Usuwane Ogoszenie
     */
    public static void usunNoweOgloszenie(Ogloszenie ogloszenie) {
        komSieciowa.usunNoweOgloszenie(ogloszenie);
    }
    
    /**
     * Usunicie niekatualnego Ogoszenia
     * @param ogloszenie Usuwane Ogoszenie
     */
    public static void usunNieaktualneOgloszenie(Ogloszenie ogloszenie) {
        komSieciowa.usunNieaktualneOgloszenie(ogloszenie);
    }
    
    /**
     * Potwierdzenie aktualnoci Ogoszenia
     * @param ogloszenie Ogoszenie, ktrego aktualno ma zosta potwierdzona
     */
    public static void potwierdzAktualnoscOgloszenia(Ogloszenie ogloszenie) {
        komSieciowa.potwierdzAktualnoscOgloszenia(ogloszenie);
    }
    
    /**
     * Odebranie listy nowych Ogosze pobranej z serwera 
     * @param list Pobrana lista Ogosze
     */
    public static void odbierzNoweOgloszenia(List list) {
        biezace.odbierzNoweOgloszenia(list);
    }
    
    /**
     * Odebranie listy nieaktualnych Ogosze pobranej z serwera 
     * @param list Pobrana lista Ogosze
     */
    public static void odbierzNieaktualneOgloszenia(List list) {
        biezace.odbierzNieakualneOgloszenia(list);
    }
    
    /**
     * Odebranie listy nieopaconych Ogosze pobranej z serwera 
     * @param list Pobrana lista Ogosze
     */
    public static void odbierzNieoplaconeOgloszenia(List list) {
        biezace.odbierzNieoplaconeOgloszenia(list);
    }
    
    /**
     * Sygnalizacja niepowodzenia przy generowaniu Katalogu Bran 
     */
    public static void porazkaWygenerowanieKataloguBranz() {
        JOptionPane.showMessageDialog(frame, "Wygenerowanie Katalogu Bran nie powiodo si!");
    }
    
    /**
     * Odebranie Katalogu Bran pobranego z serwera 
     * @param katalogBranz Pobrany katalog
     */
    public static void odbierzKatalogBranz(KatalogBranzDrzewo katalogBranz) {
        katalog = katalogBranz;
        if (katalog != null) {
            widokBranz = new WidokKataloguBranz(katalog.dajModel());
            cards.add(widokBranz, WIDOKBRANZ);
            brakKatalogu = false;
        } else
            brakKatalogu = true;
    }

    /**
     * Odebranie Katalogu Najpopularniejszych Bran pobranego z serwera 
     * @param katalogNajpop Pobrany katalog
     */
    public static void odbierzKatalogNajpop(List katalogNajpop) {
        widokPop.odbierzKatalogNajpop(katalogNajpop);
    }
    
    /**
     * Odebranie listy Bran pobranej z serwera 
     * @param listaPop Pobrana lista
     */
    public static void odbierzListePop(List listaPop) {
        widokPop.odbierzListePop(listaPop);
    }
    
    /**
     * Wywietlenie komunikatu o bdzie
     * @param tresc Wypisywana tre komunikatu
     */
    public static void pokazBlad(String tresc) {
        JOptionPane.showMessageDialog(frame, tresc, "Bd", JOptionPane.ERROR_MESSAGE);
    } 
    
    /**
     * Wywietlanie informacji na ekranie
     * @param tresc Wypisywana tre informacji
     */
    public static void pokazInfo(String tresc) {
        JOptionPane.showMessageDialog(frame, tresc, "Informacja", JOptionPane.INFORMATION_MESSAGE);
    }
    
    /**
     * Zlecenie zamiany ogoszenia na bezpatne w wypadku, gdy nie zostao ono
     * opacona na nadchodzcy okres
     * @param ogloszenie Ogoszenie, ktre zostanie zamienione na bezpatne
     */
    public static void zmienNaBezplatnieOgloszenie(OgloszeniePlatne ogloszenie) {
        komSieciowa.zmienNaBezplatneOgloszenie(ogloszenie);
    }
    /**
     * Zlecenie umieszczenia w bazie nowego Katalogu Najpopularniejszych Bran
     * @param nowyKatalog nowy Katalog Najpopularniejszych Bran
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji
     */
    public static void zamienKatalogNajpop(List nowyKatalog) {
        komSieciowa.zamienKatalogNajpop(nowyKatalog);
    }
    
     /**
     * Zlecenie wygenerowania statycznego katalogu Najpopularniejszych Bran
     */
    public static void generujStatycznyKatalogNajpopularniejszych() {
        komSieciowa.generujStatycznyKatalogNajpopularniejszych();
    }
    
    /**
     * Zlecenie dodania nowej zalenoci do Katalogu Bran
     * @param nowa podbrana w nowej zalenoci
     * @param matka nadbrana w nowej zalenoci
     */
    public static void dodajZaleznosc(shared.Branza nowa, shared.Branza matka) {
        komSieciowa.dodajZaleznosc(nowa, matka);
    }
    
    /** Usunicie podczepienia Brany (i samej brany jeli ju nigdzie nie jest podczepiona)
     * @param branza Brana, ktra zostanie usunita z bazy danych
     * @param matka Nadbrana usuwanej Brany
     * @return True gdy operacja powioda sie, false wpp.
     */
    public static boolean usunPodczepionaBranza(shared.Branza branza, shared.Branza matka) {
        return komSieciowa.usunPodczepionaBranza(branza, matka);
    }
    
     /** Przedua termin opacenia ogoszenia patnego.
     * @param platne    patne ogoszenie, ktrego termin przeduamy
     * @param doKiedy   data, do kiedy dane ogoszenie jest opacone
     */
    public static void przedluzTermin(OgloszeniePlatne platne, java.util.Date doKiedy) {
        komSieciowa.przedluzTermin(platne, doKiedy);
    }
    
     /** Zaktualizowanie ogoszenia w bazie danych 
     * @param ogloszenie Aktualizowane ogoszenie
     * @return True jeli udao si zaktualizowa ogoszenie, false wpp
     */
    public static boolean edytujOgloszenie(Ogloszenie ogloszenie) {
        return komSieciowa.edytujOgloszenie(ogloszenie);
    }
    
    /**
     * Zleca zatwierdzenie nowego ogoszenia w bazie danych
     * @param ogloszenie Ogloszenie, ktre ma by zatwierdzone
     */
    public static void zatwierdzNoweOgloszenie(Ogloszenie ogloszenie) {
        komSieciowa.zatwierdzNoweOgloszenie(ogloszenie);
    }
    
    
    /** Zaktualizowanie ogoszenia w bazie danych 
     * @param ogloszenie Aktualizowane ogoszenie
     * @param telefony Lista telefonw aktualizowanego ogoszenia
     * @return True jeli udao si zaktualizowa ogoszenie, false wpp
     */
     public static boolean modyfikujOgloszenie(Ogloszenie ogloszenie, ArrayList telefony) {
         return komSieciowa.modyfikujOgloszenie(ogloszenie, telefony);
     }
     
     /** Wyszukanie ogosze speniajcych zadane kryteria
      * @param kryteria Zadane kryteria
      */
     public static void zapytanie(Kryteria kryteria) {
        komSieciowa.zapytanie(kryteria);
     }
     private static java.util.List wyniki = new ArrayList();
     private static java.util.List telefony = new ArrayList();
     
     /** Odebranie wynikw wyszukiwania 
      * @param listaWynikow Lista zawierajca wyniki wyszukiwania
      */
     public static void odbierzWyniki(java.util.List listaWynikow) {                 
        wyniki.clear();
        telefony.clear();
        //pobierz ogloszenia
        for (int i = 0; i<(listaWynikow.size()-1)/2; i++)
            wyniki.add(listaWynikow.get(i+1));
        //pobierz telefony z konca listy
        for (int i = (listaWynikow.size()-1)/2; i<listaWynikow.size()-1; i++)
            telefony.add(listaWynikow.get(i+1));     
        widokFirm.wyswietlWyniki(wyniki);
     }
     
     
     /** Powtrzenie ostatnio wykonywanego wyszukiwania
      */
     public static void ponownieWyszukaj() {
         shared.Kryteria kryteria = widokFirm.ostatnieZapytanie();
         if (kryteria != null) {
             zapytanie(kryteria);
         }
     }
     
     /** Ustawienie w widoku zapyta przyciskw nastpny i poprzedni
      * @param dl dugo listy wynikw
      */
     public static void ustawNastPoprz(int dl) {
         widokFirm.ustawNastPoprz(dl);
     }
     
     /** Koczy dziaanie aplikacji */
     public static void koniecPracy() {
         System.exit(0);
     }
     
     /** Ponowne pobranie wszystkich danych z serwera */
     public static void odswiezDane() {
         zalogowany();
     }
     
     /** Czyci widok zapyta z wprowadzonych przez uytkownika
      * danych
      */
     public static void noweZapytanie() {
         widokFirm = new WidokKataloguFirm();
         cards.add(widokFirm, WIDOKKATALOGUFIRM);
         pokazWidokKataloguFirm();
     }
     
     /** Dostp do pobranego Katalogu Bran
      * @return Pobrany wczeniej katalog bran
      */
     public static KatalogBranzDrzewo dajPobranyKatalog() {
         return katalog;
     }
     
     
}