/*
 * WidokKataloguBranz.java
 *
 * Created on 30 kwiecie 2004, 11:52
 */

package admin;
import javax.swing.tree.*;
import javax.swing.JTree;
import shared.branze.*;
import shared.*;
import java.util.ArrayList;
import java.awt.event.*;
import javax.swing.event.*;
import javax.swing.JOptionPane;
import javax.swing.JMenuItem;
//import javax.swing.JOptionPane;

/**
 * Graficzna obsuga Katalogu Bran
 * @author  witus
 * @version %I% %G%
 */
public class WidokKataloguBranz extends javax.swing.JPanel 
    implements BranzaWaiterAdmin {
        
    class PopupListener extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (((javax.swing.JTree) e.getComponent()).getSelectionPath() == null)
                    return;
                
                jPopupMenu1.show(e.getComponent(),
                           e.getX(), e.getY());
            }
        }
    }
    private WidokKataloguBranz ten = this;
    
    private BranzaWyborOknoAdmin branzaWybor;
    
    private ActionListener podczepWielokrotnie = new ActionListener() {
        public void actionPerformed(ActionEvent a) {
           
            KatTreeNode parentNode = null;
            TreePath parentPath = jTree1.getSelectionPath();
            if (parentPath == null) return;
            if (branzaWybor != null) {
                KonsolaAdministratora.pokazBlad("Jeszcze nie zakoczye pracy z poprzednim podczepianiem!");
                return;
            }
     
            parentNode = (KatTreeNode) parentPath.getLastPathComponent();
            wybranaDoWielokrotnego = (EltKatBranz) parentNode.getUserObject();
            ((EltKatBranz) 
                ((KatTreeNode) 
                    treeModel.getRoot()).getUserObject()).szukajBranzy(wybranaDoWielokrotnego.getBranza());
            branzaWybor = new BranzaWyborOknoAdmin(treeModel, ten);
            branzaWybor.setVisible(true);  
        }
    };
    
    private DefaultTreeModel treeModel;
    
    private EltKatBranz wybranaDoWielokrotnego;
    
    /** Creates new form WidokKataloguBranz 
     * @param model Model drzewa bran, ktre zostanie wywietlone w widoku
     */
    public WidokKataloguBranz(KatTreeNode model) {
        initComponents();
        treeModel = new DefaultTreeModel(model);
        this.jTree1 = new JTree(treeModel);
        this.drzewko.setViewportView(jTree1);
        jTree1.getSelectionModel().setSelectionMode
            (TreeSelectionModel.SINGLE_TREE_SELECTION);
        dodaj.addActionListener(dodajBranzeListener);
        usun.addActionListener(usunBranzeListener);
        zapisz.addActionListener(zmienBranzeListener);
        jTree1.addTreeSelectionListener(wyborBranzyListener);
        
        JMenuItem menuItem1 = new JMenuItem("Podczep w inne miejsce");
        menuItem1.addActionListener(podczepWielokrotnie);
        jPopupMenu1.add(menuItem1);
        MouseListener popupListener = new PopupListener();
        jTree1.addMouseListener(popupListener);
        
        this.branzaWybor = null;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPopupMenu1 = new javax.swing.JPopupMenu();
        drzewko = new javax.swing.JScrollPane();
        jTree1 = new javax.swing.JTree();
        jPanel1 = new javax.swing.JPanel();
        nowa = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        nazwa = new javax.swing.JTextField();
        jPanel5 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        opis = new javax.swing.JTextField();
        jPanel6 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        klucz = new javax.swing.JTextField();
        dodaj = new javax.swing.JButton();
        edycja = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        nazwaE = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        opisE = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        kluczE = new javax.swing.JTextField();
        zapisz = new javax.swing.JButton();
        usun = new javax.swing.JButton();
        opcje = new javax.swing.JPanel();
        odswiez = new javax.swing.JButton();
        generuj = new javax.swing.JButton();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.X_AXIS));

        setBorder(new javax.swing.border.TitledBorder(new javax.swing.border.TitledBorder(""), "Katalog Bran\u017c"));
        drzewko.setBorder(new javax.swing.border.TitledBorder("Drzewo Katalogu Bran\u017c"));
        drzewko.setPreferredSize(new java.awt.Dimension(180, 406));
        drzewko.setViewportView(jTree1);

        add(drzewko);

        jPanel1.setLayout(new java.awt.GridLayout(3, 1));

        nowa.setLayout(new java.awt.GridLayout(4, 1));

        nowa.setBorder(new javax.swing.border.TitledBorder("Nowa Bran\u017ca"));
        jPanel2.setLayout(new java.awt.GridLayout(1, 0));

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel1.setText("Nazwa");
        jPanel2.add(jLabel1);

        jPanel2.add(nazwa);
        nazwa.getAccessibleContext().setAccessibleName("nazwa");

        nowa.add(jPanel2);

        jPanel5.setLayout(new java.awt.GridLayout(1, 0));

        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel2.setText("Opis");
        jPanel5.add(jLabel2);

        jPanel5.add(opis);

        nowa.add(jPanel5);

        jPanel6.setLayout(new java.awt.GridLayout(1, 0));

        jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel3.setText("S\u0142owo klucz");
        jPanel6.add(jLabel3);

        jPanel6.add(klucz);

        nowa.add(jPanel6);

        dodaj.setText("Dodaj Bran\u017c\u0119");
        nowa.add(dodaj);

        jPanel1.add(nowa);

        edycja.setLayout(new java.awt.GridLayout(4, 2));

        edycja.setBorder(new javax.swing.border.TitledBorder("Edytuj/Usu\u0144 Bran\u017c\u0119"));
        jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel4.setText("Nazwa");
        edycja.add(jLabel4);

        edycja.add(nazwaE);

        jLabel5.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel5.setText("Opis");
        edycja.add(jLabel5);

        edycja.add(opisE);

        jLabel6.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel6.setText("S\u0142owo klucz");
        edycja.add(jLabel6);

        edycja.add(kluczE);

        zapisz.setText("Zapisz");
        edycja.add(zapisz);

        usun.setText("Usu\u0144");
        edycja.add(usun);

        jPanel1.add(edycja);

        opcje.setLayout(new java.awt.GridLayout(2, 0));

        opcje.setBorder(new javax.swing.border.TitledBorder(new javax.swing.border.TitledBorder(""), "Opcje Katalogu Bran\u017c"));
        odswiez.setText("Od\u015bwie\u017c Katalog Bran\u017c");
        odswiez.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                odswiezActionPerformed(evt);
            }
        });

        opcje.add(odswiez);

        generuj.setText("Generuj Katalog Bran\u017c");
        generuj.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                generujActionPerformed(evt);
            }
        });

        opcje.add(generuj);

        jPanel1.add(opcje);

        add(jPanel1);

    }//GEN-END:initComponents

    private void generujActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_generujActionPerformed
        KonsolaAdministratora.komSieciowa.generujStatycznyKatalogBranz();
    }//GEN-LAST:event_generujActionPerformed

    private void odswiezActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_odswiezActionPerformed
        
    }//GEN-LAST:event_odswiezActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton dodaj;
    private javax.swing.JScrollPane drzewko;
    private javax.swing.JPanel edycja;
    private javax.swing.JButton generuj;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPopupMenu jPopupMenu1;
    private javax.swing.JTree jTree1;
    private javax.swing.JTextField klucz;
    private javax.swing.JTextField kluczE;
    private javax.swing.JTextField nazwa;
    private javax.swing.JTextField nazwaE;
    private javax.swing.JPanel nowa;
    private javax.swing.JButton odswiez;
    private javax.swing.JPanel opcje;
    private javax.swing.JTextField opis;
    private javax.swing.JTextField opisE;
    private javax.swing.JButton usun;
    private javax.swing.JButton zapisz;
    // End of variables declaration//GEN-END:variables
    
    /**
     * Ustala gdzie ma zosta dodana nowa Brana i wydaje polecenie
     * dodania jej tam
     * @return nowoutworzony wze w modelu drzewa Bran
     * @param child Brana, ktra ma zosta dodana do drzewa Bran
     */
    public DefaultMutableTreeNode addObject(Object child) {
        KatTreeNode parentNode = null;
        TreePath parentPath = jTree1.getSelectionPath();
        
        if (parentPath == null) {
            /* Nic nie wybrano podczepiam now Bran do gwnego wza */
            parentNode = (KatTreeNode) treeModel.getRoot();
        } else {
            /* Ustalam wze gdzie ma by podczepiona nowa Brana */
            parentNode = (KatTreeNode)
                         (parentPath.getLastPathComponent());
        }
        /* Wydaja polecenie dodania nowej Brany w odpowiednim miejscu */
        return addObject(parentNode, child, true);
    }
    
    /**
     * Tworzy now bran na podstawie pl w WidokuKataloguBranz/NowaBranza
     * @return Branza utowrzona na podstawie zawartoci odpowiednich p w widoku
     */
    public Branza zbierzBranze() {
        if (nazwa.getText().length() == 0) {
            return new Branza("BranzaBezNazwy", opis.getText(), klucz.getText());
        } else {
            return new Branza(nazwa.getText(), opis.getText(), klucz.getText());
        }
    }
    
    /**
     * Tworzy now bran na podstawie pl w WidokuKataloguBranz/EdytujBran
     * @return Branza utowrzona na podstawie zawartoci odpowiednich p w widoku
     */
    public Branza zbierzEBranze() {
        if (nazwaE.getText().length() == 0) {
            return new Branza("BranzaBezNazwy", opisE.getText(), kluczE.getText());
        } else {
            return new Branza(nazwaE.getText(), opisE.getText(), kluczE.getText());
        }
    }
    
    /**
     * Potrafi zebra z pl dane, utworzy z nich now Bran i doda j do drzewa Bran.
     */    
    private ActionListener dodajBranzeListener = new ActionListener() {
        public void actionPerformed(ActionEvent a) {
            addObject(zbierzBranze());
        }
    };
    
    /**
     * Potrafi zebra z pl dane, utworzy z nich now Bran i doda j do drzewa Bran.
     */    
    private ActionListener zmienBranzeListener = new ActionListener() {
        public void actionPerformed(ActionEvent a) {
            changeNode();
        }
    };
    
    /**
     * Wydaje polecenie usunicia wskazanej Brany
     */    
    private ActionListener usunBranzeListener = new ActionListener() {
        public void actionPerformed(ActionEvent a) {
            delNode();
        }
    };
    
    /**
     * Dodaje now Bran do drzewa Bran w zadanym wle i upewnia si, e nowa
     * Brana jest widoczna w drzewie.
     * @param parent Wze do ktrego zostanie dodana nowa Brana
     * @param child Brana, ktra zostanie dodana do drzewa Bran
     * @param shouldBeVisible Flaga informujca czy po dodaniu nowej Brany wze z ni ma by widoczny
     * w drzewie Bran.
     * @return Utworzony wze z now Bran
     */    
    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Object child, boolean shouldBeVisible) {
        /* Wydostaje odpowiedni element drzewa bran */
        EltKatBranz parentElt = (EltKatBranz) parent.getUserObject();  
        /* Tworz nowe poddrzewo skadajce si tylko z korzenia */
        EltKatBranz nowyElt = new EltKatBranz((Branza) child, new ArrayList());
        /* List rodzicw */
        java.util.List parentList = 
            ((KatTreeNode) treeModel.getRoot()).szukaj(((EltKatBranz) parent.getUserObject()).getBranza());
        /* Dodaje dziecko w drzewie katalogu bran */
        try {
            nowyElt.setBranza(KonsolaAdministratora.komSieciowa.dodajNowaBranze(nowyElt.getBranza(), parentElt.getBranza()));
        } catch (Wyjatek w) {
            JOptionPane.showMessageDialog(this, "Nie udao si doda nowej brany!", "Bd", JOptionPane.ERROR_MESSAGE);
            return null;
        }
        
        parentElt.dodajDziecko(nowyElt);
        /* Nowy wze w modelu dla JTree */
        KatTreeNode childNode;
        /* Dodaje wze w modelu dla JTree */
        parentList.remove(parent);
        java.util.Iterator iterator = parentList.iterator();
        
        for (; iterator.hasNext();) {
            childNode = new KatTreeNode(nowyElt);
            KatTreeNode pom = (KatTreeNode) iterator.next();
            treeModel.insertNodeInto(childNode, pom, pom.getChildCount());
        }
        
        childNode = new KatTreeNode(nowyElt);
        treeModel.insertNodeInto(childNode, parent, parent.getChildCount());
               
        /* Jeli zadano tego, to upewniamy si, e nowy wze jest widoczny */
        if (shouldBeVisible) {
            jTree1.scrollPathToVisible(new TreePath(childNode.getPath()));
        }
        
        this.nazwa.setText("");
        this.opis.setText("");
        this.klucz.setText("");
        return childNode;
    }
    
    /**
     * Ustala ktry wze chce usun Administrator, sprawdza, czy jest to moliwe
     * i jeli tak to wydaje polecenie usunicia go
     */    
    public void delNode() {
        KatTreeNode delNode = null;
        KatTreeNode parentNode = null;
        TreePath parentPath = jTree1.getSelectionPath();
        
        if (parentPath == null) {
            /* Nic nie wybrano i nic nie bdziemy usuwa */
            return;
        }
        
        /* Ustalamy usuwany wze i jego rodzica */
        delNode = (KatTreeNode) parentPath.getLastPathComponent();
        // if (delNode.getChildCount() > 0) {
            /* Nie usuwamy wza, ktry ma potomkw */
        //    KonsolaAdministratora.pokazBlad("Nie wolno usuwa wzw majcych potomkw!");
        //    return;
        // }
        parentNode = (KatTreeNode) delNode.getParent();
        
        /* Jeli jest to gwny wze to go nie usuwamy */
        if (parentNode == null) {
            KonsolaAdministratora.pokazBlad("Nie wolno usuwa korzenia drzewa Bran!");
            return;
        }
        /* Wydajemy polecenie usunicia wza */
        delNode(parentNode, delNode);
        return;
    }
    
    /**
     * Ustala ktry wze chce zamieni Administrator, sprawdza, czy jest to moliwe
     * i jeli tak to wydaje polecenie zamiany
     */    
    public void changeNode() {
        KatTreeNode changeNode = null;
        TreePath parentPath = jTree1.getSelectionPath();
        
        if (parentPath == null) {
            /* Nic nie wybrano i nic nie bdziemy zamienia */
            return;
        } else {
            /* Ustalamy usuwany wze i jego rodzica */
            changeNode = (KatTreeNode) parentPath.getLastPathComponent();
        }
        /* Wydajemy polecenie zmiany wza */
        Branza szukana = ((EltKatBranz) changeNode.getUserObject()).getBranza();
        java.util.List changeNodesList = ((KatTreeNode) treeModel.getRoot()).szukaj(szukana);
        
        Branza nowaBranza = null;
        try {
            nowaBranza = KonsolaAdministratora.komSieciowa.katalogBranz.zmienBranze(
                ((EltKatBranz)changeNode.getUserObject()).getBranza(), zbierzEBranze());
        } catch (Exception e) {
            KonsolaAdministratora.pokazBlad("Nie udao sie zmieni brany!");
            return;
        }
        
        java.util.Iterator iter = changeNodesList.iterator();
        for (; iter.hasNext();) {
            KatTreeNode pom = (KatTreeNode) iter.next();
            ((EltKatBranz) pom.getUserObject()).setBranza(nowaBranza);
            treeModel.nodeChanged(pom);
        }
        // treeModel.nodeChanged(changeNode);        
        return;
    }
    
    /**
     * Usuwa zadany wze z modelu drzewa Bran i z samego drzewa Bran
     * @param delNode Wze, ktry ma zosta usunity
     * @param parentNode Nadwze wza, ktry ma zosta usunity
     */    
    public void delNode(KatTreeNode parentNode, KatTreeNode delNode) {
        // try {
            // KonsolaAdministratora.komSieciowa.usunBranze(((EltKatBranz) delNode.getUserObject()).getBranza());
        if (!KonsolaAdministratora.usunPodczepionaBranza(
        ((EltKatBranz) delNode.getUserObject()).getBranza(),
        ((EltKatBranz) parentNode.getUserObject()).getBranza()))
            return;
            
            
        EltKatBranz parentElt = (EltKatBranz) parentNode.getUserObject();
        java.util.List parentList = ((KatTreeNode) treeModel.getRoot()).szukaj(parentElt.getBranza());
        Branza szukana = ((EltKatBranz) delNode.getUserObject()).getBranza();
        java.util.Iterator iter = parentList.iterator();
        for (; iter.hasNext();) {
            KatTreeNode pom = (KatTreeNode) iter.next();
            treeModel.removeNodeFromParent(pom.dajPotomka(szukana));
            treeModel.nodeChanged(pom);
        }
        
        //     treeModel.removeNodeFromParent(delNode);
        //     treeModel.nodeChanged(parentNode);
            this.nazwaE.setText("");
            this.opisE.setText("");
            this.kluczE.setText("");
        // } catch (Wyjatek w) {}
        return;
    }
    
    /**
     * Wywietla w odpowiednich polach widoku informacja o zadanej parametrem Brany
     * @param elt Element drzewa Bran, z ktrym jest zwizana Brana, o ktrej
     * informacja zostan wywietlone w widoku/Edytuj/Usu
     */    
    public void wyswietlBranze(EltKatBranz elt) {
        Branza branza = elt.getBranza();
        nazwaE.setText(branza.getNazwa());
        opisE.setText(branza.getOpis());
        kluczE.setText(branza.getSlowoKluczowe());
    }
    
    /**
     * Reaguje na zmian zaznaczenia w drzewie Bran
     */    
    private TreeSelectionListener wyborBranzyListener = new TreeSelectionListener() {
        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)
                                          jTree1.getLastSelectedPathComponent();
            if (node == null) return;
            wyswietlBranze((EltKatBranz) node.getUserObject());
        }
    };
    
    /** Odbiera pobrany Katalog Bran i przekazuje go do wywietlania
     * @param katalogBranz nowy Katalog Bran do wywietlania
     */
    public void odbierzKatalogBranz(KatalogBranzDrzewo katalogBranz) {
        KatTreeNode myModel = katalogBranz.dajModel();
        if (myModel == null) 
            return;
        this.jTree1.setModel(treeModel = new DefaultTreeModel(myModel));
    }
    
    public void setBranza(shared.branze.EltKatBranz eltKatBranz) {
        KonsolaAdministratora.dodajZaleznosc(wybranaDoWielokrotnego.getBranza(), eltKatBranz.getBranza());
        oczyscModel();
        this.branzaWybor = null;
        if (!eltKatBranz.maDziecko(wybranaDoWielokrotnego.getBranza())) {
            java.util.List parentList = ((KatTreeNode) treeModel.getRoot()).szukaj(eltKatBranz.getBranza());
            java.util.Iterator iterator = parentList.iterator();
        
            for (; iterator.hasNext();) {
                KatTreeNode childNode = wybranaDoWielokrotnego.wezelJTree();
                KatTreeNode pom = (KatTreeNode) iterator.next();
                treeModel.insertNodeInto(childNode, pom, pom.getChildCount());
            }
        }
    }
    
    public void bezWyboru() {
        this.branzaWybor = null;
        oczyscModel();
    }
    
    /**
     * Oczyszczenie modelu Katlogu Bran z atrybutw odwiedzony
     */
    private void oczyscModel() {
        ((EltKatBranz) ((KatTreeNode) this.treeModel.getRoot()).getUserObject()).czyscOdwiedzony();
    }
    
}
