/*
 * WidokKataloguFirm.java
 *
 * Created on 6 kwiecie 2004, 19:53
 */

package admin;

import java.util.List;
import java.util.Iterator;
import java.util.ArrayList;
import shared.Ogloszenie;
import komponenty.models.OgloszenieListModel;
import javax.swing.DefaultListModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;

/**
 * Widok umoliwiajcy Administratorowi przegldanie katalogu Firm
 * @author  me201258
 * @version %I% %G%
 */
public class WidokKataloguFirm extends javax.swing.JPanel {
    private WidokZapytan zapytania;
    private WidokWynikow wyniki;
    
    /** Kryteria z ostatniego zapytania 
     * @return Kryteria z ostatniego zapytania, null jeeli takiego nie byo
     */
    public shared.Kryteria ostatnieZapytanie() {
        return zapytania.kryteria;
    }
       
    
    /** Tworzy nowy widok klasy WidokKataloguFirm */
    public WidokKataloguFirm() {
        initComponents();
        this.zapytania = new WidokZapytan();
        jScrollPane1.setViewportView(this.zapytania);
        this.wyniki = new WidokWynikow();
        jScrollPane2.setViewportView(this.wyniki);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jScrollPane1 = new javax.swing.JScrollPane();
        jScrollPane2 = new javax.swing.JScrollPane();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.Y_AXIS));

        setBorder(new javax.swing.border.TitledBorder("Katalog Firm"));
        add(jScrollPane1);

        add(jScrollPane2);

    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    // End of variables declaration//GEN-END:variables
    
    private DefaultListModel przerobNaModel(List list) {
        DefaultListModel ret = new DefaultListModel();
        Iterator iter = list.iterator();
        
        for (; iter.hasNext();) {
            ret.addElement(new OgloszenieListModel((Ogloszenie) iter.next()));
        }
        return ret;
    }
    
    /** Wywielenie wynikw wyszukiwania
     * @param wyniki Lista zawierajca wyniki wyszukiwania
     */
    public void wyswietlWyniki(java.util.List wyniki) {
        this.wyniki.odbierzWyniki(wyniki);
    }
    
    /** Ustawienie przyciskw nastpne i poprzednie w widoku zapyta
     * @param dl dugo listy wynikw
     */
    public void ustawNastPoprz(int dl) {
        this.zapytania.ustawNastPoprz(dl);
    }
}
