/*
 * WidokNajpopularniejszychBranz.java
 *
 * Created on 17 maj 2004, 10:38
 */

package admin;

import java.util.List;
import java.util.Iterator;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import shared.NajpopularniejszaBranza;
import komponenty.models.NajpopListItem;
import javax.swing.ListSelectionModel;
import javax.swing.JMenuItem;
import shared.Wyjatek;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import java.util.Collections;


/**
 * Widok umoliwiajcy manipulacj Katalogiem Najpopularniejszych Bran
 * @author  witus
 * @version %I% %G%
 */
public class WidokNajpopularniejszychBranz extends javax.swing.JPanel {
    
    
    class PopupListener extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (((javax.swing.JList) e.getComponent()).getSelectedValue() == null)
                    return;
                
                jPopupMenu1.show(e.getComponent(),
                           e.getX(), e.getY());
            }
        }
    }
    
    /** Creates new form WidokNajpopularniejszychBranz */
    public WidokNajpopularniejszychBranz() {
        initComponents();
        jList1.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        jList2.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        JMenuItem menuItem1 = new JMenuItem("Zmie opis");
        menuItem1.addActionListener(zmienOpisListener);
        jPopupMenu1.add(menuItem1);
        MouseListener popupListener = new PopupListener();
        jList1.addMouseListener(popupListener);
        
    }
      
    private ActionListener zmienOpisListener = new ActionListener() {
        public void actionPerformed(ActionEvent a) {
            
            NajpopListItem wybrana = (NajpopListItem) jList1.getSelectedValue();
            if (wybrana == null) return;
            JFrame podwidok = new WidokZmianyOpisuNajpopularniejszej(wybrana.getNb());
            podwidok.setSize(600, 120);
            podwidok.show();
        }
    };
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPopupMenu1 = new javax.swing.JPopupMenu();
        jPanel8 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jPanel2 = new javax.swing.JPanel();
        jList1 = new javax.swing.JList();
        jPanel1 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jScrollPane2 = new javax.swing.JScrollPane();
        jPanel3 = new javax.swing.JPanel();
        jList2 = new javax.swing.JList();
        jPanel9 = new javax.swing.JPanel();
        jButton3 = new javax.swing.JButton();
        jButton4 = new javax.swing.JButton();

        setLayout(new java.awt.BorderLayout());

        setBorder(new javax.swing.border.TitledBorder("Katalog Najpopularniejszych Bran\u017c"));
        jPanel8.setLayout(new javax.swing.BoxLayout(jPanel8, javax.swing.BoxLayout.X_AXIS));

        jPanel2.setLayout(new java.awt.BorderLayout());

        jPanel2.setBorder(new javax.swing.border.TitledBorder("Najpopularniejsze Bran\u017ce"));
        jPanel2.add(jList1, java.awt.BorderLayout.CENTER);

        jScrollPane1.setViewportView(jPanel2);

        jPanel8.add(jScrollPane1);

        jPanel1.setLayout(new javax.swing.BoxLayout(jPanel1, javax.swing.BoxLayout.Y_AXIS));

        jButton1.setText("->");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jPanel1.add(jButton1);

        jButton2.setText("<-");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        jPanel1.add(jButton2);

        jPanel8.add(jPanel1);

        jPanel3.setLayout(new java.awt.BorderLayout());

        jPanel3.setBorder(new javax.swing.border.TitledBorder("Popularne Bran\u017ce"));
        jPanel3.add(jList2, java.awt.BorderLayout.CENTER);

        jScrollPane2.setViewportView(jPanel3);

        jPanel8.add(jScrollPane2);

        add(jPanel8, java.awt.BorderLayout.CENTER);

        jPanel9.setLayout(new java.awt.GridLayout());

        jButton3.setText("Generuj katalog najpopularniejszych bran\u017c");
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });

        jPanel9.add(jButton3);

        jButton4.setText("Odswie\u017c katalog najpopularniejszych bran\u017c");
        jButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton4ActionPerformed(evt);
            }
        });

        jPanel9.add(jButton4);

        add(jPanel9, java.awt.BorderLayout.SOUTH);

    }//GEN-END:initComponents

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
        if (list1 == null)
            return;
        KonsolaAdministratora.zamienKatalogNajpop(list1);
        KonsolaAdministratora.generujStatycznyKatalogNajpopularniejszych();
            
        KonsolaAdministratora.komSieciowa.getKatalogNajpop();
        KonsolaAdministratora.komSieciowa.getListaPop();
    }//GEN-LAST:event_jButton3ActionPerformed

    private void jButton4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton4ActionPerformed
        KonsolaAdministratora.komSieciowa.getKatalogNajpop();
        KonsolaAdministratora.komSieciowa.getListaPop();
    }//GEN-LAST:event_jButton4ActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        NajpopListItem wybrana = (NajpopListItem) jList2.getSelectedValue();
        if (wybrana == null) return;
        // ((DefaultListModel) jList2.getModel()).removeElement(wybrana);
        // ((DefaultListModel) jList1.getModel()).addElement(wybrana);
        ((DefaultListModel) jList2.getModel()).removeElement(wybrana);
        list2.remove(wybrana.getNb());
        list1 = wsadz(list1, wybrana.getNb());
        // list1.add(wybrana.getNb());
        // Collections.sort(list1);
        jList1.setModel(przerobNaModel(list1));
    }//GEN-LAST:event_jButton2ActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        NajpopListItem wybrana = (NajpopListItem) jList1.getSelectedValue();
        if (wybrana == null) return;
        ((DefaultListModel) jList1.getModel()).removeElement(wybrana);
        // ((DefaultListModel) jList2.getModel()).addElement(wybrana);
        list1.remove(wybrana.getNb());
        list2 = wsadz(list2, wybrana.getNb());
        // list2.add(wybrana.getNb());
        // Collections.sort(list2);
        jList2.setModel(przerobNaModel(list2));
    }//GEN-LAST:event_jButton1ActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton4;
    private javax.swing.JList jList1;
    private javax.swing.JList jList2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JPanel jPanel9;
    private javax.swing.JPopupMenu jPopupMenu1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    // End of variables declaration//GEN-END:variables
    private List list1;
    private List list2;
    
    
    private DefaultListModel przerobNaModel(List list) {
        DefaultListModel ret = new DefaultListModel();
        Iterator iter = list.iterator();
        
        for (; iter.hasNext();) {
            NajpopularniejszaBranza nb = (NajpopularniejszaBranza) iter.next();
            ret.addElement(new NajpopListItem(nb));
        }
        return ret;
    }
    
    /**
     * Odebranie pobranego Katalogu Najpopularniejszych Bran
     * @param katalogNajpop pobrany katalog
     */
    public void odbierzKatalogNajpop(List katalogNajpop) {
        list1 = katalogNajpop;
        jList1.setModel(przerobNaModel(katalogNajpop));
        
    }
    
    /**
     * Odebranie pobranej listy popularnoci
     * @param listaPop pobrana lista
     */
     public void odbierzListePop(List listaPop) {
         list2 = listaPop;
         jList2.setModel(przerobNaModel(listaPop));
    }
    
     private List wsadz(List lista, NajpopularniejszaBranza nb) {
         List ret = new ArrayList();
         Iterator iter = lista.iterator();
         boolean wsadzone = false;
         
         for (; iter.hasNext();) {
             NajpopularniejszaBranza akt = (NajpopularniejszaBranza) iter.next();
             if ((akt.compareTo(nb) >= 0) && (!wsadzone)) {
                 ret.add(nb);
                 ret.add(akt);
                 wsadzone = true;
             } else
                 ret.add(akt);
         }
         
         if (!wsadzone)
             ret.add(nb);
         
         return ret;
     }
     
}
