/*
 * WidokPrzedluzania.java
 *
 * Created on 18 czerwiec 2004, 14:18
 */

package admin;

import java.util.Date;
import javax.swing.SpinnerNumberModel;
import java.util.GregorianCalendar;
import java.util.Calendar;
import shared.Ogloszenie;

/**
 * Widok, w ktrym Administator moe przeduy okres opacenia
 * ogoszenia
 * @author  witus
 * @version %I% %G%
 */
public class WidokPrzedluzania extends javax.swing.JPanel {
    
    private Ogloszenie ogloszenie;
    
    final String MIESIAC = "miesiac";
    final String DWA = "dwa";
    final String POL = "pol";
    final String ROK = "rok";
    final String DATA = "data";
    
    /** Creates new form WidokPrzedluzania 
     * @param ogloszenie Ogoszenie, ktrego okres opacenia
     * bdzie przeduany
     */
    public WidokPrzedluzania(Ogloszenie ogloszenie) {
        this.ogloszenie = ogloszenie;
       
       
        initComponents();
        jRadioButton1.setActionCommand(MIESIAC);
        buttonGroup1.add(jRadioButton1);
        jRadioButton2.setActionCommand(DWA);
        buttonGroup1.add(jRadioButton2);
        jRadioButton3.setActionCommand(POL);
        buttonGroup1.add(jRadioButton3);
        jRadioButton4.setActionCommand(ROK);
        buttonGroup1.add(jRadioButton4);
        jRadioButton5.setActionCommand(DATA);
        buttonGroup1.add(jRadioButton5);
        
        jComboBox2.setModel(
        new javax.swing.DefaultComboBoxModel(
        new String[] {
            "stycze\u0144",
            "luty",
            "marzec",
            "kwiecie\u0144",
            "maj",
            "czerwiec",
            "lipiec",
            "sierpie\u0144",
            "wrzesie\u0144",
            "pa\u017adziernik",
            "listopad",
            "grudzie\u0144"
        }));
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(new Date());
        jSpinner1.setModel(new SpinnerNumberModel(gc.get(Calendar.DAY_OF_MONTH), 1, 31, 1));
        
        jSpinner2.setModel(new SpinnerNumberModel(gc.get(Calendar.YEAR), 1600, 3000, 1));
        jLabel3.setText("Ogoszenie firmy: " + this.ogloszenie.getNazwa()
            + " wane do: " + this.ogloszenie.getPlatne().getDataOplacenia().toString());
        jComboBox2.setSelectedIndex(gc.get(Calendar.MONTH));
        jRadioButton1.setSelected(true);
    }
    
    /** Konstuuje podan przez uytkownika dat z wypenonych przez niego pl
     * @return Dat podan przez uytkownika na ekranie
     */
    public Date getDate() {
        Date d;
        try {
            SpinnerNumberModel modelDzien = (SpinnerNumberModel)jSpinner1.getModel();
            SpinnerNumberModel modelRok = (SpinnerNumberModel)jSpinner2.getModel();
            int dzien = modelDzien.getNumber().intValue();    /* 1-31 */
            int miesiac = jComboBox2.getSelectedIndex(); /* 0-11 */
            int rok = modelRok.getNumber().intValue();
            GregorianCalendar gc = new GregorianCalendar();
            gc.setLenient(false);
            gc.set(Calendar.YEAR, rok);
            gc.set(Calendar.MONTH, miesiac);
            gc.set(Calendar.DAY_OF_MONTH, dzien);
            d = gc.getTime();
        } catch (Exception e) {
            KonsolaAdministratora.pokazBlad("Niepoprawny format daty.");
            return null;
        }
        return d;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        buttonGroup1 = new javax.swing.ButtonGroup();
        jLabel6 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jRadioButton1 = new javax.swing.JRadioButton();
        jRadioButton2 = new javax.swing.JRadioButton();
        jRadioButton3 = new javax.swing.JRadioButton();
        jRadioButton4 = new javax.swing.JRadioButton();
        jPanel1 = new javax.swing.JPanel();
        jRadioButton5 = new javax.swing.JRadioButton();
        jPanel3 = new javax.swing.JPanel();
        jSpinner1 = new javax.swing.JSpinner();
        jLabel1 = new javax.swing.JLabel();
        jComboBox2 = new javax.swing.JComboBox();
        jLabel2 = new javax.swing.JLabel();
        jSpinner2 = new javax.swing.JSpinner();
        jLabel8 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jPanel5 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();

        setLayout(new java.awt.GridLayout(11, 0));

        setBorder(new javax.swing.border.TitledBorder("Prze\u0142u\u017c okres op\u0142acenia og\u0142oszenia"));
        add(jLabel6);

        add(jLabel3);

        jLabel4.setText(" Przed\u0142u\u017c okres op\u0142acenia");
        add(jLabel4);

        jRadioButton1.setText("o miesi\u0105c");
        add(jRadioButton1);

        jRadioButton2.setText("o dwa miesi\u0105ce");
        add(jRadioButton2);

        jRadioButton3.setText("o p\u00f3\u0142 roku");
        add(jRadioButton3);

        jRadioButton4.setText("o rok");
        add(jRadioButton4);

        jPanel1.setLayout(new java.awt.GridLayout(1, 0));

        jRadioButton5.setText("do daty:");
        jPanel1.add(jRadioButton5);

        jPanel3.setLayout(new javax.swing.BoxLayout(jPanel3, javax.swing.BoxLayout.X_AXIS));

        jPanel3.add(jSpinner1);

        jLabel1.setText("-");
        jPanel3.add(jLabel1);

        jPanel3.add(jComboBox2);

        jLabel2.setText("-");
        jPanel3.add(jLabel2);

        jPanel3.add(jSpinner2);

        jPanel1.add(jPanel3);

        add(jPanel1);

        add(jLabel8);

        add(jLabel5);

        jPanel5.setLayout(new java.awt.GridLayout(1, 2));

        jButton1.setText("Przed\u0142u\u017c okres");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jPanel5.add(jButton1);

        jButton2.setText("Anuluj");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        jPanel5.add(jButton2);

        add(jPanel5);

    }//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        
        String polecenie = buttonGroup1.getSelection().getActionCommand();
        if (polecenie == DATA) {
            Date data = getDate();
            if (data == null)
                return;
            przedluzOgloszenie(data);
            KonsolaAdministratora.komSieciowa.getNieoplaconeOgloszenia();
            KonsolaAdministratora.pokazOstatni();
            return;
        }
        
        Calendar c = new GregorianCalendar();
        c.setTime(this.ogloszenie.getPlatne().getDataOplacenia());
        //ogloszenia ktorym data oplacenia juz minela lub minie za 14 dni
        
        if (polecenie == MIESIAC) {
            c.add(Calendar.DATE, +31);
            przedluzOgloszenie(c.getTime());
            KonsolaAdministratora.komSieciowa.getNieoplaconeOgloszenia();
            KonsolaAdministratora.pokazOstatni();
            return;
        }
        if (polecenie == DWA) {
            c.add(Calendar.DATE, +62);
            przedluzOgloszenie(c.getTime());
            KonsolaAdministratora.komSieciowa.getNieoplaconeOgloszenia();
            KonsolaAdministratora.pokazOstatni();
            return;
        }
        if (polecenie == POL) {
            c.add(Calendar.DATE, +183);
            przedluzOgloszenie(c.getTime());
            KonsolaAdministratora.komSieciowa.getNieoplaconeOgloszenia();
            KonsolaAdministratora.pokazOstatni();
            return;
        }
        if (polecenie == ROK) {
            c.add(Calendar.DATE, +365);
            przedluzOgloszenie(c.getTime());
            KonsolaAdministratora.komSieciowa.getNieoplaconeOgloszenia();
            KonsolaAdministratora.pokazOstatni();
            return;
        }
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        KonsolaAdministratora.pokazOstatni();
    }//GEN-LAST:event_jButton2ActionPerformed
        
    private void przedluzOgloszenie(Date data) {
        KonsolaAdministratora.przedluzTermin(this.ogloszenie.getPlatne(), data);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JComboBox jComboBox2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JRadioButton jRadioButton1;
    private javax.swing.JRadioButton jRadioButton2;
    private javax.swing.JRadioButton jRadioButton3;
    private javax.swing.JRadioButton jRadioButton4;
    private javax.swing.JRadioButton jRadioButton5;
    private javax.swing.JSpinner jSpinner1;
    private javax.swing.JSpinner jSpinner2;
    // End of variables declaration//GEN-END:variables
    
}
