/*
 * WidokWynikw.java
 *
 * Created on 20 czerwiec 2004, 16:48
 */

package admin;

import java.util.List;
import java.util.Iterator;
import java.util.ArrayList;
import shared.Ogloszenie;
import komponenty.models.OgloszenieListModel;
import javax.swing.DefaultListModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;

/**
 * Cz ekranu, gdzie bd wywietane wyniki wyszukiwania
 * @author  witus
 * @version %I% %G%
 */
public class WidokWynikow extends javax.swing.JPanel {
    class PopupListener extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (((javax.swing.JList) e.getComponent()).getSelectedValue() == null)
                    return;
                Ogloszenie wybrane = ((OgloszenieListModel) ((javax.swing.JList) e.getComponent()).getSelectedValue()).getOgloszenie();
		if (wybrane.getPlatne() == null) {
                    jPopupMenu1.show(e.getComponent(),
                            e.getX(), e.getY());
                } else {
                    jPopupMenu2.show(e.getComponent(),
                            e.getX(), e.getY());
                }
            }
        }
    }
       
    private ActionListener edytujOgloszenieListener = new ActionListener() {
        public void actionPerformed(ActionEvent a) {  
            OgloszenieListModel ogloszenieListModel = (OgloszenieListModel) jList1.getSelectedValue();
            if (ogloszenieListModel == null) return;
            KonsolaAdministratora.pokazWidokOgloszenia(ogloszenieListModel.getOgloszenie());
        }
    };
    
    private ActionListener usunOgloszenieListener = new ActionListener() {
        public void actionPerformed(ActionEvent a) {
            OgloszenieListModel ogloszenieListModel = (OgloszenieListModel) jList1.getSelectedValue();
            if (ogloszenieListModel == null) return;      
            KonsolaAdministratora.usunNieaktualneOgloszenie(ogloszenieListModel.getOgloszenie());
        }
    };
    
    private ActionListener potwierdzOgloszenieListener = new ActionListener() {
        public void actionPerformed(ActionEvent a) {
            OgloszenieListModel ogloszenieListModel = (OgloszenieListModel) jList1.getSelectedValue();
            if (ogloszenieListModel == null) return;
            KonsolaAdministratora.potwierdzAktualnoscOgloszenia(ogloszenieListModel.getOgloszenie());
        }
    };
    
    private ActionListener zmienNaBezplatneOgloszenieListener = new ActionListener() {
        public void actionPerformed(ActionEvent a) {
            OgloszenieListModel ogloszenieListModel = (OgloszenieListModel) jList1.getSelectedValue();
            if (ogloszenieListModel == null) return;
            KonsolaAdministratora.zmienNaBezplatnieOgloszenie(ogloszenieListModel.getOgloszenie().getPlatne());
        }
    };
    
    private ActionListener przedluzOgloszenieListener = new ActionListener() {
        public void actionPerformed(ActionEvent a) {
            OgloszenieListModel ogloszenieListModel = (OgloszenieListModel) jList1.getSelectedValue();
            if (ogloszenieListModel == null) return;
            KonsolaAdministratora.pokazWidokPrzedluzania(ogloszenieListModel.getOgloszenie());
        }
    };
    
    /** Creates new form WidokWynikw */
    public WidokWynikow() {
        initComponents();
        
        JMenuItem menuItem1 = new JMenuItem("Edytuj ogoszenie");
        menuItem1.addActionListener(edytujOgloszenieListener);
        jPopupMenu1.add(menuItem1);
        
        JMenuItem menu1 = new JMenuItem("Edytuj ogoszenie");
        menu1.addActionListener(edytujOgloszenieListener);
        jPopupMenu2.add(menu1);
        
        JMenuItem menuItem2 = new JMenuItem("Usu ogoszenie");
        menuItem2.addActionListener(usunOgloszenieListener);
        jPopupMenu1.add(menuItem2);
        
        JMenuItem menu2 = new JMenuItem("Usu ogoszenie");
        menu2.addActionListener(usunOgloszenieListener);
        jPopupMenu2.add(menu2);
        
        JMenuItem menuItem3 = new JMenuItem("Przedu wano ogoszenia");
        menuItem3.addActionListener(potwierdzOgloszenieListener);
        jPopupMenu1.add(menuItem3);
        
        JMenuItem menu3 = new JMenuItem("Przedu wano ogoszenia");
        menu3.addActionListener(potwierdzOgloszenieListener);
        jPopupMenu2.add(menu3);
        
        JMenuItem menuItem4 = new JMenuItem("Przedu okres opacenia ogoszenia");
        menuItem4.addActionListener(przedluzOgloszenieListener);
        jPopupMenu2.add(menuItem4);
        
        JMenuItem menuItem5 = new JMenuItem("Zmie na bezpatne ogoszenie");
        menuItem5.addActionListener(zmienNaBezplatneOgloszenieListener);
        jPopupMenu2.add(menuItem5);
        
        MouseListener popupListener = new PopupListener();
        jList1.addMouseListener(popupListener);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPopupMenu1 = new javax.swing.JPopupMenu();
        jPopupMenu2 = new javax.swing.JPopupMenu();
        jScrollPane1 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();

        setLayout(new java.awt.BorderLayout());

        jScrollPane1.setViewportView(jList1);

        add(jScrollPane1, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JList jList1;
    private javax.swing.JPopupMenu jPopupMenu1;
    private javax.swing.JPopupMenu jPopupMenu2;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables
    private DefaultListModel przerobNaModel(List list) {
        DefaultListModel ret = new DefaultListModel();
        Iterator iter = list.iterator();
        
        for (; iter.hasNext();) {
            ret.addElement(new OgloszenieListModel((Ogloszenie) iter.next()));
        }
        return ret;
    }
    
    /** Odebranie wynikw 
     * @param list Lista z wynikami wyszukiwania
     */
    public void odbierzWyniki(List list) {
        KonsolaAdministratora.ustawNastPoprz(list.size());
        jList1.setModel(przerobNaModel(list));
    }
}
