/*
 * WidokZadanBiezacych.java
 *
 * Created on 6 kwiecie 2004, 19:46
 */

package admin;

import java.util.List;
import java.util.Iterator;
import java.util.ArrayList;
import shared.Ogloszenie;
import komponenty.models.OgloszenieListModel;
import javax.swing.DefaultListModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;


/**
 * Widok umowiajcy Administratorowi kontrol nad najpilniejszymi
 * zadaniami
 * @author witus
 * @version %I% %G%
 */
public class WidokZadanBiezacych extends javax.swing.JPanel {
    
    class PopupListener extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (((javax.swing.JList) e.getComponent()).getSelectedValue() == null)
                    return;
                        
                jPopupMenu1.show(e.getComponent(),
                           e.getX(), e.getY());
            }
        }
    }
    
    class PopupListener2 extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (((javax.swing.JList) e.getComponent()).getSelectedValue() == null)
                    return;
                        
                jPopupMenu2.show(e.getComponent(),
                           e.getX(), e.getY());
            }
        }
    }
    
    class PopupListener3 extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (((javax.swing.JList) e.getComponent()).getSelectedValue() == null)
                    return;
                        
                jPopupMenu3.show(e.getComponent(),
                           e.getX(), e.getY());
            }
        }
    }
    
    /** Tworzy nowy widok WidokZadanBiezacych */
    public WidokZadanBiezacych() {
        initComponents();
        
        /* Menu nowych ogosze */
        JMenuItem menuItem0 = new JMenuItem("Zatwierd ogoszenie");
        menuItem0.addActionListener(zatwierdzNoweOgloszenieListener);
        jPopupMenu1.add(menuItem0);
        
        JMenuItem menuItem1 = new JMenuItem("Edytuj ogoszenie");
        menuItem1.addActionListener(edytujNoweOgloszenieListener);
        jPopupMenu1.add(menuItem1);
        
        JMenuItem menuItem2 = new JMenuItem("Usu ogoszenie");
        menuItem2.addActionListener(usunNoweOgloszenieListener);
        jPopupMenu1.add(menuItem2);
        
        MouseListener popupListener = new PopupListener();
        jList1.addMouseListener(popupListener);
        
        /* Menu nieaktualnych ogosze */
        menuItem0 = new JMenuItem("Przedu wano ogoszenia");
        menuItem0.addActionListener(potwierdzOgloszenieListener);
        jPopupMenu2.add(menuItem0);
        
        menuItem1 = new JMenuItem("Usu ogoszenie");
        menuItem1.addActionListener(usunNieaktualneOgloszenieListener);
        jPopupMenu2.add(menuItem1);
        
        popupListener = new PopupListener2();
        jList2.addMouseListener(popupListener);
        
        /* Menu nieopaconych ogosze */
        menuItem0 = new JMenuItem("Przedu okres opacenia ogoszenia");
        menuItem0.addActionListener(przedluzOgloszenieListener);
        jPopupMenu3.add(menuItem0);
        
        menuItem1 = new JMenuItem("Zmie na bezpatne ogoszenie");
        menuItem1.addActionListener(zmienNaBezplatneOgloszenieListener);
        jPopupMenu3.add(menuItem1);
        
        popupListener = new PopupListener3();
        jList3.addMouseListener(popupListener);
    }
    
    private ActionListener zatwierdzNoweOgloszenieListener = new ActionListener() {
        public void actionPerformed(ActionEvent a) {
            OgloszenieListModel ogloszenieListModel = (OgloszenieListModel) jList1.getSelectedValue();
            if (ogloszenieListModel == null) return;
            KonsolaAdministratora.zatwierdzNoweOgloszenie(ogloszenieListModel.getOgloszenie());
        }  
    };
    
    private ActionListener edytujNoweOgloszenieListener = new ActionListener() {
        public void actionPerformed(ActionEvent a) {  
            OgloszenieListModel ogloszenieListModel = (OgloszenieListModel) jList1.getSelectedValue();
            if (ogloszenieListModel == null) return;
            KonsolaAdministratora.pokazWidokOgloszenia(ogloszenieListModel.getOgloszenie());    
        }
    };
    
    private ActionListener usunNieaktualneOgloszenieListener = new ActionListener() {
        public void actionPerformed(ActionEvent a) {
            OgloszenieListModel ogloszenieListModel = (OgloszenieListModel) jList2.getSelectedValue();
            if (ogloszenieListModel == null) return;      
            KonsolaAdministratora.usunNieaktualneOgloszenie(ogloszenieListModel.getOgloszenie());
        }
    };
    
     private ActionListener usunNoweOgloszenieListener = new ActionListener() {
        public void actionPerformed(ActionEvent a) {
            OgloszenieListModel ogloszenieListModel = (OgloszenieListModel) jList1.getSelectedValue();
            if (ogloszenieListModel == null) return;
            KonsolaAdministratora.usunNoweOgloszenie(ogloszenieListModel.getOgloszenie());
        }
    };
    
    private ActionListener potwierdzOgloszenieListener = new ActionListener() {
        public void actionPerformed(ActionEvent a) {
            OgloszenieListModel ogloszenieListModel = (OgloszenieListModel) jList2.getSelectedValue();
            if (ogloszenieListModel == null) return;
            KonsolaAdministratora.potwierdzAktualnoscOgloszenia(ogloszenieListModel.getOgloszenie());
        }
    };
    
    private ActionListener zmienNaBezplatneOgloszenieListener = new ActionListener() {
        public void actionPerformed(ActionEvent a) {
            OgloszenieListModel ogloszenieListModel = (OgloszenieListModel) jList3.getSelectedValue();
            if (ogloszenieListModel == null) return;
            KonsolaAdministratora.zmienNaBezplatnieOgloszenie(ogloszenieListModel.getOgloszenie().getPlatne());
        }
    };
    
    private ActionListener przedluzOgloszenieListener = new ActionListener() {
        public void actionPerformed(ActionEvent a) {
            OgloszenieListModel ogloszenieListModel = (OgloszenieListModel) jList3.getSelectedValue();
            if (ogloszenieListModel == null) return;
            KonsolaAdministratora.pokazWidokPrzedluzania(ogloszenieListModel.getOgloszenie());
        }
    };
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPopupMenu1 = new javax.swing.JPopupMenu();
        jPopupMenu2 = new javax.swing.JPopupMenu();
        jPopupMenu3 = new javax.swing.JPopupMenu();
        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();
        jPanel2 = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jList2 = new javax.swing.JList();
        jPanel3 = new javax.swing.JPanel();
        jScrollPane3 = new javax.swing.JScrollPane();
        jList3 = new javax.swing.JList();

        setLayout(new java.awt.GridLayout(3, 0));

        setBorder(new javax.swing.border.TitledBorder("Bie\u017c\u0105ce Zadania"));
        jPanel1.setLayout(new java.awt.BorderLayout());

        jPanel1.setBorder(new javax.swing.border.TitledBorder("Nowe ogloszenia"));
        jScrollPane1.setViewportView(jList1);

        jPanel1.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        add(jPanel1);

        jPanel2.setLayout(new java.awt.BorderLayout());

        jPanel2.setBorder(new javax.swing.border.TitledBorder("Nieaktualne og\u0142oszenia"));
        jScrollPane2.setViewportView(jList2);

        jPanel2.add(jScrollPane2, java.awt.BorderLayout.CENTER);

        add(jPanel2);

        jPanel3.setLayout(new java.awt.BorderLayout());

        jPanel3.setBorder(new javax.swing.border.TitledBorder("Nieop\u0142acone og\u0142oszenia"));
        jScrollPane3.setViewportView(jList3);

        jPanel3.add(jScrollPane3, java.awt.BorderLayout.CENTER);

        add(jPanel3);

    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JList jList1;
    private javax.swing.JList jList2;
    private javax.swing.JList jList3;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPopupMenu jPopupMenu1;
    private javax.swing.JPopupMenu jPopupMenu2;
    private javax.swing.JPopupMenu jPopupMenu3;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    // End of variables declaration//GEN-END:variables
    
    private DefaultListModel przerobNaModel(List list) {
        DefaultListModel ret = new DefaultListModel();
        Iterator iter = list.iterator();
        
        for (; iter.hasNext();) {
            ret.addElement(new OgloszenieListModel((Ogloszenie) iter.next()));
        }
        return ret;
    }
    
    
    
    /** 
     * Odebranie listy nowych Ogosze
     * @param list odbierana lista
     */
    public void odbierzNoweOgloszenia(List list) {
        jList1.setModel(przerobNaModel(list));
    }
    
    /** 
     * Odebranie listy niekaktualnych Ogosze
     * @param list odbierana lista
     */
    public void odbierzNieakualneOgloszenia(List list) {
        jList2.setModel(przerobNaModel(list));
    }
    
    /** 
     * Odebranie listy nieopaconych Ogosze
     * @param list odbierana lista
     */
    public void odbierzNieoplaconeOgloszenia(List list) {
        jList3.setModel(przerobNaModel(list));
    }
    
    
}
