/*
 * EdytujWarstwe.java
 *
 * Created on 20 kwiecie 2004, 18:01
 */

package admin.mapa;

import shared.*;
import javax.swing.*;
import java.lang.*;
import java.awt.event.*;

/** Okienko modyfikacji danych o warstwie.
 *
 * @author  me201258
 */
public class EdytujWarstwe extends javax.swing.JDialog {
    /** Warstwa, ktrej dane obrabiamy. */
    private WarstwaMapy warstwa;
    /** true jeli uytkownik zaakcpetowa zmiany, false wpp. */
    public boolean czy;
    
    /** Tworzy nowy obiekt klasy EdytujWarstwe, inicjalizuje wszystkie komponenty. 
     *  @param parent ramka-rodzic wzgldem tego obiektu
     *  @param modal czy to okno ma by modalne
     */
    public EdytujWarstwe(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
    }
    
    /** Inicjalizuje wszystkie komponenty. */
    private void initComponents() {//GEN-BEGIN:initComponents
        opisLabel = new javax.swing.JLabel();
        skalaLabel = new javax.swing.JLabel();
        opisTextField = new javax.swing.JTextField();
        skalaTextField = new javax.swing.JTextField();
        OKButton = new javax.swing.JButton();
        AnulujButton = new javax.swing.JButton();
        RozmiarXLabel = new javax.swing.JLabel();
        rozmiarXField = new javax.swing.JTextField();
        rozmiarYField = new javax.swing.JTextField();
        RozmiarYLabel = new javax.swing.JLabel();

        getContentPane().setLayout(null);

        setTitle("Zmiana danych Warstwy");
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        opisLabel.setText("Opis Warstwy (np 1:50000)");
        opisLabel.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        getContentPane().add(opisLabel);
        opisLabel.setBounds(10, 30, 170, 19);

        skalaLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        skalaLabel.setText("Skala");
        getContentPane().add(skalaLabel);
        skalaLabel.setBounds(140, 60, 40, 19);

        opisTextField.setColumns(20);
        opisTextField.setToolTipText("opis warstwy");
        getContentPane().add(opisTextField);
        opisTextField.setBounds(190, 30, 160, 23);

        skalaTextField.setToolTipText("skala warstwy (licczba zmiennoprzecinkowa)");
        getContentPane().add(skalaTextField);
        skalaTextField.setBounds(190, 60, 160, 23);

        OKButton.setText("Zatwierd\u017a");
        OKButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                OKButtonActionPerformed(evt);
            }
        });

        getContentPane().add(OKButton);
        OKButton.setBounds(30, 150, 130, 40);

        AnulujButton.setText("Anuluj");
        AnulujButton.setPreferredSize(new java.awt.Dimension(96, 29));
        AnulujButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                AnulujButtonActionPerformed(evt);
            }
        });

        getContentPane().add(AnulujButton);
        AnulujButton.setBounds(200, 150, 140, 40);

        RozmiarXLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        RozmiarXLabel.setText("Szeroko\u015b\u0107 (X)");
        getContentPane().add(RozmiarXLabel);
        RozmiarXLabel.setBounds(40, 90, 140, 19);

        rozmiarXField.setToolTipText("szeroko\u015b\u0107 (w pikselach) jednego fragmentu mapy");
        getContentPane().add(rozmiarXField);
        rozmiarXField.setBounds(190, 90, 160, 23);

        rozmiarYField.setToolTipText("wysoko\u015b\u0107 (w pikselach) jednego fragmentu mapy");
        getContentPane().add(rozmiarYField);
        rozmiarYField.setBounds(190, 120, 160, 23);

        RozmiarYLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        RozmiarYLabel.setText("Wysoko\u015b\u0107 (Y)");
        getContentPane().add(RozmiarYLabel);
        RozmiarYLabel.setBounds(90, 120, 90, 19);

        pack();
    }//GEN-END:initComponents

    private void AnulujButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_AnulujButtonActionPerformed
        zamknij(false);
    }//GEN-LAST:event_AnulujButtonActionPerformed

    private void OKButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_OKButtonActionPerformed
        try {
            warstwa.setOpis(opisTextField.getText());
            warstwa.setSkala(Float.parseFloat(skalaTextField.getText()));
            warstwa.setRozmiar_x(Integer.parseInt(rozmiarXField.getText()));
            warstwa.setRozmiar_y(Integer.parseInt(rozmiarYField.getText()));
            zamknij(true);
        } catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Nieprawidowe dane!", "Uwaga!", JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_OKButtonActionPerformed
    
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        dispose();
    }//GEN-LAST:event_closeDialog
    
    /** Zamyka okienko, zapamitujc sposb wyjcia uytkownika.
     *  @param czyOK true jeli uytkownik wcisn OK, false wpp.
     */
    public void zamknij(boolean czyOK) {
        czy = czyOK;
        closeDialog(null);
    }
    
    /** Ustawia zaznaczenie na podanym polu - od pocztku do koca tekstu.
     *  @param pole pole, w ktrym chcemy ustawi znaznaczenie
     */
    private void ustawZaznaczenie(JTextField pole) {
        pole.setSelectionEnd(skalaTextField.getText().length() > 0 ? skalaTextField.getText().length() - 1 : 0);
        pole.setSelectionStart(0);
    }
    
    /** Inicjalizuje komponenty.
     *  @param warstwa warstwa mapy, ktr bdziemy modyfikowa.
     */
    public void initPola(WarstwaMapy warstwa) {
        this.warstwa = warstwa;
        skalaTextField.setText(Float.toString(warstwa.getSkala()));
        ustawZaznaczenie(skalaTextField);
        opisTextField.setText(warstwa.getOpis());
        ustawZaznaczenie(opisTextField);
        rozmiarXField.setText(Integer.toString(warstwa.getRozmiar_x()));
        ustawZaznaczenie(rozmiarXField);
        rozmiarYField.setText(Integer.toString(warstwa.getRozmiar_y()));
        ustawZaznaczenie(rozmiarYField);
    }

    /** Uruchamia okienko modyfikacji danych o warstwie.
     *  @param warstwa warstwa mapy, ktr bdziemy modyfikowa
     *  @return obiekt EdytujWarstwe
     */
    public static EdytujWarstwe main(WarstwaMapy warstwa) {
        EdytujWarstwe ew = new EdytujWarstwe(new JFrame(), true);
        ew.setSize(400,300);
        ew.initPola(warstwa);
        ew.setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        ew.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                ((EdytujWarstwe) e.getSource()).zamknij(false);
            }
        });
        ew.show();
        return ew;
    }

   
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton AnulujButton;
    private javax.swing.JButton OKButton;
    private javax.swing.JLabel RozmiarXLabel;
    private javax.swing.JLabel RozmiarYLabel;
    private javax.swing.JLabel opisLabel;
    private javax.swing.JTextField opisTextField;
    private javax.swing.JTextField rozmiarXField;
    private javax.swing.JTextField rozmiarYField;
    private javax.swing.JLabel skalaLabel;
    private javax.swing.JTextField skalaTextField;
    // End of variables declaration//GEN-END:variables
    
}
