/*
 * FragmentyUlicyPanel.java
 *
 * Created on 25 kwiecie 2004, 16:03
 */

package admin.mapa;

import javax.swing.*;
import javax.swing.event.*;
import shared.*;
import admin.KonsolaAdministratora;

/** Panel obsugi fragmentw ulicy. Zawiera okienko z list fragmentw, pola 
 *  i klawisze umoliwiajce usuwanie i zmian fragmentw oraz usuwanie i zmian
 *  nazwy ulicy.
 *
 * @author  me201258
 */
public class FragmentyUlicyPanel
                extends javax.swing.JPanel 
                implements ListSelectionListener {
    /** Bieca ulica.*/
    private Ulica biezUlica = null;
    /** Fragmenty biecej ulicy. */
    private FragmentUlicy[] biezFr = null;
    /** Zaznaczony przez uytkownika fragment. */
    private FragmentUlicy wybranyFr;
    /** Model listy fragmentw - potrzebny do JLista. */
    public DefaultListModel modelListy = new DefaultListModel();
    /** Obiekt nawigacji mapy administratora. */
    private NawigacjaMapaAdmin nma;
    
    /** Pomocnicza metoda zwracajca tekstow reprezentacj danego fragmentu ulicy. 
     *  @param fr fragment ulicy do opisania
     *  @return tekstowa reprezentacja fragmentu
     */
    private String fragmentToString(FragmentUlicy fr) {
        return fr.getNr_pocz() + " <-> " + fr.getNr_konc();
    }
    
    /** Inicjalizuje widok panelu fragmentw mapy w opraciu o now ulic i jej  fragmenty.
     *  @param ul ulica
     *  @param fr fragmenty ulicy
     */
    public void zbudujWidok(Ulica ul, FragmentUlicy[] fr) {
        int i;
        
        biezFr = fr;
        modelListy.clear();
        nrDoTextField.setEnabled(false);
        nrOdTextField.setEnabled(false);
        usunFrUlicyButton.setEnabled(false);
        biezUlica = ul;
        if (ul != null) {
            if (fr != null)
                for (i = 0; i < fr.length; i++)
                    modelListy.addElement(fragmentToString(fr[i]));
            nazwaUlicyLabel.setText(ul.getNazwa());
            zatwierdzPrzebiegButton.setEnabled(true);
            zmienNazweButton.setEnabled(true);
            usunUliceButton.setEnabled(true);
        } else {
            nazwaUlicyLabel.setText("");
            zatwierdzPrzebiegButton.setEnabled(false);
            zmienNazweButton.setEnabled(false);
            usunUliceButton.setEnabled(false);
        }
    }
    
    /** Aktualizuje widok po zainstniaych zmianach we fragmentach ulic (zaszych
     *  np. w nawigacji mapy administratora.
     *  @param fr nowa wersja fragmentw mapy
     *  @param wybor wybrany przez uytkownika fragment
     */
    public void zaktualizujWidok(FragmentUlicy[] fr, int wybor) {
        int i;
        biezFr = fr;
        modelListy.clear();
        for (i = 0; i < fr.length; i++)
            modelListy.addElement(fragmentToString(fr[i]));
        if (fr.length > 0) {
            wybranyFr = fr[wybor-1];
            frUlicyList.setSelectedIndex(wybor - 1);
        } else {
            wybranyFr = null;
            nrOdTextField.setText("");
            nrDoTextField.setText("");
        }
        nrDoTextField.setEnabled(fr.length > 0);
        nrOdTextField.setEnabled(fr.length > 0);
        usunFrUlicyButton.setEnabled(fr.length > 0);
    }

    /** Metoda nasuchuje zmian w licie fragmentw ulicy.
     *  @param lse zasze zdarzenie zmiany selekcji
     */
    public void valueChanged(ListSelectionEvent lse) {
        if (!lse.getValueIsAdjusting()) {
            int nv = frUlicyList.getSelectedIndex();
            if (nv == -1) {
                nrDoTextField.setEnabled(false);
                nrOdTextField.setEnabled(false);
                usunFrUlicyButton.setEnabled(false);
                wybranyFr = null;
            } else {
                nrDoTextField.setEnabled(true);
                nrOdTextField.setEnabled(true);
                usunFrUlicyButton.setEnabled(true);
                wybranyFr = biezFr[nv];
                nrOdTextField.setText(wybranyFr.getNr_pocz() > 0 ? Integer.toString(wybranyFr.getNr_pocz()) : "");
                nrDoTextField.setText(wybranyFr.getNr_konc() > 0 ? Integer.toString(wybranyFr.getNr_konc()) : "");
                nrOdTextField.grabFocus();
            }
            nma.wybranoFragmentUlicy(nv);
        }
    }
    
    /** Tworzy nowy obiekt klasy FragmentyUlicyPanel.
     *  @param nma wywoujca nas nawigacja mapy administratora
     */
    public FragmentyUlicyPanel(NawigacjaMapaAdmin nma) {
        initComponents();
        frUlicyList.addListSelectionListener(this);
        frUlicyList.setModel(modelListy);
        frUlicyScrollPane.getViewport().add(frUlicyList);
        this.nma = nma;
    }
    
    /** Zapamituje nowe numery fragmentu, wpisane przez uytkownika. */
    private void zapamietajNoweNumeryFragmentu() {
        try {
            wybranyFr.setNr_pocz(nrOdTextField.getText().length() > 0 ? Integer.parseInt(nrOdTextField.getText()) : 0);
            wybranyFr.setNr_konc(nrDoTextField.getText().length() > 0 ? Integer.parseInt(nrDoTextField.getText()) : 0);
            modelListy.set(frUlicyList.getSelectedIndex(), fragmentToString(wybranyFr));
        } catch (java.lang.NumberFormatException e) {
            JOptionPane.showMessageDialog(this, 
                            "Podane liczby s nieprawidowe!",
                            "Bd",
                            JOptionPane.WARNING_MESSAGE);
        }
    }
    /** Inicjalizuje komponenety panelu.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jLabel1 = new javax.swing.JLabel();
        nazwaUlicyLabel = new javax.swing.JLabel();
        zatwierdzPrzebiegButton = new javax.swing.JButton();
        zmienNazweButton = new javax.swing.JButton();
        przebiegPanel = new javax.swing.JPanel();
        frUlicyScrollPane = new javax.swing.JScrollPane();
        frUlicyList = new javax.swing.JList();
        nryDomowPanel = new javax.swing.JPanel();
        nryDomowLabel = new javax.swing.JLabel();
        nrOdTextField = new javax.swing.JTextField();
        nrDoLabel = new javax.swing.JLabel();
        nrDoTextField = new javax.swing.JTextField();
        usunFrUlicyButton = new javax.swing.JButton();
        takiSeparator = new javax.swing.JSeparator();
        usunUliceButton = new javax.swing.JButton();

        setLayout(null);

        setBorder(new javax.swing.border.TitledBorder("Zarz\u0105dzanie ulic\u0105"));
        setMinimumSize(new java.awt.Dimension(60, 100));
        setPreferredSize(new java.awt.Dimension(135, 28));
        jLabel1.setFont(new java.awt.Font("Dialog", 0, 10));
        jLabel1.setText("Ulica:");
        add(jLabel1);
        jLabel1.setBounds(10, 20, 30, 19);

        nazwaUlicyLabel.setFont(new java.awt.Font("Dialog", 1, 10));
        nazwaUlicyLabel.setMaximumSize(new java.awt.Dimension(60, 19));
        nazwaUlicyLabel.setMinimumSize(new java.awt.Dimension(60, 19));
        nazwaUlicyLabel.setPreferredSize(new java.awt.Dimension(60, 19));
        add(nazwaUlicyLabel);
        nazwaUlicyLabel.setBounds(40, 20, 240, 20);

        zatwierdzPrzebiegButton.setFont(new java.awt.Font("Dialog", 0, 10));
        zatwierdzPrzebiegButton.setText("Zatwierd\u017a przebieg ulicy");
        zatwierdzPrzebiegButton.setEnabled(false);
        zatwierdzPrzebiegButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                zatwierdzPrzebiegButtonActionPerformed(evt);
            }
        });

        add(zatwierdzPrzebiegButton);
        zatwierdzPrzebiegButton.setBounds(10, 290, 210, 25);

        zmienNazweButton.setFont(new java.awt.Font("Dialog", 0, 10));
        zmienNazweButton.setText("Zmie\u0144 nazw\u0119 ulicy");
        zmienNazweButton.setEnabled(false);
        zmienNazweButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                zmienNazweButtonActionPerformed(evt);
            }
        });

        add(zmienNazweButton);
        zmienNazweButton.setBounds(10, 330, 210, 25);

        przebiegPanel.setLayout(new java.awt.BorderLayout());

        przebiegPanel.setBorder(new javax.swing.border.TitledBorder("Przebieg"));
        frUlicyScrollPane.setToolTipText("lista fragment\u00f3w mapy");
        frUlicyList.setBorder(new javax.swing.border.EtchedBorder());
        frUlicyList.setFont(new java.awt.Font("Dialog", 0, 10));
        frUlicyList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        frUlicyScrollPane.setViewportView(frUlicyList);

        przebiegPanel.add(frUlicyScrollPane, java.awt.BorderLayout.CENTER);

        add(przebiegPanel);
        przebiegPanel.setBounds(10, 40, 210, 190);

        nryDomowPanel.setBorder(new javax.swing.border.TitledBorder(null, "Wybrany fragment", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 10)));
        nryDomowLabel.setFont(new java.awt.Font("Dialog", 0, 10));
        nryDomowLabel.setText("nr od:");
        nryDomowPanel.add(nryDomowLabel);

        nrOdTextField.setFont(new java.awt.Font("Dialog", 0, 10));
        nrOdTextField.setToolTipText("pocz\u0105tkowy numer domu na odcinku");
        nrOdTextField.setPreferredSize(new java.awt.Dimension(30, 19));
        nrOdTextField.setEnabled(false);
        nrOdTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                nrOdTextFieldFocusGained(evt);
            }
        });
        nrOdTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                nrOdTextFieldKeyReleased(evt);
            }
        });

        nryDomowPanel.add(nrOdTextField);

        nrDoLabel.setFont(new java.awt.Font("Dialog", 0, 10));
        nrDoLabel.setText("do:");
        nryDomowPanel.add(nrDoLabel);

        nrDoTextField.setFont(new java.awt.Font("Dialog", 0, 10));
        nrDoTextField.setToolTipText("ko\u0144cowy numer domu na odcinku");
        nrDoTextField.setPreferredSize(new java.awt.Dimension(30, 19));
        nrDoTextField.setEnabled(false);
        nrDoTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                nrDoTextFieldFocusGained(evt);
            }
        });
        nrDoTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                nrDoTextFieldKeyReleased(evt);
            }
        });

        nryDomowPanel.add(nrDoTextField);

        usunFrUlicyButton.setFont(new java.awt.Font("Dialog", 0, 10));
        usunFrUlicyButton.setText("usu\u0144 fr.");
        usunFrUlicyButton.setMaximumSize(new java.awt.Dimension(71, 20));
        usunFrUlicyButton.setMinimumSize(new java.awt.Dimension(71, 20));
        usunFrUlicyButton.setPreferredSize(new java.awt.Dimension(71, 20));
        usunFrUlicyButton.setEnabled(false);
        usunFrUlicyButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                usunFrUlicyButtonActionPerformed(evt);
            }
        });

        nryDomowPanel.add(usunFrUlicyButton);

        add(nryDomowPanel);
        nryDomowPanel.setBounds(10, 230, 210, 54);

        takiSeparator.setPreferredSize(new java.awt.Dimension(100, 2));
        add(takiSeparator);
        takiSeparator.setBounds(10, 322, 210, 2);

        usunUliceButton.setFont(new java.awt.Font("Dialog", 0, 10));
        usunUliceButton.setText("Usu\u0144 ulic\u0119");
        usunUliceButton.setMaximumSize(new java.awt.Dimension(124, 25));
        usunUliceButton.setMinimumSize(new java.awt.Dimension(124, 25));
        usunUliceButton.setPreferredSize(new java.awt.Dimension(124, 25));
        usunUliceButton.setEnabled(false);
        usunUliceButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                usunUliceButtonActionPerformed(evt);
            }
        });

        add(usunUliceButton);
        usunUliceButton.setBounds(10, 360, 210, 25);

    }//GEN-END:initComponents

    private void nrDoTextFieldFocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_nrDoTextFieldFocusGained
        nma.wybranyKoniecFrUlicy(frUlicyList.getSelectedIndex()+1);
    }//GEN-LAST:event_nrDoTextFieldFocusGained

    private void nrOdTextFieldFocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_nrOdTextFieldFocusGained
        nma.wybranyKoniecFrUlicy(-(frUlicyList.getSelectedIndex()+1));
    }//GEN-LAST:event_nrOdTextFieldFocusGained

    private void nrDoTextFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_nrDoTextFieldKeyReleased
        int kt;
        zapamietajNoweNumeryFragmentu();
        if (evt.getKeyCode() == java.awt.event.KeyEvent.VK_ENTER) {
            if (frUlicyList.getSelectedIndex() < biezFr.length-1) 
                kt = frUlicyList.getSelectedIndex()+1;
            else
                kt = 0;
            frUlicyList.setSelectedIndex(kt);
            nrOdTextField.grabFocus();
        }
    }//GEN-LAST:event_nrDoTextFieldKeyReleased

    private void nrOdTextFieldKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_nrOdTextFieldKeyReleased
        zapamietajNoweNumeryFragmentu();
        if (evt.getKeyCode() == java.awt.event.KeyEvent.VK_ENTER)
            nrDoTextField.grabFocus();
    }//GEN-LAST:event_nrOdTextFieldKeyReleased

    private void usunUliceButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_usunUliceButtonActionPerformed
    //TODO: usuwanie ulic z ogoszeniami
        try {
            KonsolaAdministratora.komSieciowa.ulice.usunUlice(biezUlica);
            JOptionPane.showMessageDialog(this, "Ulica usunita!");
            zbudujWidok(null, null);
            nma.usunietaUlica();
        } catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Nie udao si usun ulicy!", "Bd!", JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_usunUliceButtonActionPerformed

    private void usunFrUlicyButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_usunFrUlicyButtonActionPerformed
        int kt = frUlicyList.getSelectedIndex();
        FragmentUlicy[] nowa = new FragmentUlicy[biezFr.length-1];
        int i;
        
        for (i=0;i<biezFr.length;i++) {
            if (i<kt)
                nowa[i] = biezFr[i];
            else
                if (i>kt)
                    nowa[i-1] = biezFr[i];
        }
        zaktualizujWidok(nowa, kt>1 ? (kt < biezFr.length ? kt : kt-1) : 1);
        nma.zmienioneFragmentyUlicy(nowa);
    }//GEN-LAST:event_usunFrUlicyButtonActionPerformed

    private void zatwierdzPrzebiegButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_zatwierdzPrzebiegButtonActionPerformed
        try {
            int i;
            boolean czy = true;
            for (i = 0;i<biezFr.length && czy;i++) {
                if (biezFr[i].getNr_konc() == 0 || biezFr[i].getNr_pocz() == 0)
                    czy = false;
            }
            if (czy) {
                KonsolaAdministratora.komSieciowa.ulice.zapiszPrzebiegUlicy(biezUlica, biezFr);
                JOptionPane.showMessageDialog(this, "Przebieg ulicy zosta zapamitany!");
            } else 
                JOptionPane.showMessageDialog(this, "Nieprawidowo zdefiniowane numery domw\n(s zera lub przedziay nie s rozczne)!", "Bd!", JOptionPane.ERROR_MESSAGE);
        } catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Nie udao si zapamita na serwerze nowego przebiegu ulicy!", 
                            "Bd", JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_zatwierdzPrzebiegButtonActionPerformed

    private void zmienNazweButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_zmienNazweButtonActionPerformed
        String nowaNazwa;
        
        nowaNazwa = JOptionPane.showInputDialog(this, "Wprowad now nazw ulicy", biezUlica.getNazwa());
        if (nowaNazwa != null) {
            try {
                KonsolaAdministratora.komSieciowa.ulice.zmienNazweUlicy(biezUlica, nowaNazwa);
                nazwaUlicyLabel.setText(nowaNazwa);
                biezUlica.setNazwa(nowaNazwa);
                JOptionPane.showMessageDialog(this, "Nazwa zmieniona");
            } catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Nie udao si zaktualizowac nazwy ulicy na serwerze!", "Bd", JOptionPane.ERROR_MESSAGE);
            }
        }
    }//GEN-LAST:event_zmienNazweButtonActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JList frUlicyList;
    private javax.swing.JScrollPane frUlicyScrollPane;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel nazwaUlicyLabel;
    private javax.swing.JLabel nrDoLabel;
    private javax.swing.JTextField nrDoTextField;
    private javax.swing.JTextField nrOdTextField;
    private javax.swing.JLabel nryDomowLabel;
    private javax.swing.JPanel nryDomowPanel;
    private javax.swing.JPanel przebiegPanel;
    private javax.swing.JSeparator takiSeparator;
    private javax.swing.JButton usunFrUlicyButton;
    private javax.swing.JButton usunUliceButton;
    private javax.swing.JButton zatwierdzPrzebiegButton;
    private javax.swing.JButton zmienNazweButton;
    // End of variables declaration//GEN-END:variables
    
}
