/*
 * NawigacjaMapaAdmin.java
 *
 * Created on 23 kwiecie 2004, 17:40
 */

package admin.mapa;

import admin.KomSieciowa;
import komponenty.*;
import shared.*;

import java.io.File;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.util.*;

/** Obsuga nawigacji po mapie dla admina. Rozszerza standardow klas ({@link komponenty.NawigacjaMapa})
 *  o administrowanie warstwami, fragmentami mapy, ulicami i fragmentami ulic.
 *
 * @author  me201258
 */
public class NawigacjaMapaAdmin extends komponenty.NawigacjaMapa {
    /** Wybieracz plikw - do wskazywania obrazkw mapy. */
    private JFileChooser frMapyFileChooser;
    /** Odpowiedni obiekt komunikacji sieciowej. */
    private KomSieciowa komSieciowa;
    /** Klawisz edycji warstwy. */
    private JButton edytujWarstweButton;
    /** Klawisz nowej warstwy. */
    private JButton nowaWarstwaButton;
    /** Klawisz wczajcy tryb przenoszenia punktu 0,0.*/
    private JToggleButton zaznaczanie00;
    /** Panel obsugi fragmentw ulicy. */
    private FragmentyUlicyPanel frUlicyPanel;
    /** Indeks wybranej ulicy.*/
    private int wybranyFrUlicy = -1;
    /** Lista wierzchokw fragmentw ulic w selekcji. */
    private ArrayList zaznaczoneWierzcholki = new ArrayList();
    /** Zaznaczony nowy punkt. */
    private Point nowyPkt = null;
    /** true jeli jestemy w trybie przenoszenia 0,0. */
    private boolean czyZaznaczanie00 = false;
    /** Indeks wybranego koca fragmentu ulicy. */
    private int wybranyKoniecUlicy = 0;
    /** Wielko zaznaczenia (poowa szerokoci krzyyka). */
    private final int wielkoscZaznaczenia = 5;
    /** Kolor fragmentu ulicy.*/
    private final Color kolorUlicy = Color.GRAY;
    /** Kolor zaznaczonego fragmentu ulicy. */
    private final Color kolorZUlicy = Color.DARK_GRAY;
    /** Kolor zaznaczonego punktu. */
    private final Color kolorZPunktu = Color.DARK_GRAY;
    /** Kolor nowego punktu. */
    private final Color kolorNPunktu = Color.BLUE;
    /** Kolor punktu 0,0.*/
    private final Color kolor00 = Color.GREEN;
    /** Stroke rysowania ulic i punktw.*/
    private final Stroke strokeZaznaczenia = new BasicStroke(3.0f);
    
    /** Tworzy nowy obiekt NawigacjaMapaAdmin. */
    public NawigacjaMapaAdmin() {
        Dimension dwp;
        
        edytujWarstweButton = new JButton("zmie dane warstwy");
        
        edytujWarstweButton.setFont(new java.awt.Font("Dialog", 0, 9));
        edytujWarstweButton.setMaximumSize(new java.awt.Dimension(125, 20));
        edytujWarstweButton.setMinimumSize(new java.awt.Dimension(125, 20));
        edytujWarstweButton.setPreferredSize(new java.awt.Dimension(125, 20));
        edytujWarstweButton.setEnabled(false);
        edytujWarstweButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                edytujWarstweButtonActionPerformed(evt);
            }
        });
        warstwyPanel.add(edytujWarstweButton);

        nowaWarstwaButton = new JButton("nowa warstwa");
        nowaWarstwaButton.setFont(new java.awt.Font("Dialog", 0, 9));
        nowaWarstwaButton.setMaximumSize(new java.awt.Dimension(125, 20));
        nowaWarstwaButton.setMinimumSize(new java.awt.Dimension(125, 20));
        nowaWarstwaButton.setPreferredSize(new java.awt.Dimension(125, 20));
        nowaWarstwaButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                nowaWarstwaButtonActionPerformed(evt);
            }
        });
        warstwyPanel.add(nowaWarstwaButton);
        
        zaznaczanie00 = new JToggleButton("zaznaczanie [0,0]", false);
        zaznaczanie00.setFont(new java.awt.Font("Dialog", 0, 9));
        zaznaczanie00.setMaximumSize(new java.awt.Dimension(125, 20));
        zaznaczanie00.setMinimumSize(new java.awt.Dimension(125, 20));
        zaznaczanie00.setPreferredSize(new java.awt.Dimension(125, 20));
        zaznaczanie00.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                zaznaczanie00ToggleButtonActionPerformed();
            }
        });
        warstwyPanel.add(zaznaczanie00);
        
        dwp = new Dimension(warstwyPanel.getPreferredSize().width,
                            warstwyPanel.getPreferredSize().height+20*3+10);
        warstwyPanel.setMinimumSize(dwp);
        warstwyPanel.setPreferredSize(dwp);
        warstwyPanel.validate();
        
        frMapyFileChooser = new JFileChooser();
        frUlicyPanel = new FragmentyUlicyPanel(this);
        frUlicyPanel.setMinimumSize(new Dimension(228, 393));
        frUlicyPanel.setPreferredSize(new Dimension(228, 393));
        glownyPrawyPanel.add(frUlicyPanel);
    }

    /** Metoda woana, by powiadomi NawigacjaMapaAdmin o dokonaniu przez uytkownika wyboru
     *  koca fragmentu ulicy w panelu obsugi fragmentw ulicy.
     *  @param nr liczba, reprezentujca wybrany koniec fragmentu (= (poczatek ? (-1) : 1) * (nr fragmentu + 1))
     */
    public void wybranyKoniecFrUlicy(int nr) {
        wybranyKoniecUlicy = nr;
        repaint();
    }
    
    private void zaznaczanie00ToggleButtonActionPerformed() {
        czyZaznaczanie00 = !czyZaznaczanie00;
    }
    
    /** Reakcja na wybranie przez uytkownika fragmentu ulicy.
     *  @param indeks indeks wybranego fragmentu.
     */
    public void wybranoFragmentUlicy(int indeks) {
        wybranyFrUlicy = indeks;
        repaint();
    }

    /** Zaznacza na mapie punkt o wsprzdnych bezwzgldnych mapowych (nie ekranowych).
     *  @param czyKrzyzyk czy zaznaczenie ma by krzyykiem (jeli nie, to kkiem)
     *  @param mg obszar do rysowania
     *  @param kolor kolor
     *  @param p punkt do zaznaczenia (wsprzdne mapowe bezwzgldne)
     */
    private void zaznaczPunkt(boolean czyKrzyzyk, Graphics2D mg, Color kolor, Point p) {
        Point p2 = PomocnikMapy.bezwzgledneNaWzgledne(biezacaWarstwa, p);
        p2.x -= lewyGornyPkt.x;
        p2.y -= lewyGornyPkt.y;
        mg.setColor(kolor);
        if (czyKrzyzyk) {
            mg.drawLine(p2.x-wielkoscZaznaczenia, p2.y, p2.x+wielkoscZaznaczenia, p2.y);
            mg.drawLine(p2.x, p2.y-wielkoscZaznaczenia, p2.x, p2.y+wielkoscZaznaczenia);
        } else 
            mg.drawOval(p2.x-wielkoscZaznaczenia, p2.y-wielkoscZaznaczenia, 2*wielkoscZaznaczenia, 2*wielkoscZaznaczenia);
    }

    /** Rysuje fragmenty ulic.
     *  @param g
     */
    private void rysujFragmentyUlic(Graphics g) {
        if (biezacaWarstwa == null || fragmenty == null || lewyGornyPkt == null)
            return;
        
//        System.out.println("rysujFragmentyUlic2 ("+wybranyFrUlicy+")");
        
        Graphics2D mg = (Graphics2D) g.create(pomMapaPanel.getLocation().x,
                               pomMapaPanel.getLocation().y,
                               mapaPanel.getWidth(),
                               mapaPanel.getHeight());
        mg.setStroke(strokeZaznaczenia);
        
        zaznaczPunkt(true, mg, kolor00, new Point(0,0));
        
        //zaznaczamy wyrniony koniec fragmentu
        if (wybranyKoniecUlicy != 0) {
            FragmentUlicy fr = frUlicy[Math.abs(wybranyKoniecUlicy)-1];
            Point p;
            if (wybranyKoniecUlicy > 0)
                p = new Point(fr.getWsp_konc_x(), fr.getWsp_konc_y());
            else
                p = new Point(fr.getWsp_pocz_x(), fr.getWsp_pocz_y());
            zaznaczPunkt(false, mg, kolorUlicy, p);
        }

        if (frUlicy != null) 
            if (frUlicy.length > 0) {
//                System.out.println("frUlicy.length>0");
                int i;
                Point poczf, konf;
                
                //rysujemy fragmenty
                for (i=0; i<frUlicy.length; i++) {
                    mg.setColor(i == wybranyFrUlicy ? kolorZUlicy : kolorUlicy);
                    poczf = PomocnikMapy.bezwzgledneNaWzgledne(biezacaWarstwa, new Point(frUlicy[i].getWsp_pocz_x(), frUlicy[i].getWsp_pocz_y()));
                    konf = PomocnikMapy.bezwzgledneNaWzgledne(biezacaWarstwa, new Point(frUlicy[i].getWsp_konc_x(), frUlicy[i].getWsp_konc_y()));
                    poczf.x -= lewyGornyPkt.x;
                    poczf.y -= lewyGornyPkt.y;
                    konf.x -= lewyGornyPkt.x;
                    konf.y -= lewyGornyPkt.y;
                    mg.drawLine(poczf.x, poczf.y, konf.x, konf.y);
                }
                
                //zaznaczamy zaznaczone przez usera wierzchoki
                if (zaznaczoneWierzcholki.size() > 0) {
                    ListIterator li = zaznaczoneWierzcholki.listIterator();
                    while (li.hasNext()) {
                        int n = ((Integer) li.next()).intValue();
                        FragmentUlicy fr = frUlicy[Math.abs(n)-1];
                        Point p;
                        if (n > 0)
                            p = new Point(fr.getWsp_konc_x(), fr.getWsp_konc_y());
                        else
                            p = new Point(fr.getWsp_pocz_x(), fr.getWsp_pocz_y());
                        zaznaczPunkt(true, mg, kolorZPunktu, p);
                    } //while
                } //if zaznaczone
                
            } //if length > 0

        //zaznaczamy nowe wierzchoki
        if (nowyPkt != null)
            zaznaczPunkt(true, mg, kolorNPunktu, nowyPkt);
    }
    
    protected void fragmentyMapyNarysowane() {
        repaint();
    }
    
    public void paint(Graphics g) {
//        System.out.println("paint!");
        super.paint(g);
        rysujFragmentyUlic(g);
    }
    
    /** Oblicza indeks fragmentu mapy, na ktrym zostao wywoane popup menu,
     *  z ktrego wybrano pozycj, co wygenerowao zadany ActionEvent.
     *  @param evt zdarzenie wybrania pozycji z popup menu
     *  @return indeks fragmentu mapy
     */
    private int przeliczPopupActionEventNaIndeksFM(ActionEvent evt) {
        //evt.getSource - rdo (JMenuItem)
        //JMenuItem .getParent() - rodzic (JPopupMenu)
        //JPopupMenu .getInvoker() - skd - (JLabel)
        JLabel jl = ((JLabel) ((JPopupMenu) ((JMenuItem)evt.getSource())
                                                .getParent())
                                .getInvoker());
        Point p = jl.getLocation();

        //wszystkie JLabele wewntrz mapaPanel powinny mie tak sam wielko
        //wic dzielimy przez wielko jednego
        int x = p.x / jl.getSize().width;
        int y = p.y / jl.getSize().height;
        return y*ileFragmentow + x;
    }
    
    /** Przeprowadza skomplikowan procedur dodawania fragmentu mapy w miejsce
     *  o zadanym indeksie.
     *  @param indeks indeks fragmentu mapy, ktry ma by dodany
     */
    private void zapiszFragment(int indeks, int przesunieciex) {
        File plik;
        PlikGraficzny pg;
        int gdzieX = 0, gdzieY = 0;
        FragmentMapy bazowy = null;

        if (ileAktywnychFragmentow == 0) {//na mapie nie aktywnych fragmentw
            if (centralnyPkt.x == 0 && centralnyPkt.y == 0) { //to bdzie inicjalny fragment na tej warstwie
                gdzieX = 0;
                gdzieY = 0;
                JOptionPane.showMessageDialog(
                    this,
                    "To jest pierwszy fragment mapy na tej warstwie!\n"
                    + "Jego grnemu lewemu rogowi zostan przypisane wsprzdne (0,0)\n"
                    + "a warstwa zostanie powizana tym punktem z innymi.",
                    "Informacja",
                    JOptionPane.INFORMATION_MESSAGE);
            } else { //jestemy gdzie z boku centrum, nie ma punktu odniesienia
                JOptionPane.showMessageDialog(
                    this,
                    "Jeste gdzie z boku mapy. Przenie si tak, aby byo wida jaki fragment mapy.",
                    "Bd",
                    JOptionPane.ERROR_MESSAGE);
                return;
            }
        } else { //jest jaki punkt zaczepienia
            int i;
            for (i = 0;i<ileFragmentow*ileFragmentow;i++) {
                if (fragmenty[i] != null) {
                    gdzieX = (indeks % ileFragmentow) - (i % ileFragmentow);
                    gdzieY = (indeks / ileFragmentow) - (i / ileFragmentow);
                    bazowy = fragmenty[i];
                    break;
                }
            }
        }
        
        if (frMapyFileChooser.showOpenDialog(new JFrame()) != JFileChooser.APPROVE_OPTION)
            return;
        if ((plik = frMapyFileChooser.getSelectedFile()) == null)
            return;

        try {
            pg = new PlikGraficzny(plik);
        } catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(
                this,
                "Nie udao si wczyta pliku mapy!",
                "Bd",
                JOptionPane.ERROR_MESSAGE);
            return;
        }

        try {
            System.out.println("Zapisuj z przesuniciem:"+przesunieciex);
            int ile = komSieciowa.mapy.zapiszFragment(biezacaWarstwa, bazowy, gdzieX, gdzieY, przesunieciex, 0, pg);
            pobierzFragmenty();
            JOptionPane.showMessageDialog(this, "Serwer wczyta: "+ile+" fragmentw mapy.");
        } catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(
                this,
                "Nie udao si przesa pliku mapy na serwer!",
                "Bd",
                JOptionPane.ERROR_MESSAGE);
        }
    }

    protected MouseAdapter stworzPopupMenuDlaFragmentuNieobecnego() {
        final JPopupMenu menuNieakt;
        JMenuItem mi;
        MouseAdapter maNieakt;
        
        menuNieakt = new JPopupMenu();
        mi = new JMenuItem("dodaj fragment");
        menuNieakt.add(mi);
        mi.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent evt) {
                    zapiszFragment(przeliczPopupActionEventNaIndeksFM(evt), 0);
                }});
        maNieakt = new MouseAdapter() {
                        public void mousePressed(MouseEvent evt) {
                            if (evt.isPopupTrigger()) {
                                menuNieakt.show(evt.getComponent(), evt.getX(), evt.getY());
                            }
                        }
                        public void mouseReleased(MouseEvent evt) {
                            if (evt.isPopupTrigger()) {
                                menuNieakt.show(evt.getComponent(), evt.getX(), evt.getY());
                            }
                        }
                    };
        return maNieakt;
    }
    
    /** Odszukuje najbliszy punkt (koniec lub pocztek fragmentu ulicy) wzgldem zadanego.
     *  @param p wyjciowy punkt
     *  @return najbliszy punkt - wsprzdna pocztku lub koca jakiego fragmentu ulicy
     */
    private Point znajdzNajblizszyPunktFrUlicy(Point p) {
        Point tmpp, bestp = null;
        double tmp, bestdist = -1;
        int i;
                
        if (frUlicy != null)
            for (i=0;i<frUlicy.length;i++) {
                tmpp = new Point(frUlicy[i].getWsp_konc_x(), frUlicy[i].getWsp_konc_y());
                tmp = Point.distance(p.x, p.y, tmpp.x, tmpp.y);
                if (tmp < bestdist || bestdist == -1) {bestdist = tmp; bestp = tmpp;}
                tmpp = new Point(frUlicy[i].getWsp_pocz_x(), frUlicy[i].getWsp_pocz_y());
                tmp = Point.distance(p.x, p.y, tmpp.x, tmpp.y);
                if (tmp < bestdist) {bestdist = tmp; bestp = tmpp;}
            }
        if (bestdist < 10) //mierzone we wsprzdnych bezwzgldnych
            return bestp;
        else
            return null;
    }
    
    /** Reakcja na kliknicie przez uytkownika na mapce.
     *  @param evt zdarzenie spowodowane klikniciem
     */
    private void kliknietaMapka(MouseEvent evt) {
        int i;
        int klikx, kliky;
        Point tmpp, tmpp2;
        Point bzwzglklik;

        tmpp = ((JLabel)evt.getSource()).getLocation();
        if (czyZaznaczanie00) {
            if (JOptionPane.showConfirmDialog(this, "Czy na pewno chcesz przesun punkt 0,0 w to miejsce?", "Punkt 0,0", JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION) {
                try {
                    klikx = evt.getX()-1+lewyGornyPkt.x+tmpp.x-1;
                    kliky = evt.getY()-1+lewyGornyPkt.y+tmpp.y-1;
                    komSieciowa.mapy.przesun00(biezacaWarstwa, -klikx, -kliky);
                    centralnyPkt = new Point (0,0);
                    pobierzFragmenty();
                    JOptionPane.showMessageDialog(this, "rodek przesunity!");
                    czyZaznaczanie00 = false;
                    zaznaczanie00.setSelected(false);
                } catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Nie udao si przesun rodka!", "Bd!", JOptionPane.ERROR_MESSAGE);
                }
            }
            return;
        }
        
        tmpp2 = PomocnikMapy.wzgledneNaBezwzgledne(biezacaWarstwa, lewyGornyPkt);
        tmpp2 = lewyGornyPkt;
        klikx = evt.getX()-1+lewyGornyPkt.x+tmpp.x-1;
        kliky = evt.getY()-1+lewyGornyPkt.y+tmpp.y-1;
        bzwzglklik = PomocnikMapy.wzgledneNaBezwzgledne(biezacaWarstwa, new Point(klikx, kliky));

        //z controlem - apiemy najbliszy punkt
        if (evt.isControlDown())
            if ((bzwzglklik = znajdzNajblizszyPunktFrUlicy(bzwzglklik)) == null)
                return;
        
        //z shiftem = nowy wierzchoek
        if (evt.isShiftDown()) {
            nowyPkt = bzwzglklik;
            zaznaczoneWierzcholki = new ArrayList();
            repaint();
            return ;
        }

        //by jaki punkt - ten jest dopenieniem
        if (nowyPkt != null) {
            FragmentUlicy fr;
            fr = new FragmentUlicy(0, 0, nowyPkt.x, nowyPkt.y, bzwzglklik.x, bzwzglklik.y, biezacaUlica);
            FragmentUlicy[] nowa = new FragmentUlicy[frUlicy.length+1];
            System.arraycopy(frUlicy, 0, nowa, 0, frUlicy.length);
            nowa[nowa.length-1] = fr;
            frUlicy = nowa;
            frUlicyPanel.zaktualizujWidok(frUlicy, nowa.length);
            nowyPkt = null;
            repaint();
            return;
        }

        if (frUlicy != null)
        if (frUlicy.length > 0) {
        
            //zaznaczamy klikniciem wierzchoki
            if (zaznaczoneWierzcholki.size() == 0) { //nie mamy adnego wierzchoka
                double bestdist, tmp;
                Point najbl = znajdzNajblizszyPunktFrUlicy(bzwzglklik);
                if (najbl == null) return;
                
                bestdist = Point.distance(bzwzglklik.x, bzwzglklik.y, najbl.x, najbl.y);
                //znajdujemy wszystkie bliskie punkty
                for (i=0;i<frUlicy.length;i++) {
                    tmp = Point.distance(bzwzglklik.x, bzwzglklik.y, frUlicy[i].getWsp_konc_x(), frUlicy[i].getWsp_konc_y());
                    if (tmp == bestdist || (tmp < bestdist+5 && bestdist > 0))
                        zaznaczoneWierzcholki.add(new Integer(i+1));
                    tmp = Point.distance(bzwzglklik.x, bzwzglklik.y, frUlicy[i].getWsp_pocz_x(), frUlicy[i].getWsp_pocz_y());
                    if (tmp == bestdist || (tmp < bestdist+5 && bestdist > 0))
                        zaznaczoneWierzcholki.add(new Integer(-(i+1)));
                } //for
                repaint();
                return ;
            }

            //mamy ju co zaznaczone - przenosimy zaznaczone punkty
            if (zaznaczoneWierzcholki.size() > 0) {
                ListIterator li = zaznaczoneWierzcholki.listIterator();
                int n;
                FragmentUlicy fr;
                while (li.hasNext()) {
                    n = ((Integer) li.next()).intValue();
                    fr = frUlicy[Math.abs(n)-1];
                    if (n > 0) {
                        fr.setWsp_konc_x(bzwzglklik.x);
                        fr.setWsp_konc_y(bzwzglklik.y);
                    } else {
                        fr.setWsp_pocz_x(bzwzglklik.x);
                        fr.setWsp_pocz_y(bzwzglklik.y);
                    }
                } //while
                zaznaczoneWierzcholki = new ArrayList();
                repaint();
                return;
            }
        }
    }
    
    protected MouseAdapter stworzPopupMenuDlaFragmentuObecnego() {
        final JPopupMenu menuAkt;
        JMenuItem mi;
        MouseAdapter maAkt;

        menuAkt = new JPopupMenu();
        mi = new JMenuItem("podmie fragment");
        menuAkt.add(mi);
        mi.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                zapiszFragment(przeliczPopupActionEventNaIndeksFM(evt), 0);
            }});
        maAkt = new MouseAdapter() {
                        public void mousePressed(MouseEvent evt) {
                            if (evt.isPopupTrigger())
                                menuAkt.show(evt.getComponent(), evt.getX(), evt.getY());
                        }
                        public void mouseReleased(MouseEvent evt) {
                            if (evt.isPopupTrigger())
                                menuAkt.show(evt.getComponent(), evt.getX(), evt.getY());
                            if (evt.getClickCount() == 1 && evt.getButton() == MouseEvent.BUTTON1)
                                kliknietaMapka(evt);
                        }
                    };
        return maAkt;
    }

    /** Umoliwia zmian danych podanej warstwy.
     *  @param warstwa warstwa do edycji
     */
    private void edytujWarstwe(WarstwaMapy warstwa) {
        boolean czy = false;
        
        while (!czy) {
            if (EdytujWarstwe.main(warstwa).czy) {
                try {
                    komSieciowa.mapy.zapiszWarstwe(warstwa);
                    JOptionPane.showMessageDialog(this, "Zmieniono dane warstwy!");
                    czy = true;
                } catch(Exception e) {
                    JOptionPane.showMessageDialog(this, "Bd przy zmianie danych warstwy!");
                    e.printStackTrace();
                }
            } else
                czy = true;
        } //while
        //niezalenie od tego czy by bd czy nie, pobieramy od nowa warstwy - a n user co zmieni?
        komSieciowa.pobierzWarstwy();
    }

    /** Reakcja na wcinicie guzika edycji warstwy.
     *  @param evt wygenerowane klikniciem zdarzenie.
     */
    private void edytujWarstweButtonActionPerformed(java.awt.event.ActionEvent evt) {
        edytujWarstwe(biezacaWarstwa);
    }
   
    /** Reakcja na wcinicie guzika nowej warstwy.
     *  @param evt wygenerowane klikniciem zdarzenie.
     */
    private void nowaWarstwaButtonActionPerformed(java.awt.event.ActionEvent evt) {
        WarstwaMapy w;
        w = new WarstwaMapy("", 0, 0, 0);
        edytujWarstwe(w);
    }
    
    protected void saWarstwy() {
        super.saWarstwy();
        edytujWarstweButton.setEnabled(true);
    }
    
    protected void niemaWarstw() {
        super.niemaWarstw();
        edytujWarstweButton.setEnabled(false);
    }
    
    protected void przyszlyFragmentyMapy() {
        repaint();
    }
    
    /** Reakcja na zmian przez uytkownika fragmentw ulic.
     *  @param fr nowe fragmenty.
     */
    public void zmienioneFragmentyUlicy(FragmentUlicy[] fr) {
        frUlicy = fr;
        wybranyFrUlicy = -1;
        wybranyKoniecUlicy = 0;
        repaint();
    }
    
    protected void przyszlyFragmentyUlicy() {
        super.przyszlyFragmentyUlicy();
        frUlicyPanel.zbudujWidok(biezacaUlica, frUlicy);
        wybranyFrUlicy = -1;
        wybranyKoniecUlicy = 0;
        //pokaemy na mapce rodek ulicy
    }
    
    protected void przyszlaUlica(Ulica ul) {
        wybranyFrUlicy = -1;
        wybranyKoniecUlicy = 0;
        super.przyszlaUlica(ul);
        repaint();
    }
    
    public void brakUlicy() {
        if (JOptionPane.showConfirmDialog(this, "Podana ulica nie istnieje.\nCzy chcesz j utworzy?",
                        "Brak ulicy", JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION) {
            //tworzymy ulic!
            try {
                komSieciowa.ulice.dodajUlice(new Ulica(szukanaUlica));
                JOptionPane.showMessageDialog(this, "Ulica zarejestrowana!");
                mKomSieciowa.znajdzUlice(szukanaUlica);
            } catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Nie udao si zarejestrowa ulicy na serwerze!",
                            "Bd", JOptionPane.ERROR_MESSAGE);
            }
        }
    }

    /** Reaguje na usunit przez uytkownika (w panelu fragmentw ulicy) ulic.
     */
    public void usunietaUlica() {
        biezacaUlica = null;
        frUlicy = null;
        wybranyKoniecUlicy = 0;
    }
    
    /** Inicjalizuje komponenty.
     *  @param komSieciowa obiekt odpowiedzialny za komunikacj sieciow.
     */
    public void initWidok(KomSieciowa komSieciowa) {
        this.komSieciowa = komSieciowa;
        super.initWidok((MapaKomSieciowa) komSieciowa, System.getProperty("NIIKT_HTTP") + "/");
    }
    
}
