/*
 * WidokKataloguFirm.java
 *
 * Created on 6 kwiecie 2004, 19:53
 */

package admin.mapa;

import shared.*;
import admin.*;
import java.util.List;
import java.lang.*;
import javax.swing.*;
import java.awt.event.*;
import java.io.File;
import java.net.URL;
import java.net.MalformedURLException;

/** Widok mapy admina.
 *
 * @author  me201258
 */
public class WidokMapy extends javax.swing.JPanel {
    /** Panel nawigacji po mapie. */
    NawigacjaMapaAdmin mapaPanel;
    
    /** Tworzy nowy obiekt Widoku Mapy i dodaje podstawowe komponenty (nie wymagajce
     *  interakcji z serwerem. 
     *  @see #initWidok
     */
    public WidokMapy() {
        initComponents();
        mapaPanel = new NawigacjaMapaAdmin();
        srodkowyPanel.add(mapaPanel);
    }

    /** Inicjalizuje widok mapy, pobierajc z serwera wszystkie potrzebne informacje. */
    public void initWidok() {
        mapaPanel.initWidok(KonsolaAdministratora.komSieciowa);
    }
    
    /** Odbiera przysane z serwera warstwy mapy.
     *  @param w warstwy mapy
     */
    public void odbierzWarstwy(WarstwaMapy[] w) {
        mapaPanel.odbierzWarstwy(w);
    }
    
    /** Odbiera przysane z serwera fragmenty mapy.
     *  @param fr tablica fragmentw mapy
     */
    public void odbierzFragmenty(FragmentMapy[] fr) {
        mapaPanel.odbierzFragmenty(fr);
    }
    
    /** Odbiera przysane z serwera fragmenty ulicy.
     *  @param fr tablica fragmentw ulicy
     */
    public void odbierzFragmentyUlicy(FragmentUlicy[] fr) {
        mapaPanel.odbierzFragmentyUlicy(fr);
    }
    
    /** Odbiera informacj o braku ulicy.
     */
    public void brakUlicy() {
        mapaPanel.brakUlicy();
    }
    
    /** Odbiera przysane z serwera ulice (lub ulic).
     *  @param ulice lista ulic
     */
    public void odbierzUlice(List ulice) {
            mapaPanel.odbierzUlice(ulice);
    }

    /** Inicjalizuje komponenty.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        frMapyFileChooser = new javax.swing.JFileChooser();
        gornyPanel = new javax.swing.JPanel();
        tytulLabel = new javax.swing.JLabel();
        srodkowyPanel = new javax.swing.JPanel();
        dolnyPanel = new javax.swing.JPanel();

        setLayout(new java.awt.BorderLayout());

        gornyPanel.setLayout(new java.awt.BorderLayout());

        gornyPanel.setMaximumSize(new java.awt.Dimension(2147483647, 27));
        tytulLabel.setFont(new java.awt.Font("Dialog", 1, 18));
        tytulLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        tytulLabel.setText("Zarz\u0105dzanie map\u0105");
        gornyPanel.add(tytulLabel, java.awt.BorderLayout.CENTER);

        add(gornyPanel, java.awt.BorderLayout.NORTH);

        srodkowyPanel.setLayout(new javax.swing.BoxLayout(srodkowyPanel, javax.swing.BoxLayout.X_AXIS));

        add(srodkowyPanel, java.awt.BorderLayout.CENTER);

        dolnyPanel.setLayout(null);

        dolnyPanel.setMinimumSize(new java.awt.Dimension(0, 0));
        dolnyPanel.setPreferredSize(new java.awt.Dimension(0, 0));
        add(dolnyPanel, java.awt.BorderLayout.SOUTH);

    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel dolnyPanel;
    private javax.swing.JFileChooser frMapyFileChooser;
    private javax.swing.JPanel gornyPanel;
    private javax.swing.JPanel srodkowyPanel;
    private javax.swing.JLabel tytulLabel;
    // End of variables declaration//GEN-END:variables
    
}
