/*
 * KonsolaFirmy.java
 *
 * Created on 25 kwiecie 2004, 20:05
 */

package firma;

import javax.swing.*;
import java.awt.*;
import java.io.File;
import shared.*;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.net.URL;

/**
 * Implementacja logiki interfejsu firmy jako aplet.
 *
 * Podmienia widoki. Jest porednikiem w komunikacji midzy
 * interfejsem i logik na serwerze.
 *
 * Poniewa ten aplet wymaga dostpu do lokalnego systemu plikw,
 * musi by on podpisany.
 *
 * @author  ek197882
 */
public class KonsolaFirmy extends JApplet {
    
    /**
     * Widok pojawiajcy si bezporedio po uruchomieniu apletu. Umoliwia
     * przejcie do widokw {@link KonsolaFirmy#WIDOK_NOWEGO_OGLOSZENIA},
     * {@link KonsolaFirmy#WIDOK_POWITANIA}.
     *
     * @see WidokLogowania
     */
    public final static String WIDOK_LOGOWANIA = "WidokLogowania";
    
    /**
     * Widok pojawiajcy si bezporedio po zalogowaniu si firmy. Umoliwia
     * przejcie do widokw: {@link KonsolaFirmy#WIDOK_ZARZADZANIA_OGLOSZENIEM},
     * {@link KonsolaFirmy#WIDOK_ZMIANY_HASLA} oraz {@link KonsolaFirmy#WIDOK_STATYSTYK}.
     *
     * @see WidokPowitania
     */
    public final static String WIDOK_POWITANIA = "WidokPowitania";
    
    /**
     * Widok pokazujcy panel edycji ogoszenia. Widok ten jest
     * uywany przez {@link KonsolaFirmy#WIDOK_NOWEGO_OGLOSZENIA} oraz
     * {@link KonsolaFirmy#WIDOK_ZARZADZANIA_OGLOSZENIEM}
     *
     * @see WidokOgloszenia
     */
    public final static String WIDOK_OGLOSZENIA = "WidokOgloszenia";
    
    /**
     * Widok pokazujcy panel z guzikami do edycji nowego ogoszenia
     * oraz podczajcy {@link KonsolaFirmy#WIDOK_OGLOSZENIA}.
     *
     * @see WidokNowegoOgloszenia
     */
    public final static String WIDOK_NOWEGO_OGLOSZENIA = "WidokNowegoOgloszenia";
    
    /**
     * Widok pokazujcy panel z guzikami do edycji istniejcego ogoszenia
     * oraz podczajcy {@link KonsolaFirmy#WIDOK_OGLOSZENIA}.
     *
     * @see WidokNowegoOgloszenia
     */
    public final static String WIDOK_ZARZADZANIA_OGLOSZENIEM = "WidokZarzadzaniaOgloszeniem";
    
    /**
     * Widok pokazujcy ekran umoliwiajcy zmian hasa firmy po zalogowaniu.
     *
     * @see WidokZmianyHasla
     */
    public final static String WIDOK_ZMIANY_HASLA = "WidokZmianyHasla";
    
    /**
     * Widok pokazujcy ekran umoliwiajcy obejrzenie statystyk firmy po zalogowaniu.
     *
     * @see WidokStatystyk
     */
    public final static String WIDOK_STATYSTYK = "WidokStatystyk";
    
    /**
     * Widok pokazujcy ekran umoliwiajcy obejrzenie statusu ogoszenia.
     *
     * @see WidokStatusu
     */
    public final static String WIDOK_STATUSU = "WidokStatusu";
    
    /**
     * Ogoszenie firmy, ktra jest zalogowana.
     * Gdy ogl = null adna firma nie jest zalogowana.
     */
    public Ogloszenie ogl;
    
    /** Konstruowane / zmodyfikowane ogloszenie. */
    public Ogloszenie konstrOgl;
    
    /** Zbir telefonw nalecych do firmy. */
    public ArrayList telefony;
    
    /** Konstruowane telefony. */
    public ArrayList konstrTelefony;
    
    /** Nowo wprowadzony plik logo. */
    public PlikGraficzny pg;
    
    /** Katalog bran. */
    shared.branze.KatalogBranzDrzewo kb;
    
    /**
     * Reprezentacja serwera NIIKT, umoliwia komunikacj poprzez sie z warstw
     * logiki biznesowej serwera.
     */
    public KomSieciowa komSieciowa;
    
    /**
     * Ramka edycji ogoszenia.
     * Gdy oframe = null, oznacza to, e adne ogoszenie nie jest edytowane.
     * Nie jest moliwe edytowanie jednoczesne nowego ogoszenia i
     * istniejcego ogoszenia.
     */
    public JFrame oframe;
    
    /**
     * Minimalny konstruktor. Pena inicjalizacja znajduje si w {@link KonsolaFirmy#init}
     */
    public KonsolaFirmy() {
        ogl = null;
        telefony = null;
        oframe = null;
        konstrOgl = null;
        konstrTelefony  = null;
        pg = null;
        kb = null;
    }
    
    /**
     * Usuwa biecy widok, zastpujc go podanym nowym.
     *
     * @param ident Napis okrelajcy widok, ktry mamy wywietli
     *
     * @see WIDOK_LOGOWANIA
     * @see WIDOK_POWITANIA
     * @see WIDOK_OGLOSZENIA
     * @see WIDOK_NOWEGO_OGLOSZENIA
     * @see WIDOK_ZARZADZANIA_OGLOSZENIEM
     * @see WIDOK_ZMIANY_HASLA
     * @see WIDOK_STATYSTYK
     * @see WIDOK_STATUSU
     */
    private void podmienWidok(String ident) {
        Container cp = getContentPane();
        JPanel comp = (JPanel) cp.getComponent(1);
        CardLayout cl = (CardLayout) comp.getLayout();
        cl.show(comp, ident);
    }
    
    /**
     * Tworzy ramk, zawierajac ekran, w ktrym mona wprowadza ogoszenie.
     * Ramka zostanie zapamitana na {@link oframe}.
     *
     * @param tytul Napis, ktry pojawi si na pasku tytuowym ramki
     * @param dodatkowyWidokNaDole Widok, ktry zostanie umieszczony pod widokiem ogoszenia
     *
     * @see WidokZarzadzaniaOgloszeniem
     * @see WidokNowegoOgloszenia
     */
    private void stworzWidokOgloszenia(JPanel dodatkowyWidokNaDole, String tytul) {
        /* nie pozwalamy otworzyc dwa razy tego widoku */
        if (oframe != null) return;
        
        /* tworzymy osobna ramke z edycja ogloszenia */
        oframe = new JFrame(tytul);
        oframe.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
        oframe.setDefaultLookAndFeelDecorated(true);
        
        /* organizujemy podwidoki nastepujaco: widok z edycja ogloszenia
         * to widok glowny, "na dole" (tj. pod widokiem glownym) ma
         * znajdowac sie pasek 'dodatkowyWidokNaDole' */
        Container c = oframe.getContentPane();
        c.removeAll();
        c.setLayout(new BorderLayout());
        WidokOgloszenia widokOgloszenia = new WidokOgloszenia(this);
        c.add(widokOgloszenia, BorderLayout.CENTER);
        c.add(dodatkowyWidokNaDole, BorderLayout.SOUTH);
        oframe.setBounds(20, 20, 715+20, 500+20);
        oframe.setVisible(true);
    }
    
    
    /**
     * Usuwa widok ogoszenia.
     */
    public void usunWidokOgloszenia() {
        if (oframe != null) {
            oframe.setVisible(false);
            oframe.dispose();
            oframe = null;
        }
    }
    
    /**
     * Czynnosci po zalogowaniu sie firmy. Zapamitanie ogoszenia oraz
     * podczenie wszystkich widokw dla zalogowanej firmy.
     *
     * @param og Ogoszenie firmy, ktra si zalogowaa.
     *
     * @see WidokLogowania
     */
    public void firmaZalogowana(Ogloszenie og) {
        
        /* zapamietanie, ktora firma jest zalogowana */
        ogl = og;
        
        /* pobranie telefonow */
        try {
            telefony = komSieciowa.kontaFirm.pobierzTelefony(ogl.getId());
        } catch (Exception e) {
            telefony = null;
            e.printStackTrace();
        }
        
        /* zamkniecie edycji nowego ogloszenia */
        usunWidokOgloszenia();
        
        /* stworzenie paneli-podwidokow */
        JPanel cards = new JPanel(new CardLayout());
        
        JPanel card1 = new PanelPodstawowy(this);
        JPanel card2 = new WidokZmianyHasla(this);
        JPanel card3 = new WidokStatystyk(this);
        JPanel card4 = new WidokPowitania(this);
        JPanel card5 = new WidokStatusu(this);
        cards.add(card4, WIDOK_POWITANIA);
        cards.add(card5, WIDOK_STATUSU);
        cards.add(card2, WIDOK_ZMIANY_HASLA);
        cards.add(card3, WIDOK_STATYSTYK);
        
        /* usuniecie tego co jest */
        Container cp = getContentPane();
        cp.invalidate();
        cp.removeAll();
        
        /* wyswietlenie widokow */
        cp.setLayout(new BorderLayout());
        cp.add(card1, BorderLayout.WEST);
        cp.add(cards, BorderLayout.CENTER);
        
        cp.validate();
    }
    
    /**
     * Czynnoci po wylogowaniu si firmy. Usunicie ogoszenia oraz
     * pokazanie widoku logowania.
     *
     * @see WidokLogowania
     * @see KonsolaFirmy#firmaZalogowana
     */
    public void firmaWylogowana() {
        ogl = null;
        telefony = null;
        pg = null;
        konstrOgl = null;
        konstrTelefony = null;
        usunWidokOgloszenia();
        pokazEkranLogowania();
    }
    
    /**
     * Wywietla {@link KonsolaFirmy#WIDOK_LOGOWANIA}.
     */
    public void pokazEkranLogowania() {
        Container cp = getContentPane();
        cp.invalidate();
        cp.removeAll();
        cp.add(new WidokLogowania(this));
        cp.validate();
    }
    
    /**
     * Wywietla {@link KonsolaFirmy#WIDOK_NOWEGO_OGLOSZENIA} wraz z odpowiednio doczonym
     * widokiem {@link KonsolaFirmy#WIDOK_OGLOSZENIA}.
     *
     * @see KonsolaFirmy#usunWidokOgloszenia
     */
    public void pokazEkranNowegoOgloszenia() {
        if (oframe == null)
            stworzWidokOgloszenia(new WidokNowegoOgloszenia(this), "NIIKT - Nowe Ogoszenie");
        else
            oframe.setVisible(true);
    }
    
    /**
     * Wywietla {@link KonsolaFirmy#WIDOK_ZARZADZANIA_OGLOSZENIEM} oraz odpowiednio podczony
     * {@link KonsolaFirmy#WIDOK_OGLOSZENIA}.
     *
     * @see KonsolaFirmy#usunWidokOgloszenia
     */
    public void pokazEkranEdycjiOgloszenia() {
        if (oframe == null)
            stworzWidokOgloszenia(new WidokZarzadzaniaOgloszeniem(this), "NIIKT - Edycja Ogoszenia");
        else
            oframe.setVisible(true);
    }
    
    /**
     * Aktualizuje i wywietla {@link KonsolaFirmy#WIDOK_STATYSTYK}.
     */
    public void pokazEkranStatystyk() {
        uaktualnijEkranStatystyk();
        podmienWidok(WIDOK_STATYSTYK);
    }
    
    /**
     * Uaktualnia {@link KonsolaFirmy#WIDOK_STATYSTYK}.
     */
    public void uaktualnijEkranStatystyk() {
        try {
            Container cp = getContentPane();
            JPanel jp = (JPanel)cp.getComponent(1);
            WidokStatystyk ws = (WidokStatystyk) jp.getComponent(3);
            ws.pokazStatystyki();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    /**
     * Wywietla {@link KonsolaFirmy#WIDOK_ZMIANY_HASLA}.
     */
    public void pokazEkranZmianyHasla() {
        podmienWidok(WIDOK_ZMIANY_HASLA);
    }
    
    /**
     * Aktualizuje i wywietla {@link KonsolaFirmy#WIDOK_STATUSU}.
     */
    public void pokazEkranStatusu() {
        uaktualnijEkranStatusu();
        podmienWidok(WIDOK_STATUSU);
    }
    
    /**
     * Aktualizuje @link KonsolaFirmy#WIDOK_STATUSU}.
     */
    public void uaktualnijEkranStatusu() {
        try {
            Container cp = getContentPane();
            JPanel jp = (JPanel)cp.getComponent(1);
            WidokStatusu ws = (WidokStatusu) jp.getComponent(1);
            ws.pokazStatus();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    /**
     * Aktualizuje i wywietla {@link KonsolaFirmy#WIDOK_POWITANIA}.
     */
    public void pokazEkranPowitania() {
        uaktualnijEkranPowitania();
    }
    
    /**
     * Aktualizuje {@link KonsolaFirmy#WIDOK_POWITANIA}.
     */
    public void uaktualnijEkranPowitania() {
        try {
            Container cp = getContentPane();
            JPanel jp = (JPanel)cp.getComponent(1);
            WidokPowitania wp = (WidokPowitania) jp.getComponent(0);
            wp.pokazTerminAktualizacji();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    /**
     * Aktualizuje wszystkie widoki, ktre tego wymagaj.
     */
    public void uaktualnijWidoki() {
        uaktualnijEkranStatusu();
        uaktualnijEkranStatystyk();
        uaktualnijEkranPowitania();
    }
    
    /**
     * Odpala modu firmy, gdy uruchamiamy konsol firmy jako aplet.
     * Pokazuje widok logowania.
     */
    public void init() {
        try {
            komSieciowa = new KomSieciowa(getCodeBase().getHost());
            getContentPane().add(new WidokLogowania(this));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
